/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.utils;

import cn.leancloud.LCFile;
import cn.leancloud.utils.DefaultMimeTypeDetector;
import cn.leancloud.utils.StringUtil;
import java.util.regex.Pattern;

public class FileUtil {
    public static final int DEFAULT_FILE_KEY_LEN = 40;
    public static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private static MimeTypeDetector detector = new DefaultMimeTypeDetector();

    public static void config(MimeTypeDetector mimeTypeDetector) {
        detector = mimeTypeDetector;
    }

    public static String getExtensionFromFilename(String filename) {
        int dotPos;
        if (!StringUtil.isEmpty(filename) && Pattern.matches("[a-zA-Z_0-9\\.\\-\\(\\)\\%]+", filename) && 0 <= (dotPos = filename.lastIndexOf(46))) {
            return filename.substring(dotPos + 1);
        }
        return "";
    }

    public static String getFileMimeType(LCFile avFile) {
        String fileName = avFile.getName();
        String fileUrl = avFile.getUrl();
        String mimeType = null;
        if (!StringUtil.isEmpty(fileName)) {
            mimeType = FileUtil.getMimeTypeFromFilename(fileName);
        } else if (!StringUtil.isEmpty(fileUrl)) {
            mimeType = FileUtil.getMimeTypeFromUrl(fileUrl);
        }
        if (StringUtil.isEmpty(mimeType)) {
            mimeType = DEFAULT_MIME_TYPE;
        }
        return mimeType;
    }

    public static String getMimeTypeFromFilename(String fileName) {
        String extension = FileUtil.getExtensionFromFilename(fileName);
        if (!StringUtil.isEmpty(extension)) {
            String result = detector.getMimeTypeFromExtension(extension);
            return null != result ? result : "";
        }
        return "";
    }

    public static String getMimeTypeFromPath(String localPath) {
        if (!StringUtil.isEmpty(localPath)) {
            String result = detector.getMimeTypeFromPath(localPath);
            return null != result ? result : "";
        }
        return "";
    }

    public static String getMimeTypeFromUrl(String url) {
        if (!StringUtil.isEmpty(url)) {
            String result = detector.getMimeTypeFromUrl(url);
            return null != result ? result : "";
        }
        return "";
    }

    public static interface MimeTypeDetector {
        public String getMimeTypeFromUrl(String var1);

        public String getMimeTypeFromPath(String var1);

        public String getMimeTypeFromExtension(String var1);
    }
}

