/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.types;

import cn.leancloud.utils.LCUtils;

public class LCGeoPoint {
    static double ONE_KM_TO_MILES = 1.609344;
    private double latitude;
    private double longitude;

    public LCGeoPoint() {
        this.latitude = 0.0;
        this.longitude = 0.0;
    }

    public LCGeoPoint(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public double distanceInKilometersTo(LCGeoPoint point) {
        if (null == point) {
            return 0.0;
        }
        return LCUtils.distance(this.latitude, point.latitude, this.longitude, point.longitude, 0.0, 0.0) / 1000.0;
    }

    public double distanceInMilesTo(LCGeoPoint point) {
        return this.distanceInKilometersTo(point) / ONE_KM_TO_MILES;
    }

    public double distanceInRadiansTo(LCGeoPoint point) {
        return this.distanceInKilometersTo(point) / 6378.14;
    }
}

