/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.codec;

import cn.leancloud.LCLogger;
import cn.leancloud.codec.Base64Decoder;
import cn.leancloud.codec.Base64Encoder;
import cn.leancloud.utils.LogUtil;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class AES {
    private static final LCLogger Log = LogUtil.getLogger(AES.class);
    private static final String KEY_GENERATION_ALG = "PBKDF2WithHmacSHA1";
    private static final int HASH_ITERATIONS = 10000;
    private static final int KEY_LENGTH = 256;
    private char[] humanPassphrase = "QxciDjdHjuAIf8VCsqhmGK3OZV7pBQTZ".toCharArray();
    private byte[] salt = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private PBEKeySpec myKeyspec = new PBEKeySpec(this.humanPassphrase, this.salt, 10000, 256);
    private static final String CIPHERMODEPADDING = "AES/CBC/PKCS7Padding";
    private SecretKeyFactory keyfactory = null;
    private SecretKey sk = null;
    private SecretKeySpec skforAES = null;
    private IvParameterSpec IV;

    public AES() {
        try {
            this.keyfactory = SecretKeyFactory.getInstance(KEY_GENERATION_ALG);
            this.sk = this.keyfactory.generateSecret(this.myKeyspec);
        }
        catch (NoSuchAlgorithmException nsae) {
            Log.e("no key factory support for PBEWITHSHAANDTWOFISH-CBC");
        }
        catch (InvalidKeySpecException ikse) {
            Log.e("invalid key spec for PBEWITHSHAANDTWOFISH-CBC");
        }
        byte[] skAsByteArray = this.sk.getEncoded();
        this.skforAES = new SecretKeySpec(skAsByteArray, "AES");
        SecureRandom random = new SecureRandom();
        byte[] iv = new byte[16];
        random.nextBytes(iv);
        this.IV = new IvParameterSpec(iv);
    }

    public String encrypt(byte[] plaintext) {
        byte[] ciphertext = this.encrypt(CIPHERMODEPADDING, this.skforAES, this.IV, plaintext);
        String base64_ciphertext = Base64Encoder.encode(ciphertext);
        return base64_ciphertext;
    }

    public String decrypt(String ciphertext_base64) {
        byte[] s = Base64Decoder.decodeToBytes(ciphertext_base64);
        String decrypted = new String(this.decrypt(CIPHERMODEPADDING, this.skforAES, this.IV, s));
        return decrypted;
    }

    private byte[] addPadding(byte[] plain) {
        int i;
        byte[] plainpad = null;
        int shortage = 16 - plain.length % 16;
        if (shortage == 0) {
            shortage = 16;
        }
        plainpad = new byte[plain.length + shortage];
        for (i = 0; i < plain.length; ++i) {
            plainpad[i] = plain[i];
        }
        for (i = plain.length; i < plain.length + shortage; ++i) {
            plainpad[i] = (byte)shortage;
        }
        return plainpad;
    }

    private byte[] dropPadding(byte[] plainpad) {
        byte[] plain = null;
        byte drop = plainpad[plainpad.length - 1];
        plain = new byte[plainpad.length - drop];
        for (int i = 0; i < plain.length; ++i) {
            plain[i] = plainpad[i];
            plainpad[i] = 0;
        }
        return plain;
    }

    private byte[] encrypt(String cmp, SecretKey sk, IvParameterSpec IV, byte[] msg) {
        try {
            Cipher c = Cipher.getInstance(cmp);
            c.init(1, (Key)sk, IV);
            return c.doFinal(msg);
        }
        catch (NoSuchAlgorithmException nsae) {
            Log.e("no cipher getinstance support for " + cmp);
        }
        catch (NoSuchPaddingException nspe) {
            Log.e("no cipher getinstance support for padding " + cmp);
        }
        catch (InvalidKeyException e) {
            Log.e("invalid key exception");
        }
        catch (InvalidAlgorithmParameterException e) {
            Log.e("invalid algorithm parameter exception");
        }
        catch (IllegalBlockSizeException e) {
            Log.e("illegal block size exception");
        }
        catch (BadPaddingException e) {
            Log.e("bad padding exception");
        }
        return null;
    }

    private byte[] decrypt(String cmp, SecretKey sk, IvParameterSpec IV, byte[] ciphertext) {
        try {
            Cipher c = Cipher.getInstance(cmp);
            c.init(2, (Key)sk, IV);
            return c.doFinal(ciphertext);
        }
        catch (NoSuchAlgorithmException nsae) {
            Log.e("no cipher getinstance support for " + cmp);
        }
        catch (NoSuchPaddingException nspe) {
            Log.e("no cipher getinstance support for padding " + cmp);
        }
        catch (InvalidKeyException e) {
            Log.e("invalid key exception");
        }
        catch (InvalidAlgorithmParameterException e) {
            Log.e("invalid algorithm parameter exception");
        }
        catch (IllegalBlockSizeException e) {
            Log.e("illegal block size exception");
        }
        catch (BadPaddingException e) {
            Log.e("bad padding exception");
        }
        return null;
    }
}

