/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.LCLogger;
import cn.leancloud.LCObject;
import cn.leancloud.LCQuery;
import cn.leancloud.annotation.LCClassName;
import cn.leancloud.cache.PersistenceUtil;
import cn.leancloud.codec.MDFive;
import cn.leancloud.core.AppConfiguration;
import cn.leancloud.core.LeanCloud;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import java.io.File;
import java.util.TimeZone;
import java.util.UUID;

@LCClassName(value="_Installation")
public final class LCInstallation
extends LCObject {
    public static final String CLASS_NAME = "_Installation";
    private static final LCLogger LOGGER = LogUtil.getLogger(LCInstallation.class);
    static final String INSTALLATION = "installation";
    private static final String DEVICETYPETAG = "deviceType";
    private static final String CHANNELSTAG = "channel";
    private static final String INSTALLATIONIDTAG = "installationId";
    private static final String TIMEZONE = "timeZone";
    public static final String REGISTRATION_ID = "registrationId";
    public static final String VENDOR = "vendor";
    private static String DEFAULT_DEVICETYPE = "android";
    private static volatile LCInstallation currentInstallation;

    public LCInstallation() {
        super(CLASS_NAME);
        this.totallyOverwrite = true;
        this.initialize();
        this.endpointClassName = "installations";
    }

    protected LCInstallation(LCObject obj) {
        this.objectId = obj.getObjectId();
        this.acl = obj.getACL();
        this.serverData = obj.getServerData();
        this.totallyOverwrite = true;
        this.endpointClassName = "installations";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LCInstallation getCurrentInstallation() {
        if (null != currentInstallation) return currentInstallation;
        Class<LCInstallation> clazz = LCInstallation.class;
        synchronized (LCInstallation.class) {
            if (null != currentInstallation) return currentInstallation;
            currentInstallation = LCInstallation.createInstanceFromLocal(INSTALLATION);
            // ** MonitorExit[var0] (shouldn't be in output)
            return currentInstallation;
        }
    }

    private static File getCacheFile() {
        String cacheBase = AppConfiguration.getImportantFileDir();
        if (StringUtil.isEmpty(cacheBase)) {
            return null;
        }
        return new File(cacheBase, LeanCloud.getSimplifiedAppId() + INSTALLATION);
    }

    protected static LCInstallation createInstanceFromLocal(String fileName) {
        String json;
        File installationFile = LCInstallation.getCacheFile();
        String newInstallationId = LCInstallation.genInstallationId();
        if (null != installationFile) {
            boolean tmp;
            String cacheBase;
            File oldInstallationFile;
            LOGGER.d("installation cache file path: " + installationFile.getAbsolutePath());
            if (!installationFile.exists() && (oldInstallationFile = new File(cacheBase = AppConfiguration.getImportantFileDir(), INSTALLATION)).exists() && !(tmp = oldInstallationFile.renameTo(installationFile))) {
                LOGGER.w("failed to rename installation cache file.");
            }
            if (installationFile.exists()) {
                json = PersistenceUtil.sharedInstance().readContentFromFile(installationFile);
                if (!StringUtil.isEmpty(json)) {
                    if (json.indexOf("{") >= 0) {
                        try {
                            currentInstallation = (LCInstallation)LCObject.parseLCObject(json);
                            LCInstallation.currentInstallation.totallyOverwrite = true;
                        }
                        catch (Exception ex) {
                            LOGGER.w("failed to parse local installation data.", ex);
                        }
                    } else if (json.length() == UUID_LEN) {
                        newInstallationId = json;
                    }
                } else {
                    LOGGER.d("installation cache file is empty, create new instance.");
                }
            }
        }
        if (null == currentInstallation) {
            json = String.format("{ \"_version\":\"5\",\"className\":\"_Installation\",\"serverData\":{\"@type\":\"java.util.concurrent.ConcurrentHashMap\",\"deviceType\":\"android\",\"installationId\":\"%s\",\"timeZone\":\"%s\"}}", newInstallationId, LCInstallation.timezone());
            PersistenceUtil.sharedInstance().saveContentToFile(json, installationFile);
            LOGGER.d("create-ahead installation with json: " + json);
            try {
                currentInstallation = (LCInstallation)LCObject.parseLCObject(json);
                LCInstallation.currentInstallation.totallyOverwrite = true;
            }
            catch (Exception ex) {
                LOGGER.w("failed to parse create-ahead installation string.", ex);
                currentInstallation = new LCInstallation();
                currentInstallation.setInstallationId(newInstallationId);
            }
        }
        return currentInstallation;
    }

    public static void changeDeviceType(String deviceType) {
        DEFAULT_DEVICETYPE = deviceType;
    }

    private static String deviceType() {
        return DEFAULT_DEVICETYPE;
    }

    private static String timezone() {
        TimeZone defaultTimezone = TimeZone.getDefault();
        return defaultTimezone.getID();
    }

    private void initialize() {
        if (currentInstallation != null) {
            this.put(INSTALLATIONIDTAG, currentInstallation.getInstallationId());
        } else {
            String installationId = LCInstallation.genInstallationId();
            if (!StringUtil.isEmpty(installationId)) {
                this.put(INSTALLATIONIDTAG, installationId);
            }
        }
        this.put(DEVICETYPETAG, LCInstallation.deviceType());
        this.put(TIMEZONE, LCInstallation.timezone());
    }

    private static String genInstallationId() {
        String packageName = AppConfiguration.getApplicationPackageName();
        String additionalStr = UUID.randomUUID().toString();
        return MDFive.computeMD5(packageName + additionalStr);
    }

    public String getInstallationId() {
        return this.getString(INSTALLATIONIDTAG);
    }

    public static LCQuery<LCInstallation> getQuery() {
        LCQuery<LCInstallation> query = new LCQuery<LCInstallation>(CLASS_NAME);
        return query;
    }

    @Override
    protected void onSaveSuccess() {
        super.onSaveSuccess();
        this.updateCurrentInstallationCache();
    }

    @Override
    protected void onDataSynchronized() {
        super.onDataSynchronized();
        this.updateCurrentInstallationCache();
    }

    void updateCurrentInstallationCache() {
        if (currentInstallation == this) {
            File installationFile = LCInstallation.getCacheFile();
            String jsonString = currentInstallation.toJSONString();
            PersistenceUtil.sharedInstance().saveContentToFile(jsonString, installationFile);
        }
    }

    void setInstallationId(String installationId) {
        this.put(INSTALLATIONIDTAG, installationId);
    }
}

