/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.LCObject;
import cn.leancloud.LCUser;
import cn.leancloud.Transformer;
import cn.leancloud.core.PaasClient;
import cn.leancloud.query.LCCloudQueryResult;
import cn.leancloud.query.LCQueryResult;
import cn.leancloud.utils.LCUtils;
import cn.leancloud.utils.StringUtil;
import io.reactivex.Observable;
import io.reactivex.functions.Function;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

public class LCCloudQuery {
    private LCCloudQuery() {
    }

    public static Observable<LCCloudQueryResult> executeInBackground(String cql) {
        return LCCloudQuery.executeInBackground(null, cql);
    }

    public static Observable<LCCloudQueryResult> executeInBackground(LCUser asAuthenticatedUser, String cql) {
        return LCCloudQuery.executeInBackground(asAuthenticatedUser, cql, LCObject.class);
    }

    public static Observable<LCCloudQueryResult> executeInBackground(String cql, Object ... params) {
        return LCCloudQuery.executeInBackground(null, cql, params);
    }

    public static Observable<LCCloudQueryResult> executeInBackground(LCUser asAuthenticatedUser, String cql, Object ... params) {
        return LCCloudQuery.executeInBackground(asAuthenticatedUser, cql, LCObject.class, params);
    }

    public static Observable<LCCloudQueryResult> executeInBackground(String cql, Class<? extends LCObject> clazz) {
        return LCCloudQuery.executeInBackground(null, cql, clazz);
    }

    public static Observable<LCCloudQueryResult> executeInBackground(LCUser asAuthenticatedUser, String cql, Class<? extends LCObject> clazz) {
        return LCCloudQuery.executeInBackground(asAuthenticatedUser, cql, clazz, null);
    }

    public static <T extends LCObject> Observable<LCCloudQueryResult> executeInBackground(String cql, Class<T> clazz, Object ... params) {
        return LCCloudQuery.executeInBackground(null, cql, clazz, params);
    }

    public static <T extends LCObject> Observable<LCCloudQueryResult> executeInBackground(LCUser asAuthenticatedUser, String cql, Class<T> clazz, Object ... params) {
        if (StringUtil.isEmpty(cql)) {
            throw new IllegalArgumentException("cql is empty");
        }
        if (null == clazz) {
            throw new IllegalArgumentException("target class is null");
        }
        LinkedList<Object> pValue = new LinkedList<Object>();
        if (null != params) {
            for (Object o : params) {
                pValue.add(o);
            }
        }
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("cql", cql);
        if (!pValue.isEmpty()) {
            p.put("pvalues", LCUtils.jsonStringFromObjectWithNull(pValue));
        }
        return PaasClient.getStorageClient().cloudQuery(asAuthenticatedUser, p).map((Function)new Function<LCQueryResult, LCCloudQueryResult>(){

            public LCCloudQueryResult apply(LCQueryResult LCQueryResult2) throws Exception {
                LCCloudQueryResult finalResult = new LCCloudQueryResult();
                ArrayList rawObjs = new ArrayList(LCQueryResult2.getCount());
                for (LCObject o : LCQueryResult2.getResults()) {
                    rawObjs.add(Transformer.transform(o, LCQueryResult2.getClassName()));
                }
                finalResult.setResults(rawObjs);
                finalResult.setCount(LCQueryResult2.getCount());
                return finalResult;
            }
        });
    }
}

