/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.utils;

import cn.leancloud.LCException;
import cn.leancloud.json.JSON;
import cn.leancloud.json.JSONObject;
import java.io.IOException;
import retrofit2.HttpException;
import retrofit2.Response;

public class ErrorUtils {
    public static LCException propagateException(String content) {
        try {
            JSONObject object = JSON.parseObject(content);
            String errorMessage = object.getString("error");
            int code = object.getIntValue("code");
            return new LCException(code, errorMessage);
        }
        catch (Exception exception) {
            return new LCException(999, content);
        }
    }

    public static LCException propagateException(Throwable throwable) {
        Response response;
        HttpException httpException;
        if (null == throwable) {
            return null;
        }
        if (throwable instanceof HttpException && null != (httpException = (HttpException)throwable).response() && null != (response = httpException.response()) && null != response.errorBody()) {
            try {
                String content = response.errorBody().string();
                LCException exception = ErrorUtils.propagateException(content);
                return exception;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new LCException(999, throwable.getMessage());
    }

    public static LCException propagateException(int code, String content) {
        return new LCException(code, content);
    }

    public static LCException sessionMissingException() {
        return ErrorUtils.propagateException(206, "No valid session token, make sure signUp or login has been called.");
    }

    public static LCException illegalArgument(String message) {
        return ErrorUtils.propagateException(9304, message);
    }

    public static LCException invalidObjectIdException() {
        return ErrorUtils.propagateException(104, "Invalid object id.");
    }

    public static LCException invalidStateException() {
        return ErrorUtils.propagateException(9303, "Invalid State Exception.");
    }

    public static LCException invalidStateException(String message) {
        return ErrorUtils.propagateException(9303, message);
    }
}

