/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.upload;

import cn.leancloud.LCException;
import cn.leancloud.LCLogger;
import cn.leancloud.cache.PersistenceUtil;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileAlreadyExistsException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class FileDownloader {
    private static final LCLogger gLogger = LogUtil.getLogger(FileDownloader.class);
    private static final int READ_BUF_SIZE = 8192;

    public LCException execute(String url, File localFile) {
        if (StringUtil.isEmpty(url)) {
            return new LCException(new IllegalArgumentException("url is null"));
        }
        if (localFile.exists()) {
            return new LCException(new FileAlreadyExistsException("local file already existed."));
        }
        return this.downloadFileFromNetwork(url, localFile);
    }

    private OkHttpClient createHttpClient() {
        return new OkHttpClient.Builder().connectTimeout(15L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LCException downloadFileFromNetwork(String url, File cacheFile) {
        LCException errors;
        block28: {
            errors = null;
            Request.Builder requestBuilder = new Request.Builder();
            requestBuilder.url(url);
            OkHttpClient client = this.createHttpClient();
            Response response = null;
            try {
                response = client.newCall(requestBuilder.build()).execute();
                int statusCode = response.code();
                if (null == response.body()) {
                    errors = new LCException(statusCode, "response body is invalid");
                    gLogger.w(errors);
                    break block28;
                }
                InputStream data = response.body().byteStream();
                if (statusCode / 100 == 2 && null != data) {
                    byte[] content = new byte[8192];
                    ReentrantReadWriteLock.WriteLock writeLock = PersistenceUtil.sharedInstance().getLock(cacheFile.getAbsolutePath()).writeLock();
                    if (writeLock.tryLock()) {
                        FileOutputStream out = null;
                        try {
                            out = new FileOutputStream(cacheFile, false);
                            int currentReadSize = data.read(content);
                            while (currentReadSize > 0) {
                                out.write(content, 0, currentReadSize);
                                currentReadSize = data.read(content);
                            }
                            break block28;
                        }
                        catch (Exception e) {
                            gLogger.w(e);
                            errors = new LCException(e);
                            break block28;
                        }
                        finally {
                            try {
                                data.close();
                            }
                            catch (IOException iOException) {}
                            if (out != null) {
                                try {
                                    out.close();
                                }
                                catch (IOException iOException) {}
                            }
                            writeLock.unlock();
                        }
                    }
                    gLogger.w("failed to lock writeLocker, skip to save network streaming to local cache.");
                    break block28;
                }
                errors = new LCException(statusCode, "status code is invalid");
                gLogger.w(errors);
            }
            catch (IOException ex) {
                errors = new LCException(ex);
            }
            finally {
                if (null != response) {
                    response.close();
                }
            }
        }
        return errors;
    }
}

