/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.logging;

import cn.leancloud.LCLogger;
import cn.leancloud.logging.InternalLogger;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class SimpleLogger
extends InternalLogger {
    private Logger logger = null;

    public SimpleLogger(Logger logger) {
        if (null == logger) {
            throw new IllegalArgumentException("Logger is null.");
        }
        this.logger = logger;
    }

    @Override
    public void setLevel(LCLogger.Level level) {
        super.setLevel(level);
        this.logger.setLevel(this.getNativeLevel(level));
    }

    private Level getNativeLevel(LCLogger.Level level) {
        Level result;
        switch (level) {
            case OFF: {
                result = Level.OFF;
                break;
            }
            case ERROR: {
                result = Level.SEVERE;
                break;
            }
            case WARNING: {
                result = Level.WARNING;
                break;
            }
            case INFO: {
                result = Level.INFO;
                break;
            }
            case DEBUG: {
                result = Level.FINE;
                break;
            }
            case VERBOSE: {
                result = Level.FINER;
                break;
            }
            default: {
                result = Level.ALL;
            }
        }
        return result;
    }

    @Override
    protected void internalWriteLog(LCLogger.Level level, String msg) {
        Level nativeLevel = this.getNativeLevel(level);
        this.logger.log(nativeLevel, "[Thread-" + Thread.currentThread().getId() + "] " + msg);
    }

    @Override
    protected void internalWriteLog(LCLogger.Level level, String msg, Throwable tr) {
        Level nativeLevel = this.getNativeLevel(level);
        this.logger.log(nativeLevel, "[Thread-" + Thread.currentThread().getId() + "] " + msg, tr);
    }

    @Override
    protected void internalWriteLog(LCLogger.Level level, Throwable tr) {
        Level nativeLevel = this.getNativeLevel(level);
        LogRecord record = new LogRecord(nativeLevel, "");
        record.setThrown(tr);
        this.logger.log(record);
    }
}

