/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;

public class NumberDeserializerDoubleAsIntFix
implements JsonDeserializer<Number> {
    public Number deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        return (Number)this.read(jsonElement);
    }

    public static Object parsePrecisionNumber(Number num) {
        if (null == num) {
            return null;
        }
        if (Math.floor(num.doubleValue()) != Math.ceil(num.doubleValue())) {
            return num;
        }
        double doubleValue = Math.ceil(num.doubleValue());
        if (doubleValue == (double)num.intValue()) {
            return num.intValue();
        }
        if (doubleValue == (double)num.longValue()) {
            return num.longValue();
        }
        return num.doubleValue();
    }

    public Object read(JsonElement in) {
        if (in.isJsonPrimitive()) {
            JsonPrimitive prim = in.getAsJsonPrimitive();
            if (prim.isBoolean()) {
                return prim.getAsBoolean();
            }
            if (prim.isString()) {
                return prim.getAsString();
            }
            if (prim.isNumber()) {
                Number num = prim.getAsNumber();
                return NumberDeserializerDoubleAsIntFix.parsePrecisionNumber(num);
            }
        }
        return null;
    }
}

