/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.gson;

import cn.leancloud.gson.NumberDeserializerDoubleAsIntFix;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.LinkedTreeMap;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class MapDeserializerDoubleAsIntFix
implements JsonDeserializer<Map<String, Object>> {
    public Map<String, Object> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return (Map)this.read(json);
    }

    public Object read(JsonElement in) {
        if (in.isJsonArray()) {
            ArrayList<Object> list = new ArrayList<Object>();
            JsonArray arr = in.getAsJsonArray();
            for (JsonElement anArr : arr) {
                list.add(this.read(anArr));
            }
            return list;
        }
        if (in.isJsonObject()) {
            LinkedTreeMap map = new LinkedTreeMap();
            JsonObject obj = in.getAsJsonObject();
            Set entitySet = obj.entrySet();
            for (Map.Entry entry : entitySet) {
                map.put(entry.getKey(), this.read((JsonElement)entry.getValue()));
            }
            return map;
        }
        if (in.isJsonPrimitive()) {
            JsonPrimitive prim = in.getAsJsonPrimitive();
            if (prim.isBoolean()) {
                return prim.getAsBoolean();
            }
            if (prim.isString()) {
                return prim.getAsString();
            }
            if (prim.isNumber()) {
                Number num = prim.getAsNumber();
                return NumberDeserializerDoubleAsIntFix.parsePrecisionNumber(num);
            }
        }
        return null;
    }
}

