/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.core;

import cn.leancloud.LCFile;
import cn.leancloud.LCFriendship;
import cn.leancloud.LCFriendshipRequest;
import cn.leancloud.LCLeaderboardResult;
import cn.leancloud.LCLogger;
import cn.leancloud.LCObject;
import cn.leancloud.LCQuery;
import cn.leancloud.LCStatisticResult;
import cn.leancloud.LCStatus;
import cn.leancloud.LCUser;
import cn.leancloud.Transformer;
import cn.leancloud.cache.QueryResultCache;
import cn.leancloud.core.AppConfiguration;
import cn.leancloud.gson.NumberDeserializerDoubleAsIntFix;
import cn.leancloud.json.JSON;
import cn.leancloud.json.JSONObject;
import cn.leancloud.ops.Utils;
import cn.leancloud.query.LCQueryResult;
import cn.leancloud.search.LCSearchResponse;
import cn.leancloud.service.APIService;
import cn.leancloud.sms.LCCaptchaDigest;
import cn.leancloud.sms.LCCaptchaOption;
import cn.leancloud.sms.LCCaptchaValidateResult;
import cn.leancloud.types.LCDate;
import cn.leancloud.types.LCNull;
import cn.leancloud.upload.FileUploadToken;
import cn.leancloud.utils.ErrorUtils;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Scheduler;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StorageClient {
    private static LCLogger LOGGER = LogUtil.getLogger(StorageClient.class);
    private static final String CUSTOM_ENDPOINT_PREFIX = "CUSTOM_ENDPOINT_";
    private APIService apiService = null;
    private boolean asynchronized = false;
    private AppConfiguration.SchedulerCreator defaultCreator = null;
    private QueryResultCache queryResultCache = QueryResultCache.getInstance();
    private LCUser currentUser = null;

    public StorageClient(APIService apiService, boolean asyncRequest, AppConfiguration.SchedulerCreator observerSchedulerCreator) {
        this.apiService = apiService;
        this.asynchronized = asyncRequest;
        this.defaultCreator = observerSchedulerCreator;
    }

    public void setCurrentUser(LCUser newUser) {
        this.currentUser = newUser;
    }

    public LCUser getCurrentUser() {
        return this.currentUser;
    }

    public Observable wrapObservable(Observable observable) {
        if (null == observable) {
            return null;
        }
        if (this.asynchronized) {
            observable = observable.subscribeOn(Schedulers.io());
        }
        if (null != this.defaultCreator) {
            observable = observable.observeOn(this.defaultCreator.create());
        }
        observable = observable.onErrorResumeNext((Function)new Function<Throwable, ObservableSource>(){

            public ObservableSource apply(Throwable throwable) throws Exception {
                return Observable.error((Throwable)ErrorUtils.propagateException(throwable));
            }
        });
        return observable;
    }

    private Observable wrapObservableInBackground(Observable observable) {
        if (null == observable) {
            return null;
        }
        Scheduler scheduler = Schedulers.io();
        if (this.asynchronized) {
            observable = observable.subscribeOn(scheduler);
        }
        if (null != this.defaultCreator) {
            observable = observable.observeOn(scheduler);
        }
        return observable;
    }

    public Observable<LCDate> getServerTime() {
        Observable date = this.wrapObservable(this.apiService.currentTimeMillis());
        return date;
    }

    public Observable<? extends LCObject> fetchObject(LCUser authenticatedUser, final String className, String objectId, String includeKeys) {
        Observable object = null;
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        object = StringUtil.isEmpty(includeKeys) ? this.wrapObservable(this.apiService.fetchObject(authenticatedSession, className, objectId)) : this.wrapObservable(this.apiService.fetchObject(authenticatedSession, className, objectId, includeKeys));
        if (null == object) {
            return object;
        }
        return object.map((Function)new Function<LCObject, LCObject>(){

            public LCObject apply(LCObject LCObject2) throws Exception {
                return Transformer.transform(LCObject2, className);
            }
        });
    }

    public boolean hasCachedResult(String className, Map<String, String> query, long maxAgeInMilliseconds) {
        return QueryResultCache.getInstance().hasCachedResult(className, query, maxAgeInMilliseconds);
    }

    private String getSessionToken(LCUser avUser) {
        if (null == avUser) {
            if (AppConfiguration.isIncognitoMode() || null == LCUser.currentUser()) {
                return "";
            }
            return LCUser.currentUser().getSessionToken();
        }
        return avUser.getSessionToken();
    }

    private Observable<LCQueryResult> queryRemoteServer(LCUser authenticatedUser, String className, Map<String, String> query) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        if ("_User".equalsIgnoreCase(className)) {
            return this.wrapObservable(this.apiService.queryUsers(authenticatedSession, query));
        }
        if ("_Blocklist".equalsIgnoreCase(className)) {
            return this.wrapObservable(this.apiService.getBlockListOfFriend(authenticatedSession, query));
        }
        if (className.startsWith(CUSTOM_ENDPOINT_PREFIX)) {
            String endPoint = className.substring(CUSTOM_ENDPOINT_PREFIX.length());
            return this.wrapObservable(this.apiService.queryObjectsByCustomEndPoint(authenticatedSession, endPoint, query));
        }
        return this.wrapObservable(this.apiService.queryObjects(authenticatedSession, className, query));
    }

    public Observable<List<LCUser>> strictlyQueryUsers(LCUser authenticatedUser, Map<String, String> query) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservable(this.apiService.strictlyQueryUsers(authenticatedSession, query)).map((Function)new Function<LCQueryResult, List<LCObject>>(){

            public List<LCObject> apply(LCQueryResult o) throws Exception {
                o.setClassName("_User");
                for (LCObject obj : o.getResults()) {
                    obj.setClassName("_User");
                }
                LOGGER.d("invoke within StorageClient.strictlyQueryUsers(). resultSize:" + (null != o.getResults() ? o.getResults().size() : 0));
                return o.getResults();
            }
        }).map((Function)new Function<List<LCObject>, List<LCUser>>(){

            public List<LCUser> apply(List<LCObject> var1) throws Exception {
                ArrayList<LCUser> result = new ArrayList<LCUser>(var1.size());
                for (LCObject obj : var1) {
                    LCUser tmp = (LCUser)Transformer.transform(obj, "_User");
                    result.add(tmp);
                }
                return result;
            }
        });
    }

    public Observable<List<LCObject>> queryObjects(final LCUser authenticatedUser, final String className, String endPoint, final Map<String, String> query, LCQuery.CachePolicy cachePolicy, final long maxAgeInMilliseconds) {
        final String cacheKey = QueryResultCache.generateKeyForQueryCondition(className, query);
        Observable result = null;
        Observable<LCQueryResult> queryResult = null;
        final String validPath = endPoint == null || endPoint.length() == 0 ? className : CUSTOM_ENDPOINT_PREFIX + endPoint;
        switch (cachePolicy) {
            case CACHE_ONLY: {
                result = this.wrapObservable(QueryResultCache.getInstance().getCacheResult(className, query, maxAgeInMilliseconds, true));
                break;
            }
            case CACHE_ELSE_NETWORK: {
                result = this.wrapObservable(QueryResultCache.getInstance().getCacheResult(className, query, maxAgeInMilliseconds, false)).onErrorResumeNext((Function)new Function<Throwable, ObservableSource<? extends List<LCObject>>>(){

                    public ObservableSource<? extends List<LCObject>> apply(Throwable throwable) throws Exception {
                        LOGGER.d("failed to query local cache, cause: " + throwable.getMessage() + ", try to query networking");
                        return StorageClient.this.queryRemoteServer(authenticatedUser, validPath, query).map((Function)new Function<LCQueryResult, List<LCObject>>(){

                            public List<LCObject> apply(LCQueryResult o) throws Exception {
                                o.setClassName(className);
                                for (LCObject obj : o.getResults()) {
                                    obj.setClassName(className);
                                }
                                QueryResultCache.getInstance().cacheResult(cacheKey, o.toJSONString());
                                LOGGER.d("invoke within StorageClient.queryObjects(). resultSize:" + (null != o.getResults() ? o.getResults().size() : 0));
                                return o.getResults();
                            }
                        });
                    }
                });
                break;
            }
            case NETWORK_ELSE_CACHE: {
                queryResult = this.queryRemoteServer(authenticatedUser, validPath, query);
                if (null == queryResult) break;
                result = queryResult.map((Function)new Function<LCQueryResult, List<LCObject>>(){

                    public List<LCObject> apply(LCQueryResult o) throws Exception {
                        o.setClassName(className);
                        for (LCObject obj : o.getResults()) {
                            obj.setClassName(className);
                        }
                        QueryResultCache.getInstance().cacheResult(cacheKey, o.toJSONString());
                        LOGGER.d("invoke within StorageClient.queryObjects(). resultSize:" + (null != o.getResults() ? o.getResults().size() : 0));
                        return o.getResults();
                    }
                }).onErrorResumeNext((Function)new Function<Throwable, ObservableSource<? extends List<LCObject>>>(){

                    public ObservableSource<? extends List<LCObject>> apply(Throwable throwable) throws Exception {
                        LOGGER.d("failed to query networking, cause: " + throwable.getMessage() + ", try to query local cache.");
                        return QueryResultCache.getInstance().getCacheResult(className, query, maxAgeInMilliseconds, true);
                    }
                });
                break;
            }
            default: {
                queryResult = this.queryRemoteServer(authenticatedUser, validPath, query);
                if (null == queryResult) break;
                result = queryResult.map((Function)new Function<LCQueryResult, List<LCObject>>(){

                    public List<LCObject> apply(LCQueryResult o) throws Exception {
                        o.setClassName(className);
                        for (LCObject obj : o.getResults()) {
                            obj.setClassName(className);
                        }
                        QueryResultCache.getInstance().cacheResult(cacheKey, o.toJSONString());
                        LOGGER.d("invoke within StorageClient.queryObjects(). resultSize:" + (null != o.getResults() ? o.getResults().size() : 0));
                        return o.getResults();
                    }
                });
            }
        }
        return result;
    }

    public Observable<LCQueryResult> cloudQuery(LCUser authenticatedUser, Map<String, String> query) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservable(this.apiService.cloudQuery(authenticatedSession, query));
    }

    public Observable<Integer> queryCount(LCUser authenticatedUser, String className, Map<String, String> query) {
        Observable<LCQueryResult> queryResult = this.queryRemoteServer(authenticatedUser, className, query);
        if (null == queryResult) {
            return null;
        }
        return queryResult.map((Function)new Function<LCQueryResult, Integer>(){

            public Integer apply(LCQueryResult o) throws Exception {
                LOGGER.d("invoke within StorageClient.queryCount(). result:" + o + ", return:" + o.getCount());
                return o.getCount();
            }
        });
    }

    public Observable<LCNull> deleteObject(LCUser authenticatedUser, String className, String objectId, Map<String, Object> param) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservable(this.apiService.deleteObject(authenticatedSession, className, objectId, param));
    }

    public Observable<? extends LCObject> createObject(LCUser authenticatedUser, final String className, JSONObject data, boolean fetchFlag, JSONObject where) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        Observable object = this.wrapObservable(this.apiService.createObject(authenticatedSession, className, data, fetchFlag, where));
        if (null == object) {
            return null;
        }
        return object.map((Function)new Function<LCObject, LCObject>(){

            public LCObject apply(LCObject LCObject2) {
                LOGGER.d(LCObject2.toString());
                return Transformer.transform(LCObject2, className);
            }
        });
    }

    public Observable<? extends LCObject> saveObject(LCUser authenticatedUser, final String className, String objectId, JSONObject data, boolean fetchFlag, JSONObject where) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        Observable object = this.wrapObservable(this.apiService.updateObject(authenticatedSession, className, objectId, data, fetchFlag, where));
        if (null == object) {
            return null;
        }
        return object.map((Function)new Function<LCObject, LCObject>(){

            public LCObject apply(LCObject LCObject2) {
                LOGGER.d("saveObject finished. intermediaObj=" + LCObject2.toString() + ", convert to " + className);
                return Transformer.transform(LCObject2, className);
            }
        });
    }

    public <E extends LCObject> Observable<E> saveWholeObject(LCUser authenticatedUser, final Class<E> clazz, String endpointClass, String objectId, JSONObject object, boolean fetchFlag, JSONObject where) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        Observable result = null;
        result = StringUtil.isEmpty(objectId) ? this.wrapObservable(this.apiService.saveWholeObject(authenticatedSession, endpointClass, object, fetchFlag, where)) : this.wrapObservable(this.apiService.saveWholeObject(authenticatedSession, endpointClass, objectId, object, fetchFlag, where));
        if (null == result) {
            return null;
        }
        return result.map(new Function<LCObject, E>(){

            public E apply(LCObject LCObject2) throws Exception {
                return Transformer.transform(LCObject2, clazz);
            }
        });
    }

    public Observable<LCObject> getWholeObject(LCUser authenticatedUser, String endpointClass, String objectId, String includeKeys) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservable(this.apiService.getWholeObject(authenticatedSession, endpointClass, objectId, includeKeys));
    }

    public Observable<LCNull> deleteWholeObject(LCUser authenticatedUser, String endpointClass, String objectId, Map<String, Object> param) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservable(this.apiService.deleteWholeObject(authenticatedSession, endpointClass, objectId, param));
    }

    public Observable<LCFile> fetchFile(LCUser authenticatedUser, String objectId) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        Observable object = this.wrapObservable(this.apiService.fetchFile(authenticatedSession, objectId));
        if (null == object) {
            return null;
        }
        return object.map((Function)new Function<LCFile, LCFile>(){

            public LCFile apply(LCFile avFile) throws Exception {
                avFile.setClassName("_File");
                return avFile;
            }
        });
    }

    public Observable<FileUploadToken> newUploadToken(LCUser authenticatedUser, JSONObject fileData) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservableInBackground(this.apiService.createUploadToken(authenticatedSession, fileData));
    }

    public void fileCallback(LCUser authenticatedUser, JSONObject result) throws IOException {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        this.apiService.fileCallback(authenticatedSession, result).execute();
    }

    public Observable<List<Map<String, Object>>> batchSave(LCUser authenticatedUser, JSONObject parameter) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        Observable result = this.wrapObservable(this.apiService.batchCreate(authenticatedSession, parameter));
        return result;
    }

    public Observable<JSONObject> batchUpdate(LCUser authenticatedUser, JSONObject parameter) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        Observable result = this.wrapObservable(this.apiService.batchUpdate(authenticatedSession, parameter));
        return result;
    }

    public Observable<LCUser> signUp(JSONObject data) {
        return this.wrapObservable(this.apiService.signup(data));
    }

    public Observable<LCUser> signUpWithFlag(JSONObject data, boolean failOnNotExist) {
        return this.wrapObservable(this.apiService.signup(data, failOnNotExist));
    }

    public <T extends LCUser> Observable<T> signUpOrLoginByMobilephone(final JSONObject data, final Class<T> clazz) {
        return this.wrapObservable(this.apiService.signupByMobilePhone(data)).map(new Function<LCUser, T>(){

            public T apply(LCUser avUser) throws Exception {
                LCUser rst = (LCUser)Transformer.transform((LCObject)avUser, clazz);
                StorageClient.this.attachLoginInfo(data, rst);
                LCUser.changeCurrentUser(rst, true);
                return rst;
            }
        });
    }

    private <T extends LCUser> void attachLoginInfo(JSONObject data, T rst) {
        if (null == data || null == rst) {
            return;
        }
        if (data.containsKey("email")) {
            rst.setEmail(data.getString("email"));
        }
        if (data.containsKey("username")) {
            rst.setUsername(data.getString("username"));
        }
        if (data.containsKey("mobilePhoneNumber")) {
            rst.setMobilePhoneNumber(data.getString("mobilePhoneNumber"));
        }
    }

    public <T extends LCUser> Observable<T> logIn(final JSONObject data, final Class<T> clazz) {
        Observable object = this.wrapObservable(this.apiService.login(data));
        if (null == object) {
            return null;
        }
        return object.map(new Function<LCUser, T>(){

            public T apply(LCUser avUser) throws Exception {
                LCUser rst = (LCUser)Transformer.transform((LCObject)avUser, clazz);
                StorageClient.this.attachLoginInfo(data, rst);
                LCUser.changeCurrentUser(rst, true);
                return rst;
            }
        });
    }

    public Observable<LCFriendshipRequest> applyFriendshipRequest(LCUser authenticatedUser, JSONObject data) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        Observable result = this.wrapObservable(this.apiService.applyFriendship(authenticatedSession, data));
        if (null == result) {
            return null;
        }
        return result.map((Function)new Function<LCObject, LCFriendshipRequest>(){

            public LCFriendshipRequest apply(LCObject LCObject2) throws Exception {
                return Transformer.transform(LCObject2, LCFriendshipRequest.class);
            }
        });
    }

    public Observable<LCFriendshipRequest> acceptFriendshipRequest(LCUser authenticatedUser, final LCFriendshipRequest request, JSONObject param) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        Observable result = this.wrapObservable(this.apiService.acceptFriendshipRequest(authenticatedSession, request.getObjectId(), param));
        if (null == result) {
            return null;
        }
        return result.map((Function)new Function<LCObject, LCFriendshipRequest>(){

            public LCFriendshipRequest apply(LCObject LCObject2) throws Exception {
                LCFriendshipRequest response = Transformer.transform(LCObject2, LCFriendshipRequest.class);
                request.getServerData().put("status", "accepted");
                request.getServerData().put("updatedAt", response.getUpdatedAtString());
                return request;
            }
        });
    }

    public Observable<LCFriendshipRequest> declineFriendshipRequest(LCUser authenticatedUser, final LCFriendshipRequest request) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        Observable result = this.wrapObservable(this.apiService.declineFriendshipRequest(authenticatedSession, request.getObjectId()));
        return result.map((Function)new Function<LCObject, LCFriendshipRequest>(){

            public LCFriendshipRequest apply(LCObject LCObject2) throws Exception {
                LCFriendshipRequest response = Transformer.transform(LCObject2, LCFriendshipRequest.class);
                request.getServerData().put("status", "declined");
                request.getServerData().put("updatedAt", response.getUpdatedAtString());
                return request;
            }
        });
    }

    public Observable<Boolean> checkAuthenticated(String sessionToken) {
        HashMap<String, String> param = new HashMap<String, String>(1);
        param.put("session_token", sessionToken);
        Observable apiResult = this.wrapObservable(this.apiService.checkAuthenticated(sessionToken, param));
        if (null == apiResult) {
            return Observable.just((Object)false);
        }
        return apiResult.map((Function)new Function<LCUser, Boolean>(){

            public Boolean apply(LCUser o) throws Exception {
                if (null != o) {
                    return true;
                }
                return false;
            }
        });
    }

    public <T extends LCUser> Observable<T> createUserBySession(String sessionToken, final Class<T> clazz) {
        HashMap<String, String> param = new HashMap<String, String>(1);
        param.put("session_token", sessionToken);
        Observable result = this.wrapObservable(this.apiService.checkAuthenticated(sessionToken, param));
        return result.map(new Function<LCUser, T>(){

            public T apply(LCUser avUser) throws Exception {
                if (null == avUser) {
                    LOGGER.e("The mapper function returned a null value.");
                    return null;
                }
                return (LCUser)Transformer.transform((LCObject)avUser, clazz);
            }
        });
    }

    public Observable<Boolean> refreshSessionToken(final LCUser user) {
        return this.wrapObservable(this.apiService.refreshSessionToken(user.getSessionToken(), user.getObjectId()).map((Function)new Function<LCUser, Boolean>(){

            public Boolean apply(LCUser avUser) throws Exception {
                if (null != avUser && !StringUtil.isEmpty(avUser.getSessionToken())) {
                    user.internalChangeSessionToken(avUser.getSessionToken());
                    return true;
                }
                return false;
            }
        }));
    }

    public Observable<LCNull> requestResetPassword(String email) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("email", email);
        return this.wrapObservable(this.apiService.requestResetPassword(map));
    }

    public Observable<LCNull> requestResetPasswordBySmsCode(String phoneNumber, String validateToken) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("mobilePhoneNumber", phoneNumber);
        if (!StringUtil.isEmpty(validateToken)) {
            map.put("validate_token", validateToken);
        }
        return this.wrapObservable(this.apiService.requestResetPasswordBySmsCode(map));
    }

    public Observable<LCNull> requestEmailVerify(String email) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("email", email);
        return this.wrapObservable(this.apiService.requestEmailVerify(map));
    }

    public Observable<LCNull> requestMobilePhoneVerify(String mobilePhone, String validateToken) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("mobilePhoneNumber", mobilePhone);
        if (!StringUtil.isEmpty(validateToken)) {
            map.put("validate_token", validateToken);
        }
        return this.wrapObservable(this.apiService.requestMobilePhoneVerify(map));
    }

    public Observable<LCNull> verifyMobilePhone(String verifyCode) {
        return this.wrapObservable(this.apiService.verifyMobilePhone(verifyCode));
    }

    public Observable<LCNull> requestLoginSmsCode(String phoneNumber, String validateToken) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("mobilePhoneNumber", phoneNumber);
        if (!StringUtil.isEmpty(validateToken)) {
            map.put("validate_token", validateToken);
        }
        return this.wrapObservable(this.apiService.requestLoginSmsCode(map));
    }

    public Observable<LCNull> resetPasswordBySmsCode(String smsCode, String newPass) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("password", newPass);
        return this.wrapObservable(this.apiService.resetPasswordBySmsCode(smsCode, map));
    }

    public Observable<LCNull> updatePassword(final LCUser user, String oldPass, String newPass) {
        if (null == user) {
            return Observable.error((Throwable)new IllegalArgumentException("user is null"));
        }
        if (StringUtil.isEmpty(oldPass) || StringUtil.isEmpty(newPass)) {
            return Observable.error((Throwable)new IllegalArgumentException("old password or new password is empty"));
        }
        JSONObject param = JSONObject.Builder.create(null);
        param.put("old_password", oldPass);
        param.put("new_password", newPass);
        return this.wrapObservable(this.apiService.updatePassword(user.getSessionToken(), user.getObjectId(), param).map((Function)new Function<LCUser, LCNull>(){

            public LCNull apply(LCUser var1) throws Exception {
                if (null != var1) {
                    user.internalChangeSessionToken(var1.getSessionToken());
                }
                return new LCNull();
            }
        }));
    }

    public Observable<JSONObject> followUser(LCUser authenticatedUser, String followee, String follower, Map<String, Object> attr) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservable(this.apiService.followUser(authenticatedSession, followee, follower, attr));
    }

    public Observable<JSONObject> unfollowUser(LCUser authenticatedUser, String followee, String follower) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservable(this.apiService.unfollowUser(authenticatedSession, followee, follower));
    }

    public Observable<LCFriendship> updateFriendship(LCUser authenticatedUser, String followeeUserid, String friendObjectId, Map<String, Object> attr) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservable(this.apiService.updateFriendship(authenticatedSession, followeeUserid, friendObjectId, attr));
    }

    public Observable<JSONObject> getFollowersAndFollowees(LCUser authenticatedUser, String userId) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservable(this.apiService.getFollowersAndFollowees(authenticatedSession, userId));
    }

    public Observable<List<LCFriendship>> queryFriendship(LCUser authenticatedUser, Map<String, String> conditions) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservable(this.apiService.getFriends(authenticatedSession, conditions).map((Function)new Function<LCQueryResult, List<LCFriendship>>(){

            public List<LCFriendship> apply(LCQueryResult result) throws Exception {
                if (null == result || null == result.getResults()) {
                    return null;
                }
                List<LCObject> originResult = result.getResults();
                ArrayList<LCFriendship> convertedResult = new ArrayList<LCFriendship>(originResult.size());
                for (LCObject obj : originResult) {
                    convertedResult.add(new LCFriendship(obj));
                }
                return convertedResult;
            }
        }));
    }

    public Observable<JSONObject> blockFriend(LCUser authenticatedUser, String objectId) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservable(this.apiService.blockFriendByObjectId(authenticatedSession, objectId));
    }

    public Observable<JSONObject> unblockFriend(LCUser authenticatedUser, String objectId) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservable(this.apiService.unblockFriendByObjectId(authenticatedSession, objectId));
    }

    public Observable<LCStatus> postStatus(LCUser authenticatedUser, Map<String, Object> param) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservable(this.apiService.postStatus(authenticatedSession, param));
    }

    public Observable<LCStatus> fetchStatus(LCUser authenticatedUser, String objectId) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservable(this.apiService.fetchSingleStatus(authenticatedSession, objectId));
    }

    public Observable<List<LCStatus>> queryStatus(LCUser authenticatedUser, Map<String, String> param) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservable(this.apiService.fetchStatuses(authenticatedSession, param).map((Function)new Function<LCQueryResult, List<LCStatus>>(){

            public List<LCStatus> apply(LCQueryResult o) throws Exception {
                if (null == o) {
                    LOGGER.e("The mapper function returned a null value.");
                    return null;
                }
                ArrayList<LCStatus> results = new ArrayList<LCStatus>();
                for (LCObject obj : o.getResults()) {
                    results.add(new LCStatus(obj));
                }
                return results;
            }
        }));
    }

    public Observable<List<LCStatus>> queryInbox(LCUser authenticatedUser, Map<String, String> param) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservable(this.apiService.queryInbox(authenticatedSession, param).map((Function)new Function<LCQueryResult, List<LCStatus>>(){

            public List<LCStatus> apply(LCQueryResult o) throws Exception {
                if (null == o) {
                    LOGGER.e("The mapper function returned a null value.");
                    return null;
                }
                ArrayList<LCStatus> results = new ArrayList<LCStatus>();
                for (LCObject obj : o.getResults()) {
                    results.add(new LCStatus(obj));
                }
                return results;
            }
        }));
    }

    public Observable<JSONObject> getInboxCount(LCUser authenticatedUser, Map<String, String> param) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservable(this.apiService.getInboxCount(authenticatedSession, param));
    }

    public Observable<LCNull> deleteStatus(LCUser authenticatedUser, String statusId) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservable(this.apiService.deleteStatus(authenticatedSession, statusId));
    }

    public Observable<LCNull> deleteInboxStatus(LCUser authenticatedUser, Map<String, Object> param) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservable(this.apiService.deleteInboxStatus(authenticatedSession, param));
    }

    public <T> Observable<T> callRPC(LCUser authenticatedUser, String name, Object param) {
        return this.callRPC(authenticatedUser, name, param, false, null);
    }

    <T> Observable<T> callRPC(LCUser authenticatedUser, String name, Object param, final boolean enableCache, final String cacheKey) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        Observable cloudCall = this.wrapObservable(this.apiService.cloudRPC(authenticatedSession, name, param));
        if (null == cloudCall) {
            return null;
        }
        return cloudCall.map(new Function<Map<String, ?>, T>(){

            public T apply(Map<String, ?> resultMap) throws Exception {
                try {
                    Object resultValue = resultMap.get("result");
                    if (enableCache && !StringUtil.isEmpty(cacheKey)) {
                        LOGGER.d("cache rpc result:" + JSON.toJSONString(resultValue));
                        QueryResultCache.getInstance().cacheResult(cacheKey, JSON.toJSONString(resultValue));
                    }
                    if (resultValue instanceof Collection) {
                        return Utils.getObjectFrom((Collection)resultValue);
                    }
                    if (resultValue instanceof Map) {
                        return Utils.getObjectFrom((Map)resultValue);
                    }
                    return resultValue;
                }
                catch (Exception ex) {
                    LOGGER.d("RPCFunction error: " + ex.getMessage());
                    return null;
                }
            }
        });
    }

    public <T> Observable<T> callFunction(LCUser authenticatedUser, String name, Map<String, Object> params) {
        return this.callFunction(authenticatedUser, name, params, false, null);
    }

    <T> Observable<T> callFunction(LCUser authenticatedUser, String name, Map<String, Object> params, final boolean enableCache, final String cacheKey) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        Observable cloudCall = this.wrapObservable(this.apiService.cloudFunction(authenticatedSession, name, params));
        if (null == cloudCall) {
            return null;
        }
        return cloudCall.map(new Function<Map<String, ?>, T>(){

            public T apply(Map<String, ?> resultMap) throws Exception {
                try {
                    Object resultValue = resultMap.get("result");
                    if (enableCache && !StringUtil.isEmpty(cacheKey)) {
                        LOGGER.d("cache cloud function result:" + JSON.toJSONString(resultValue));
                        QueryResultCache.getInstance().cacheResult(cacheKey, JSON.toJSONString(resultMap));
                    }
                    if (resultValue instanceof Collection) {
                        return Utils.getObjectFrom((Collection)resultValue);
                    }
                    if (resultValue instanceof Map) {
                        return Utils.getObjectFrom((Map)resultValue);
                    }
                    return resultValue;
                }
                catch (Exception ex) {
                    LOGGER.d("CloudFunction error: " + ex.getMessage());
                    return null;
                }
            }
        });
    }

    <T> Observable<T> executeCachedQuery(String clazz, Map<String, Object> query, LCQuery.CachePolicy cachePolicy, long maxAgeInMilliseconds, final QueryExecutor cacheQueryExecutor, final QueryExecutor remoteQueryExecutor) {
        Observable result = null;
        switch (cachePolicy) {
            case CACHE_ONLY: {
                result = cacheQueryExecutor.executor();
                break;
            }
            case CACHE_ELSE_NETWORK: {
                result = cacheQueryExecutor.executor();
                result = result.onErrorResumeNext(new Function<Throwable, Observable<T>>(){

                    public Observable<T> apply(Throwable throwable) throws Exception {
                        LOGGER.d("failed to query local cache, cause: " + throwable.getMessage() + ", try to query networking");
                        return remoteQueryExecutor.executor();
                    }
                });
                break;
            }
            case NETWORK_ELSE_CACHE: {
                result = remoteQueryExecutor.executor();
                result = result.onErrorResumeNext(new Function<Throwable, Observable<T>>(){

                    public Observable<T> apply(Throwable throwable) throws Exception {
                        LOGGER.d("failed to query networking, cause: " + throwable.getMessage() + ", try to query local cache.");
                        return cacheQueryExecutor.executor();
                    }
                });
                break;
            }
            default: {
                result = remoteQueryExecutor.executor();
            }
        }
        return result;
    }

    public <T> Observable<T> callRPCWithCachePolicy(final LCUser asAuthenticatedUser, final String name, final Map<String, Object> param, final LCQuery.CachePolicy cachePolicy, final long maxCacheAge, final Class<T> clazz) {
        final String cacheKey = QueryResultCache.generateCachedKey(name, param);
        return this.executeCachedQuery(name, param, cachePolicy, maxCacheAge, new QueryExecutor(){

            @Override
            public <T> Observable<T> executor() {
                return QueryResultCache.getInstance().getCacheRawResult(name, cacheKey, maxCacheAge, true).map(new Function<String, T>(){

                    public T apply(String s) throws Exception {
                        if (StringUtil.isEmpty(s)) {
                            return null;
                        }
                        LOGGER.d("found cached rpc result: " + s);
                        Object parsedObject = JSON.parseObject(s, clazz);
                        if (parsedObject instanceof Collection) {
                            return Utils.getObjectFrom((Collection)parsedObject);
                        }
                        if (parsedObject instanceof Map) {
                            return Utils.getObjectFrom((Map)parsedObject);
                        }
                        return parsedObject;
                    }
                });
            }
        }, new QueryExecutor(){

            @Override
            public <T> Observable<T> executor() {
                return StorageClient.this.callRPC(asAuthenticatedUser, name, param, cachePolicy != LCQuery.CachePolicy.IGNORE_CACHE && cachePolicy != LCQuery.CachePolicy.NETWORK_ONLY, cacheKey);
            }
        });
    }

    public <T> Observable<T> callFunctionWithCachePolicy(final LCUser asAuthenticatedUser, final String name, final Map<String, Object> params, final LCQuery.CachePolicy cachePolicy, final long maxCacheAge, final Class<T> clazz) {
        final String cacheKey = QueryResultCache.generateCachedKey(name, params);
        return this.executeCachedQuery(name, params, cachePolicy, maxCacheAge, new QueryExecutor(){

            @Override
            public <T> Observable<T> executor() {
                return QueryResultCache.getInstance().getCacheRawResult(name, cacheKey, maxCacheAge, true).map(new Function<String, T>(){

                    public T apply(String s) throws Exception {
                        if (StringUtil.isEmpty(s)) {
                            return null;
                        }
                        LOGGER.d("found cached function result: " + s);
                        JSONObject parsedObject = null;
                        try {
                            JSONObject tmpObject = JSON.parseObject(s);
                            parsedObject = null != tmpObject && tmpObject.containsKey("result") ? tmpObject.get("result") : tmpObject;
                        }
                        catch (Exception exception) {
                            parsedObject = JSON.parseObject(s, clazz);
                        }
                        if (parsedObject instanceof Collection) {
                            return Utils.getObjectFrom((Collection)((Object)parsedObject));
                        }
                        if (parsedObject instanceof Map) {
                            return Utils.getObjectFrom(parsedObject);
                        }
                        if (parsedObject instanceof Number) {
                            return NumberDeserializerDoubleAsIntFix.parsePrecisionNumber((Number)((Object)parsedObject));
                        }
                        return parsedObject;
                    }
                });
            }
        }, new QueryExecutor(){

            @Override
            public <T> Observable<T> executor() {
                return StorageClient.this.callFunction(asAuthenticatedUser, name, params, cachePolicy != LCQuery.CachePolicy.IGNORE_CACHE && cachePolicy != LCQuery.CachePolicy.NETWORK_ONLY, cacheKey);
            }
        });
    }

    public Observable<LCCaptchaDigest> requestCaptcha(LCCaptchaOption option) {
        return this.wrapObservable(this.apiService.requestCaptcha(option.getRequestParam()));
    }

    public Observable<LCCaptchaValidateResult> verifyCaptcha(String code, String token) {
        if (StringUtil.isEmpty(code) || StringUtil.isEmpty(token)) {
            return Observable.error((Throwable)new IllegalArgumentException("code or token is empty"));
        }
        HashMap<String, String> param = new HashMap<String, String>(2);
        param.put("captcha_code", code);
        param.put("captcha_token", token);
        return this.wrapObservable(this.apiService.verifyCaptcha(param));
    }

    public Observable<LCNull> requestSMSCode(String mobilePhone, Map<String, Object> param) {
        param.put("mobilePhoneNumber", mobilePhone);
        return this.wrapObservable(this.apiService.requestSMSCode(param));
    }

    public Observable<LCNull> requestSMSCodeForUpdatingPhoneNumber(LCUser asUser, String mobilePhone, Map<String, Object> param) {
        param.put("mobilePhoneNumber", mobilePhone);
        String sessionToken = this.getSessionToken(asUser);
        return this.wrapObservable(this.apiService.requestSMSCodeForUpdatingPhoneNumber(sessionToken, param));
    }

    public Observable<LCNull> verifySMSCode(String code, String mobilePhone) {
        if (StringUtil.isEmpty(code) || StringUtil.isEmpty(mobilePhone)) {
            return Observable.error((Throwable)new IllegalArgumentException("code or mobilePhone is empty"));
        }
        HashMap<String, Object> param = new HashMap<String, Object>(1);
        param.put("mobilePhoneNumber", mobilePhone);
        return this.wrapObservable(this.apiService.verifySMSCode(code, param));
    }

    public Observable<LCNull> verifySMSCodeForUpdatingPhoneNumber(LCUser asUser, String code, String mobilePhone) {
        if (StringUtil.isEmpty(code) || StringUtil.isEmpty(mobilePhone)) {
            return Observable.error((Throwable)new IllegalArgumentException("code or mobilePhone is empty"));
        }
        String sessionToken = this.getSessionToken(asUser);
        HashMap<String, Object> param = new HashMap<String, Object>(1);
        param.put("mobilePhoneNumber", mobilePhone);
        param.put("code", code);
        return this.wrapObservable(this.apiService.verifySMSCodeForUpdatingPhoneNumber(sessionToken, param));
    }

    public Observable<LCSearchResponse> search(LCUser authenticatedUser, Map<String, String> params) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservable(this.apiService.search(authenticatedSession, params));
    }

    public Observable<LCObject> createLeaderboard(Map<String, Object> params) {
        return this.wrapObservable(this.apiService.createLeaderboard(params));
    }

    public Observable<LCObject> fetchLeaderboard(String name) {
        return this.wrapObservable(this.apiService.fetchLeaderboard(name));
    }

    public Observable<LCObject> updateLeaderboard(String name, Map<String, Object> params) {
        return this.wrapObservable(this.apiService.updateLeaderboard(name, params));
    }

    public Observable<LCObject> resetLeaderboard(String name) {
        return this.wrapObservable(this.apiService.resetLeaderboard(name));
    }

    public Observable<Boolean> destroyLeaderboard(String name) {
        return this.wrapObservable(this.apiService.destroyLeaderboard(name)).map((Function)new Function<LCObject, Boolean>(){

            public Boolean apply(LCObject object) throws Exception {
                return null != object;
            }
        });
    }

    public Observable<LCStatisticResult> updateUserStatistics(LCUser user, List<Map<String, Object>> params, boolean overwrite) {
        int overwriteFlag;
        if (null == user) {
            return Observable.error((Throwable)new IllegalArgumentException("user is null"));
        }
        if (null == params || params.size() < 1) {
            return Observable.error((Throwable)new IllegalArgumentException("params is empty"));
        }
        String sessionToken = user.getSessionToken();
        int n = overwriteFlag = overwrite ? 1 : 0;
        if (user.isAuthenticated()) {
            return this.wrapObservable(this.apiService.updateAuthenticatedUserStatistics(sessionToken, params, overwriteFlag));
        }
        return this.wrapObservable(this.apiService.updateUserStatistics(user.getObjectId(), params, overwriteFlag));
    }

    public Observable<LCStatisticResult> updateObjectStatistics(String objectId, List<Map<String, Object>> params, boolean overwrite) {
        if (StringUtil.isEmpty(objectId)) {
            return Observable.error((Throwable)new IllegalArgumentException("objectId is invalid."));
        }
        if (null == params || params.size() < 1) {
            return Observable.error((Throwable)new IllegalArgumentException("params is invalid."));
        }
        int overwriteFlag = overwrite ? 1 : 0;
        return this.wrapObservable(this.apiService.updateObjectStatistics(objectId, params, overwriteFlag));
    }

    public Observable<LCStatisticResult> updateEntityStatistics(String entityId, List<Map<String, Object>> params, boolean overwrite) {
        if (StringUtil.isEmpty(entityId)) {
            return Observable.error((Throwable)new IllegalArgumentException("entityId is invalid."));
        }
        if (null == params || params.size() < 1) {
            return Observable.error((Throwable)new IllegalArgumentException("params is invalid."));
        }
        int overwriteFlag = overwrite ? 1 : 0;
        return this.wrapObservable(this.apiService.updateEntityStatistics(entityId, params, overwriteFlag));
    }

    public Observable<LCStatisticResult> getUserStatistics(String userObjectId, List<String> statisticNames) {
        if (StringUtil.isEmpty(userObjectId)) {
            return Observable.error((Throwable)new IllegalArgumentException("userObjectId is invalid."));
        }
        String statistics = StringUtil.join(",", statisticNames);
        return this.wrapObservable(this.apiService.getUserStatistics(userObjectId, statistics));
    }

    public Observable<LCStatisticResult> getEntityStatistics(String entityId, List<String> statisticNames) {
        if (StringUtil.isEmpty(entityId)) {
            return Observable.error((Throwable)new IllegalArgumentException("entityId is null"));
        }
        String statistics = StringUtil.join(",", statisticNames);
        return this.wrapObservable(this.apiService.getEntityStatistics(entityId, statistics));
    }

    public Observable<LCStatisticResult> getObjectStatistics(String objectId, List<String> statisticNames) {
        if (StringUtil.isEmpty(objectId)) {
            return Observable.error((Throwable)new IllegalArgumentException("objectId is null"));
        }
        String statistics = StringUtil.join(",", statisticNames);
        return this.wrapObservable(this.apiService.getObjectStatistics(objectId, statistics));
    }

    public Observable<LCStatisticResult> getGroupStatistics(String leaderboardType, String statisticName, List<String> targetKeys) {
        if (StringUtil.isEmpty(leaderboardType)) {
            return Observable.error((Throwable)new IllegalArgumentException("leaderboard type is null"));
        }
        if (StringUtil.isEmpty(statisticName)) {
            return Observable.error((Throwable)new IllegalArgumentException("statistic name is null"));
        }
        if (null == targetKeys || targetKeys.size() < 1) {
            return Observable.just((Object)new LCStatisticResult());
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("ids", targetKeys);
        return this.wrapObservable(this.apiService.queryGroupStatistics(leaderboardType, statisticName, param));
    }

    public Observable<LCLeaderboardResult> getLeaderboardResults(String leaderboardType, String statisticName, int skip, int limit, List<String> selectUserKeys, List<String> includeUserKeys, List<String> includeStatisticNames, int version, boolean withCount) {
        if (StringUtil.isEmpty(leaderboardType) || StringUtil.isEmpty(statisticName)) {
            return Observable.error((Throwable)new IllegalArgumentException("memberType or statisticName is null"));
        }
        String selectKeys = StringUtil.join(",", selectUserKeys);
        String includeKeys = StringUtil.join(",", includeUserKeys);
        String includeStatistics = StringUtil.join(",", includeStatisticNames);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (skip > 0) {
            params.put("startPosition", skip);
        }
        if (limit > 0) {
            params.put("maxResultsCount", limit);
        }
        if (!StringUtil.isEmpty(selectKeys)) {
            params.put("selectKeys", selectKeys);
        }
        if (!StringUtil.isEmpty(includeKeys)) {
            params.put("includeKeys", includeKeys);
        }
        if (!StringUtil.isEmpty(includeStatistics)) {
            params.put("includeStatistics", includeStatistics);
        }
        if (version > -1) {
            params.put("version", version);
        }
        if (withCount) {
            params.put("count", 1);
        }
        return this.wrapObservable(this.apiService.getLeaderboardResults(leaderboardType, statisticName, params));
    }

    public Observable<LCLeaderboardResult> getLeaderboardGroupResults(String leaderboardType, String statisticName, List<String> groupUserIds, int skip, int limit, List<String> selectUserKeys, List<String> includeUserKeys, List<String> includeStatisticNames, int version) {
        if (StringUtil.isEmpty(leaderboardType) || StringUtil.isEmpty(statisticName)) {
            return Observable.error((Throwable)new IllegalArgumentException("memberType or statisticName is null"));
        }
        if (!"user".equalsIgnoreCase(leaderboardType)) {
            return Observable.error((Throwable)new IllegalArgumentException("only memberType of user is supported."));
        }
        if (null == groupUserIds || groupUserIds.isEmpty()) {
            return Observable.error((Throwable)new IllegalArgumentException("group user id is empty."));
        }
        String selectKeys = StringUtil.join(",", selectUserKeys);
        String includeKeys = StringUtil.join(",", includeUserKeys);
        String includeStatistics = StringUtil.join(",", includeStatisticNames);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (skip > 0) {
            params.put("startPosition", skip);
        }
        if (limit > 0) {
            params.put("maxResultsCount", limit);
        }
        if (!StringUtil.isEmpty(selectKeys)) {
            params.put("selectKeys", selectKeys);
        }
        if (!StringUtil.isEmpty(includeKeys)) {
            params.put("includeKeys", includeKeys);
        }
        if (!StringUtil.isEmpty(includeStatistics)) {
            params.put("includeStatistics", includeStatistics);
        }
        if (version > -1) {
            params.put("version", version);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("ids", groupUserIds);
        return this.wrapObservable(this.apiService.queryLeaderboardGroupResults(leaderboardType, statisticName, params, data));
    }

    public Observable<LCLeaderboardResult> getLeaderboardAroundResults(String leaderboardType, String statisticName, String targetId, int skip, int limit, List<String> selectUserKeys, List<String> includeUserKeys, List<String> includeStatisticNames, int version) {
        if (StringUtil.isEmpty(leaderboardType) || StringUtil.isEmpty(statisticName)) {
            return Observable.error((Throwable)new IllegalArgumentException("memberType or statisticName is null"));
        }
        String selectKeys = StringUtil.join(",", selectUserKeys);
        String includeKeys = StringUtil.join(",", includeUserKeys);
        String includeStatistics = StringUtil.join(",", includeStatisticNames);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (skip > 0) {
            params.put("startPosition", skip);
        }
        if (limit > 0) {
            params.put("maxResultsCount", limit);
        }
        if (!StringUtil.isEmpty(selectKeys)) {
            params.put("selectKeys", selectKeys);
        }
        if (!StringUtil.isEmpty(includeKeys)) {
            params.put("includeKeys", includeKeys);
        }
        if (!StringUtil.isEmpty(includeStatistics)) {
            params.put("includeStatistics", includeStatistics);
        }
        if (version > -1) {
            params.put("version", version);
        }
        return this.wrapObservable(this.apiService.getLeaderboardAroundResults(leaderboardType, statisticName, targetId, params));
    }

    public Observable<LCLeaderboardResult> getLeaderboardAroundInGroupResults(String leaderboardType, String statisticName, List<String> groupUserIds, String targetId, int limit, List<String> selectUserKeys, List<String> includeUserKeys, List<String> includeStatisticNames, int version) {
        if (StringUtil.isEmpty(leaderboardType) || StringUtil.isEmpty(statisticName)) {
            return Observable.error((Throwable)new IllegalArgumentException("memberType or statisticName is null"));
        }
        if (!"user".equalsIgnoreCase(leaderboardType)) {
            return Observable.error((Throwable)new IllegalArgumentException("only memberType of user is supported."));
        }
        if (null == groupUserIds || groupUserIds.isEmpty()) {
            return Observable.error((Throwable)new IllegalArgumentException("group user id is empty."));
        }
        String selectKeys = StringUtil.join(",", selectUserKeys);
        String includeKeys = StringUtil.join(",", includeUserKeys);
        String includeStatistics = StringUtil.join(",", includeStatisticNames);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (limit > 0) {
            params.put("maxResultsCount", limit);
        }
        if (!StringUtil.isEmpty(selectKeys)) {
            params.put("selectKeys", selectKeys);
        }
        if (!StringUtil.isEmpty(includeKeys)) {
            params.put("includeKeys", includeKeys);
        }
        if (!StringUtil.isEmpty(includeStatistics)) {
            params.put("includeStatistics", includeStatistics);
        }
        if (version > -1) {
            params.put("version", version);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("ids", groupUserIds);
        return this.wrapObservable(this.apiService.queryLeaderboardAroundInGroupResults(leaderboardType, statisticName, targetId, params, data));
    }

    static interface QueryExecutor {
        public <T> Observable<T> executor();
    }
}

