/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.LCLeaderboardResult;
import cn.leancloud.LCObject;
import cn.leancloud.LCStatisticResult;
import cn.leancloud.LCUser;
import cn.leancloud.core.PaasClient;
import cn.leancloud.utils.StringUtil;
import io.reactivex.Observable;
import io.reactivex.functions.Function;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LCLeaderboard {
    public static final int INVALID_VERSION = -1;
    public static final String MEMBER_TYPE_USER = "_User";
    public static final String MEMBER_TYPE_ENTITY = "_Entity";
    public static final String MEMBER_TYPE_OBJECT = "_Object";
    static final String ATTR_STATISTIC_NAME = "statisticName";
    static final String ATTR_MEMBER_TYPE = "memberType";
    static final String ATTR_UPDATE_STRATEGY = "updateStrategy";
    static final String ATTR_ORDER = "order";
    static final String ATTR_VERSION_CHANGE_INTERVAL = "versionChangeInterval";
    static final String ATTR_VERSION = "version";
    static final String ATTR_EXPIRED_AT = "expiredAt";
    private String memberType = "_User";
    private String statisticName = null;
    private LCLeaderboardOrder order = LCLeaderboardOrder.Ascending;
    private LCLeaderboardUpdateStrategy updateStrategy = LCLeaderboardUpdateStrategy.Better;
    private LCLeaderboardVersionChangeInterval versionChangeInterval = LCLeaderboardVersionChangeInterval.Never;
    private int version = -1;
    private Date nextResetAt = null;
    private Date createdAt = null;

    public String getStatisticName() {
        return this.statisticName;
    }

    public LCLeaderboardOrder getOrder() {
        return this.order;
    }

    public LCLeaderboardUpdateStrategy getUpdateStrategy() {
        return this.updateStrategy;
    }

    public LCLeaderboardVersionChangeInterval getVersionChangeInterval() {
        return this.versionChangeInterval;
    }

    public int getVersion() {
        return this.version;
    }

    public Date getNextResetAt() {
        return (Date)this.nextResetAt.clone();
    }

    public Date getCreatedAt() {
        return (Date)this.createdAt.clone();
    }

    void setOrder(LCLeaderboardOrder order) {
        if (null != order) {
            this.order = order;
        }
    }

    void setUpdateStrategy(LCLeaderboardUpdateStrategy updateStrategy) {
        if (null != updateStrategy) {
            this.updateStrategy = updateStrategy;
        }
    }

    void setVersionChangeInterval(LCLeaderboardVersionChangeInterval versionChangeInterval) {
        if (null != versionChangeInterval) {
            this.versionChangeInterval = versionChangeInterval;
        }
    }

    public void setVersion(int version) {
        this.version = version;
    }

    void setNextResetAt(Date nextResetAt) {
        this.nextResetAt = nextResetAt;
    }

    void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    private LCLeaderboard(String name) {
        this.statisticName = name;
    }

    private LCLeaderboard(String name, String memberType) {
        this.statisticName = name;
        this.memberType = memberType;
    }

    protected static <T extends Enum<T>> T lookup(Class<T> enumType, String name) {
        for (Enum item : (Enum[])enumType.getEnumConstants()) {
            if (!item.name().equalsIgnoreCase(name)) continue;
            return (T)item;
        }
        return null;
    }

    protected LCLeaderboard(LCObject object) {
        String versionUpdateInterval;
        String updateStrategy;
        if (null == object) {
            return;
        }
        this.memberType = object.getString(ATTR_MEMBER_TYPE);
        this.statisticName = object.getString(ATTR_STATISTIC_NAME);
        String order = object.getString(ATTR_ORDER);
        if (!StringUtil.isEmpty(order)) {
            this.setOrder(LCLeaderboard.lookup(LCLeaderboardOrder.class, order));
        }
        if (!StringUtil.isEmpty(updateStrategy = object.getString(ATTR_UPDATE_STRATEGY))) {
            this.setUpdateStrategy(LCLeaderboard.lookup(LCLeaderboardUpdateStrategy.class, updateStrategy));
        }
        if (!StringUtil.isEmpty(versionUpdateInterval = object.getString(ATTR_VERSION_CHANGE_INTERVAL))) {
            this.setVersionChangeInterval(LCLeaderboard.lookup(LCLeaderboardVersionChangeInterval.class, versionUpdateInterval));
        }
        int version = object.getInt(ATTR_VERSION);
        this.setVersion(version);
        this.setNextResetAt(object.getDate(ATTR_EXPIRED_AT));
        this.setCreatedAt(object.getCreatedAt());
    }

    public static LCLeaderboard createWithoutData(String name) {
        return new LCLeaderboard(name);
    }

    public static LCLeaderboard createWithoutData(String name, String memberType) {
        return new LCLeaderboard(name, memberType);
    }

    public static Observable<LCStatisticResult> updateStatistic(LCUser user, Map<String, Double> values) {
        return LCLeaderboard.updateStatistic(user, values, false);
    }

    public static Observable<LCStatisticResult> updateStatistic(LCUser user, Map<String, Double> params, boolean overwrite) {
        if (null == user) {
            return Observable.error((Throwable)new IllegalArgumentException("user is null"));
        }
        if (null == params || params.size() < 1) {
            return Observable.error((Throwable)new IllegalArgumentException("params is empty"));
        }
        ArrayList<Map<String, Object>> statistics = new ArrayList<Map<String, Object>>(params.size());
        for (Map.Entry<String, Double> entry : params.entrySet()) {
            HashMap<String, Object> statistic = new HashMap<String, Object>();
            statistic.put(ATTR_STATISTIC_NAME, entry.getKey());
            statistic.put("statisticValue", entry.getValue());
            statistics.add(statistic);
        }
        return PaasClient.getStorageClient().updateUserStatistics(user, statistics, overwrite);
    }

    public static Observable<LCStatisticResult> getUserStatistics(LCUser user) {
        return LCLeaderboard.getUserStatistics(user, null);
    }

    public static Observable<LCStatisticResult> getUserStatistics(LCUser user, List<String> statisticNames) {
        if (null == user || StringUtil.isEmpty(user.getObjectId())) {
            return Observable.error((Throwable)new IllegalArgumentException("user is invalid."));
        }
        return PaasClient.getStorageClient().getUserStatistics(user.getObjectId(), statisticNames);
    }

    public static Observable<LCStatisticResult> getMemberStatistics(String memberType, String memberId) {
        return LCLeaderboard.getMemberStatistics(memberType, memberId, null);
    }

    public static Observable<LCStatisticResult> getMemberStatistics(String memberType, String memberId, List<String> statisticNames) {
        if (StringUtil.isEmpty(memberType) || StringUtil.isEmpty(memberId)) {
            return Observable.error((Throwable)new IllegalArgumentException("memberType or memberId is invalid."));
        }
        if (MEMBER_TYPE_USER.equalsIgnoreCase(memberType)) {
            return PaasClient.getStorageClient().getUserStatistics(memberId, statisticNames);
        }
        if (MEMBER_TYPE_ENTITY.equalsIgnoreCase(memberType)) {
            return PaasClient.getStorageClient().getEntityStatistics(memberId, statisticNames);
        }
        return PaasClient.getStorageClient().getObjectStatistics(memberId, statisticNames);
    }

    public static Observable<LCStatisticResult> queryGroupStatistics(String memberType, String statisticName, List<String> targetKeys) {
        if (StringUtil.isEmpty(statisticName)) {
            return Observable.error((Throwable)new IllegalArgumentException("name is empty"));
        }
        String leaderboardType = LCLeaderboard.convertLeaderboardType4Stats(memberType);
        return PaasClient.getStorageClient().getGroupStatistics(leaderboardType, statisticName, targetKeys);
    }

    static String convertLeaderboardType4Rank(String memberType) {
        String leaderboardType = null;
        leaderboardType = MEMBER_TYPE_USER.equalsIgnoreCase(memberType) ? "user" : (MEMBER_TYPE_ENTITY.equalsIgnoreCase(memberType) ? "entity" : "object");
        return leaderboardType;
    }

    static String convertLeaderboardType4Stats(String memberType) {
        String leaderboardType = null;
        leaderboardType = MEMBER_TYPE_USER.equalsIgnoreCase(memberType) ? "users" : (MEMBER_TYPE_ENTITY.equalsIgnoreCase(memberType) ? "entities" : "objects");
        return leaderboardType;
    }

    public Observable<LCLeaderboardResult> getResults(int skip, int limit, List<String> selectMemberKeys, List<String> includeStatistics) {
        return this.getResults(skip, limit, selectMemberKeys, includeStatistics, false);
    }

    public Observable<LCLeaderboardResult> getResults(int skip, int limit, List<String> selectMemberKeys, List<String> includeStatistics, boolean withCount) {
        if (StringUtil.isEmpty(this.statisticName)) {
            return Observable.error((Throwable)new IllegalArgumentException("name is empty"));
        }
        String leaderboardType = LCLeaderboard.convertLeaderboardType4Rank(this.memberType);
        return PaasClient.getStorageClient().getLeaderboardResults(leaderboardType, this.statisticName, skip, limit, selectMemberKeys, null, includeStatistics, this.version, withCount);
    }

    public Observable<LCLeaderboardResult> getGroupResults(List<String> groupUserIds, int skip, int limit, List<String> selectMemberKeys, List<String> includeStatistics) {
        if (StringUtil.isEmpty(this.statisticName)) {
            return Observable.error((Throwable)new IllegalArgumentException("name is empty"));
        }
        String leaderboardType = LCLeaderboard.convertLeaderboardType4Rank(this.memberType);
        return PaasClient.getStorageClient().getLeaderboardGroupResults(leaderboardType, this.statisticName, groupUserIds, skip, limit, selectMemberKeys, null, includeStatistics, this.version);
    }

    public Observable<LCLeaderboardResult> getAroundResults(String targetId, int skip, int limit, List<String> selectMemberKeys, List<String> includeStatistics) {
        if (StringUtil.isEmpty(this.statisticName)) {
            return Observable.error((Throwable)new IllegalArgumentException("name is empty"));
        }
        String leaderboardType = LCLeaderboard.convertLeaderboardType4Rank(this.memberType);
        return PaasClient.getStorageClient().getLeaderboardAroundResults(leaderboardType, this.statisticName, targetId, skip, limit, selectMemberKeys, null, includeStatistics, this.version);
    }

    public Observable<LCLeaderboardResult> getAroundInGroupResults(List<String> groupUserIds, String targetId, int limit, List<String> selectMemberKeys, List<String> includeStatistics) {
        if (StringUtil.isEmpty(this.statisticName)) {
            return Observable.error((Throwable)new IllegalArgumentException("name is empty"));
        }
        String leaderboardType = LCLeaderboard.convertLeaderboardType4Rank(this.memberType);
        return PaasClient.getStorageClient().getLeaderboardAroundInGroupResults(leaderboardType, this.statisticName, groupUserIds, targetId, limit, selectMemberKeys, null, includeStatistics, this.version);
    }

    public Observable<LCStatisticResult> queryGroupStatistics(List<String> targetKeys) {
        return LCLeaderboard.queryGroupStatistics(this.memberType, this.statisticName, targetKeys);
    }

    public static Observable<LCLeaderboard> create(String name, LCLeaderboardOrder order, LCLeaderboardUpdateStrategy updateStrategy, LCLeaderboardVersionChangeInterval versionChangeInterval) {
        return LCLeaderboard.createWithMemberType(MEMBER_TYPE_USER, name, order, updateStrategy, versionChangeInterval);
    }

    public static Observable<LCLeaderboard> createWithMemberType(String memberType, String name, LCLeaderboardOrder order, LCLeaderboardUpdateStrategy updateStrategy, LCLeaderboardVersionChangeInterval versionChangeInterval) {
        if (StringUtil.isEmpty(name)) {
            return Observable.error((Throwable)new IllegalArgumentException("name is empty"));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(ATTR_STATISTIC_NAME, name);
        params.put(ATTR_MEMBER_TYPE, memberType);
        if (null != order) {
            params.put(ATTR_ORDER, order.toString().toLowerCase(Locale.ROOT));
        } else {
            params.put(ATTR_ORDER, "descending");
        }
        if (null != updateStrategy) {
            params.put(ATTR_UPDATE_STRATEGY, updateStrategy.toString().toLowerCase(Locale.ROOT));
        } else {
            params.put(ATTR_UPDATE_STRATEGY, "better");
        }
        if (null != versionChangeInterval) {
            params.put(ATTR_VERSION_CHANGE_INTERVAL, versionChangeInterval.toString().toLowerCase(Locale.ROOT));
        } else {
            params.put(ATTR_VERSION_CHANGE_INTERVAL, "week");
        }
        return PaasClient.getStorageClient().createLeaderboard(params).map((Function)new Function<LCObject, LCLeaderboard>(){

            public LCLeaderboard apply(LCObject object) throws Exception {
                return new LCLeaderboard(object);
            }
        });
    }

    public static Observable<LCLeaderboard> fetchByName(String name) {
        if (StringUtil.isEmpty(name)) {
            return Observable.error((Throwable)new IllegalArgumentException("name is empty"));
        }
        return PaasClient.getStorageClient().fetchLeaderboard(name).map((Function)new Function<LCObject, LCLeaderboard>(){

            public LCLeaderboard apply(LCObject object) throws Exception {
                return new LCLeaderboard(object);
            }
        });
    }

    public Observable<Boolean> reset() {
        if (StringUtil.isEmpty(this.statisticName)) {
            return Observable.error((Throwable)new IllegalStateException("statistic name is empty."));
        }
        return PaasClient.getStorageClient().resetLeaderboard(this.statisticName).map((Function)new Function<LCObject, Boolean>(){

            public Boolean apply(LCObject object) throws Exception {
                LCLeaderboard.this.setVersion(object.getInt(LCLeaderboard.ATTR_VERSION));
                Date nextReset = object.getDate(LCLeaderboard.ATTR_EXPIRED_AT);
                if (null != nextReset) {
                    LCLeaderboard.this.setNextResetAt(nextReset);
                }
                return true;
            }
        });
    }

    public Observable<Boolean> updateVersionChangeInterval(final LCLeaderboardVersionChangeInterval interval) {
        if (StringUtil.isEmpty(this.statisticName)) {
            return Observable.error((Throwable)new IllegalStateException("statistic name is empty."));
        }
        if (null == interval) {
            return Observable.error((Throwable)new IllegalArgumentException("interval is null."));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(ATTR_VERSION_CHANGE_INTERVAL, interval.toString().toLowerCase(Locale.ROOT));
        return PaasClient.getStorageClient().updateLeaderboard(this.statisticName, params).map((Function)new Function<LCObject, Boolean>(){

            public Boolean apply(LCObject object) throws Exception {
                LCLeaderboard.this.setVersionChangeInterval(interval);
                Date nextReset = object.getDate(LCLeaderboard.ATTR_EXPIRED_AT);
                if (null != nextReset) {
                    LCLeaderboard.this.setNextResetAt(nextReset);
                }
                return true;
            }
        });
    }

    public Observable<Boolean> updateUpdateStrategy(final LCLeaderboardUpdateStrategy strategy) {
        if (StringUtil.isEmpty(this.statisticName)) {
            return Observable.error((Throwable)new IllegalStateException("statistic name is empty."));
        }
        if (null == strategy) {
            return Observable.error((Throwable)new IllegalArgumentException("strategy is null."));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(ATTR_UPDATE_STRATEGY, strategy.toString().toLowerCase(Locale.ROOT));
        return PaasClient.getStorageClient().updateLeaderboard(this.statisticName, params).map((Function)new Function<LCObject, Boolean>(){

            public Boolean apply(LCObject object) throws Exception {
                LCLeaderboard.this.setUpdateStrategy(strategy);
                return null != object;
            }
        });
    }

    public Observable<Boolean> destroy() {
        if (StringUtil.isEmpty(this.statisticName)) {
            return Observable.error((Throwable)new IllegalStateException("statistic name is empty."));
        }
        return PaasClient.getStorageClient().destroyLeaderboard(this.statisticName);
    }

    public static enum LCLeaderboardVersionChangeInterval {
        Never,
        Day,
        Week,
        Month;

    }

    public static enum LCLeaderboardUpdateStrategy {
        Better,
        Last,
        Sum;

    }

    public static enum LCLeaderboardOrder {
        Ascending,
        Descending;

    }
}

