/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.LCACL;
import cn.leancloud.LCException;
import cn.leancloud.LCObject;
import cn.leancloud.LCUser;
import cn.leancloud.annotation.LCClassName;
import cn.leancloud.cache.FileCache;
import cn.leancloud.cache.PersistenceUtil;
import cn.leancloud.callback.ProgressCallback;
import cn.leancloud.codec.MDFive;
import cn.leancloud.core.AppConfiguration;
import cn.leancloud.core.LeanCloud;
import cn.leancloud.core.PaasClient;
import cn.leancloud.core.StorageClient;
import cn.leancloud.json.JSONObject;
import cn.leancloud.upload.FileDownloader;
import cn.leancloud.upload.FileUploadToken;
import cn.leancloud.upload.FileUploader;
import cn.leancloud.utils.FileUtil;
import cn.leancloud.utils.LCUtils;
import cn.leancloud.utils.StringUtil;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;

@LCClassName(value="_File")
public final class LCFile
extends LCObject {
    public static final String CLASS_NAME = "_File";
    private static final String FILE_SUM_KEY = "_checksum";
    private static final String FILE_NAME_KEY = "_name";
    private static final String FILE_LENGTH_KEY = "size";
    private static final String FILE_SOURCE_KEY = "__source";
    private static final String FILE_SOURCE_EXTERNAL = "external";
    private static final String FILE_PATH_PREFIX_KEY = "prefix";
    private static final String THUMBNAIL_FMT = "?imageView/%d/w/%d/h/%d/q/%d/format/%s";
    private static final String KEY_FILE_NAME = "name";
    private static final String KEY_METADATA = "metaData";
    private static final String KEY_URL = "url";
    private static final String KEY_BUCKET = "bucket";
    private static final String KEY_PROVIDER = "provider";
    private static final String KEY_MIME_TYPE = "mime_type";
    private static final String KEY_FILE_KEY = "key";
    private transient String localPath = "";
    private transient String cachePath = "";

    public static void setUploadHeader(String key, String value) {
        FileUploader.setUploadHeader(key, value);
    }

    public LCFile() {
        super(CLASS_NAME);
        if (AppConfiguration.getDefaultACL() != null) {
            this.acl = new LCACL(AppConfiguration.getDefaultACL());
        }
    }

    public LCFile(String name, byte[] data) {
        this();
        if (null == data) {
            logger.w("data is illegal(null)");
            throw new IllegalArgumentException("data is illegal(null)");
        }
        this.internalPut(KEY_FILE_NAME, name);
        this.addMetaData(FILE_NAME_KEY, name);
        String md5 = MDFive.computeMD5(data);
        this.localPath = FileCache.getIntance().saveData(md5, data);
        this.addMetaData(FILE_SUM_KEY, md5);
        this.addMetaData(FILE_LENGTH_KEY, data.length);
        this.internalPut(KEY_MIME_TYPE, FileUtil.getMimeTypeFromFilename(name));
    }

    public LCFile(String name, File localFile) {
        this();
        if (null == localFile || !localFile.exists() || !localFile.isFile()) {
            logger.w("local file is illegal");
            throw new IllegalArgumentException("local file is illegal.");
        }
        this.internalPut(KEY_FILE_NAME, name);
        this.addMetaData(FILE_NAME_KEY, name);
        String md5 = MDFive.computeFileMD5(localFile);
        this.localPath = localFile.getAbsolutePath();
        this.addMetaData(FILE_SUM_KEY, md5);
        this.addMetaData(FILE_LENGTH_KEY, localFile.length());
        this.internalPut(KEY_MIME_TYPE, FileUtil.getMimeTypeFromPath(this.localPath));
    }

    public LCFile(String name, String url) {
        this(name, url, null);
    }

    public LCFile(String name, String url, Map<String, Object> metaData) {
        this(name, url, metaData, true);
    }

    protected LCFile(String name, String url, Map<String, Object> metaData, boolean external) {
        this();
        this.internalPut(KEY_FILE_NAME, name);
        this.addMetaData(FILE_NAME_KEY, name);
        this.internalPut(KEY_URL, url);
        HashMap<String, Object> meta = new HashMap<String, Object>();
        if (null != metaData) {
            LCUtils.putAllWithNullFilter(meta, metaData);
        }
        if (external) {
            meta.put(FILE_SOURCE_KEY, FILE_SOURCE_EXTERNAL);
        }
        this.internalPut(KEY_METADATA, meta);
        this.internalPut(KEY_MIME_TYPE, FileUtil.getMimeTypeFromUrl(url));
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private void internalPutDirectly(String key, Object value) {
        this.serverData.put(key, value);
    }

    public static Observable<LCFile> withObjectIdInBackground(String objectId) {
        return PaasClient.getStorageClient().fetchFile(null, objectId);
    }

    public String getName() {
        return (String)this.internalGet(KEY_FILE_NAME);
    }

    public void setName(String name) {
        this.internalPut(KEY_FILE_NAME, name);
    }

    public void setPathPrefix(String path) {
        Object externalFlag = this.getMetaData(FILE_SOURCE_KEY);
        if (FILE_SOURCE_EXTERNAL.equals(externalFlag)) {
            return;
        }
        if (StringUtil.isEmpty(path)) {
            this.clearPathPrefix();
        } else {
            this.internalPut(FILE_PATH_PREFIX_KEY, path);
            this.addMetaData(FILE_PATH_PREFIX_KEY, path);
        }
    }

    public void clearPathPrefix() {
        Object externalFlag = this.getMetaData(FILE_SOURCE_KEY);
        if (FILE_SOURCE_EXTERNAL.equals(externalFlag)) {
            return;
        }
        super.remove(FILE_PATH_PREFIX_KEY);
        this.getMetaData().remove(FILE_PATH_PREFIX_KEY);
    }

    public Map<String, Object> getMetaData() {
        HashMap result = (HashMap)this.internalGet(KEY_METADATA);
        if (null == result) {
            result = new HashMap();
            this.internalPut(KEY_METADATA, result);
        }
        return result;
    }

    public void setMetaData(Map<String, Object> metaData) {
        this.internalPut(KEY_METADATA, metaData);
    }

    public void addMetaData(String key, Object val) {
        Map<String, Object> metaData = this.getMetaData();
        metaData.put(key, val);
    }

    public Object getMetaData(String key) {
        return this.getMetaData().get(key);
    }

    public Object removeMetaData(String key) {
        return this.getMetaData().remove(key);
    }

    public void clearMetaData() {
        this.getMetaData().clear();
    }

    public int getSize() {
        Number size = (Number)this.getMetaData(FILE_LENGTH_KEY);
        if (size != null) {
            return size.intValue();
        }
        return -1;
    }

    public String getMimeType() {
        return (String)this.internalGet(KEY_MIME_TYPE);
    }

    public void setMimeType(String mimeType) {
        this.internalPut(KEY_MIME_TYPE, mimeType);
    }

    public String getKey() {
        return (String)this.internalGet(KEY_FILE_KEY);
    }

    void setKey(String fileKey) {
        this.internalPut(KEY_FILE_KEY, fileKey);
    }

    public String getBucket() {
        return (String)this.internalGet(KEY_BUCKET);
    }

    public String getUrl() {
        return (String)this.internalGet(KEY_URL);
    }

    public String getProvider() {
        return (String)this.internalGet(KEY_PROVIDER);
    }

    @Override
    public void put(String key, Object value) {
        throw new UnsupportedOperationException("cannot invoke put method in AVFile");
    }

    @Override
    public Object get(String key) {
        throw new UnsupportedOperationException("cannot invoke get method in AVFile");
    }

    @Override
    public void remove(String key) {
        throw new UnsupportedOperationException("cannot invoke remove method in AVFile");
    }

    @Override
    public void increment(String key) {
        throw new UnsupportedOperationException("cannot invoke increment method in AVFile");
    }

    @Override
    public void increment(String key, Number value) {
        throw new UnsupportedOperationException("cannot invoke increment(Number) method in AVFile");
    }

    public String getThumbnailUrl(boolean scaleToFit, int width, int height) {
        return this.getThumbnailUrl(scaleToFit, width, height, 100, "png");
    }

    public String getThumbnailUrl(boolean scaleToFit, int width, int height, int quality, String fmt) {
        if (LeanCloud.getRegion() == LeanCloud.REGION.NorthAmerica) {
            logger.w("We only support this method for qiniu storage.");
            throw new UnsupportedOperationException("We only support this method for qiniu storage.");
        }
        if (width < 0 || height < 0) {
            logger.w("Invalid width or height.");
            throw new IllegalArgumentException("Invalid width or height.");
        }
        if (quality < 1 || quality > 100) {
            logger.w("Invalid quality,valid range is 0-100.");
            throw new IllegalArgumentException("Invalid quality,valid range is 0-100.");
        }
        if (fmt == null || StringUtil.isEmpty(fmt.trim())) {
            fmt = "png";
        }
        int mode = scaleToFit ? 2 : 1;
        return this.getUrl() + String.format(THUMBNAIL_FMT, mode, width, height, quality, fmt);
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("__type", CLASS_NAME);
        result.put(KEY_METADATA, this.getMetaData());
        if (!StringUtil.isEmpty(this.getUrl())) {
            result.put(KEY_URL, this.getUrl());
        }
        if (!StringUtil.isEmpty(this.getObjectId())) {
            result.put("objectId", this.getObjectId());
        }
        result.put("id", this.getName());
        return result;
    }

    public synchronized void saveInBackground(boolean keepFileName, ProgressCallback progressCallback) {
        this.saveInBackground(null, keepFileName, progressCallback);
    }

    public synchronized void saveInBackground(LCUser asAuthenticatedUser, boolean keepFileName, final ProgressCallback progressCallback) {
        this.saveWithProgressCallback(asAuthenticatedUser, keepFileName, progressCallback).subscribe((Observer)new Observer<LCFile>(){

            public void onSubscribe(Disposable disposable) {
            }

            public void onNext(LCFile avFile) {
                if (null != progressCallback) {
                    progressCallback.internalDone(100, null);
                }
            }

            public void onError(Throwable throwable) {
                if (null != progressCallback) {
                    progressCallback.internalDone(90, new LCException(throwable));
                }
            }

            public void onComplete() {
            }
        });
    }

    public void saveInBackground(ProgressCallback progressCallback) {
        this.saveInBackground(false, progressCallback);
    }

    private Observable<LCFile> directlyCreate(LCUser asAuthenticatedUser, final JSONObject parameters) {
        return PaasClient.getStorageClient().createObject(asAuthenticatedUser, this.className, parameters, false, null).map((Function)new Function<LCObject, LCFile>(){

            public LCFile apply(LCObject LCObject2) throws Exception {
                LCUtils.putAllWithNullFilter(LCFile.this.serverData, parameters);
                LCFile.this.mergeRawData(LCObject2, true);
                LCFile.this.onSaveSuccess();
                return LCFile.this;
            }
        });
    }

    private boolean isSavingExternalFile() {
        return StringUtil.isEmpty(this.getObjectId()) && !StringUtil.isEmpty(this.getUrl());
    }

    private Observable<LCFile> saveWithProgressCallback(final LCUser asAuthenticatedUser, boolean keepFileName, final ProgressCallback callback) {
        JSONObject paramData = this.generateChangedParam();
        if (StringUtil.isEmpty(this.getObjectId())) {
            if (!StringUtil.isEmpty(this.getUrl())) {
                return this.directlyCreate(asAuthenticatedUser, paramData);
            }
            logger.d("createToken params: " + paramData.toJSONString() + ", " + this);
            StorageClient storageClient = PaasClient.getStorageClient();
            Observable result = storageClient.newUploadToken(asAuthenticatedUser, paramData).map((Function)new Function<FileUploadToken, LCFile>(){

                public LCFile apply(@NonNull FileUploadToken fileUploadToken) throws Exception {
                    LCObject.logger.d("[Thread:" + Thread.currentThread().getId() + "]" + fileUploadToken.toString() + ", " + LCFile.this);
                    LCFile.this.setObjectId(fileUploadToken.getObjectId());
                    LCFile.this.internalPutDirectly("objectId", fileUploadToken.getObjectId());
                    LCFile.this.internalPutDirectly(LCFile.KEY_BUCKET, fileUploadToken.getBucket());
                    LCFile.this.internalPutDirectly(LCFile.KEY_PROVIDER, fileUploadToken.getProvider());
                    LCFile.this.internalPutDirectly(LCFile.KEY_FILE_KEY, fileUploadToken.getKey());
                    FileUploader uploader = new FileUploader(LCFile.this, fileUploadToken, callback);
                    LCFile.this.internalPutDirectly(LCFile.KEY_URL, fileUploadToken.getUrl());
                    LCException exception = uploader.execute();
                    JSONObject completeResult = JSONObject.Builder.create(null);
                    completeResult.put("result", null == exception);
                    completeResult.put("token", fileUploadToken.getToken());
                    LCObject.logger.d("file upload result: " + completeResult.toJSONString());
                    try {
                        PaasClient.getStorageClient().fileCallback(asAuthenticatedUser, completeResult);
                        if (null != exception) {
                            LCObject.logger.w("failed to invoke fileCallback. cause:", exception);
                            throw exception;
                        }
                        return LCFile.this;
                    }
                    catch (IOException ex) {
                        LCObject.logger.w(ex);
                        throw ex;
                    }
                }
            });
            result = storageClient.wrapObservable(result);
            return result;
        }
        logger.d("file has been upload to cloud, ignore update request.");
        return Observable.just((Object)this);
    }

    public Observable<LCFile> saveInBackground() {
        return this.saveInBackground(false);
    }

    @Override
    public void save() {
        this.saveInBackground().blockingSubscribe();
    }

    @Override
    public void save(LCUser asAuthenticatedUser) {
        this.saveInBackground(asAuthenticatedUser, false).blockingSubscribe();
    }

    public Observable<LCFile> saveInBackground(boolean keepFileName) {
        return this.saveInBackground(null, keepFileName);
    }

    @Override
    public void saveEventually() throws LCException {
        this.saveEventually(null);
    }

    @Override
    public void saveEventually(LCUser asAuthenticatedUser) throws LCException {
        if (!this.isSavingExternalFile()) {
            throw new UnsupportedOperationException("AVFile#saveEventually is not allowed, please save the binary data to temp store and try to save in future.");
        }
        super.saveEventually(asAuthenticatedUser);
    }

    public Observable<LCFile> saveInBackground(LCUser asAuthenticatedUser, boolean keepFileName) {
        return this.saveWithProgressCallback(asAuthenticatedUser, keepFileName, null);
    }

    public byte[] getData() {
        String filePath = "";
        if (!StringUtil.isEmpty(this.localPath)) {
            filePath = this.localPath;
        } else if (!StringUtil.isEmpty(this.cachePath)) {
            filePath = this.cachePath;
        } else if (!StringUtil.isEmpty(this.getUrl())) {
            File cacheFile = FileCache.getIntance().getCacheFile(this.getUrl());
            if (null == cacheFile || !cacheFile.exists()) {
                FileDownloader downloader = new FileDownloader();
                downloader.execute(this.getUrl(), cacheFile);
            }
            if (null != cacheFile) {
                filePath = cacheFile.getAbsolutePath();
            }
        }
        if (!StringUtil.isEmpty(filePath)) {
            return PersistenceUtil.sharedInstance().readContentBytesFromFile(new File(filePath));
        }
        return new byte[0];
    }

    public Observable<byte[]> getDataInBackground() {
        AppConfiguration.SchedulerCreator defaultScheduler;
        Observable observable = Observable.fromCallable((Callable)new Callable<byte[]>(){

            @Override
            public byte[] call() throws Exception {
                return LCFile.this.getData();
            }
        });
        if (AppConfiguration.isAsynchronized()) {
            observable = observable.subscribeOn(Schedulers.io());
        }
        if (null != (defaultScheduler = AppConfiguration.getDefaultScheduler())) {
            observable = observable.observeOn(defaultScheduler.create());
        }
        return observable;
    }

    public InputStream getDataStream() throws Exception {
        String filePath = "";
        if (!StringUtil.isEmpty(this.localPath)) {
            filePath = this.localPath;
        } else if (!StringUtil.isEmpty(this.cachePath)) {
            filePath = this.cachePath;
        } else if (!StringUtil.isEmpty(this.getUrl())) {
            File cacheFile = FileCache.getIntance().getCacheFile(this.getUrl());
            if (null == cacheFile || !cacheFile.exists()) {
                FileDownloader downloader = new FileDownloader();
                downloader.execute(this.getUrl(), cacheFile);
            }
            if (null != cacheFile) {
                filePath = cacheFile.getAbsolutePath();
            }
        }
        if (!StringUtil.isEmpty(filePath)) {
            logger.d("dest file path=" + filePath);
            return FileCache.getIntance().getInputStreamFromFile(new File(filePath));
        }
        logger.w("failed to get dataStream.");
        return null;
    }

    public Observable<InputStream> getDataStreamInBackground() {
        AppConfiguration.SchedulerCreator defaultScheduler;
        Observable observable = Observable.fromCallable((Callable)new Callable<InputStream>(){

            @Override
            public InputStream call() throws Exception {
                return LCFile.this.getDataStream();
            }
        });
        if (AppConfiguration.isAsynchronized()) {
            observable = observable.subscribeOn(Schedulers.io());
        }
        if (null != (defaultScheduler = AppConfiguration.getDefaultScheduler())) {
            observable = observable.observeOn(defaultScheduler.create());
        }
        return observable;
    }

    public static LCFile withAbsoluteLocalPath(String name, String absoluteLocalFilePath) throws FileNotFoundException {
        return LCFile.withFile(name, new File(absoluteLocalFilePath));
    }

    public static LCFile withFile(String name, File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("null file object.");
        }
        if (!file.exists() || !file.isFile()) {
            throw new FileNotFoundException();
        }
        LCFile avFile = new LCFile(name, file);
        LCUser currentUser = LCUser.getCurrentUser();
        if (null != currentUser && !StringUtil.isEmpty(currentUser.getObjectId())) {
            avFile.addMetaData("owner", currentUser.getObjectId());
        }
        return avFile;
    }
}

