/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.LCUser;
import cn.leancloud.json.JSON;
import cn.leancloud.json.JSONObject;
import cn.leancloud.utils.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class LCACL {
    private static final String PUBLIC_KEY = "*";
    private static final String ROLE_PREFIX = "role:";
    private static final String KEY_READ_PERMISSION = "read";
    private static final String KEY_WRITE_PERMISSION = "write";
    private final Map<String, Permissions> permissionsById = new HashMap<String, Permissions>();

    public LCACL() {
    }

    public LCACL(JSONObject json) {
        if (null != json) {
            Set entries = json.entrySet();
            for (Map.Entry entry : entries) {
                Object v = entry.getValue();
                if (null == v || !(v instanceof HashMap)) continue;
                this.permissionsById.put((String)entry.getKey(), new Permissions((HashMap)entry.getValue()));
            }
        }
    }

    public LCACL(HashMap data) {
        if (null != data) {
            Set entries = data.entrySet();
            for (Map.Entry entry : entries) {
                Object v = entry.getValue();
                if (null == v || !(v instanceof HashMap)) continue;
                this.permissionsById.put((String)entry.getKey(), new Permissions((HashMap)entry.getValue()));
            }
        }
    }

    public LCACL(LCACL other) {
        this.permissionsById.putAll(other.permissionsById);
    }

    public LCACL(LCUser owner) {
        this.setReadAccess(owner, true);
        this.setWriteAccess(owner, true);
    }

    public Map<String, Permissions> getPermissionsById() {
        return this.permissionsById;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LCACL)) {
            return false;
        }
        LCACL realACL = (LCACL)o;
        return Objects.equals(this.getPermissionsById(), realACL.getPermissionsById());
    }

    public int hashCode() {
        return Objects.hash(this.getPermissionsById());
    }

    public JSONObject toJSONObject() {
        String jsonStr = JSON.toJSONString(this.permissionsById);
        return JSON.parseObject(jsonStr);
    }

    private void setPermissionsIfNonEmpty(String userId, boolean readPermission, boolean writePermission) {
        if (!readPermission && !writePermission) {
            this.permissionsById.remove(userId);
        } else {
            this.permissionsById.put(userId, new Permissions(readPermission, writePermission));
        }
    }

    public void setPublicReadAccess(boolean allowed) {
        this.setReadAccess(PUBLIC_KEY, allowed);
    }

    public boolean getPublicReadAccess() {
        return this.getReadAccess(PUBLIC_KEY);
    }

    public void setPublicWriteAccess(boolean allowed) {
        this.setWriteAccess(PUBLIC_KEY, allowed);
    }

    public boolean getPublicWriteAccess() {
        return this.getWriteAccess(PUBLIC_KEY);
    }

    public void setReadAccess(String userId, boolean allowed) {
        if (StringUtil.isEmpty(userId)) {
            throw new IllegalArgumentException("cannot setRead/WriteAccess for null userId");
        }
        boolean writePermission = this.getWriteAccess(userId);
        this.setPermissionsIfNonEmpty(userId, allowed, writePermission);
    }

    public boolean getReadAccess(String userId) {
        if (StringUtil.isEmpty(userId)) {
            return false;
        }
        Permissions permissions = this.permissionsById.get(userId);
        return permissions != null && permissions.getReadPermission();
    }

    public void setWriteAccess(String userId, boolean allowed) {
        if (StringUtil.isEmpty(userId)) {
            throw new IllegalArgumentException("cannot setRead/WriteAccess for null userId");
        }
        boolean readPermission = this.getReadAccess(userId);
        this.setPermissionsIfNonEmpty(userId, readPermission, allowed);
    }

    public boolean getWriteAccess(String userId) {
        if (StringUtil.isEmpty(userId)) {
            return false;
        }
        Permissions permissions = this.permissionsById.get(userId);
        return permissions != null && permissions.getWritePermission();
    }

    public void setReadAccess(LCUser user, boolean allowed) {
        if (null == user || StringUtil.isEmpty(user.getObjectId())) {
            throw new IllegalArgumentException("cannot setRead/WriteAccess for a user with null id");
        }
        this.setReadAccess(user.getObjectId(), allowed);
    }

    public boolean getReadAccess(LCUser user) {
        if (null == user || StringUtil.isEmpty(user.getObjectId())) {
            return false;
        }
        return this.getReadAccess(user.getObjectId());
    }

    public void setWriteAccess(LCUser user, boolean allowed) {
        if (null == user || StringUtil.isEmpty(user.getObjectId())) {
            throw new IllegalArgumentException("cannot setRead/WriteAccess for a user with null id");
        }
        this.setWriteAccess(user.getObjectId(), allowed);
    }

    public boolean getWriteAccess(LCUser user) {
        if (null == user || StringUtil.isEmpty(user.getObjectId())) {
            return false;
        }
        return this.getWriteAccess(user.getObjectId());
    }

    public void setRoleReadAccess(String role, boolean allowed) {
        if (StringUtil.isEmpty(role)) {
            throw new IllegalArgumentException("cannot setRead/WriteAccess to a empty role");
        }
        this.setReadAccess(ROLE_PREFIX + role, allowed);
    }

    public boolean getRoleReadAccess(String role) {
        if (StringUtil.isEmpty(role)) {
            return false;
        }
        return this.getReadAccess(ROLE_PREFIX + role);
    }

    public void setRoleWriteAccess(String role, boolean allowed) {
        if (StringUtil.isEmpty(role)) {
            throw new IllegalArgumentException("cannot setRead/WriteAccess to a empty role");
        }
        this.setWriteAccess(ROLE_PREFIX + role, allowed);
    }

    public boolean getRoleWriteAccess(String role) {
        if (StringUtil.isEmpty(role)) {
            return false;
        }
        return this.getWriteAccess(ROLE_PREFIX + role);
    }

    public static class Permissions
    extends HashMap<String, Boolean> {
        public Permissions() {
        }

        public Permissions(boolean read, boolean write) {
            if (read) {
                this.put(LCACL.KEY_READ_PERMISSION, read);
            }
            if (write) {
                this.put(LCACL.KEY_WRITE_PERMISSION, write);
            }
        }

        public Permissions(HashMap<String, Object> map) {
            if (null == map) {
                return;
            }
            Object readValue = map.get(LCACL.KEY_READ_PERMISSION);
            Object writeValue = map.get(LCACL.KEY_WRITE_PERMISSION);
            if (null == readValue || !(readValue instanceof Boolean)) {
                this.put(LCACL.KEY_READ_PERMISSION, false);
            } else {
                this.put(LCACL.KEY_READ_PERMISSION, (Boolean)readValue);
            }
            if (null == writeValue || !(writeValue instanceof Boolean)) {
                this.put(LCACL.KEY_WRITE_PERMISSION, false);
            } else {
                this.put(LCACL.KEY_WRITE_PERMISSION, (Boolean)writeValue);
            }
        }

        public Permissions(Permissions permissions) {
            if (null == permissions) {
                return;
            }
            if (permissions.getReadPermission()) {
                this.put(LCACL.KEY_READ_PERMISSION, true);
            }
            if (permissions.getWritePermission()) {
                this.put(LCACL.KEY_WRITE_PERMISSION, true);
            }
        }

        boolean getReadPermission() {
            if (this.containsKey(LCACL.KEY_READ_PERMISSION)) {
                return (Boolean)this.get(LCACL.KEY_READ_PERMISSION);
            }
            return false;
        }

        boolean getWritePermission() {
            if (this.containsKey(LCACL.KEY_WRITE_PERMISSION)) {
                return (Boolean)this.get(LCACL.KEY_WRITE_PERMISSION);
            }
            return false;
        }
    }
}

