/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.upload;

import cn.leancloud.LCException;
import cn.leancloud.LCFile;
import cn.leancloud.LCLogger;
import cn.leancloud.callback.ProgressCallback;
import cn.leancloud.upload.FileUploader;
import cn.leancloud.upload.HttpClientUploader;
import cn.leancloud.upload.QiniuAccessor;
import cn.leancloud.utils.LogUtil;
import java.io.InputStream;
import java.util.ArrayList;

class QiniuSlicingUploader
extends HttpClientUploader {
    private static LCLogger LOGGER = LogUtil.getLogger(QiniuSlicingUploader.class);
    private final String token;
    private FileUploader.ProgressCalculator progressCalculator;
    private int uploadChunkSize = 262144;
    private String fileKey = null;
    private QiniuAccessor qiniuAccessor;

    QiniuSlicingUploader(LCFile avFile, String token, String uploadUrl, ProgressCallback progressCallback) {
        super(avFile, progressCallback);
        this.token = token;
        this.fileKey = avFile.getKey();
        this.qiniuAccessor = new QiniuAccessor(this.getOKHttpClient(), this.token, this.fileKey, uploadUrl);
        LOGGER.d("Constructor with token=" + token + ", key=" + this.fileKey + ", accessor=" + this.qiniuAccessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LCException execute() {
        block24: {
            LCException lCException;
            boolean isWifi = true;
            if (!isWifi) {
                this.uploadChunkSize = 65536;
            }
            InputStream is = null;
            byte[] buf = new byte[this.uploadChunkSize];
            int fileSize = this.avFile.getSize();
            int blockCount = fileSize / 0x400000 + (fileSize % 0x400000 > 0 ? 1 : 0);
            ArrayList<String> uploadFileCtxs = new ArrayList<String>(blockCount);
            this.progressCalculator = new FileUploader.ProgressCalculator(blockCount, new FileUploader.FileUploadProgressCallback(){

                @Override
                public void onProgress(int progress) {
                    QiniuSlicingUploader.this.publishProgress(progress);
                }
            });
            try {
                is = this.avFile.getDataStream();
                LOGGER.d("begin to upload qiniu. chunkSize=" + this.uploadChunkSize + ", blockCount=" + blockCount + ", is=" + is);
                for (int i = 0; i < blockCount; ++i) {
                    int currentBlockSize = 0x400000;
                    int currentBlockOffset = i * 0x400000;
                    if (i == blockCount - 1) {
                        currentBlockSize = fileSize - currentBlockOffset;
                    }
                    int chunkCount = currentBlockSize / this.uploadChunkSize + (currentBlockSize % this.uploadChunkSize > 0 ? 1 : 0);
                    QiniuAccessor.QiniuBlockResponseData lastResponse = null;
                    for (int j = 0; j < chunkCount; ++j) {
                        int currentChunkOffset = j * this.uploadChunkSize;
                        int currentChunkSize = j == chunkCount - 1 ? currentBlockSize - currentChunkOffset : this.uploadChunkSize;
                        int totalReadCnt = 0;
                        int curReadCnt = is.read(buf, totalReadCnt, currentChunkSize - totalReadCnt);
                        totalReadCnt += curReadCnt;
                        while (curReadCnt > 0 && totalReadCnt < currentChunkSize) {
                            curReadCnt = is.read(buf, totalReadCnt, currentChunkSize - totalReadCnt);
                            totalReadCnt += curReadCnt;
                        }
                        if (j == 0) {
                            lastResponse = this.qiniuAccessor.createBlockInQiniu(currentBlockSize, currentChunkSize, buf, 6);
                            LOGGER.d("createBlockInQiniu(curBlockSize=" + currentBlockSize + ", curChunkSize=" + currentChunkSize + ") result=" + lastResponse);
                            continue;
                        }
                        QiniuAccessor.QiniuBlockResponseData tmpResponse = lastResponse;
                        lastResponse = this.qiniuAccessor.putFileBlocksToQiniu(lastResponse, currentBlockOffset, buf, currentChunkSize, 6);
                        LOGGER.d("putFileBlocksToQiniu(lastRes=" + tmpResponse + ", curBlockOffset=" + currentBlockOffset + ", curChunkSize=" + currentChunkSize + ") result=" + lastResponse);
                    }
                    if (null == lastResponse) {
                        LCException lCException2 = new LCException(9302, "failed to upload file to qiniu.");
                        return lCException2;
                    }
                    uploadFileCtxs.add(lastResponse.getCtx());
                    this.progressCalculator.publishProgress(i, 100);
                    LOGGER.d("finished to upload block(" + i + "), ctx=" + lastResponse.getCtx());
                }
                QiniuAccessor.QiniuMKFileResponseData finalResponse = this.qiniuAccessor.makeFile(fileSize, uploadFileCtxs, 6);
                LOGGER.d("makeFile(fileSize=" + fileSize + ") result=" + finalResponse);
                if (finalResponse != null && finalResponse.key.equals(this.fileKey)) break block24;
                lCException = new LCException(-1, "upload file failure");
            }
            catch (Exception ex) {
                LCException lCException3 = new LCException(ex);
                return lCException3;
            }
            finally {
                try {
                    if (null != is) {
                        is.close();
                    }
                }
                catch (Exception exception) {}
            }
            return lCException;
        }
        return null;
    }
}

