/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.sms;

import cn.leancloud.core.PaasClient;
import cn.leancloud.sms.LCSMSOption;
import cn.leancloud.types.LCNull;
import cn.leancloud.utils.StringUtil;
import io.reactivex.Observable;
import java.util.Map;
import java.util.regex.Pattern;

public class LCSMS {
    static Pattern phoneNumPattern = Pattern.compile("^[1+]\\d+$");

    public static boolean checkMobilePhoneNumber(String phoneNumber) {
        return phoneNumPattern.matcher(phoneNumber).find();
    }

    public static Observable<LCNull> requestSMSCodeInBackground(String mobilePhone, LCSMSOption option) {
        if (StringUtil.isEmpty(mobilePhone) || !LCSMS.checkMobilePhoneNumber(mobilePhone)) {
            return Observable.error((Throwable)new IllegalArgumentException("mobile phone number is empty or invalid"));
        }
        if (null == option) {
            return Observable.error((Throwable)new IllegalArgumentException("smsOption is null"));
        }
        Map<String, Object> param = option.getOptionMap();
        return PaasClient.getStorageClient().requestSMSCode(mobilePhone, param);
    }

    public static Observable<LCNull> verifySMSCodeInBackground(String code, String mobilePhone) {
        if (StringUtil.isEmpty(code) || StringUtil.isEmpty(mobilePhone)) {
            return Observable.error((Throwable)new IllegalArgumentException("code or mobilePhone is empty"));
        }
        return PaasClient.getStorageClient().verifySMSCode(code, mobilePhone);
    }

    public static enum TYPE {
        VOICE_SMS("voice"),
        TEXT_SMS("sms");

        private String name;

        private TYPE(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

