/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.gson;

import cn.leancloud.LCFile;
import cn.leancloud.LCFriendship;
import cn.leancloud.LCFriendshipRequest;
import cn.leancloud.LCInstallation;
import cn.leancloud.LCObject;
import cn.leancloud.LCRole;
import cn.leancloud.LCStatus;
import cn.leancloud.LCUser;
import cn.leancloud.gson.BaseOperationAdapter;
import cn.leancloud.gson.FileUploadTokenAdapter;
import cn.leancloud.gson.GeneralObjectAdapter;
import cn.leancloud.gson.GsonArray;
import cn.leancloud.gson.GsonObject;
import cn.leancloud.gson.JSONArrayAdapter;
import cn.leancloud.gson.JSONObjectAdapter;
import cn.leancloud.gson.MapDeserializerDoubleAsIntFix;
import cn.leancloud.gson.NumberDeserializerDoubleAsIntFix;
import cn.leancloud.gson.ObjectDeserializer;
import cn.leancloud.json.JSONObject;
import cn.leancloud.ops.AddOperation;
import cn.leancloud.ops.AddRelationOperation;
import cn.leancloud.ops.AddUniqueOperation;
import cn.leancloud.ops.BaseOperation;
import cn.leancloud.ops.BitAndOperation;
import cn.leancloud.ops.BitOrOperation;
import cn.leancloud.ops.BitXOROperation;
import cn.leancloud.ops.CompoundOperation;
import cn.leancloud.ops.DecrementOperation;
import cn.leancloud.ops.DeleteOperation;
import cn.leancloud.ops.IncrementOperation;
import cn.leancloud.ops.NumericOperation;
import cn.leancloud.ops.RemoveOperation;
import cn.leancloud.ops.RemoveRelationOperation;
import cn.leancloud.ops.SetOperation;
import cn.leancloud.service.AppAccessEndpoint;
import cn.leancloud.sms.LCCaptchaDigest;
import cn.leancloud.sms.LCCaptchaValidateResult;
import cn.leancloud.upload.FileUploadToken;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.Primitives;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class GsonWrapper {
    static final ObjectDeserializer objectDeserializer = new ObjectDeserializer();
    static final BaseOperationAdapter baseOperationAdapter = new BaseOperationAdapter();
    static final JSONObjectAdapter jsonObjectAdapter = new JSONObjectAdapter();
    static final JSONArrayAdapter jsonArrayAdapter = new JSONArrayAdapter();
    static final Gson gson = new GsonBuilder().serializeNulls().excludeFieldsWithModifiers(new int[]{8, 128, 64}).setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").registerTypeAdapter(LCObject.class, (Object)objectDeserializer).registerTypeAdapter(LCUser.class, (Object)objectDeserializer).registerTypeAdapter(LCFile.class, (Object)objectDeserializer).registerTypeAdapter(LCRole.class, (Object)objectDeserializer).registerTypeAdapter(LCStatus.class, (Object)objectDeserializer).registerTypeAdapter(LCInstallation.class, (Object)objectDeserializer).registerTypeAdapter(LCFriendshipRequest.class, (Object)objectDeserializer).registerTypeAdapter(LCFriendship.class, (Object)objectDeserializer).registerTypeAdapter(BaseOperation.class, (Object)baseOperationAdapter).registerTypeAdapter(AddOperation.class, (Object)baseOperationAdapter).registerTypeAdapter(AddRelationOperation.class, (Object)baseOperationAdapter).registerTypeAdapter(AddUniqueOperation.class, (Object)baseOperationAdapter).registerTypeAdapter(BitAndOperation.class, (Object)baseOperationAdapter).registerTypeAdapter(BitOrOperation.class, (Object)baseOperationAdapter).registerTypeAdapter(BitXOROperation.class, (Object)baseOperationAdapter).registerTypeAdapter(CompoundOperation.class, (Object)baseOperationAdapter).registerTypeAdapter(DecrementOperation.class, (Object)baseOperationAdapter).registerTypeAdapter(DeleteOperation.class, (Object)baseOperationAdapter).registerTypeAdapter(IncrementOperation.class, (Object)baseOperationAdapter).registerTypeAdapter(NumericOperation.class, (Object)baseOperationAdapter).registerTypeAdapter(RemoveOperation.class, (Object)baseOperationAdapter).registerTypeAdapter(RemoveRelationOperation.class, (Object)baseOperationAdapter).registerTypeAdapter(SetOperation.class, (Object)baseOperationAdapter).registerTypeAdapter(GsonObject.class, (Object)jsonObjectAdapter).registerTypeAdapter(JSONObject.class, (Object)jsonObjectAdapter).registerTypeAdapter(GsonArray.class, (Object)jsonArrayAdapter).registerTypeAdapter(FileUploadToken.class, (Object)new FileUploadTokenAdapter()).registerTypeAdapter(AppAccessEndpoint.class, new GeneralObjectAdapter(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES, TypeToken.get(AppAccessEndpoint.class))).registerTypeAdapter(LCCaptchaDigest.class, new GeneralObjectAdapter(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES, TypeToken.get(LCCaptchaDigest.class))).registerTypeAdapter(LCCaptchaValidateResult.class, new GeneralObjectAdapter(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES, TypeToken.get(LCCaptchaValidateResult.class))).registerTypeAdapter(new TypeToken<Map<String, Object>>(){}.getType(), (Object)new MapDeserializerDoubleAsIntFix()).registerTypeAdapter(Map.class, (Object)new MapDeserializerDoubleAsIntFix()).setLenient().create();
    public static final TimeZone defaultTimeZone = TimeZone.getDefault();
    public static final Locale defaultLocale = Locale.getDefault();
    public static final String DEFFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public static Gson getGsonInstance() {
        return gson;
    }

    public static String toJsonString(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        return gson.toJson(map);
    }

    public static JsonElement toJsonElement(Object object) {
        if (null == object) {
            return null;
        }
        if (object instanceof GsonObject) {
            return ((GsonObject)object).getRawObject();
        }
        if (object instanceof GsonArray) {
            return ((GsonArray)object).getRawObject();
        }
        return gson.toJsonTree(object);
    }

    public static Object parseObject(String jsonString) {
        try {
            return gson.fromJson(jsonString, new TypeToken<Map<String, Object>>(){}.getType());
        }
        catch (Exception ex) {
            JsonElement element = gson.toJsonTree((Object)jsonString);
            if (element.isJsonPrimitive()) {
                JsonPrimitive jsonPrimitive = element.getAsJsonPrimitive();
                if (jsonPrimitive.isBoolean()) {
                    return jsonPrimitive.getAsBoolean();
                }
                if (jsonPrimitive.isString()) {
                    return jsonPrimitive.getAsString();
                }
                if (jsonPrimitive.isNumber()) {
                    return NumberDeserializerDoubleAsIntFix.parsePrecisionNumber(jsonPrimitive.getAsNumber());
                }
                return null;
            }
            if (element.isJsonArray()) {
                return element.getAsJsonArray();
            }
            return null;
        }
    }

    public static <T> T parseObject(String jsonString, Class<T> clazz) {
        if (clazz.isPrimitive() || String.class.isAssignableFrom(clazz)) {
            JsonElement element = gson.toJsonTree((Object)jsonString);
            return (T)gson.fromJson(element, clazz);
        }
        return (T)gson.fromJson(jsonString, clazz);
    }

    public static <T> T parseObject(String jsonString, Type typeOfT) {
        if (Primitives.isPrimitive((Type)typeOfT) || typeOfT instanceof Class && String.class.isAssignableFrom((Class)typeOfT)) {
            JsonElement element = gson.toJsonTree((Object)jsonString, typeOfT);
            return (T)gson.fromJson(element, typeOfT);
        }
        return (T)gson.fromJson(jsonString, typeOfT);
    }

    public static <T> T toJavaObject(JsonElement element, Class<T> clazz) {
        if (null == element) {
            return null;
        }
        return (T)gson.fromJson(element, clazz);
    }

    public static Object toJavaObject(JsonElement element) {
        if (null == element) {
            return null;
        }
        return GsonWrapper.toJavaObject(element, Object.class);
    }

    public static final Date castToDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime();
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        long longValue = -1L;
        if (value instanceof BigDecimal) {
            BigDecimal decimal = (BigDecimal)value;
            int scale = decimal.scale();
            longValue = scale >= -100 && scale <= 100 ? decimal.longValue() : decimal.longValueExact();
        } else if (value instanceof Number) {
            longValue = ((Number)value).longValue();
        } else if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.indexOf(45) != -1) {
                String format = strVal.length() == DEFFAULT_DATE_FORMAT.length() ? DEFFAULT_DATE_FORMAT : (strVal.length() == 10 ? "yyyy-MM-dd" : (strVal.length() == DEFFAULT_DATE_FORMAT.length() ? DEFFAULT_DATE_FORMAT : (strVal.length() == 29 && strVal.charAt(26) == ':' && strVal.charAt(28) == '0' ? "yyyy-MM-dd'T'HH:mm:ss.SSSXXX" : "yyyy-MM-dd HH:mm:ss.SSS")));
                SimpleDateFormat dateFormat = new SimpleDateFormat(format, defaultLocale);
                dateFormat.setTimeZone(defaultTimeZone);
                try {
                    return dateFormat.parse(strVal);
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("can not cast to Date, value : " + strVal);
                }
            }
            if (strVal.length() == 0 || "null".equals(strVal)) {
                return null;
            }
            longValue = Long.parseLong(strVal);
        }
        if (longValue < 0L) {
            throw new IllegalArgumentException("can not cast to Date, value : " + value);
        }
        return new Date(longValue);
    }
}

