/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.LCQuery;
import cn.leancloud.LCStatus;
import cn.leancloud.LCStatusQuery;
import cn.leancloud.json.JSON;
import java.util.Map;

class StatusIterator {
    LCStatusQuery.SourceType sourceType;
    LCStatus lastStatus = null;
    private int pageSize;
    private long sinceId = 0L;
    private long maxId = 0L;
    private LCStatusQuery.PaginationDirection direction;

    public StatusIterator(LCStatusQuery.SourceType type) {
        this(type, LCStatusQuery.PaginationDirection.NEW_TO_OLD, 0);
    }

    public StatusIterator(LCStatusQuery.SourceType type, LCStatusQuery.PaginationDirection direction, int pageSize) {
        this.sourceType = type;
        this.direction = direction;
        this.pageSize = pageSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        if (pageSize > 0 && pageSize < 200) {
            this.pageSize = pageSize;
        }
    }

    public long getSinceId() {
        return this.sinceId;
    }

    public void setSinceId(long sinceId) {
        this.sinceId = sinceId;
    }

    public long getMaxId() {
        return this.maxId;
    }

    public void setMaxId(long maxId) {
        this.maxId = maxId;
    }

    public LCStatusQuery.PaginationDirection getDirection() {
        return this.direction;
    }

    public void setDirection(LCStatusQuery.PaginationDirection direction) {
        this.direction = direction;
    }

    public void fillConditions(LCQuery query) {
        if (null == query || null == this.lastStatus) {
            return;
        }
        if (LCStatusQuery.PaginationDirection.NEW_TO_OLD == this.direction) {
            query.whereLessThan("createdAt", this.lastStatus.getCreatedAt());
        } else {
            query.whereGreaterThan("createdAt", this.lastStatus.getCreatedAt());
        }
    }

    public void fillConditions(Map<String, String> condition) {
        if (this.direction == LCStatusQuery.PaginationDirection.OLD_TO_NEW && this.sinceId > 0L) {
            condition.put("sinceId", String.valueOf(this.sinceId));
        }
        if (this.direction == LCStatusQuery.PaginationDirection.NEW_TO_OLD && this.maxId > 0L) {
            condition.put("maxId", String.valueOf(this.maxId - 1L));
        }
    }

    public void encounter(LCStatus status) {
        this.lastStatus = status;
        if (LCStatusQuery.SourceType.INBOX == this.sourceType && null != status) {
            if (this.direction == LCStatusQuery.PaginationDirection.OLD_TO_NEW) {
                if (status.getMessageId() > this.sinceId) {
                    this.sinceId = status.getMessageId();
                }
            } else if (0L == this.maxId) {
                this.maxId = status.getMessageId();
            } else if (status.getMessageId() < this.maxId) {
                this.maxId = status.getMessageId();
            }
        }
    }

    public String toString() {
        return JSON.toJSONString(this);
    }
}

