/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.LCQuery;
import cn.leancloud.LCStatus;
import cn.leancloud.LCUser;
import cn.leancloud.StatusIterator;
import cn.leancloud.core.PaasClient;
import cn.leancloud.json.JSONObject;
import cn.leancloud.ops.Utils;
import cn.leancloud.utils.ErrorUtils;
import cn.leancloud.utils.StringUtil;
import io.reactivex.Observable;
import io.reactivex.functions.Function;
import java.util.List;
import java.util.Map;

public class LCStatusQuery
extends LCQuery<LCStatus> {
    private LCUser source = null;
    private LCUser owner = null;
    private String inboxType = null;
    private SourceType sourceType;
    private StatusIterator iterator;

    protected LCStatusQuery(SourceType type) {
        super("_Status", LCStatus.class);
        this.sourceType = type;
        this.iterator = new StatusIterator(type);
    }

    public void setSinceId(long sinceId) {
        this.iterator.setSinceId(sinceId);
    }

    public long getSinceId() {
        return this.iterator.getSinceId();
    }

    public long getMaxId() {
        return this.iterator.getMaxId();
    }

    public void setMaxId(long maxId) {
        this.iterator.setMaxId(maxId);
    }

    public int getPageSize() {
        return this.iterator.getPageSize();
    }

    public void setPageSize(int pageSize) {
        this.iterator.setPageSize(pageSize);
    }

    public void setDirection(PaginationDirection direct) {
        this.iterator.setDirection(direct);
    }

    void setSource(LCUser source) {
        this.source = source;
    }

    void setOwner(LCUser owner) {
        this.owner = owner;
        if (null != owner) {
            this.getInclude().add("source");
        }
    }

    void setInboxType(String type) {
        this.inboxType = type;
    }

    @Override
    public Map<String, String> assembleParameters() {
        return this.assembleParameters(false);
    }

    private Map<String, String> assembleParameters(boolean withIterator) {
        if (SourceType.OWNED == this.sourceType) {
            if (!StringUtil.isEmpty(this.inboxType)) {
                this.whereEqualTo("inboxType", this.inboxType);
            }
            if (null != this.source) {
                this.whereEqualTo("source", this.source);
            }
            if (withIterator) {
                this.iterator.fillConditions(this);
            } else if (PaginationDirection.NEW_TO_OLD == this.iterator.getDirection()) {
                this.addDescendingOrder("createdAt");
            } else {
                this.addAscendingOrder("createdAt");
            }
        } else if (!withIterator) {
            if (PaginationDirection.NEW_TO_OLD == this.iterator.getDirection()) {
                this.addDescendingOrder("messageId");
            } else {
                this.addAscendingOrder("messageId");
            }
        }
        Map<String, String> result = super.assembleParameters();
        if (null != this.owner) {
            if (withIterator) {
                this.iterator.fillConditions(result);
            }
            if (!StringUtil.isEmpty(this.inboxType)) {
                result.put("inboxType", this.inboxType);
            }
            String ownerString = JSONObject.Builder.create(Utils.mapFromAVObject(this.owner, false)).toJSONString();
            result.put("owner", ownerString);
        } else if (SourceType.OWNED != this.sourceType && null != this.source) {
            String sourceString = JSONObject.Builder.create(Utils.mapFromAVObject(this.source, false)).toJSONString();
            result.put("source", sourceString);
        }
        if (this.getPageSize() > 0) {
            result.put("limit", String.valueOf(this.getPageSize()));
        }
        return result;
    }

    protected Observable<List<LCStatus>> findInBackground(int explicitLimit) {
        return this.findInBackground(null, explicitLimit);
    }

    @Override
    protected Observable<List<LCStatus>> findInBackground(LCUser asAuthenticatedUser, int explicitLimit) {
        return this.internalFindInBackground(asAuthenticatedUser, explicitLimit, false);
    }

    private Observable<List<LCStatus>> internalFindInBackground(LCUser asAuthenticatedUser, int explicitLimit, boolean enableIterator) {
        if (null == this.owner && null == this.source) {
            return Observable.error((Throwable)ErrorUtils.illegalArgument("source or owner is null, please initialize correctly."));
        }
        if (null != this.owner && !this.owner.isAuthenticated()) {
            return Observable.error((Throwable)ErrorUtils.sessionMissingException());
        }
        Map<String, String> query = enableIterator ? this.assembleParameters(true) : this.assembleParameters();
        if (explicitLimit > 0) {
            query.put("limit", String.valueOf(explicitLimit));
        }
        if (null != this.owner) {
            return PaasClient.getStorageClient().queryInbox(asAuthenticatedUser, query).map((Function)new Function<List<LCStatus>, List<LCStatus>>(){

                public List<LCStatus> apply(List<LCStatus> avStatuses) throws Exception {
                    if (null == avStatuses || avStatuses.size() < 1) {
                        return avStatuses;
                    }
                    for (LCStatus status : avStatuses) {
                        LCStatusQuery.this.iterator.encounter(status);
                    }
                    return avStatuses;
                }
            });
        }
        return PaasClient.getStorageClient().queryStatus(asAuthenticatedUser, query).map((Function)new Function<List<LCStatus>, List<LCStatus>>(){

            public List<LCStatus> apply(List<LCStatus> avStatuses) throws Exception {
                if (null == avStatuses || avStatuses.size() < 1) {
                    return avStatuses;
                }
                for (LCStatus status : avStatuses) {
                    LCStatusQuery.this.iterator.encounter(status);
                }
                return avStatuses;
            }
        });
    }

    public Observable<List<LCStatus>> nextInBackground() {
        return this.internalFindInBackground(null, 0, true);
    }

    @Override
    public Observable<Integer> countInBackground() {
        if (null == this.owner && null == this.source) {
            return Observable.error((Throwable)ErrorUtils.illegalArgument("source or owner is null, please initialize correctly."));
        }
        if (null != this.owner) {
            return Observable.error((Throwable)ErrorUtils.invalidStateException("countInBackground doesn't work for inbox query, please use unreadCountInBackground."));
        }
        Map<String, String> query = this.assembleParameters();
        query.put("count", "1");
        query.put("limit", "0");
        return PaasClient.getStorageClient().queryCount(null, "_Status", query);
    }

    public Observable<JSONObject> unreadCountInBackground() {
        if (null == this.owner || !this.owner.isAuthenticated()) {
            return Observable.error((Throwable)ErrorUtils.sessionMissingException());
        }
        Map<String, String> query = this.assembleParameters();
        query.put("count", "1");
        query.put("limit", "0");
        return PaasClient.getStorageClient().getInboxCount(this.owner, query);
    }

    public static enum PaginationDirection {
        NEW_TO_OLD(0),
        OLD_TO_NEW(1);

        int value;

        private PaginationDirection(int v) {
            this.value = v;
        }

        public int value() {
            return this.value;
        }
    }

    public static enum SourceType {
        INBOX,
        OWNED;

    }
}

