/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.LCObject;
import cn.leancloud.LCSaveOption;
import cn.leancloud.LCUser;
import cn.leancloud.annotation.LCClassName;
import cn.leancloud.utils.ErrorUtils;
import io.reactivex.Observable;
import java.util.Map;

@LCClassName(value="_FriendshipRequest")
public class LCFriendshipRequest
extends LCObject {
    public static final String CLASS_NAME = "_FriendshipRequest";
    public static final String ATTR_FRIEND = "friend";
    public static final String ATTR_USER = "user";
    public static final String ATTR_STATUS = "status";
    public static final String INTERNAL_STATUS_ACCEPTED = "accepted";
    public static final String INTERNAL_STATUS_DECLINED = "declined";
    public static final int STATUS_PENDING = 1;
    public static final int STATUS_ACCEPTED = 2;
    public static final int STATUS_DECLINED = 4;
    public static final int STATUS_ANY = 7;

    public LCFriendshipRequest() {
        super(CLASS_NAME);
    }

    public LCFriendshipRequest(LCFriendshipRequest other) {
        super(other);
    }

    public void setFriend(LCUser user) {
        this.put(ATTR_FRIEND, user);
    }

    public LCUser getFriend() {
        return (LCUser)this.getLCObject(ATTR_FRIEND);
    }

    public LCUser getSourceUser() {
        return (LCUser)this.getLCObject(ATTR_USER);
    }

    public void setSourceUser(LCUser user) {
        this.put(ATTR_USER, user);
    }

    public Observable<? extends LCObject> accept(Map<String, Object> attributes) {
        LCUser currentUser = LCUser.currentUser();
        if (null == currentUser) {
            logger.d("current user is null.");
            return Observable.error((Throwable)ErrorUtils.propagateException(206, "No valid session token, make sure signUp or login has been called."));
        }
        return currentUser.acceptFriendshipRequest(this, attributes);
    }

    public Observable<? extends LCObject> decline() {
        LCUser currentUser = LCUser.currentUser();
        if (null == currentUser) {
            logger.d("current user is null.");
            return Observable.error((Throwable)ErrorUtils.propagateException(206, "No valid session token, make sure signUp or login has been called."));
        }
        return currentUser.declineFriendshipRequest(this);
    }

    @Override
    public Observable<? extends LCObject> saveInBackground(LCSaveOption option) {
        return Observable.error((Throwable)ErrorUtils.propagateException(119, "save operation isn't allowed in AVFriendshipRequest class."));
    }

    static enum RequestStatus {
        Pending,
        Accepted,
        Declined;

    }
}

