/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.upload;

import cn.leancloud.LCException;
import cn.leancloud.LCLogger;
import cn.leancloud.codec.Base64;
import cn.leancloud.json.JSON;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import java.util.List;
import java.util.zip.CRC32;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

class QiniuAccessor {
    private static LCLogger LOGGER = LogUtil.getLogger(QiniuAccessor.class);
    static final String QINIU_HOST = "http://upload.qiniu.com";
    static final String QINIU_CREATE_BLOCK_EP = "%s/mkblk/%d";
    static final String QINIU_BRICK_UPLOAD_EP = "%s/bput/%s/%d";
    static final String QINIU_MKFILE_EP = "%s/mkfile/%d/key/%s";
    static final String HEAD_CONTENT_LENGTH = "Content-Length";
    static final String HEAD_CONTENT_TYPE = "Content-Type";
    static final String HEAD_AUTHORIZATION = "Authorization";
    static final String TEXT_CONTENT_TYPE = "text/plain";
    static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    static final int WIFI_CHUNK_SIZE = 262144;
    static final int BLOCK_SIZE = 0x400000;
    static final int NONWIFI_CHUNK_SIZE = 65536;
    private OkHttpClient client;
    private String uploadToken;
    private String fileKey;
    private String uploadUrl = "http://upload.qiniu.com";

    QiniuAccessor(OkHttpClient client, String uploadToken, String fileKey, String uploadUrl) {
        this.client = client;
        this.uploadToken = uploadToken;
        this.fileKey = fileKey;
        if (!StringUtil.isEmpty(uploadUrl)) {
            this.uploadUrl = uploadUrl;
        }
    }

    private static <T> T parseQiniuResponse(Response resp, Class<T> clazz) throws Exception {
        int code = resp.code();
        String phrase = resp.message();
        String h = resp.header("X-Log");
        if (code == 401) {
            throw new Exception("unauthorized to create Qiniu Block");
        }
        String responseData = StringUtil.stringFromBytes(resp.body().bytes());
        try {
            if (code / 100 == 2) {
                T data = JSON.parseObject(responseData, clazz);
                return data;
            }
        }
        catch (Exception e) {
            LOGGER.w(e);
        }
        if (responseData.length() > 0) {
            throw new Exception(code + ":" + responseData);
        }
        if (!StringUtil.isEmpty(h)) {
            throw new Exception(h);
        }
        throw new Exception(phrase);
    }

    public QiniuBlockResponseData createBlockInQiniu(int blockSize, int firstChunkSize, byte[] firstChunkData, int retry) {
        try {
            String endPoint = String.format(QINIU_CREATE_BLOCK_EP, this.uploadUrl, blockSize);
            Request.Builder builder = new Request.Builder();
            builder.url(endPoint);
            builder.addHeader(HEAD_CONTENT_TYPE, DEFAULT_CONTENT_TYPE);
            builder.addHeader(HEAD_CONTENT_LENGTH, String.valueOf(firstChunkSize));
            builder.addHeader(HEAD_AUTHORIZATION, "UpToken " + this.uploadToken);
            LOGGER.d("createBlockInQiniu with uploadUrl: " + endPoint);
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)DEFAULT_CONTENT_TYPE), (byte[])firstChunkData, (int)0, (int)firstChunkSize);
            builder = builder.post(requestBody);
            Response response = this.client.newCall(builder.build()).execute();
            return QiniuAccessor.parseQiniuResponse(response, QiniuBlockResponseData.class);
        }
        catch (Exception e) {
            if (retry-- > 0) {
                return this.createBlockInQiniu(blockSize, firstChunkSize, firstChunkData, retry);
            }
            LOGGER.w(e);
            return null;
        }
    }

    public QiniuBlockResponseData putFileBlocksToQiniu(QiniuBlockResponseData lastChunk, int blockOffset, byte[] currentChunkData, int currentChunkSize, int retry) {
        try {
            String endPoint = String.format(QINIU_BRICK_UPLOAD_EP, this.uploadUrl, lastChunk.ctx, lastChunk.offset);
            Request.Builder builder = new Request.Builder();
            builder.url(endPoint);
            builder.addHeader(HEAD_CONTENT_TYPE, DEFAULT_CONTENT_TYPE);
            builder.addHeader(HEAD_CONTENT_LENGTH, String.valueOf(currentChunkSize));
            builder.addHeader(HEAD_AUTHORIZATION, "UpToken " + this.uploadToken);
            LOGGER.d("putFileBlocksToQiniu with uploadUrl: " + endPoint);
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)DEFAULT_CONTENT_TYPE), (byte[])currentChunkData, (int)0, (int)currentChunkSize);
            builder = builder.post(requestBody);
            Response response = this.client.newCall(builder.build()).execute();
            QiniuBlockResponseData respData = QiniuAccessor.parseQiniuResponse(response, QiniuBlockResponseData.class);
            this.validateCrc32Value(respData, currentChunkData, 0, currentChunkSize);
            return respData;
        }
        catch (Exception e) {
            if (retry-- > 0) {
                return this.putFileBlocksToQiniu(lastChunk, blockOffset, currentChunkData, currentChunkSize, retry);
            }
            LOGGER.w(e);
            return null;
        }
    }

    private void validateCrc32Value(QiniuBlockResponseData respData, byte[] data, int offset, int nextChunkSize) throws LCException {
        CRC32 crc32 = new CRC32();
        crc32.update(data, offset, nextChunkSize);
        long localCRC32 = crc32.getValue();
        if (respData != null && respData.crc32 != localCRC32) {
            throw new LCException(-1, "CRC32 validation failure for chunk upload");
        }
    }

    public QiniuMKFileResponseData makeFile(int fileTotalSize, List<String> uploadFileCtxs, int retry) throws Exception {
        try {
            String endPoint = String.format(QINIU_MKFILE_EP, this.uploadUrl, fileTotalSize, Base64.encodeToString(this.fileKey.getBytes(), 10));
            String joinedFileCtx = StringUtil.join(",", uploadFileCtxs);
            Request.Builder builder = new Request.Builder();
            builder.url(endPoint);
            builder.addHeader(HEAD_CONTENT_TYPE, TEXT_CONTENT_TYPE);
            builder.addHeader(HEAD_CONTENT_LENGTH, String.valueOf(joinedFileCtx.length()));
            builder.addHeader(HEAD_AUTHORIZATION, "UpToken " + this.uploadToken);
            LOGGER.d("makeFile to qiniu with uploadUrl: " + endPoint);
            builder = builder.post(RequestBody.create((MediaType)MediaType.parse((String)TEXT_CONTENT_TYPE), (String)joinedFileCtx));
            Response response = this.client.newCall(builder.build()).execute();
            return QiniuAccessor.parseQiniuResponse(response, QiniuMKFileResponseData.class);
        }
        catch (Exception e) {
            if (retry-- > 0) {
                return this.makeFile(fileTotalSize, uploadFileCtxs, retry);
            }
            LOGGER.w(e);
            return null;
        }
    }

    static class QiniuMKFileResponseData {
        public String key;
        public String hash;

        QiniuMKFileResponseData() {
        }

        public String toString() {
            return "QiniuMKFileResponseData{key='" + this.key + '\'' + ", hash='" + this.hash + '\'' + '}';
        }
    }

    static class QiniuBlockResponseData {
        private String ctx;
        private long crc32;
        private int offset;
        private String host;
        private String checksum;

        QiniuBlockResponseData() {
        }

        public String getCtx() {
            return this.ctx;
        }

        public void setCtx(String ctx) {
            this.ctx = ctx;
        }

        public long getCrc32() {
            return this.crc32;
        }

        public void setCrc32(long crc32) {
            this.crc32 = crc32;
        }

        public int getOffset() {
            return this.offset;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public String getChecksum() {
            return this.checksum;
        }

        public void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public String toString() {
            return "QiniuBlockResponseData{ctx='" + this.ctx + '\'' + ", crc32=" + this.crc32 + ", offset=" + this.offset + ", host='" + this.host + '\'' + ", checksum='" + this.checksum + '\'' + '}';
        }
    }
}

