/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.service;

import cn.leancloud.LCFile;
import cn.leancloud.LCFriendship;
import cn.leancloud.LCObject;
import cn.leancloud.LCRole;
import cn.leancloud.LCStatus;
import cn.leancloud.LCUser;
import cn.leancloud.json.JSONObject;
import cn.leancloud.query.LCQueryResult;
import cn.leancloud.search.LCSearchResponse;
import cn.leancloud.sms.LCCaptchaDigest;
import cn.leancloud.sms.LCCaptchaValidateResult;
import cn.leancloud.types.LCDate;
import cn.leancloud.types.LCNull;
import cn.leancloud.upload.FileUploadToken;
import io.reactivex.Observable;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;

public interface APIService {
    public static final String HEADER_KEY_LC_SESSIONTOKEN = "X-LC-Session";

    @GET(value="/1.1/classes/{className}")
    public Observable<List<? extends LCObject>> findObjects(@Header(value="X-LC-Session") String var1, @Path(value="className") String var2);

    @GET(value="/1.1/classes/{className}")
    public Observable<LCQueryResult> queryObjects(@Header(value="X-LC-Session") String var1, @Path(value="className") String var2, @QueryMap Map<String, String> var3);

    @GET(value="/1.1/cloudQuery")
    public Observable<LCQueryResult> cloudQuery(@Header(value="X-LC-Session") String var1, @QueryMap Map<String, String> var2);

    @GET(value="/1.1/classes/{className}/{objectId}")
    public Observable<LCObject> fetchObject(@Header(value="X-LC-Session") String var1, @Path(value="className") String var2, @Path(value="objectId") String var3);

    @GET(value="/1.1/classes/{className}/{objectId}")
    public Observable<LCObject> fetchObject(@Header(value="X-LC-Session") String var1, @Path(value="className") String var2, @Path(value="objectId") String var3, @Query(value="include") String var4);

    @POST(value="/1.1/classes/{className}")
    public Observable<LCObject> createObject(@Header(value="X-LC-Session") String var1, @Path(value="className") String var2, @Body JSONObject var3, @Query(value="fetchWhenSave") boolean var4, @Query(value="where") JSONObject var5);

    @PUT(value="/1.1/classes/{className}/{objectId}")
    public Observable<LCObject> updateObject(@Header(value="X-LC-Session") String var1, @Path(value="className") String var2, @Path(value="objectId") String var3, @Body JSONObject var4, @Query(value="fetchWhenSave") boolean var5, @Query(value="where") JSONObject var6);

    @HTTP(method="DELETE", path="/1.1/classes/{className}/{objectId}", hasBody=true)
    public Observable<LCNull> deleteObject(@Header(value="X-LC-Session") String var1, @Path(value="className") String var2, @Path(value="objectId") String var3, @Body Map<String, Object> var4);

    @POST(value="/1.1/batch")
    public Observable<List<Map<String, Object>>> batchCreate(@Header(value="X-LC-Session") String var1, @Body JSONObject var2);

    @POST(value="/1.1/{endpointClass}")
    public Observable<LCObject> saveWholeObject(@Header(value="X-LC-Session") String var1, @Path(value="endpointClass") String var2, @Body JSONObject var3, @Query(value="fetchWhenSave") boolean var4, @Query(value="where") JSONObject var5);

    @PUT(value="/1.1/{endpointClass}/{objectId}")
    public Observable<LCObject> saveWholeObject(@Header(value="X-LC-Session") String var1, @Path(value="endpointClass") String var2, @Path(value="objectId") String var3, @Body JSONObject var4, @Query(value="fetchWhenSave") boolean var5, @Query(value="where") JSONObject var6);

    @GET(value="/1.1/{endpointClass}/{objectId}")
    public Observable<LCObject> getWholeObject(@Header(value="X-LC-Session") String var1, @Path(value="endpointClass") String var2, @Path(value="objectId") String var3, @Query(value="include") String var4);

    @HTTP(method="DELETE", path="/1.1/{endpointClass}/{objectId}", hasBody=true)
    public Observable<LCNull> deleteWholeObject(@Header(value="X-LC-Session") String var1, @Path(value="endpointClass") String var2, @Path(value="objectId") String var3, @Body Map<String, Object> var4);

    @POST(value="/1.1/batch/save")
    public Observable<JSONObject> batchUpdate(@Header(value="X-LC-Session") String var1, @Body JSONObject var2);

    @POST(value="/1.1/functions/{name}")
    public Observable<Map<String, Object>> cloudFunction(@Header(value="X-LC-Session") String var1, @Path(value="name") String var2, @Body Map<String, Object> var3);

    @POST(value="/1.1/call/{name}")
    public Observable<Map<String, Object>> cloudRPC(@Header(value="X-LC-Session") String var1, @Path(value="name") String var2, @Body Object var3);

    @POST(value="/1.1/fileTokens")
    public Observable<FileUploadToken> createUploadToken(@Header(value="X-LC-Session") String var1, @Body JSONObject var2);

    @POST(value="/1.1/fileCallback")
    public Call<LCNull> fileCallback(@Header(value="X-LC-Session") String var1, @Body JSONObject var2);

    @GET(value="/1.1/files/{objectId}")
    public Observable<LCFile> fetchFile(@Header(value="X-LC-Session") String var1, @Path(value="objectId") String var2);

    @GET(value="/1.1/date")
    public Observable<LCDate> currentTimeMillis();

    @POST(value="/1.1/roles")
    public Observable<LCRole> createRole(@Body JSONObject var1);

    @POST(value="/1.1/users")
    public Observable<LCUser> signup(@Body JSONObject var1);

    @POST(value="/1.1/users")
    public Observable<LCUser> signup(@Body JSONObject var1, @Query(value="failOnNotExist") boolean var2);

    @GET(value="/1.1/users")
    public Observable<LCQueryResult> queryUsers(@Header(value="X-LC-Session") String var1, @QueryMap Map<String, String> var2);

    @POST(value="/1.1/users/friendshipRequests")
    public Observable<LCObject> applyFriendship(@Header(value="X-LC-Session") String var1, @Body JSONObject var2);

    @PUT(value="/1.1/users/friendshipRequests/{requestId}/accept")
    public Observable<LCObject> acceptFriendshipRequest(@Header(value="X-LC-Session") String var1, @Path(value="requestId") String var2, @Body JSONObject var3);

    @PUT(value="/1.1/users/friendshipRequests/{requestId}/decline")
    public Observable<LCObject> declineFriendshipRequest(@Header(value="X-LC-Session") String var1, @Path(value="requestId") String var2);

    @POST(value="/1.1/usersByMobilePhone")
    public Observable<LCUser> signupByMobilePhone(@Body JSONObject var1);

    @POST(value="/1.1/login")
    public Observable<LCUser> login(@Body JSONObject var1);

    @PUT(value="/1.1/users/{objectId}/updatePassword")
    public Observable<LCUser> updatePassword(@Header(value="X-LC-Session") String var1, @Path(value="objectId") String var2, @Body JSONObject var3);

    @GET(value="/1.1/users/me")
    public Observable<LCUser> checkAuthenticated(@Header(value="X-LC-Session") String var1, @QueryMap Map<String, String> var2);

    @PUT(value="/1.1/users/{objectId}/refreshSessionToken")
    public Observable<LCUser> refreshSessionToken(@Header(value="X-LC-Session") String var1, @Path(value="objectId") String var2);

    @POST(value="/1.1/requestPasswordReset")
    public Observable<LCNull> requestResetPassword(@Body Map<String, String> var1);

    @POST(value="/1.1/requestPasswordResetBySmsCode")
    public Observable<LCNull> requestResetPasswordBySmsCode(@Body Map<String, String> var1);

    @PUT(value="/1.1/resetPasswordBySmsCode/{smsCode}")
    public Observable<LCNull> resetPasswordBySmsCode(@Path(value="smsCode") String var1, @Body Map<String, String> var2);

    @POST(value="/1.1/requestEmailVerify")
    public Observable<LCNull> requestEmailVerify(@Body Map<String, String> var1);

    @POST(value="/1.1/requestMobilePhoneVerify")
    public Observable<LCNull> requestMobilePhoneVerify(@Body Map<String, String> var1);

    @POST(value="/1.1/verifyMobilePhone/{verifyCode}")
    public Observable<LCNull> verifyMobilePhone(@Path(value="verifyCode") String var1);

    @POST(value="/1.1/requestLoginSmsCode")
    public Observable<LCNull> requestLoginSmsCode(@Body Map<String, String> var1);

    @POST(value="/1.1/users/{followee}/friendship/{follower}")
    public Observable<JSONObject> followUser(@Header(value="X-LC-Session") String var1, @Path(value="followee") String var2, @Path(value="follower") String var3, @Body Map<String, Object> var4);

    @PUT(value="/1.1/users/{followee}/friendship/{friendId}")
    public Observable<LCFriendship> updateFriendship(@Header(value="X-LC-Session") String var1, @Path(value="followee") String var2, @Path(value="friendId") String var3, @Body Map<String, Object> var4);

    @DELETE(value="/1.1/users/{followee}/friendship/{follower}")
    public Observable<JSONObject> unfollowUser(@Header(value="X-LC-Session") String var1, @Path(value="followee") String var2, @Path(value="follower") String var3);

    @GET(value="/1.1/users/{userId}/followers")
    public Observable<LCQueryResult> getFollowers(@Header(value="X-LC-Session") String var1, @Path(value="userId") String var2, @QueryMap Map<String, String> var3);

    @GET(value="/1.1/users/{userId}/followees")
    public Observable<LCQueryResult> getFollowees(@Header(value="X-LC-Session") String var1, @Path(value="userId") String var2, @QueryMap Map<String, String> var3);

    @GET(value="/1.1/users/{userId}/followersAndFollowees")
    public Observable<JSONObject> getFollowersAndFollowees(@Header(value="X-LC-Session") String var1, @Path(value="userId") String var2);

    @POST(value="/1.1/statuses")
    public Observable<LCStatus> postStatus(@Header(value="X-LC-Session") String var1, @Body Map<String, Object> var2);

    @GET(value="/1.1/statuses/{statusId}")
    public Observable<LCStatus> fetchSingleStatus(@Header(value="X-LC-Session") String var1, @Path(value="statusId") String var2);

    @GET(value="/1.1/statuses")
    public Observable<LCQueryResult> fetchStatuses(@Header(value="X-LC-Session") String var1, @QueryMap Map<String, String> var2);

    @DELETE(value="/1.1/statuses/{statusId}")
    public Observable<LCNull> deleteStatus(@Header(value="X-LC-Session") String var1, @Path(value="statusId") String var2);

    @DELETE(value="/1.1/subscribe/statuses/inbox")
    public Observable<LCNull> deleteInboxStatus(@Header(value="X-LC-Session") String var1, @QueryMap Map<String, Object> var2);

    @GET(value="/1.1/subscribe/statuses")
    public Observable<LCQueryResult> queryInbox(@Header(value="X-LC-Session") String var1, @QueryMap Map<String, String> var2);

    @GET(value="/1.1/subscribe/statuses/count")
    public Observable<JSONObject> getInboxCount(@Header(value="X-LC-Session") String var1, @QueryMap Map<String, String> var2);

    @POST(value="/1.1/subscribe/statuses/resetUnreadCount")
    public Observable<LCNull> resetInboxUnreadCount(@Header(value="X-LC-Session") String var1);

    @GET(value="/1.1/requestCaptcha")
    public Observable<LCCaptchaDigest> requestCaptcha(@QueryMap Map<String, String> var1);

    @POST(value="/1.1/verifyCaptcha")
    public Observable<LCCaptchaValidateResult> verifyCaptcha(@Body Map<String, String> var1);

    @POST(value="/1.1/requestSmsCode")
    public Observable<LCNull> requestSMSCode(@Body Map<String, Object> var1);

    @POST(value="/1.1/verifySmsCode/{code}")
    public Observable<LCNull> verifySMSCode(@Path(value="code") String var1, @Body Map<String, Object> var2);

    @POST(value="/1.1/requestChangePhoneNumber")
    public Observable<LCNull> requestSMSCodeForUpdatingPhoneNumber(@Header(value="X-LC-Session") String var1, @Body Map<String, Object> var2);

    @POST(value="/1.1/changePhoneNumber")
    public Observable<LCNull> verifySMSCodeForUpdatingPhoneNumber(@Header(value="X-LC-Session") String var1, @Body Map<String, Object> var2);

    @GET(value="/1.1/search/select")
    public Observable<LCSearchResponse> search(@Header(value="X-LC-Session") String var1, @QueryMap Map<String, String> var2);
}

