/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.search;

import cn.leancloud.LCLogger;
import cn.leancloud.LCObject;
import cn.leancloud.LCUser;
import cn.leancloud.Transformer;
import cn.leancloud.core.PaasClient;
import cn.leancloud.search.LCSearchResponse;
import cn.leancloud.search.LCSearchSortBuilder;
import cn.leancloud.utils.LCUtils;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import io.reactivex.Observable;
import io.reactivex.functions.Function;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class LCSearchQuery<T extends LCObject> {
    private static final LCLogger LOGGER = LogUtil.getLogger(LCSearchQuery.class);
    public static final String AVSEARCH_HIGHTLIGHT = "highlight_avoscloud_";
    public static final String AVSEARCH_APP_URL = "app_url_avoscloud_";
    public static final String AVSEARCH_DEEP_LINK = "deep_link_avoscloud_";
    public static final String DATA_EXTRA_SEARCH_KEY = "com.avos.avoscloud.search.key";
    private String sid;
    private int limit = 100;
    private int skip = 0;
    private String hightlights;
    private static final String URL = "search/select";
    private List<String> fields;
    private String queryString;
    private String titleAttribute;
    private String className;
    private int hits;
    private String order;
    private LCSearchSortBuilder sortBuilder;
    private List<String> include;
    Class<T> clazz;

    public LCSearchSortBuilder getSortBuilder() {
        return this.sortBuilder;
    }

    public void setSortBuilder(LCSearchSortBuilder sortBuilder) {
        this.sortBuilder = sortBuilder;
    }

    public LCSearchQuery() {
        this(null);
    }

    public LCSearchQuery(String queryString) {
        this(queryString, null);
    }

    public LCSearchQuery(String queryString, Class<T> clazz) {
        this.queryString = queryString;
        this.clazz = clazz;
        this.include = new LinkedList<String>();
        this.className = clazz == null ? Transformer.getSubClassName(LCObject.class) : Transformer.getSubClassName(clazz);
    }

    public String getClassName() {
        return this.className;
    }

    public LCSearchQuery order(String order) {
        this.order = order;
        return this;
    }

    public LCSearchQuery orderByAscending(String key) {
        this.order = StringUtil.isEmpty(this.order) ? String.format("%s", key) : String.format("%s,%s", this.order, key);
        return this;
    }

    public LCSearchQuery orderByDescending(String key) {
        this.order = StringUtil.isEmpty(this.order) ? String.format("-%s", key) : String.format("%s,-%s", this.order, key);
        return this;
    }

    public LCSearchQuery addAscendingOrder(String key) {
        if (StringUtil.isEmpty(this.order)) {
            return this.orderByAscending(key);
        }
        this.order = String.format("%s,%s", this.order, key);
        return this;
    }

    public LCSearchQuery addDescendingOrder(String key) {
        if (StringUtil.isEmpty(this.order)) {
            return this.orderByDescending(key);
        }
        this.order = String.format("%s,-%s", this.order, key);
        return this;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getSkip() {
        return this.skip;
    }

    public void setSkip(int skip) {
        this.skip = skip;
    }

    public void setHightLights(String hightlights) {
        this.hightlights = hightlights;
    }

    public String getHightLights() {
        return this.hightlights;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public String getSid() {
        return this.sid;
    }

    public void setTitleAttribute(String titleAttribute) {
        this.titleAttribute = titleAttribute;
    }

    public String getTitleAttribute() {
        return this.titleAttribute;
    }

    public void setQueryString(String query) {
        if (!(this.queryString == null && query == null || this.queryString != null && this.queryString.equals(query))) {
            this.sid = null;
        }
        this.queryString = query;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public int getHits() {
        return this.hits;
    }

    public void include(String key) {
        this.include.add(key);
    }

    private Map<String, String> getParameters(String query) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", query);
        if (!StringUtil.isEmpty(this.sid)) {
            params.put("sid", this.sid);
        }
        if (!StringUtil.isEmpty(this.hightlights)) {
            params.put("highlights", this.hightlights);
        } else {
            params.put("highlights", "*");
        }
        if (this.fields != null && this.fields.size() > 0) {
            params.put("fields", StringUtil.join(",", this.fields));
        }
        if (this.limit > 0) {
            params.put("limit", String.valueOf(this.limit));
        }
        if (this.skip > 0) {
            params.put("skip", String.valueOf(this.skip));
        }
        if (!StringUtil.isEmpty(this.order)) {
            params.put("order", this.order);
        }
        if (this.sortBuilder != null) {
            params.put("sort", LCUtils.jsonStringFromObjectWithNull(this.sortBuilder.getSortFields()));
        }
        if (!this.include.isEmpty()) {
            String value = StringUtil.join(",", this.include);
            params.put("include", value);
        }
        if (!StringUtil.isEmpty(this.className)) {
            params.put("clazz", this.className);
        }
        return params;
    }

    public Observable<List<T>> findInBackground() {
        return this.findInBackground(null);
    }

    public Observable<List<T>> findInBackground(LCUser asAuthenticatedUser) {
        return this.getSearchResult(asAuthenticatedUser, this.getParameters(this.queryString));
    }

    protected Observable<List<T>> getSearchResult(LCUser asAuthenticatedUser, Map<String, String> params) {
        return PaasClient.getStorageClient().search(asAuthenticatedUser, params).map(new Function<LCSearchResponse, List<T>>(){

            public List<T> apply(LCSearchResponse result) throws Exception {
                return LCSearchQuery.this.processContent(result);
            }
        });
    }

    private List<T> processContent(LCSearchResponse resp) throws Exception {
        if (null == resp) {
            return Collections.emptyList();
        }
        this.sid = resp.sid;
        this.hits = resp.hits;
        LinkedList<LCObject> result = new LinkedList<LCObject>();
        for (Map item : resp.results) {
            if (item == null || item.isEmpty()) continue;
            LCObject object = this.clazz == null ? new LCObject(StringUtil.isEmpty(this.className) ? (String)item.get("className") : this.className) : (LCObject)this.clazz.newInstance();
            if (item.containsKey("_highlight")) {
                item.put(AVSEARCH_HIGHTLIGHT, item.get("_highlight"));
                item.remove("_highlight");
            }
            if (item.containsKey("_app_url")) {
                item.put(AVSEARCH_APP_URL, item.get("_app_url"));
                item.remove("_app_url");
            }
            if (item.containsKey("_deeplink")) {
                item.put(AVSEARCH_DEEP_LINK, item.get("_deeplink"));
                item.remove("_deeplink");
            }
            object.resetServerData(item);
            result.add(object);
        }
        return result;
    }
}

