/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.gson;

import cn.leancloud.gson.GsonArray;
import cn.leancloud.gson.GsonWrapper;
import cn.leancloud.json.JSONArray;
import cn.leancloud.json.JSONObject;
import cn.leancloud.json.TypeReference;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class GsonObject
extends JSONObject {
    private JsonObject gsonObject;

    public GsonObject(JsonObject object) {
        this.gsonObject = object;
    }

    public GsonObject(Map<String, Object> map) {
        this.gsonObject = new JsonObject();
        if (null != map) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                this.gsonObject.add(entry.getKey(), GsonWrapper.toJsonElement(entry.getValue()));
            }
        }
    }

    public GsonObject() {
        this.gsonObject = new JsonObject();
    }

    public JsonObject getRawObject() {
        return this.gsonObject;
    }

    @Override
    public int size() {
        return this.gsonObject.size();
    }

    @Override
    public boolean isEmpty() {
        return this.gsonObject.size() <= 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.gsonObject.has((String)key);
    }

    @Override
    public boolean containsValue(Object v) {
        Collection<Object> values = this.values();
        if (null == values) {
            return false;
        }
        for (Object obj : values) {
            if (!obj.equals(v)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object get(Object key) {
        JsonElement element = this.gsonObject.get((String)key);
        return GsonWrapper.toJavaObject(element);
    }

    @Override
    public JSONObject getJSONObject(String key) {
        if (!this.gsonObject.has(key)) {
            return null;
        }
        JsonElement element = this.gsonObject.get(key);
        if (!element.isJsonObject()) {
            return null;
        }
        return new GsonObject(element.getAsJsonObject());
    }

    @Override
    public JSONArray getJSONArray(String key) {
        if (!this.gsonObject.has(key)) {
            return null;
        }
        JsonElement element = this.gsonObject.get(key);
        if (!element.isJsonArray()) {
            return null;
        }
        return new GsonArray(element.getAsJsonArray());
    }

    @Override
    public <T> T getObject(String key, Class<T> clazz) {
        if (!this.gsonObject.has(key)) {
            return null;
        }
        JsonElement element = this.gsonObject.get(key);
        if (element.isJsonNull()) {
            return null;
        }
        return GsonWrapper.toJavaObject(element, clazz);
    }

    @Override
    public <T> T getObject(String key, Type type) {
        try {
            if (type instanceof Class) {
                Class clazz = (Class)type;
                return this.getObject(key, clazz);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public <T> T getObject(String key, TypeReference typeReference) {
        return this.getObject(key, null == typeReference ? null : typeReference.getType());
    }

    @Override
    public Boolean getBoolean(String key) {
        if (!this.gsonObject.has(key)) {
            return false;
        }
        JsonElement element = this.gsonObject.get(key);
        if (!element.isJsonPrimitive()) {
            return false;
        }
        return element.getAsBoolean();
    }

    @Override
    public byte[] getBytes(String key) {
        String ret = this.getString(key);
        if (null == ret) {
            return null;
        }
        return ret.getBytes();
    }

    @Override
    public boolean getBooleanValue(String key) {
        return this.getBoolean(key);
    }

    @Override
    public Byte getByte(String key) {
        if (!this.gsonObject.has(key)) {
            return (byte)0;
        }
        JsonElement element = this.gsonObject.get(key);
        if (!element.isJsonPrimitive()) {
            return (byte)0;
        }
        return element.getAsByte();
    }

    @Override
    public byte getByteValue(String key) {
        return this.getByte(key);
    }

    @Override
    public Short getShort(String key) {
        if (!this.gsonObject.has(key)) {
            return (short)0;
        }
        JsonElement element = this.gsonObject.get(key);
        if (!element.isJsonPrimitive()) {
            return (short)0;
        }
        return element.getAsShort();
    }

    @Override
    public short getShortValue(String key) {
        return this.getShort(key);
    }

    @Override
    public Integer getInteger(String key) {
        if (!this.gsonObject.has(key)) {
            return 0;
        }
        JsonElement element = this.gsonObject.get(key);
        if (!element.isJsonPrimitive()) {
            return 0;
        }
        return element.getAsInt();
    }

    @Override
    public int getIntValue(String key) {
        return this.getInteger(key);
    }

    @Override
    public Long getLong(String key) {
        if (!this.gsonObject.has(key)) {
            return 0L;
        }
        JsonElement element = this.gsonObject.get(key);
        if (!element.isJsonPrimitive()) {
            return 0L;
        }
        return element.getAsLong();
    }

    @Override
    public long getLongValue(String key) {
        return this.getLong(key);
    }

    @Override
    public Float getFloat(String key) {
        if (!this.gsonObject.has(key)) {
            return Float.valueOf(0.0f);
        }
        JsonElement element = this.gsonObject.get(key);
        if (!element.isJsonPrimitive()) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf(element.getAsFloat());
    }

    @Override
    public float getFloatValue(String key) {
        return this.getFloat(key).floatValue();
    }

    @Override
    public Double getDouble(String key) {
        if (!this.gsonObject.has(key)) {
            return 0.0;
        }
        JsonElement element = this.gsonObject.get(key);
        if (!element.isJsonPrimitive()) {
            return 0.0;
        }
        return element.getAsDouble();
    }

    @Override
    public double getDoubleValue(String key) {
        return this.getDouble(key);
    }

    @Override
    public BigDecimal getBigDecimal(String key) {
        if (!this.gsonObject.has(key)) {
            return BigDecimal.ZERO;
        }
        JsonElement element = this.gsonObject.get(key);
        if (!element.isJsonPrimitive()) {
            return BigDecimal.ZERO;
        }
        return element.getAsBigDecimal();
    }

    @Override
    public BigInteger getBigInteger(String key) {
        if (!this.gsonObject.has(key)) {
            return BigInteger.ZERO;
        }
        JsonElement element = this.gsonObject.get(key);
        if (!element.isJsonPrimitive()) {
            return BigInteger.ZERO;
        }
        return element.getAsBigInteger();
    }

    @Override
    public String getString(String key) {
        if (!this.gsonObject.has(key)) {
            return null;
        }
        JsonElement element = this.gsonObject.get(key);
        if (!element.isJsonPrimitive()) {
            return null;
        }
        return element.getAsString();
    }

    @Override
    public java.util.Date getDate(String key) {
        Object val = this.getObject(key, Object.class);
        return GsonWrapper.castToDate(val);
    }

    @Override
    public Date getSqlDate(String key) {
        throw new UnsupportedOperationException("getSqlDate is not supported.");
    }

    @Override
    public Timestamp getTimestamp(String key) {
        throw new UnsupportedOperationException("getTimestamp is not supported.");
    }

    @Override
    public Object put(String key, Object value) {
        if (value instanceof GsonObject) {
            this.gsonObject.add(key, (JsonElement)((GsonObject)value).getRawObject());
        } else {
            JsonElement element = GsonWrapper.toJsonElement(value);
            this.gsonObject.add(key, element);
        }
        return value;
    }

    @Override
    public JSONObject fluentPut(String key, Object value) {
        JsonElement ele = GsonWrapper.toJsonElement(value);
        this.gsonObject.add(key, ele);
        return this;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        for (Map.Entry<? extends String, ? extends Object> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public JSONObject fluentPutAll(Map<? extends String, ? extends Object> m) {
        this.putAll(m);
        return this;
    }

    @Override
    public void clear() {
        for (String key : this.gsonObject.keySet()) {
            this.remove(key);
        }
    }

    @Override
    public JSONObject fluentClear() {
        this.clear();
        return this;
    }

    @Override
    public Object remove(Object key) {
        return this.gsonObject.remove((String)key);
    }

    @Override
    public Set<String> keySet() {
        return this.gsonObject.keySet();
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> result = new ArrayList<Object>(this.size());
        for (Map.Entry<String, Object> entry : this.entrySet()) {
            result.add(entry.getValue());
        }
        return result;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        Set objects = this.gsonObject.entrySet();
        HashSet<Map.Entry<String, Object>> result = new HashSet<Map.Entry<String, Object>>();
        for (Map.Entry entry : objects) {
            result.add(new InnerEntry((String)entry.getKey(), (JsonElement)entry.getValue()));
        }
        return result;
    }

    public Object clone() {
        return new GsonObject(this.gsonObject.deepCopy());
    }

    @Override
    public Map<String, Object> getInnerMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(this.gsonObject.size());
        Set objects = this.gsonObject.entrySet();
        for (Map.Entry entry : objects) {
            map.put((String)entry.getKey(), GsonWrapper.toJavaObject((JsonElement)entry.getValue()));
        }
        return map;
    }

    @Override
    public <T> T toJavaObject(Class<T> clazz) {
        return GsonWrapper.toJavaObject((JsonElement)this.gsonObject, clazz);
    }

    @Override
    public int hashCode() {
        return this.gsonObject.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GsonObject)) {
            return false;
        }
        return this.gsonObject.equals((Object)((GsonObject)obj).gsonObject);
    }

    @Override
    public String toJSONString() {
        return this.gsonObject.toString();
    }

    static class InnerEntry
    implements Map.Entry<String, Object> {
        private String key;
        private Object value;

        InnerEntry(String key, JsonElement value) {
            this.key = key;
            this.value = GsonWrapper.toJavaObject(value);
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object value) {
            this.value = value;
            return value;
        }
    }
}

