/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.core;

import cn.leancloud.LCFile;
import cn.leancloud.LCFriendship;
import cn.leancloud.LCFriendshipRequest;
import cn.leancloud.LCInstallation;
import cn.leancloud.LCLogger;
import cn.leancloud.LCObject;
import cn.leancloud.LCStatus;
import cn.leancloud.LCUser;
import cn.leancloud.core.AppConfiguration;
import cn.leancloud.core.AppRouter;
import cn.leancloud.core.GeneralRequestSignature;
import cn.leancloud.core.LeanService;
import cn.leancloud.core.PaasClient;
import cn.leancloud.types.LCDate;
import cn.leancloud.utils.StringUtil;
import io.reactivex.Observable;

public class LeanCloud {
    private static REGION defaultRegion = REGION.NorthChina;
    private static String applicationId = "";
    private static String applicationKey = "";
    private static String hookKey = "";
    private static volatile LCLogger.Level logLevel = LCLogger.Level.INFO;
    static boolean printAllHeaders = false;
    private static boolean enableCircularReferenceDetect = false;

    public static void setRegion(REGION region) {
        defaultRegion = region;
    }

    public static REGION getRegion() {
        return defaultRegion;
    }

    public static void enablePrintAllHeaders4Debug(boolean flag) {
        printAllHeaders = flag;
        if (flag) {
            System.out.println("======= WARNING: you are going to dump all details for a REST request, it is very risky for security!!! please ONLY USE IN absolutely trusted environment!!!");
            System.out.println("( \u2022\u0300\u1d17\u2022\u0301 )\u0648( \u2022\u0300\u1d17\u2022\u0301 )\u0648( \u2022\u0300\u1d17\u2022\u0301 )\u0648( \u2022\u0300\u1d17\u2022\u0301 )\u0648( \u2022\u0300\u1d17\u2022\u0301 )\u0648( \u2022\u0300\u1d17\u2022\u0301 )\u0648( \u2022\u0300\u1d17\u2022\u0301 )\u0648( \u2022\u0300\u1d17\u2022\u0301 )\u0648( \u2022\u0300\u1d17\u2022\u0301 )\u0648( \u2022\u0300\u1d17\u2022\u0301 )\u0648");
        }
    }

    public static void setLogLevel(LCLogger.Level level) {
        logLevel = level;
    }

    public static LCLogger.Level getLogLevel() {
        return logLevel;
    }

    public static boolean isDebugEnable() {
        return logLevel.intLevel() >= LCLogger.Level.DEBUG.intLevel();
    }

    public static void setCircularReferenceDetectEnable(boolean enable) {
        enableCircularReferenceDetect = enable;
    }

    public static boolean isEnableCircularReferenceDetect() {
        return enableCircularReferenceDetect;
    }

    public static void initialize(String appId, String appKey) {
        LCObject.registerSubclass(LCStatus.class);
        LCObject.registerSubclass(LCUser.class);
        LCObject.registerSubclass(LCFile.class);
        LCObject.registerSubclass(LCInstallation.class);
        LCObject.registerSubclass(LCFriendshipRequest.class);
        LCObject.registerSubclass(LCFriendship.class);
        applicationId = appId;
        applicationKey = appKey;
        PaasClient.initializeGlobalClient();
    }

    public static void initialize(String appId, String appKey, String serverUrl) {
        LeanCloud.setServerURLs(serverUrl);
        LeanCloud.initialize(appId, appKey);
    }

    public static Observable<LCDate> getServerDateInBackground() {
        return PaasClient.getStorageClient().getServerTime();
    }

    public static void setMasterKey(String masterKey) {
        GeneralRequestSignature.setMasterKey(masterKey);
    }

    public static void setServer(LeanService service, String host) {
        if (StringUtil.isEmpty(host)) {
            return;
        }
        if (!host.toLowerCase().startsWith("http")) {
            host = "https://" + host;
        }
        AppRouter appRouter = AppRouter.getInstance();
        appRouter.freezeEndpoint(service, host);
    }

    protected static void setServerURLs(String host) {
        LeanCloud.setServer(LeanService.API, host);
        LeanCloud.setServer(LeanService.RTM, host);
        LeanCloud.setServer(LeanService.ENGINE, host);
        LeanCloud.setServer(LeanService.PUSH, host);
        LeanCloud.setServer(LeanService.STATS, host);
    }

    @Deprecated
    public static void setLastModifyEnabled(boolean val) {
        AppConfiguration.setLastModifyEnabled(val);
    }

    @Deprecated
    public static boolean isLastModifyEnabled() {
        return AppConfiguration.isLastModifyEnabled();
    }

    @Deprecated
    public static void setNetworkTimeout(int seconds) {
        AppConfiguration.setNetworkTimeout(seconds);
    }

    @Deprecated
    public static int getNetworkTimeout() {
        return AppConfiguration.getNetworkTimeout();
    }

    public static void setAutoMergeOperationDataWhenSave(boolean flag) {
        AppConfiguration.setAutoMergeOperationDataWhenSave(flag);
    }

    static void setAlwaysFetchWhenSave(boolean flag) {
    }

    public static String getApplicationId() {
        return applicationId;
    }

    public static String getSimplifiedAppId() {
        if (StringUtil.isEmpty(applicationId)) {
            return "";
        }
        return applicationId.substring(0, 8);
    }

    public static String getApplicationKey() {
        return applicationKey;
    }

    public static String getHookKey() {
        return hookKey;
    }

    public static void setHookKey(String key) {
        hookKey = key;
    }

    public static enum REGION {
        EastChina,
        NorthChina,
        NorthAmerica;

    }
}

