/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.LCFile;
import cn.leancloud.LCFriendship;
import cn.leancloud.LCFriendshipRequest;
import cn.leancloud.LCInstallation;
import cn.leancloud.LCLogger;
import cn.leancloud.LCObject;
import cn.leancloud.LCRole;
import cn.leancloud.LCStatus;
import cn.leancloud.LCUser;
import cn.leancloud.annotation.LCClassName;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class Transformer {
    private static LCLogger logger = LogUtil.getLogger(Transformer.class);
    private static Pattern classnamePattern = Pattern.compile("^[a-zA-Z_][a-zA-Z_0-9]*$");
    private static final Map<String, Class<? extends LCObject>> subClassesMAP = new HashMap<String, Class<? extends LCObject>>();
    private static final Map<Class<? extends LCObject>, String> subClassesReverseMAP = new HashMap<Class<? extends LCObject>, String>();

    static Class<? extends LCObject> getSubClass(String className) {
        return subClassesMAP.get(className);
    }

    public static String getSubClassName(Class clazz) {
        if (LCUser.class.isAssignableFrom(clazz)) {
            return "_User";
        }
        if (LCRole.class.isAssignableFrom(clazz)) {
            return "_Role";
        }
        if (LCStatus.class.isAssignableFrom(clazz)) {
            return "_Status";
        }
        if (LCFile.class.isAssignableFrom(clazz)) {
            return "_File";
        }
        if (LCFriendship.class.isAssignableFrom(clazz)) {
            return "_Followee";
        }
        if (LCFriendshipRequest.class.isAssignableFrom(clazz)) {
            return "_FriendshipRequest";
        }
        return subClassesReverseMAP.get(clazz);
    }

    public static <T extends LCObject> void registerClass(Class<T> clazz) {
        LCClassName LCClassName2 = clazz.getAnnotation(LCClassName.class);
        if (LCClassName2 == null) {
            throw new IllegalArgumentException("The class is not annotated by @AVClassName");
        }
        String className = LCClassName2.value();
        Transformer.checkClassName(className);
        subClassesMAP.put(className, clazz);
        subClassesReverseMAP.put(clazz, className);
    }

    public static <T extends LCObject> T transform(LCObject rawObj, String className) {
        if (null == rawObj) {
            return null;
        }
        LCObject result = Transformer.objectFromClassName(className);
        result.resetByRawData(rawObj);
        return (T)result;
    }

    public static <T extends LCObject> T transform(LCObject rawObj, Class<T> clazz) {
        if (null == rawObj) {
            return null;
        }
        LCObject result = null;
        if (subClassesReverseMAP.containsKey(clazz)) {
            try {
                result = (LCObject)clazz.newInstance();
            }
            catch (Exception ex) {
                logger.w("newInstance failed. cause: " + ex.getMessage());
                result = new LCObject(clazz.getSimpleName());
            }
        } else {
            result = LCUser.class.isAssignableFrom(clazz) ? new LCUser() : (LCRole.class.isAssignableFrom(clazz) ? new LCRole() : (LCStatus.class.isAssignableFrom(clazz) ? new LCStatus() : (LCFile.class.isAssignableFrom(clazz) ? new LCFile() : (LCFriendshipRequest.class.isAssignableFrom(clazz) ? new LCFriendshipRequest() : (LCFriendship.class.isAssignableFrom(clazz) ? new LCFriendship() : new LCObject(clazz.getSimpleName()))))));
        }
        result.resetByRawData(rawObj);
        return (T)result;
    }

    public static void checkClassName(String className) {
        if (StringUtil.isEmpty(className)) {
            throw new IllegalArgumentException("Blank class name");
        }
        if (!classnamePattern.matcher(className).matches()) {
            throw new IllegalArgumentException("Invalid class name");
        }
    }

    public static LCObject objectFromClassName(String className) {
        LCObject result = null;
        if ("_User".equals(className)) {
            result = new LCUser();
        } else if ("_Status".equals(className)) {
            result = new LCStatus();
        } else if ("_Role".equals(className)) {
            result = new LCRole();
        } else if ("_File".equals(className)) {
            result = new LCFile();
        } else if ("_Installation".equals(className)) {
            result = new LCInstallation();
        } else if ("_FriendshipRequest".equals(className)) {
            result = new LCFriendshipRequest();
        } else if ("_Followee".equals(className)) {
            result = new LCFriendship();
        } else if (subClassesMAP.containsKey(className)) {
            try {
                result = subClassesMAP.get(className).newInstance();
            }
            catch (Exception ex) {
                logger.w("failed to create subClass: " + className, ex);
                result = new LCObject(className);
            }
        } else {
            result = new LCObject(className);
        }
        return result;
    }

    private Transformer() {
    }
}

