/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.LCException;
import cn.leancloud.LCFriendship;
import cn.leancloud.LCFriendshipRequest;
import cn.leancloud.LCInstallation;
import cn.leancloud.LCObject;
import cn.leancloud.LCQuery;
import cn.leancloud.LCRole;
import cn.leancloud.LCSaveOption;
import cn.leancloud.Transformer;
import cn.leancloud.annotation.LCClassName;
import cn.leancloud.cache.PersistenceUtil;
import cn.leancloud.callback.FollowersAndFolloweesCallback;
import cn.leancloud.callback.LCCallback;
import cn.leancloud.core.AppConfiguration;
import cn.leancloud.core.PaasClient;
import cn.leancloud.json.JSON;
import cn.leancloud.json.JSONObject;
import cn.leancloud.ops.Utils;
import cn.leancloud.query.QueryConditions;
import cn.leancloud.sms.LCSMS;
import cn.leancloud.sms.LCSMSOption;
import cn.leancloud.types.LCNull;
import cn.leancloud.utils.ErrorUtils;
import cn.leancloud.utils.LCUtils;
import cn.leancloud.utils.StringUtil;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Function;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@LCClassName(value="_User")
public class LCUser
extends LCObject {
    public static final String ATTR_USERNAME = "username";
    private static final String ATTR_PASSWORD = "password";
    public static final String ATTR_EMAIL = "email";
    public static final String ATTR_MOBILEPHONE = "mobilePhoneNumber";
    private static final String ATTR_SMSCODE = "smsCode";
    private static final String ATTR_MOBILEPHONE_VERIFIED = "mobilePhoneVerified";
    public static final String ATTR_SESSION_TOKEN = "sessionToken";
    private static final String PARAM_ATTR_FRIENDSHIP = "friendship";
    private static final String AUTHDATA_TAG = "authData";
    private static final String AUTHDATA_PLATFORM_ANONYMOUS = "anonymous";
    private static final String AUTHDATA_ATTR_UNIONID = "unionid";
    private static final String AUTHDATA_ATTR_UNIONID_PLATFORM = "platform";
    private static final String AUTHDATA_ATTR_MAIN_ACCOUNT = "main_account";
    private static final String ILLEGALARGUMENT_MSG_FORMAT = "illegal parameter. %s must not null/empty.";
    public static final String CLASS_NAME = "_User";
    public static final String FOLLOWER_TAG = "follower";
    public static final String FOLLOWEE_TAG = "followee";
    private static Class<? extends LCUser> subClazz = null;
    private static transient boolean enableAutomatic = false;

    public LCUser() {
        super(CLASS_NAME);
    }

    public static LCUser currentUser() {
        return LCUser.getCurrentUser();
    }

    public String getEmail() {
        return (String)this.get(ATTR_EMAIL);
    }

    public void setEmail(String email) {
        this.put(ATTR_EMAIL, email);
    }

    public String getUsername() {
        return (String)this.get(ATTR_USERNAME);
    }

    public void setUsername(String name) {
        this.put(ATTR_USERNAME, name);
    }

    public String getPassword() {
        return (String)this.get(ATTR_PASSWORD);
    }

    public void setPassword(String password) {
        this.put(ATTR_PASSWORD, password);
    }

    public String getMobilePhoneNumber() {
        return (String)this.get(ATTR_MOBILEPHONE);
    }

    public void setMobilePhoneNumber(String mobile) {
        this.put(ATTR_MOBILEPHONE, mobile);
    }

    public boolean isMobilePhoneVerified() {
        return this.getBoolean(ATTR_MOBILEPHONE_VERIFIED);
    }

    public String getSessionToken() {
        return (String)this.get(ATTR_SESSION_TOKEN);
    }

    public void internalChangeSessionToken(String token) {
        this.getServerData().put(ATTR_SESSION_TOKEN, token);
    }

    public boolean isAuthenticated() {
        String sessionToken = this.getSessionToken();
        return !StringUtil.isEmpty(sessionToken);
    }

    private void updateCurrentUserCache() {
        String sessionToken = this.getSessionToken();
        LCUser currentUser = LCUser.currentUser();
        if (null != currentUser && !StringUtil.isEmpty(currentUser.getObjectId()) && currentUser.getObjectId().equals(this.getObjectId()) && !StringUtil.isEmpty(sessionToken)) {
            LCUser.changeCurrentUser(this, true);
        }
    }

    @Override
    protected void onSaveSuccess() {
        super.onSaveSuccess();
        this.updateCurrentUserCache();
    }

    @Override
    protected void onSaveFailure() {
        super.onSaveFailure();
    }

    @Override
    protected void onDataSynchronized() {
        super.onDataSynchronized();
        this.updateCurrentUserCache();
    }

    public boolean isAnonymous() {
        JSONObject existedAuthData = this.getJSONObject(AUTHDATA_TAG);
        return existedAuthData != null && existedAuthData.size() == 1 && existedAuthData.containsKey(AUTHDATA_PLATFORM_ANONYMOUS);
    }

    public void signUp() {
        this.signUpInBackground().blockingSubscribe();
    }

    public Observable<LCUser> signUpInBackground() {
        JSONObject paramData = this.generateChangedParam();
        logger.d("signup param: " + paramData.toJSONString());
        return PaasClient.getStorageClient().signUp(paramData).map((Function)new Function<LCUser, LCUser>(){

            public LCUser apply(LCUser avUser) throws Exception {
                LCUser.this.mergeRawData(avUser, true);
                LCUser.this.onSaveSuccess();
                return LCUser.this;
            }
        });
    }

    public static LCUser signUpOrLoginByMobilePhone(String mobilePhoneNumber, String smsCode) {
        return LCUser.signUpOrLoginByMobilePhone(mobilePhoneNumber, smsCode, LCUser.internalUserClazz());
    }

    public static <T extends LCUser> T signUpOrLoginByMobilePhone(String mobilePhoneNumber, String smsCode, Class<T> clazz) {
        return (T)((LCUser)LCUser.signUpOrLoginByMobilePhoneInBackground(mobilePhoneNumber, smsCode, clazz).blockingSingle());
    }

    public static Observable<? extends LCUser> signUpOrLoginByMobilePhoneInBackground(String mobilePhoneNumber, String smsCode) {
        return LCUser.signUpOrLoginByMobilePhoneInBackground(mobilePhoneNumber, smsCode, LCUser.internalUserClazz());
    }

    public static <T extends LCUser> Observable<T> signUpOrLoginByMobilePhoneInBackground(String mobilePhoneNumber, String smsCode, Class<T> clazz) {
        if (StringUtil.isEmpty(mobilePhoneNumber)) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, ATTR_MOBILEPHONE)));
        }
        if (StringUtil.isEmpty(smsCode)) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, ATTR_SMSCODE)));
        }
        if (null == clazz) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, "clazz")));
        }
        Map<String, Object> params = LCUser.createUserMap(null, null, null, mobilePhoneNumber, smsCode);
        JSONObject data = JSONObject.Builder.create(params);
        return PaasClient.getStorageClient().signUpOrLoginByMobilephone(data, clazz);
    }

    public static Observable<? extends LCUser> logIn(String username, String password) {
        return LCUser.logIn(username, password, LCUser.internalUserClazz());
    }

    public static Observable<? extends LCUser> logInAnonymously() {
        String anonymousId = LCInstallation.getCurrentInstallation().getInstallationId();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("id", anonymousId);
        return LCUser.loginWithAuthData(param, AUTHDATA_PLATFORM_ANONYMOUS);
    }

    public static <T extends LCUser> Observable<T> logIn(String username, String password, Class<T> clazz) {
        Map<String, Object> params = LCUser.createUserMap(username, password, null, null, null);
        JSONObject data = JSONObject.Builder.create(params);
        return PaasClient.getStorageClient().logIn(data, clazz);
    }

    public static Observable<? extends LCUser> loginByMobilePhoneNumber(String mobile, String password) {
        return LCUser.loginByMobilePhoneNumber(mobile, password, LCUser.internalUserClazz());
    }

    public static Observable<? extends LCUser> loginByEmail(String email, String password) {
        HashMap<String, Object> params = LCUser.createUserMapAFAP(null, password, email, null, null);
        return PaasClient.getStorageClient().logIn(JSONObject.Builder.create(params), LCUser.internalUserClazz());
    }

    public static <T extends LCUser> Observable<T> loginByMobilePhoneNumber(String mobile, String password, Class<T> clazz) {
        Map<String, Object> params = LCUser.createUserMap(null, password, null, mobile, null);
        JSONObject data = JSONObject.Builder.create(params);
        return PaasClient.getStorageClient().logIn(data, clazz);
    }

    public static Observable<? extends LCUser> loginBySMSCode(String mobile, String smsCode) {
        return LCUser.loginBySMSCode(mobile, smsCode, LCUser.internalUserClazz());
    }

    public static <T extends LCUser> Observable<T> loginBySMSCode(String mobile, String smsCode, Class<T> clazz) {
        Map<String, Object> params = LCUser.createUserMap(null, null, null, mobile, smsCode);
        JSONObject data = JSONObject.Builder.create(params);
        return PaasClient.getStorageClient().logIn(data, clazz);
    }

    private static Map<String, Object> createUserMap(String username, String password, String email, String phoneNumber, String smsCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtil.isEmpty(username) && StringUtil.isEmpty(phoneNumber)) {
            throw new IllegalArgumentException("Blank username and blank mobile phone number");
        }
        if (!StringUtil.isEmpty(username)) {
            map.put(ATTR_USERNAME, username);
        }
        if (!StringUtil.isEmpty(password)) {
            map.put(ATTR_PASSWORD, password);
        }
        if (!StringUtil.isEmpty(email)) {
            map.put(ATTR_EMAIL, email);
        }
        if (!StringUtil.isEmpty(phoneNumber)) {
            map.put(ATTR_MOBILEPHONE, phoneNumber);
        }
        if (!StringUtil.isEmpty(smsCode)) {
            map.put(ATTR_SMSCODE, smsCode);
        }
        return map;
    }

    private static HashMap<String, Object> createUserMapAFAP(String username, String password, String email, String phoneNumber, String smsCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!StringUtil.isEmpty(username)) {
            map.put(ATTR_USERNAME, username);
        }
        if (!StringUtil.isEmpty(password)) {
            map.put(ATTR_PASSWORD, password);
        }
        if (!StringUtil.isEmpty(email)) {
            map.put(ATTR_EMAIL, email);
        }
        if (!StringUtil.isEmpty(phoneNumber)) {
            map.put(ATTR_MOBILEPHONE, phoneNumber);
        }
        if (!StringUtil.isEmpty(smsCode)) {
            map.put(ATTR_SMSCODE, smsCode);
        }
        return map;
    }

    public static Observable<? extends LCUser> loginWithAuthData(Map<String, Object> authData, String platform) {
        return LCUser.loginWithAuthData(LCUser.internalUserClazz(), authData, platform);
    }

    public static Observable<? extends LCUser> loginWithAuthData(Map<String, Object> authData, String platform, String unionId, String unionIdPlatform, boolean asMainAccount) {
        return LCUser.loginWithAuthData(LCUser.internalUserClazz(), authData, platform, unionId, unionIdPlatform, asMainAccount);
    }

    public static <T extends LCUser> Observable<T> loginWithAuthData(final Class<T> clazz, Map<String, Object> authData, String platform) {
        if (null == clazz) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, "clazz")));
        }
        if (null == authData || authData.isEmpty()) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, AUTHDATA_TAG)));
        }
        if (StringUtil.isEmpty(platform)) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, AUTHDATA_ATTR_UNIONID_PLATFORM)));
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        HashMap<String, Map<String, Object>> authMap = new HashMap<String, Map<String, Object>>();
        authMap.put(platform, authData);
        data.put(AUTHDATA_TAG, authMap);
        JSONObject param = JSONObject.Builder.create(data);
        return PaasClient.getStorageClient().signUp(param).map(new Function<LCUser, T>(){

            public T apply(LCUser avUser) throws Exception {
                LCUser result = (LCUser)Transformer.transform((LCObject)avUser, clazz);
                LCUser.changeCurrentUser(result, true);
                return result;
            }
        });
    }

    public static <T extends LCUser> Observable<T> loginWithAuthData(Class<T> clazz, Map<String, Object> authData, String platform, String unionId, String unionIdPlatform, boolean asMainAccount) {
        if (StringUtil.isEmpty(unionId)) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, "unionId")));
        }
        if (StringUtil.isEmpty(unionIdPlatform)) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, "unionIdPlatform")));
        }
        if (null == authData || authData.isEmpty()) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, AUTHDATA_TAG)));
        }
        authData.put(AUTHDATA_ATTR_UNIONID, unionId);
        authData.put(AUTHDATA_ATTR_UNIONID_PLATFORM, unionIdPlatform);
        if (asMainAccount) {
            authData.put(AUTHDATA_ATTR_MAIN_ACCOUNT, asMainAccount);
        }
        return LCUser.loginWithAuthData(clazz, authData, platform);
    }

    public Observable<LCUser> loginWithAuthData(Map<String, Object> authData, String platform, boolean failOnNotExist) {
        if (null == authData || authData.isEmpty()) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, AUTHDATA_TAG)));
        }
        if (StringUtil.isEmpty(platform)) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, AUTHDATA_ATTR_UNIONID_PLATFORM)));
        }
        HashMap<String, Object> data = LCUser.createUserMapAFAP(this.getUsername(), null, this.getEmail(), this.getMobilePhoneNumber(), null);
        HashMap<String, Map<String, Object>> authMap = new HashMap<String, Map<String, Object>>();
        authMap.put(platform, authData);
        data.put(AUTHDATA_TAG, authMap);
        JSONObject param = JSONObject.Builder.create(data);
        return PaasClient.getStorageClient().signUpWithFlag(param, failOnNotExist).map((Function)new Function<LCUser, LCUser>(){

            public LCUser apply(LCUser avUser) throws Exception {
                LCUser.this.resetByRawData(avUser);
                LCUser.changeCurrentUser(LCUser.this, true);
                return LCUser.this;
            }
        });
    }

    public Observable<LCUser> loginWithAuthData(Map<String, Object> authData, String platform, String unionId, String unionIdPlatform, boolean asMainAccount, boolean failOnNotExist) {
        if (null == authData || authData.isEmpty()) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, AUTHDATA_TAG)));
        }
        if (StringUtil.isEmpty(unionId)) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, "unionId")));
        }
        if (StringUtil.isEmpty(unionIdPlatform)) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, "unionIdPlatform")));
        }
        authData.put(AUTHDATA_ATTR_UNIONID, unionId);
        authData.put(AUTHDATA_ATTR_UNIONID_PLATFORM, unionIdPlatform);
        if (asMainAccount) {
            authData.put(AUTHDATA_ATTR_MAIN_ACCOUNT, asMainAccount);
        }
        return this.loginWithAuthData(authData, platform, failOnNotExist);
    }

    public Observable<LCUser> associateWithAuthData(Map<String, Object> authData, String platform) {
        if (null == authData || authData.isEmpty()) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, AUTHDATA_TAG)));
        }
        if (StringUtil.isEmpty(platform)) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, AUTHDATA_ATTR_UNIONID_PLATFORM)));
        }
        HashMap<String, Map<String, Object>> authDataAttr = new HashMap<String, Map<String, Object>>();
        authDataAttr.put(platform, authData);
        Object existedAuthData = this.get(AUTHDATA_TAG);
        if (existedAuthData instanceof Map) {
            authDataAttr.putAll((Map)existedAuthData);
        }
        this.put(AUTHDATA_TAG, authDataAttr);
        return this.saveInBackground(new LCSaveOption().setFetchWhenSave(true));
    }

    public Observable<LCUser> associateWithAuthData(Map<String, Object> authData, String platform, String unionId, String unionIdPlatform, boolean asMainAccount) {
        if (null == authData || authData.isEmpty()) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, AUTHDATA_TAG)));
        }
        if (StringUtil.isEmpty(unionId)) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, "unionId")));
        }
        if (StringUtil.isEmpty(unionIdPlatform)) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, "unionIdPlatform")));
        }
        authData.put(AUTHDATA_ATTR_UNIONID, unionId);
        authData.put(AUTHDATA_ATTR_UNIONID_PLATFORM, unionIdPlatform);
        if (asMainAccount) {
            authData.put(AUTHDATA_ATTR_MAIN_ACCOUNT, true);
        }
        return this.associateWithAuthData(authData, platform);
    }

    public Observable<LCUser> dissociateWithAuthData(final String platform) {
        if (StringUtil.isEmpty(platform)) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, AUTHDATA_ATTR_UNIONID_PLATFORM)));
        }
        String objectId = this.getObjectId();
        if (StringUtil.isEmpty(objectId) || !this.isAuthenticated()) {
            return Observable.error((Throwable)new LCException(206, "the user object missing a valid session"));
        }
        this.remove("authData." + platform);
        return this.saveInBackground().map((Function)new Function<LCObject, LCUser>(){

            public LCUser apply(@NonNull LCObject var1) throws Exception {
                Map authData = (Map)LCUser.this.get(LCUser.AUTHDATA_TAG);
                if (authData != null) {
                    authData.remove(platform);
                }
                return LCUser.this;
            }
        });
    }

    public Observable<Boolean> checkAuthenticatedInBackground() {
        String sessionToken = this.getSessionToken();
        if (StringUtil.isEmpty(sessionToken)) {
            logger.d("sessionToken is not existed.");
            return Observable.just((Object)false);
        }
        return PaasClient.getStorageClient().checkAuthenticated(sessionToken);
    }

    public Observable<Boolean> refreshSessionTokenInBackground() {
        return PaasClient.getStorageClient().refreshSessionToken(this);
    }

    public static LCUser becomeWithSessionToken(String sessionToken) {
        return LCUser.becomeWithSessionToken(sessionToken, false);
    }

    public static LCUser becomeWithSessionToken(String sessionToken, boolean saveToCurrentUser) {
        LCUser usr = (LCUser)LCUser.becomeWithSessionTokenInBackground(sessionToken, saveToCurrentUser).blockingFirst();
        return usr;
    }

    public static Observable<? extends LCUser> becomeWithSessionTokenInBackground(String sessionToken) {
        return LCUser.becomeWithSessionTokenInBackground(sessionToken, false);
    }

    public static Observable<? extends LCUser> becomeWithSessionTokenInBackground(String sessionToken, boolean saveToCurrentUser) {
        return LCUser.becomeWithSessionTokenInBackground(sessionToken, saveToCurrentUser, LCUser.internalUserClazz());
    }

    public static <T extends LCUser> T becomeWithSessionToken(String sessionToken, Class<T> clazz) {
        return LCUser.becomeWithSessionToken(sessionToken, false, clazz);
    }

    public static <T extends LCUser> T becomeWithSessionToken(String sessionToken, boolean saveToCurrentUser, Class<T> clazz) {
        LCUser result = (LCUser)LCUser.becomeWithSessionTokenInBackground(sessionToken, saveToCurrentUser, clazz).blockingFirst();
        return (T)result;
    }

    public static <T extends LCUser> Observable<T> becomeWithSessionTokenInBackground(String sessionToken, Class<T> clazz) {
        return LCUser.becomeWithSessionTokenInBackground(sessionToken, false, clazz);
    }

    public static <T extends LCUser> Observable<T> becomeWithSessionTokenInBackground(String sessionToken, final boolean saveToCurrentUser, Class<T> clazz) {
        return PaasClient.getStorageClient().createUserBySession(sessionToken, clazz).map(new Function<T, T>(){

            public T apply(T result) throws Exception {
                if (saveToCurrentUser) {
                    LCUser.changeCurrentUser(result, true);
                }
                return result;
            }
        });
    }

    public static void logOut() {
        LCUser.changeCurrentUser(null, true);
    }

    public static <T extends LCUser> LCQuery<T> getUserQuery(Class<T> clazz) {
        return new LCQuery<T>(CLASS_NAME, clazz);
    }

    public static LCQuery<LCUser> getQuery() {
        return LCUser.getQuery(LCUser.class);
    }

    public Observable<List<LCRole>> getRolesInBackground() {
        LCQuery roleQuery = new LCQuery("_Role");
        roleQuery.whereEqualTo("users", this);
        return roleQuery.findInBackground();
    }

    public static void enableAutomaticUser() {
        enableAutomatic = true;
    }

    public static boolean isEnableAutomatic() {
        return enableAutomatic;
    }

    public static void disableAutomaticUser() {
        enableAutomatic = false;
    }

    private static File currentUserArchivePath() {
        return new File(AppConfiguration.getDocumentDir() + "/currentUser");
    }

    private static boolean userArchiveExist() {
        return LCUser.currentUserArchivePath().exists();
    }

    public static synchronized void changeCurrentUser(LCUser newUser, boolean save) {
        if (AppConfiguration.isIncognitoMode()) {
            return;
        }
        if (null != newUser) {
            newUser.removeOperationForKey(ATTR_PASSWORD);
        }
        File currentUserArchivePath = LCUser.currentUserArchivePath();
        if (null != newUser && save) {
            String jsonString = newUser.toJSONString();
            logger.d(jsonString);
            PersistenceUtil.sharedInstance().saveContentToFile(jsonString, currentUserArchivePath);
        } else if (save) {
            PersistenceUtil.sharedInstance().removeLock(currentUserArchivePath.getAbsolutePath());
            boolean deleteRst = currentUserArchivePath.delete();
            if (!deleteRst) {
                logger.w("failed to delete currentUser cache file.");
            }
        }
        PaasClient.getStorageClient().setCurrentUser(newUser);
    }

    public static LCUser getCurrentUser() {
        return LCUser.getCurrentUser(LCUser.internalUserClazz());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static <T extends LCUser> T getCurrentUser(Class<T> userClass) {
        if (AppConfiguration.isIncognitoMode()) {
            return null;
        }
        LCUser user = PaasClient.getStorageClient().getCurrentUser();
        if (null != user && userClass.isAssignableFrom(user.getClass())) {
            return (T)user;
        }
        if (LCUser.userArchiveExist()) {
            File currentUserArchivePath = LCUser.currentUserArchivePath();
            Class<LCUser> clazz = LCUser.class;
            // MONITORENTER : cn.leancloud.LCUser.class
            String jsonString = PersistenceUtil.sharedInstance().readContentFromFile(currentUserArchivePath);
            if (!StringUtil.isEmpty(jsonString)) {
                if (jsonString.indexOf("@type") >= 0 || jsonString.indexOf("_version") >= 0) {
                    try {
                        user = (LCUser)LCObject.parseLCObject(jsonString);
                        PaasClient.getStorageClient().setCurrentUser(user);
                    }
                    catch (Exception ex) {
                        logger.w("failed to deserialize AVUser instance.", ex);
                    }
                } else {
                    try {
                        LCObject rawData = JSON.parseObject(jsonString, LCObject.class);
                        LCUser newUser = (LCUser)Transformer.transform(rawData, userClass);
                        LCUser.changeCurrentUser(newUser, true);
                        user = newUser;
                    }
                    catch (Exception ex) {
                        logger.w(ex);
                    }
                }
            }
            // MONITOREXIT : clazz
        }
        if (!enableAutomatic) return (T)((LCUser)Transformer.transform((LCObject)user, userClass));
        if (null != user) return (T)((LCUser)Transformer.transform((LCObject)user, userClass));
        try {
            user = (LCUser)userClass.newInstance();
            LCUser.changeCurrentUser(user, true);
            return (T)((LCUser)Transformer.transform((LCObject)user, userClass));
        }
        catch (Exception ex) {
            logger.w(ex);
        }
        return (T)((LCUser)Transformer.transform((LCObject)user, userClass));
    }

    public static Observable<LCNull> requestPasswordResetInBackground(String email) {
        return PaasClient.getStorageClient().requestResetPassword(email);
    }

    public static Observable<LCNull> requestPasswordResetBySmsCodeInBackground(String phoneNumber) {
        return LCUser.requestPasswordResetBySmsCodeInBackground(phoneNumber, null);
    }

    public static Observable<LCNull> requestPasswordResetBySmsCodeInBackground(String phoneNumber, String validateToken) {
        return PaasClient.getStorageClient().requestResetPasswordBySmsCode(phoneNumber, validateToken);
    }

    public static Observable<LCNull> resetPasswordBySmsCodeInBackground(String smsCode, String newPassword) {
        return PaasClient.getStorageClient().resetPasswordBySmsCode(smsCode, newPassword);
    }

    public Observable<LCNull> updatePasswordInBackground(String oldPass, String newPass) {
        return PaasClient.getStorageClient().updatePassword(this, oldPass, newPass);
    }

    public static Observable<LCNull> requestEmailVerifyInBackground(String email) {
        return PaasClient.getStorageClient().requestEmailVerify(email);
    }

    public static Observable<LCNull> requestMobilePhoneVerifyInBackground(String mobilePhone) {
        if (StringUtil.isEmpty(mobilePhone) || !LCSMS.checkMobilePhoneNumber(mobilePhone)) {
            return Observable.error((Throwable)new IllegalArgumentException("mobile phone number is empty or invalid"));
        }
        return LCUser.requestMobilePhoneVerifyInBackground(mobilePhone, null);
    }

    public static Observable<LCNull> requestMobilePhoneVerifyInBackground(String mobilePhone, String validateToken) {
        if (StringUtil.isEmpty(mobilePhone) || !LCSMS.checkMobilePhoneNumber(mobilePhone)) {
            return Observable.error((Throwable)new IllegalArgumentException("mobile phone number is empty or invalid"));
        }
        return PaasClient.getStorageClient().requestMobilePhoneVerify(mobilePhone, validateToken);
    }

    public static Observable<LCNull> requestLoginSmsCodeInBackground(String mobilePhone) {
        if (StringUtil.isEmpty(mobilePhone) || !LCSMS.checkMobilePhoneNumber(mobilePhone)) {
            return Observable.error((Throwable)new IllegalArgumentException("mobile phone number is empty or invalid"));
        }
        return LCUser.requestLoginSmsCodeInBackground(mobilePhone, null);
    }

    public static Observable<LCNull> requestLoginSmsCodeInBackground(String mobilePhone, String validateToken) {
        if (StringUtil.isEmpty(mobilePhone) || !LCSMS.checkMobilePhoneNumber(mobilePhone)) {
            return Observable.error((Throwable)new IllegalArgumentException("mobile phone number is empty or invalid"));
        }
        return PaasClient.getStorageClient().requestLoginSmsCode(mobilePhone, validateToken);
    }

    public static Observable<LCNull> verifyMobilePhoneInBackground(String verifyCode) {
        return PaasClient.getStorageClient().verifyMobilePhone(verifyCode);
    }

    public static Observable<LCNull> requestSMSCodeForUpdatingPhoneNumberInBackground(String mobilePhone, LCSMSOption option) {
        return LCUser.requestSMSCodeForUpdatingPhoneNumberInBackground(null, mobilePhone, option);
    }

    public static Observable<LCNull> requestSMSCodeForUpdatingPhoneNumberInBackground(LCUser asAuthenticatedUser, String mobilePhone, LCSMSOption option) {
        if (StringUtil.isEmpty(mobilePhone) || !LCSMS.checkMobilePhoneNumber(mobilePhone)) {
            return Observable.error((Throwable)new IllegalArgumentException("mobile phone number is empty or invalid"));
        }
        HashMap<String, Object> param = null == option ? new HashMap() : option.getOptionMap();
        return PaasClient.getStorageClient().requestSMSCodeForUpdatingPhoneNumber(asAuthenticatedUser, mobilePhone, param);
    }

    public static Observable<LCNull> verifySMSCodeForUpdatingPhoneNumberInBackground(String code, String mobilePhone) {
        return LCUser.verifySMSCodeForUpdatingPhoneNumberInBackground(null, code, mobilePhone);
    }

    public static Observable<LCNull> verifySMSCodeForUpdatingPhoneNumberInBackground(LCUser asAuthenticatedUser, String code, String mobilePhone) {
        if (StringUtil.isEmpty(code) || StringUtil.isEmpty(mobilePhone)) {
            return Observable.error((Throwable)new IllegalArgumentException("code or mobilePhone is empty"));
        }
        return PaasClient.getStorageClient().verifySMSCodeForUpdatingPhoneNumber(asAuthenticatedUser, code, mobilePhone);
    }

    private boolean checkUserAuthentication(LCCallback callback) {
        if (!this.isAuthenticated() || StringUtil.isEmpty(this.getObjectId())) {
            if (callback != null) {
                callback.internalDone(ErrorUtils.propagateException(206, "No valid session token, make sure signUp or login has been called."));
            }
            return false;
        }
        return true;
    }

    public Observable<JSONObject> followInBackground(String userObjectId) {
        return this.followInBackground(null, userObjectId);
    }

    public Observable<JSONObject> followInBackground(LCUser asAuthenticatedUser, String userObjectId) {
        return this.followInBackground(asAuthenticatedUser, userObjectId, new HashMap<String, Object>());
    }

    public Observable<JSONObject> followInBackground(String userObjectId, Map<String, Object> attributes) {
        return this.followInBackground(null, userObjectId, attributes);
    }

    public Observable<JSONObject> followInBackground(LCUser asAuthenticatedUser, String userObjectId, Map<String, Object> attributes) {
        if (!this.checkUserAuthentication(null)) {
            return Observable.error((Throwable)ErrorUtils.propagateException(206, "No valid session token, make sure signUp or login has been called."));
        }
        return PaasClient.getStorageClient().followUser(asAuthenticatedUser, this.getObjectId(), userObjectId, attributes);
    }

    public Observable<JSONObject> unfollowInBackground(String userObjectId) {
        return this.unfollowInBackground(null, userObjectId);
    }

    public Observable<JSONObject> unfollowInBackground(LCUser asAuthenticatedUser, String userObjectId) {
        if (!this.checkUserAuthentication(null)) {
            return Observable.error((Throwable)ErrorUtils.propagateException(206, "No valid session token, make sure signUp or login has been called."));
        }
        return PaasClient.getStorageClient().unfollowUser(asAuthenticatedUser, this.getObjectId(), userObjectId);
    }

    public LCQuery<LCObject> followerQuery() {
        return LCUser.followerQuery(this.getObjectId(), LCObject.class);
    }

    public LCQuery<LCObject> followeeQuery() {
        return LCUser.followeeQuery(this.getObjectId(), LCObject.class);
    }

    public static <T extends LCObject> LCQuery<T> followerQuery(String userObjectId, Class<T> clazz) {
        if (StringUtil.isEmpty(userObjectId)) {
            throw new IllegalArgumentException("Blank user objectId");
        }
        LCQuery<T> query = new LCQuery<T>("_Follower", clazz);
        query.whereEqualTo("user", LCUser.createWithoutData(CLASS_NAME, userObjectId));
        query.include(FOLLOWER_TAG);
        return query;
    }

    public static <T extends LCObject> LCQuery<T> followeeQuery(String userObjectId, Class<T> clazz) {
        if (StringUtil.isEmpty(userObjectId)) {
            throw new IllegalArgumentException("Blank user objectId");
        }
        LCQuery<T> query = new LCQuery<T>("_Followee", clazz);
        query.whereEqualTo("user", LCUser.createWithoutData(CLASS_NAME, userObjectId));
        query.include(FOLLOWEE_TAG);
        return query;
    }

    public LCQuery<LCFriendship> friendshipQuery(boolean isFollowerDirection) {
        String userObjectId = this.getObjectId();
        if (StringUtil.isEmpty(userObjectId)) {
            logger.d("user object id is empty.");
            return null;
        }
        LCQuery<LCFriendship> query = new LCQuery<LCFriendship>("_Followee");
        if (isFollowerDirection) {
            query.whereEqualTo(FOLLOWEE_TAG, LCUser.createWithoutData(CLASS_NAME, userObjectId));
            query.include("user");
        } else {
            query.whereEqualTo("user", LCUser.createWithoutData(CLASS_NAME, userObjectId));
            query.include(FOLLOWEE_TAG);
        }
        query.whereEqualTo("friendStatus", true);
        return query;
    }

    public Observable<List<LCFriendship>> queryFriendship() {
        return this.queryFriendship(0, 0, null);
    }

    public Observable<List<LCFriendship>> queryFriendship(int offset, int limit, String orderBy) {
        QueryConditions conditions = new QueryConditions();
        conditions.whereEqualTo("friendStatus", true);
        if (offset > 0) {
            conditions.setSkip(offset);
        }
        if (limit > 0) {
            conditions.setLimit(limit);
        }
        if (!StringUtil.isEmpty(orderBy)) {
            conditions.setOrder(orderBy);
        }
        return PaasClient.getStorageClient().queryFriendship(this, conditions.assembleParameters());
    }

    public Observable<LCFriendshipRequest> applyFriendshipInBackground(LCUser friend, Map<String, Object> attributes) {
        return this.applyFriendshipInBackground(null, friend, attributes);
    }

    public Observable<LCFriendshipRequest> applyFriendshipInBackground(LCUser asAuthenticatedUser, LCUser friend, Map<String, Object> attributes) {
        if (!this.checkUserAuthentication(null)) {
            logger.d("current user isn't authenticated.");
            return Observable.error((Throwable)ErrorUtils.propagateException(206, "No valid session token, make sure signUp or login has been called."));
        }
        if (null == friend || StringUtil.isEmpty(friend.getObjectId())) {
            return Observable.error((Throwable)ErrorUtils.propagateException(9304, "friend user is invalid."));
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("user", Utils.getParsedObject(this));
        param.put("friend", Utils.getParsedObject(friend));
        if (null != attributes && attributes.size() > 0) {
            param.put(PARAM_ATTR_FRIENDSHIP, attributes);
        }
        JSONObject jsonObject = JSONObject.Builder.create(param);
        return PaasClient.getStorageClient().applyFriendshipRequest(asAuthenticatedUser, jsonObject);
    }

    public Observable<LCFriendship> updateFriendship(LCFriendship friendship) {
        return this.updateFriendship(null, friendship);
    }

    public Observable<LCFriendship> updateFriendship(LCUser asAuthenticatedUser, LCFriendship friendship) {
        if (!this.checkUserAuthentication(null)) {
            logger.d("current user isn't authenticated.");
            return Observable.error((Throwable)ErrorUtils.propagateException(206, "No valid session token, make sure signUp or login has been called."));
        }
        if (null == friendship || StringUtil.isEmpty(friendship.getObjectId())) {
            return Observable.error((Throwable)ErrorUtils.propagateException(9304, "friendship request(objectId) is invalid."));
        }
        if (null == friendship.getFollowee() || StringUtil.isEmpty(friendship.getFollowee().getObjectId())) {
            return Observable.error((Throwable)ErrorUtils.propagateException(9304, "friendship request(followee) is invalid."));
        }
        JSONObject changedParam = friendship.generateChangedParam();
        if (null == changedParam || changedParam.size() < 1) {
            logger.d("nothing is changed within friendship.");
            return Observable.just((Object)friendship);
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(PARAM_ATTR_FRIENDSHIP, changedParam);
        return PaasClient.getStorageClient().updateFriendship(asAuthenticatedUser, this.getObjectId(), friendship.getFollowee().getObjectId(), param);
    }

    public Observable<LCFriendshipRequest> acceptFriendshipRequest(LCFriendshipRequest request, Map<String, Object> attributes) {
        return this.acceptFriendshipRequest(null, request, attributes);
    }

    public Observable<LCFriendshipRequest> acceptFriendshipRequest(LCUser asAuthenticatedUser, LCFriendshipRequest request, Map<String, Object> attributes) {
        if (!this.checkUserAuthentication(null)) {
            logger.d("current user isn't authenticated.");
            return Observable.error((Throwable)ErrorUtils.propagateException(206, "No valid session token, make sure signUp or login has been called."));
        }
        if (null == request || StringUtil.isEmpty(request.getObjectId())) {
            return Observable.error((Throwable)ErrorUtils.propagateException(9304, "friendship request(objectId) is invalid."));
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (null != attributes && attributes.size() > 0) {
            param.put(PARAM_ATTR_FRIENDSHIP, attributes);
        }
        JSONObject jsonObject = JSONObject.Builder.create(param);
        return PaasClient.getStorageClient().acceptFriendshipRequest(asAuthenticatedUser, request, jsonObject);
    }

    public Observable<LCFriendshipRequest> declineFriendshipRequest(LCFriendshipRequest request) {
        return this.declineFriendshipRequest(null, request);
    }

    public Observable<LCFriendshipRequest> declineFriendshipRequest(LCUser asAuthenticatedUser, LCFriendshipRequest request) {
        if (!this.checkUserAuthentication(null)) {
            logger.d("current user isn't authenticated.");
            return Observable.error((Throwable)ErrorUtils.propagateException(206, "No valid session token, make sure signUp or login has been called."));
        }
        if (null == request || StringUtil.isEmpty(request.getObjectId())) {
            return Observable.error((Throwable)ErrorUtils.propagateException(9304, "friendship request(objectId) is invalid."));
        }
        return PaasClient.getStorageClient().declineFriendshipRequest(asAuthenticatedUser, request);
    }

    public LCQuery<LCFriendshipRequest> friendshipRequestQuery(int status, boolean includeTargetUser, boolean requestToMe) {
        if (!this.checkUserAuthentication(null)) {
            logger.d("current user isn't authenticated.");
            return null;
        }
        ArrayList<String> statusCondition = new ArrayList<String>(1);
        if ((status & 1) == 1) {
            statusCondition.add(LCFriendshipRequest.RequestStatus.Pending.name().toLowerCase());
        }
        if ((status & 2) == 2) {
            statusCondition.add(LCFriendshipRequest.RequestStatus.Accepted.name().toLowerCase());
        }
        if ((status & 4) == 4) {
            statusCondition.add(LCFriendshipRequest.RequestStatus.Declined.name().toLowerCase());
        }
        if (statusCondition.size() < 1) {
            logger.d("status parameter is invalid.");
            return null;
        }
        LCQuery<LCFriendshipRequest> result = new LCQuery<LCFriendshipRequest>("_FriendshipRequest");
        result.whereContainedIn("status", statusCondition);
        if (requestToMe) {
            result.whereEqualTo("friend", this);
            if (includeTargetUser) {
                result.include("user");
            }
        } else {
            result.whereEqualTo("user", this);
            if (includeTargetUser) {
                result.include("friend");
            }
        }
        result.addDescendingOrder("updatedAt");
        return result;
    }

    private void processResultList(List<JSONObject> results, List<LCUser> list, String tag) {
        for (JSONObject item : results) {
            if (null == item) continue;
            LCUser user = (LCUser)Utils.parseObjectFromMap((Map)item.get(tag));
            list.add(user);
        }
    }

    private Map<String, List<LCUser>> parseFollowerAndFollowee(JSONObject jsonObject) {
        HashMap<String, List<LCUser>> map = new HashMap<String, List<LCUser>>();
        if (null != jsonObject) {
            List<JSONObject> followees;
            List<JSONObject> followers = LCUtils.getObjectListFromMapList((List)jsonObject.get("followers"));
            if (null != followers && followers.size() > 0) {
                LinkedList<LCUser> followerUsers = new LinkedList<LCUser>();
                this.processResultList(followers, followerUsers, FOLLOWER_TAG);
                map.put(FOLLOWER_TAG, followerUsers);
            }
            if (null != (followees = LCUtils.getObjectListFromMapList((List)jsonObject.get("followees"))) && followees.size() > 0) {
                LinkedList<LCUser> followeeUsers = new LinkedList<LCUser>();
                this.processResultList(followees, followeeUsers, FOLLOWEE_TAG);
                map.put(FOLLOWEE_TAG, followeeUsers);
            }
        }
        return map;
    }

    public void getFollowersAndFolloweesInBackground(FollowersAndFolloweesCallback callback) {
        this.getFollowersAndFolloweesInBackground(null, callback);
    }

    public void getFollowersAndFolloweesInBackground(LCUser asAuthenticatedUser, final FollowersAndFolloweesCallback callback) {
        if (null == callback) {
            return;
        }
        if (!this.checkUserAuthentication(callback)) {
            return;
        }
        PaasClient.getStorageClient().getFollowersAndFollowees(asAuthenticatedUser, this.getObjectId()).subscribe((Observer)new Observer<JSONObject>(){

            public void onSubscribe(Disposable disposable) {
            }

            public void onNext(JSONObject jsonObject) {
                if (null == jsonObject) {
                    callback.done(null, null);
                } else {
                    Map result = LCUser.this.parseFollowerAndFollowee(jsonObject);
                    callback.done(result, null);
                }
            }

            public void onError(Throwable throwable) {
                callback.done(null, new LCException(throwable));
            }

            public void onComplete() {
            }
        });
    }

    public static void alwaysUseSubUserClass(Class<? extends LCUser> clazz) {
        LCUser.registerSubclass(clazz);
        subClazz = clazz;
    }

    private static Class internalUserClazz() {
        return subClazz == null ? LCUser.class : subClazz;
    }

    public static <T extends LCUser> T cast(LCUser user, Class<T> clazz) {
        try {
            LCUser newUser = (LCUser)LCObject.cast(user, clazz);
            return (T)newUser;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static enum SNS_PLATFORM {
        FACEBOOK("facebook"),
        TWITTER("twitter"),
        QQ("qq"),
        WEIBO("weibo"),
        WECHAT("weixin");

        private String name;

        private SNS_PLATFORM(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

