/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.LCACL;
import cn.leancloud.LCObject;
import cn.leancloud.LCQuery;
import cn.leancloud.LCStatusQuery;
import cn.leancloud.LCUser;
import cn.leancloud.annotation.LCClassName;
import cn.leancloud.core.PaasClient;
import cn.leancloud.json.JSON;
import cn.leancloud.json.JSONObject;
import cn.leancloud.ops.Utils;
import cn.leancloud.types.LCNull;
import cn.leancloud.utils.ErrorUtils;
import cn.leancloud.utils.StringUtil;
import io.reactivex.Observable;
import io.reactivex.functions.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@LCClassName(value="_Status")
public class LCStatus
extends LCObject {
    public static final String CLASS_NAME = "_Status";
    public static final String ATTR_MESSAGE_ID = "messageId";
    public static final String ATTR_INBOX_TYPE = "inboxType";
    public static final String ATTR_SOURCE = "source";
    public static final String ATTR_OWNER = "owner";
    public static final String ATTR_IMAGE = "image";
    public static final String ATTR_MESSAGE = "message";
    public static int INVALID_MESSAGE_ID = 0;

    public static LCStatus createStatus(String imageUrl, String message) {
        LCStatus status = new LCStatus();
        status.setImageUrl(imageUrl);
        status.setMessage(message);
        return status;
    }

    public static LCStatus createStatusWithData(Map<String, Object> data) {
        LCStatus status = new LCStatus();
        status.resetServerData(data);
        return status;
    }

    public LCStatus() {
        super(CLASS_NAME);
        this.totallyOverwrite = true;
        this.endpointClassName = "statuses";
    }

    public LCStatus(LCObject o) {
        super(o);
    }

    public void setImageUrl(String imageUrl) {
        this.put(ATTR_IMAGE, imageUrl);
    }

    public String getImageUrl() {
        return this.getString(ATTR_IMAGE);
    }

    public void setMessage(String msg) {
        this.put(ATTR_MESSAGE, msg);
    }

    public String getMessage() {
        return this.getString(ATTR_MESSAGE);
    }

    public long getMessageId() {
        return this.getLong(ATTR_MESSAGE_ID);
    }

    protected void setMessageId(long messageId) {
        this.put(ATTR_MESSAGE_ID, messageId);
    }

    public String getInboxType() {
        return this.getString(ATTR_INBOX_TYPE);
    }

    public LCUser getSource() {
        return (LCUser)this.getLCObject(ATTR_SOURCE);
    }

    public void setSource(LCObject source) {
        this.put(ATTR_SOURCE, Utils.mapFromAVObject(source, false));
    }

    public void setInboxType(String type) {
        if (!StringUtil.isEmpty(type)) {
            this.put(ATTR_INBOX_TYPE, type);
        }
    }

    @Override
    public void put(String key, Object value) {
        this.serverData.put(key, value);
    }

    @Override
    public Object get(String key) {
        return this.serverData.get(key);
    }

    @Override
    public void remove(String key) {
        this.serverData.remove(key);
    }

    @Override
    public Observable<LCNull> deleteInBackground() {
        return LCStatus.deleteInBackground(this);
    }

    public static Observable<LCNull> deleteInBackground(LCStatus status) {
        return LCStatus.deleteInBackground(LCUser.currentUser(), status);
    }

    public static Observable<LCNull> deleteInBackground(LCUser asAuthenticatedUser, LCStatus status) {
        if (!LCStatus.checkUserAuthenticated(asAuthenticatedUser)) {
            return Observable.error((Throwable)ErrorUtils.sessionMissingException());
        }
        String currentUserObjectId = asAuthenticatedUser.getObjectId();
        LCObject source = null;
        Object sourceObject = status.get(ATTR_SOURCE);
        if (sourceObject instanceof LCObject) {
            source = (LCObject)sourceObject;
        } else if (sourceObject instanceof JSONObject) {
            JSONObject sourceJson = (JSONObject)sourceObject;
            source = LCObject.createWithoutData(sourceJson.getString("className"), sourceJson.getString("objectId"));
        } else if (sourceObject instanceof HashMap) {
            HashMap sourceMap = (HashMap)sourceObject;
            source = LCObject.createWithoutData((String)sourceMap.get("className"), (String)sourceMap.get("objectId"));
        }
        String statusObjectId = status.getObjectId();
        long messageId = status.getMessageId();
        if (null != source && currentUserObjectId.equals(source.getString("objectId"))) {
            if (StringUtil.isEmpty(statusObjectId)) {
                return Observable.error((Throwable)ErrorUtils.invalidObjectIdException());
            }
            return PaasClient.getStorageClient().deleteStatus(asAuthenticatedUser, statusObjectId);
        }
        if ((long)INVALID_MESSAGE_ID == messageId) {
            return Observable.error((Throwable)ErrorUtils.invalidObjectIdException());
        }
        String ownerString = JSON.toJSONString(Utils.mapFromAVObject(asAuthenticatedUser, false));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(ATTR_MESSAGE_ID, String.valueOf(messageId));
        params.put(ATTR_INBOX_TYPE, status.getInboxType());
        params.put(ATTR_OWNER, ownerString);
        return PaasClient.getStorageClient().deleteInboxStatus(asAuthenticatedUser, params);
    }

    public static Observable<LCStatus> getStatusWithIdInBackground(String statusId) {
        return LCStatus.getStatusWithIdInBackground(null, statusId);
    }

    public static Observable<LCStatus> getStatusWithIdInBackground(LCUser asAuthenticatedUser, String statusId) {
        return PaasClient.getStorageClient().fetchStatus(asAuthenticatedUser, statusId);
    }

    public Observable<LCStatus> sendToUsersInBackground(LCQuery query) {
        return this.sendToUsersInBackground(INBOX_TYPE.TIMELINE.toString(), query);
    }

    public Observable<LCStatus> sendToUsersInBackground(String inboxType, LCQuery query) {
        return this.sendInBackground(inboxType, query);
    }

    public Observable<LCStatus> sendToFollowersInBackground() {
        return this.sendToFollowersInBackground(INBOX_TYPE.TIMELINE.toString());
    }

    private LCQuery generateFollowerQuery(String userObjectId) {
        LCUser user = new LCUser();
        user.setObjectId(userObjectId);
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("follower");
        LCQuery query = new LCQuery("_Follower");
        query.whereEqualTo("user", Utils.mapFromAVObject(user, false));
        query.selectKeys(keys);
        return query;
    }

    public Observable<LCStatus> sendToFollowersInBackground(String inboxType) {
        if (!LCStatus.checkCurrentUserAuthenticated()) {
            return Observable.error((Throwable)ErrorUtils.sessionMissingException());
        }
        LCQuery followerQuery = this.generateFollowerQuery(LCUser.currentUser().getObjectId());
        return this.sendInBackground(inboxType, followerQuery);
    }

    public Observable<LCStatus> sendPrivatelyInBackground(String receiverObjectId) {
        LCQuery<LCUser> userQuery = LCUser.getQuery();
        userQuery.whereEqualTo("objectId", receiverObjectId);
        return this.sendInBackground(INBOX_TYPE.PRIVATE.toString(), userQuery);
    }

    private Observable<LCStatus> sendInBackground(String inboxType, LCQuery query) {
        return this.sendInBackground(LCUser.currentUser(), inboxType, query);
    }

    private Observable<LCStatus> sendInBackground(LCUser asAuthenticatedUser, String inboxType, LCQuery query) {
        if (!LCStatus.checkUserAuthenticated(asAuthenticatedUser)) {
            return Observable.error((Throwable)ErrorUtils.sessionMissingException());
        }
        this.setSource(asAuthenticatedUser);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("data", this.serverData);
        param.put(ATTR_INBOX_TYPE, inboxType);
        Map<String, Object> queryCondition = query.assembleJsonParam();
        param.put("query", queryCondition);
        return PaasClient.getStorageClient().postStatus(asAuthenticatedUser, param).map((Function)new Function<LCStatus, LCStatus>(){

            public LCStatus apply(LCStatus avStatus) throws Exception {
                LCStatus.this.mergeRawData(avStatus, true);
                return avStatus;
            }
        });
    }

    public static LCStatusQuery statusQuery(LCUser source) {
        LCStatusQuery query = new LCStatusQuery(LCStatusQuery.SourceType.OWNED);
        query.setSource(source);
        query.setDirection(LCStatusQuery.PaginationDirection.NEW_TO_OLD);
        query.setInboxType(INBOX_TYPE.TIMELINE.toString());
        return query;
    }

    public static LCStatusQuery inboxQuery(LCUser owner, String inboxType) {
        LCStatusQuery query = new LCStatusQuery(LCStatusQuery.SourceType.INBOX);
        query.setOwner(owner);
        query.setDirection(LCStatusQuery.PaginationDirection.NEW_TO_OLD);
        query.setInboxType(inboxType);
        return query;
    }

    public LCObject toObject() {
        return LCObject.createWithoutData(CLASS_NAME, this.objectId);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (StringUtil.isEmpty(this.objectId)) {
            return false;
        }
        LCStatus other = (LCStatus)obj;
        return this.objectId.equals(other.objectId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getClassName(), this.getObjectId());
    }

    private static boolean checkCurrentUserAuthenticated() {
        LCUser currentUser = LCUser.getCurrentUser();
        return LCStatus.checkUserAuthenticated(currentUser);
    }

    private static boolean checkUserAuthenticated(LCUser currentUser) {
        return null != currentUser && currentUser.isAuthenticated();
    }

    @Override
    @Deprecated
    public void add(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public synchronized LCACL getACL() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public synchronized void setACL(LCACL acl) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void addAll(String key, Collection<?> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void addAllUnique(String key, Collection<?> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void addUnique(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public LCObject fetch() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public LCObject fetch(String includedKeys) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void refresh() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void refresh(String includedKeys) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public LCObject fetchIfNeeded() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public Observable<LCObject> fetchIfNeededInBackground() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public Observable<LCObject> fetchInBackground() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public Observable<LCObject> refreshInBackground() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public Observable<LCObject> fetchInBackground(String includeKeys) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void save() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public Observable<? extends LCObject> saveInBackground() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void saveEventually() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean isFetchWhenSave() {
        return false;
    }

    @Override
    @Deprecated
    public void setFetchWhenSave(boolean fetchWhenSave) {
        throw new UnsupportedOperationException();
    }

    public static enum INBOX_TYPE {
        TIMELINE("default"),
        PRIVATE("private");

        private String type;

        private INBOX_TYPE(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

