/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.LCObject;
import cn.leancloud.LCQuery;
import cn.leancloud.Transformer;
import cn.leancloud.ops.Utils;
import cn.leancloud.utils.StringUtil;
import java.util.Collection;
import java.util.HashMap;

public class LCRelation<T extends LCObject> {
    private String key;
    private transient LCObject parent;
    private String targetClass;

    public LCRelation() {
    }

    public LCRelation(LCObject parent, String key) {
        this();
        this.parent = parent;
        this.key = key;
    }

    public LCRelation(String targetClass) {
        this(null, null);
        this.targetClass = targetClass;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public LCObject getParent() {
        return this.parent;
    }

    public void setParent(LCObject parent) {
        this.parent = parent;
    }

    public String getTargetClass() {
        return this.targetClass;
    }

    public void setTargetClass(String targetClass) {
        this.targetClass = targetClass;
    }

    public void add(T object) {
        if (object == null) {
            throw new IllegalArgumentException("null AVObject");
        }
        if (StringUtil.isEmpty(this.targetClass)) {
            this.targetClass = ((LCObject)object).getClassName();
        }
        if (!StringUtil.isEmpty(this.targetClass) && !this.targetClass.equals(((LCObject)object).getClassName())) {
            throw new IllegalArgumentException("Could not add class '" + ((LCObject)object).getClassName() + "' to this relation,expect class is '" + this.targetClass + "'");
        }
        this.parent.addRelation((LCObject)object, this.key);
    }

    public void addAll(Collection<T> objects) {
        if (objects != null) {
            for (LCObject obj : objects) {
                this.add(obj);
            }
        }
    }

    public void remove(LCObject object) {
        this.parent.removeRelation(object, this.key);
    }

    public LCQuery<T> getQuery() {
        return this.getQuery(null);
    }

    public LCQuery<T> getQuery(Class<T> clazz) {
        if (this.getParent() == null || StringUtil.isEmpty(this.getParent().getObjectId())) {
            throw new IllegalStateException("unable to encode an association with an unsaved AVObject");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("object", Utils.mapFromPointerObject(this.getParent()));
        map.put("key", this.getKey());
        String targetClassName = this.getTargetClass();
        if (StringUtil.isEmpty(targetClassName)) {
            targetClassName = this.getParent().getClassName();
        }
        LCQuery<T> query = new LCQuery<T>(targetClassName, clazz);
        query.addWhereItem("$relatedTo", null, map);
        if (StringUtil.isEmpty(this.getTargetClass())) {
            query.getParameters().put("redirectClassNameForKey", this.getKey());
        }
        return query;
    }

    public static <M extends LCObject> LCQuery<M> reverseQuery(String parentClassName, String relationKey, LCObject child) {
        LCQuery query = new LCQuery(parentClassName);
        query.whereEqualTo(relationKey, Utils.mapFromPointerObject(child));
        return query;
    }

    public static <M extends LCObject> LCQuery<M> reverseQuery(Class<M> theParentClazz, String relationKey, LCObject child) {
        LCQuery<M> query = new LCQuery<M>(Transformer.getSubClassName(theParentClazz), theParentClazz);
        query.whereEqualTo(relationKey, Utils.mapFromPointerObject(child));
        return query;
    }
}

