/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.LCException;
import cn.leancloud.LCLogger;
import cn.leancloud.LCObject;
import cn.leancloud.LCUser;
import cn.leancloud.Transformer;
import cn.leancloud.cache.QueryResultCache;
import cn.leancloud.core.PaasClient;
import cn.leancloud.query.QueryConditions;
import cn.leancloud.query.QueryOperation;
import cn.leancloud.types.LCGeoPoint;
import cn.leancloud.types.LCNull;
import cn.leancloud.utils.LCUtils;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.functions.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class LCQuery<T extends LCObject>
implements Cloneable {
    private static final LCLogger LOGGER = LogUtil.getLogger(LCQuery.class);
    private Class<T> clazz;
    private String className;
    private Boolean isRunning;
    private CachePolicy cachePolicy = CachePolicy.IGNORE_CACHE;
    private long maxCacheAge = -1L;
    QueryConditions conditions;

    public LCQuery(String theClassName) {
        this(theClassName, null);
    }

    public LCQuery clone() throws CloneNotSupportedException {
        LCQuery query = (LCQuery)super.clone();
        query.isRunning = false;
        query.cachePolicy = this.cachePolicy;
        query.maxCacheAge = this.maxCacheAge;
        query.conditions = null != this.conditions ? this.conditions.clone() : null;
        return query;
    }

    LCQuery(String theClassName, Class<T> clazz) {
        Transformer.checkClassName(theClassName);
        this.className = theClassName;
        this.clazz = clazz;
        this.conditions = new QueryConditions();
    }

    public static <T extends LCObject> LCQuery<T> getQuery(String theClassName) {
        return new LCQuery<T>(theClassName);
    }

    public static <T extends LCObject> LCQuery<T> getQuery(Class<T> clazz) {
        return new LCQuery<T>(Transformer.getSubClassName(clazz), clazz);
    }

    Class<T> getClazz() {
        return this.clazz;
    }

    void setClazz(Class<T> clazz) {
        this.clazz = clazz;
    }

    List<String> getInclude() {
        return this.conditions.getInclude();
    }

    void setInclude(List<String> include) {
        this.conditions.setInclude(include);
    }

    Set<String> getSelectedKeys() {
        return this.conditions.getSelectedKeys();
    }

    void setSelectedKeys(Set<String> selectedKeys) {
        this.conditions.setSelectedKeys(selectedKeys);
    }

    Map<String, String> getParameters() {
        return this.conditions.getParameters();
    }

    void setParameters(Map<String, String> parameters) {
        this.conditions.setParameters(parameters);
    }

    Map<String, List<QueryOperation>> getWhere() {
        return this.conditions.getWhere();
    }

    public String getClassName() {
        return this.className;
    }

    public LCQuery<T> setClassName(String className) {
        this.className = className;
        return this;
    }

    public CachePolicy getCachePolicy() {
        return this.cachePolicy;
    }

    public LCQuery<T> setCachePolicy(CachePolicy cachePolicy) {
        this.cachePolicy = cachePolicy;
        return this;
    }

    public CachePolicy getPolicy() {
        return this.cachePolicy;
    }

    public LCQuery<T> setPolicy(CachePolicy policy) {
        this.cachePolicy = policy;
        return this;
    }

    public long getMaxCacheAge() {
        return this.maxCacheAge;
    }

    public LCQuery<T> setMaxCacheAge(long maxCacheAge) {
        this.maxCacheAge = maxCacheAge;
        return this;
    }

    public static void clearAllCachedResults() {
        QueryResultCache.getInstance().clearAllCachedFiles();
    }

    public void clearCachedResult() {
        Map<String, String> query = this.assembleParameters();
        String cacheKey = QueryResultCache.generateKeyForQueryCondition(this.getClassName(), query);
        QueryResultCache.getInstance().clearCachedFile(cacheKey);
        query.put("limit", "1");
        cacheKey = QueryResultCache.generateKeyForQueryCondition(this.getClassName(), query);
        QueryResultCache.getInstance().clearCachedFile(cacheKey);
    }

    public int getLimit() {
        return this.conditions.getLimit();
    }

    public LCQuery<T> setLimit(int limit) {
        this.conditions.setLimit(limit);
        return this;
    }

    public LCQuery<T> limit(int limit) {
        this.setLimit(limit);
        return this;
    }

    public LCQuery<T> skip(int skip) {
        this.setSkip(skip);
        return this;
    }

    public int getSkip() {
        return this.conditions.getSkip();
    }

    public LCQuery<T> setSkip(int skip) {
        this.conditions.setSkip(skip);
        return this;
    }

    public String getOrder() {
        return this.conditions.getOrder();
    }

    public LCQuery<T> setOrder(String order) {
        this.conditions.setOrder(order);
        return this;
    }

    public LCQuery<T> order(String order) {
        this.setOrder(order);
        return this;
    }

    public LCQuery<T> addAscendingOrder(String key) {
        this.conditions.addAscendingOrder(key);
        return this;
    }

    public LCQuery<T> addDescendingOrder(String key) {
        this.conditions.addDescendingOrder(key);
        return this;
    }

    public boolean isIncludeACL() {
        return this.conditions.isIncludeACL();
    }

    public LCQuery<T> includeACL(boolean includeACL) {
        this.conditions.includeACL(includeACL);
        return this;
    }

    public LCQuery<T> include(String key) {
        this.conditions.include(key);
        return this;
    }

    public LCQuery<T> selectKeys(Collection<String> keys) {
        this.conditions.selectKeys(keys);
        return this;
    }

    public LCQuery<T> orderByAscending(String key) {
        this.conditions.orderByAscending(key);
        return this;
    }

    public LCQuery<T> orderByDescending(String key) {
        this.conditions.orderByDescending(key);
        return this;
    }

    public LCQuery<T> whereContainedIn(String key, Collection<? extends Object> values) {
        this.conditions.whereContainedIn(key, values);
        return this;
    }

    public LCQuery<T> whereContains(String key, String substring) {
        this.conditions.whereContains(key, substring);
        return this;
    }

    public LCQuery<T> whereSizeEqual(String key, int size) {
        this.conditions.whereSizeEqual(key, size);
        return this;
    }

    public LCQuery<T> whereContainsAll(String key, Collection<?> values) {
        this.conditions.whereContainsAll(key, values);
        return this;
    }

    public LCQuery<T> whereDoesNotExist(String key) {
        this.conditions.whereDoesNotExist(key);
        return this;
    }

    public LCQuery<T> whereEndsWith(String key, String suffix) {
        this.conditions.whereEndsWith(key, suffix);
        return this;
    }

    public LCQuery<T> whereEqualTo(String key, Object value) {
        this.conditions.whereEqualTo(key, value);
        return this;
    }

    private LCQuery<T> addOrItems(QueryOperation op) {
        this.conditions.addOrItems(op);
        return this;
    }

    private LCQuery<T> addAndItems(LCQuery query) {
        this.conditions.addAndItems(query.conditions);
        return this;
    }

    protected LCQuery<T> addWhereItem(String key, String op, Object value) {
        this.conditions.addWhereItem(key, op, value);
        return this;
    }

    public LCQuery<T> whereExists(String key) {
        this.conditions.whereExists(key);
        return this;
    }

    public LCQuery<T> whereGreaterThan(String key, Object value) {
        this.conditions.whereGreaterThan(key, value);
        return this;
    }

    public LCQuery<T> whereGreaterThanOrEqualTo(String key, Object value) {
        this.conditions.whereGreaterThanOrEqualTo(key, value);
        return this;
    }

    public LCQuery<T> whereLessThan(String key, Object value) {
        this.conditions.whereLessThan(key, value);
        return this;
    }

    public LCQuery<T> whereLessThanOrEqualTo(String key, Object value) {
        this.conditions.whereLessThanOrEqualTo(key, value);
        return this;
    }

    public LCQuery<T> whereMatches(String key, String regex) {
        this.conditions.whereMatches(key, regex);
        return this;
    }

    public LCQuery<T> whereMatches(String key, String regex, String modifiers) {
        this.conditions.whereMatches(key, regex, modifiers);
        return this;
    }

    public LCQuery<T> whereNear(String key, LCGeoPoint point) {
        this.conditions.whereNear(key, point);
        return this;
    }

    public LCQuery<T> whereNotContainedIn(String key, Collection<? extends Object> values) {
        this.conditions.whereNotContainedIn(key, values);
        return this;
    }

    public LCQuery<T> whereNotEqualTo(String key, Object value) {
        this.conditions.whereNotEqualTo(key, value);
        return this;
    }

    public LCQuery<T> whereStartsWith(String key, String prefix) {
        this.conditions.whereStartsWith(key, prefix);
        return this;
    }

    public LCQuery<T> whereWithinGeoBox(String key, LCGeoPoint southwest, LCGeoPoint northeast) {
        this.conditions.whereWithinGeoBox(key, southwest, northeast);
        return this;
    }

    public LCQuery<T> whereWithinKilometers(String key, LCGeoPoint point, double maxDistance) {
        this.conditions.whereWithinKilometers(key, point, maxDistance);
        return this;
    }

    public LCQuery<T> whereWithinKilometers(String key, LCGeoPoint point, double maxDistance, double minDistance) {
        this.conditions.whereWithinKilometers(key, point, maxDistance, minDistance);
        return this;
    }

    public LCQuery<T> whereWithinMiles(String key, LCGeoPoint point, double maxDistance) {
        this.conditions.whereWithinMiles(key, point, maxDistance);
        return this;
    }

    public LCQuery<T> whereWithinMiles(String key, LCGeoPoint point, double maxDistance, double minDistance) {
        this.conditions.whereWithinMiles(key, point, maxDistance, minDistance);
        return this;
    }

    public LCQuery<T> whereWithinRadians(String key, LCGeoPoint point, double maxDistance) {
        this.conditions.whereWithinRadians(key, point, maxDistance);
        return this;
    }

    public LCQuery<T> whereWithinRadians(String key, LCGeoPoint point, double maxDistance, double minDistance) {
        this.conditions.whereWithinRadians(key, point, maxDistance, minDistance);
        return this;
    }

    public LCQuery<T> whereMatchesKeyInQuery(String key, String keyInQuery, LCQuery<?> query) {
        HashMap<String, Object> inner = new HashMap<String, Object>();
        inner.put("className", query.getClassName());
        inner.put("where", query.conditions.compileWhereOperationMap());
        if (query.conditions.getSkip() > 0) {
            inner.put("skip", query.conditions.getSkip());
        }
        if (query.conditions.getLimit() > 0) {
            inner.put("limit", query.conditions.getLimit());
        }
        if (!StringUtil.isEmpty(query.getOrder())) {
            inner.put("order", query.getOrder());
        }
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("query", inner);
        queryMap.put("key", keyInQuery);
        return this.addWhereItem(key, "$select", queryMap);
    }

    public LCQuery<T> whereMatchesQuery(String key, LCQuery<?> query) {
        Map<String, Object> map = LCUtils.createMap("where", query.conditions.compileWhereOperationMap());
        map.put("className", query.className);
        if (query.conditions.getSkip() > 0) {
            map.put("skip", query.conditions.getSkip());
        }
        if (query.conditions.getLimit() > 0) {
            map.put("limit", query.conditions.getLimit());
        }
        if (!StringUtil.isEmpty(query.getOrder())) {
            map.put("order", query.getOrder());
        }
        this.addWhereItem(key, "$inQuery", map);
        return this;
    }

    public LCQuery<T> whereDoesNotMatchKeyInQuery(String key, String keyInQuery, LCQuery<?> query) {
        Map<String, Object> map = LCUtils.createMap("className", query.className);
        map.put("where", query.conditions.compileWhereOperationMap());
        Map<String, Object> queryMap = LCUtils.createMap("query", map);
        queryMap.put("key", keyInQuery);
        this.addWhereItem(key, "$dontSelect", queryMap);
        return this;
    }

    public LCQuery<T> whereDoesNotMatchQuery(String key, LCQuery<?> query) {
        Map<String, Object> map = LCUtils.createMap("className", query.className);
        map.put("where", query.conditions.compileWhereOperationMap());
        this.addWhereItem(key, "$notInQuery", map);
        return this;
    }

    LCQuery<T> setWhere(Map<String, List<QueryOperation>> value) {
        this.conditions.setWhere(value);
        return this;
    }

    public static <T extends LCObject> LCQuery<T> or(List<LCQuery<T>> queries) {
        if (null == queries || queries.isEmpty()) {
            throw new IllegalArgumentException("queries must be non-empty.");
        }
        String className = queries.get(0).getClassName();
        LCQuery<T> result = new LCQuery<T>(className);
        if (queries.size() > 1) {
            for (LCQuery<T> query : queries) {
                if (!className.equals(query.getClassName())) {
                    throw new IllegalArgumentException("All queries must be for the same class");
                }
                super.addOrItems(new QueryOperation("$or", "$or", query.conditions.compileWhereOperationMap()));
            }
        } else {
            result.setWhere(queries.get((int)0).conditions.getWhere());
        }
        return result;
    }

    public static <T extends LCObject> LCQuery<T> and(List<LCQuery<T>> queries) {
        if (null == queries || queries.isEmpty()) {
            throw new IllegalArgumentException("queries must be non-empty.");
        }
        String className = queries.get(0).getClassName();
        LCQuery<T> result = new LCQuery<T>(className);
        if (queries.size() > 1) {
            for (LCQuery<T> query : queries) {
                if (!className.equals(query.getClassName())) {
                    throw new IllegalArgumentException("All queries must be for the same class");
                }
                super.addAndItems(query);
            }
        } else {
            result.setWhere(queries.get((int)0).conditions.getWhere());
        }
        return result;
    }

    public boolean hasCachedResult() {
        Map<String, String> query = this.assembleParameters();
        return PaasClient.getStorageClient().hasCachedResult(this.getClassName(), query, this.getMaxCacheAge());
    }

    public List<T> find() {
        return (List)this.findInBackground().blockingLast();
    }

    public Observable<List<T>> findInBackground() {
        return this.findInBackground(null);
    }

    public Observable<List<T>> findInBackground(LCUser asAuthenticatedUser) {
        return this.findInBackground(asAuthenticatedUser, 0);
    }

    protected Observable<List<T>> findInBackground(LCUser asAuthenticatedUser, int explicitLimit) {
        Map<String, String> query = this.assembleParameters();
        if (explicitLimit > 0) {
            query.put("limit", Integer.toString(explicitLimit));
        }
        LOGGER.d("Query: " + query);
        return PaasClient.getStorageClient().queryObjects(asAuthenticatedUser, this.getClassName(), query, this.cachePolicy, this.maxCacheAge).map(new Function<List<LCObject>, List<T>>(){

            public List<T> apply(List<LCObject> var1) throws Exception {
                LOGGER.d("invoke within AVQuery.findInBackground(). resultSize=" + var1.size());
                ArrayList result = new ArrayList(var1.size());
                for (LCObject obj : var1) {
                    Object tmp = Transformer.transform(obj, LCQuery.this.getClassName());
                    result.add(tmp);
                }
                return result;
            }
        });
    }

    public T get(String objectId) {
        return (T)((LCObject)this.getInBackground(objectId).blockingFirst());
    }

    public Observable<T> getInBackground(String objectId) {
        return this.getInBackground(null, objectId);
    }

    public Observable<T> getInBackground(LCUser asAuthenticatedUser, String objectId) {
        List<String> include = this.getInclude();
        String includeKeys = null;
        if (null != include && include.size() > 0) {
            includeKeys = StringUtil.join(",", include);
        }
        return PaasClient.getStorageClient().fetchObject(asAuthenticatedUser, this.getClassName(), objectId, includeKeys).map(new Function<LCObject, T>(){

            public T apply(LCObject LCObject2) throws Exception {
                if (null == LCObject2 || StringUtil.isEmpty(LCObject2.getObjectId())) {
                    throw new LCException(101, "Object is not found.");
                }
                return Transformer.transform(LCObject2, LCQuery.this.getClassName());
            }
        });
    }

    public T getFirst() {
        return this.getFirst(null);
    }

    public T getFirst(LCUser asAuthenticatedUser) {
        try {
            return (T)((LCObject)this.getFirstInBackground(asAuthenticatedUser).blockingFirst());
        }
        catch (NoSuchElementException ex) {
            return null;
        }
    }

    public Observable<T> getFirstInBackground() {
        return this.getFirstInBackground(null);
    }

    public Observable<T> getFirstInBackground(LCUser asAuthenticatedUser) {
        return this.findInBackground(asAuthenticatedUser, 1).flatMap(new Function<List<T>, ObservableSource<T>>(){

            public ObservableSource<T> apply(List<T> list) throws Exception {
                LOGGER.d("flatMap: " + list);
                return Observable.fromIterable(list);
            }
        });
    }

    public int count() {
        return this.count(null);
    }

    public int count(LCUser asAuthenticatedUser) {
        return (Integer)this.countInBackground(asAuthenticatedUser).blockingFirst();
    }

    public Observable<Integer> countInBackground() {
        return this.countInBackground(null);
    }

    public Observable<Integer> countInBackground(LCUser asAuthenticatedUser) {
        Map<String, String> query = this.assembleParameters();
        query.put("count", "1");
        query.put("limit", "0");
        return PaasClient.getStorageClient().queryCount(asAuthenticatedUser, this.getClassName(), query);
    }

    public void deleteAll() {
        this.deleteAll(null);
    }

    public void deleteAll(LCUser asAuthenticatedUser) {
        this.deleteAllInBackground(asAuthenticatedUser).blockingSubscribe();
    }

    public Observable<LCNull> deleteAllInBackground() {
        return this.deleteAllInBackground(null);
    }

    public Observable<LCNull> deleteAllInBackground(LCUser asAuthenticatedUser) {
        return this.findInBackground(asAuthenticatedUser).flatMap(new Function<List<T>, ObservableSource<LCNull>>(){

            public ObservableSource<LCNull> apply(List<T> list) {
                return LCObject.deleteAllInBackground(list);
            }
        });
    }

    public Map<String, String> assembleParameters() {
        this.conditions.assembleParameters();
        return this.conditions.getParameters();
    }

    protected Map<String, Object> assembleJsonParam() {
        Map<String, Object> result = this.conditions.assembleJsonParam();
        result.put("className", this.getClassName());
        return result;
    }

    public static enum CachePolicy {
        CACHE_ELSE_NETWORK,
        CACHE_ONLY,
        CACHE_THEN_NETWORK,
        IGNORE_CACHE,
        NETWORK_ELSE_CACHE,
        NETWORK_ONLY;

    }
}

