/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.ArchivedRequests;
import cn.leancloud.LCACL;
import cn.leancloud.LCException;
import cn.leancloud.LCFile;
import cn.leancloud.LCLogger;
import cn.leancloud.LCQuery;
import cn.leancloud.LCRelation;
import cn.leancloud.LCSaveOption;
import cn.leancloud.LCUser;
import cn.leancloud.Transformer;
import cn.leancloud.core.AppConfiguration;
import cn.leancloud.core.PaasClient;
import cn.leancloud.json.JSON;
import cn.leancloud.json.JSONArray;
import cn.leancloud.json.JSONObject;
import cn.leancloud.network.NetworkingDetector;
import cn.leancloud.ops.BaseOperation;
import cn.leancloud.ops.CompoundOperation;
import cn.leancloud.ops.ObjectFieldOperation;
import cn.leancloud.ops.OperationBuilder;
import cn.leancloud.ops.Utils;
import cn.leancloud.types.LCDate;
import cn.leancloud.types.LCGeoPoint;
import cn.leancloud.types.LCNull;
import cn.leancloud.utils.LCUtils;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;

public class LCObject {
    public static final String KEY_CREATED_AT = "createdAt";
    public static final String KEY_UPDATED_AT = "updatedAt";
    public static final String KEY_OBJECT_ID = "objectId";
    public static final String KEY_ACL = "ACL";
    public static final String KEY_CLASSNAME = "className";
    public static final String KEY_IGNORE_HOOKS = "__ignore_hooks";
    private static final String INTERNAL_PATTERN = "^[\\da-z][\\d-a-z]*$";
    private static final Set<String> RESERVED_ATTRS = new HashSet<String>(Arrays.asList("createdAt", "updatedAt", "objectId", "ACL", "className"));
    protected static final LCLogger logger = LogUtil.getLogger(LCObject.class);
    protected static final int UUID_LEN = UUID.randomUUID().toString().length();
    protected String className;
    protected transient String endpointClassName = null;
    protected transient String objectId = "";
    protected ConcurrentMap<String, Object> serverData = new ConcurrentHashMap<String, Object>();
    protected transient ConcurrentMap<String, ObjectFieldOperation> operations = new ConcurrentHashMap<String, ObjectFieldOperation>();
    protected transient LCACL acl = null;
    private transient String uuid = null;
    private volatile boolean fetchWhenSave = false;
    protected volatile boolean totallyOverwrite = false;
    private transient Set<Hook> ignoreHooks = new TreeSet<Hook>();

    public LCObject() {
        this.className = Transformer.getSubClassName(this.getClass());
    }

    public LCObject(String className) {
        Transformer.checkClassName(className);
        this.className = className;
    }

    public LCObject(LCObject other) {
        this.className = other.className;
        this.objectId = other.objectId;
        this.serverData.putAll(other.serverData);
        this.operations.putAll(other.operations);
        this.acl = other.acl;
        this.endpointClassName = other.endpointClassName;
    }

    public String getClassName() {
        return this.className;
    }

    public String internalClassName() {
        return this.getClassName();
    }

    public void setClassName(String name) {
        Transformer.checkClassName(name);
        this.className = name;
    }

    public Date getCreatedAt() {
        String value = this.getCreatedAtString();
        return StringUtil.dateFromString(value);
    }

    public String getCreatedAtString() {
        return (String)this.serverData.get(KEY_CREATED_AT);
    }

    public Date getUpdatedAt() {
        String value = this.getUpdatedAtString();
        return StringUtil.dateFromString(value);
    }

    public String getUpdatedAtString() {
        return (String)this.serverData.get(KEY_UPDATED_AT);
    }

    public String getObjectId() {
        if (this.serverData.containsKey(KEY_OBJECT_ID)) {
            return (String)this.serverData.get(KEY_OBJECT_ID);
        }
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
        if (null != this.serverData && !StringUtil.isEmpty(objectId)) {
            this.serverData.put(KEY_OBJECT_ID, objectId);
        }
    }

    public boolean isFetchWhenSave() {
        return this.fetchWhenSave;
    }

    public void setFetchWhenSave(boolean fetchWhenSave) {
        this.fetchWhenSave = fetchWhenSave;
    }

    public String getUuid() {
        if (StringUtil.isEmpty(this.uuid)) {
            this.uuid = UUID.randomUUID().toString().toLowerCase();
        }
        return this.uuid;
    }

    void setUuid(String uuid) {
        this.uuid = uuid;
    }

    protected static boolean verifyInternalId(String internalId) {
        return Pattern.matches(INTERNAL_PATTERN, internalId);
    }

    protected String internalId() {
        return StringUtil.isEmpty(this.getObjectId()) ? this.getUuid() : this.getObjectId();
    }

    public boolean containsKey(String key) {
        return this.serverData.containsKey(key);
    }

    public boolean has(String key) {
        return this.get(key) != null;
    }

    public Object get(String key) {
        return this.internalGet(key);
    }

    protected Object internalGet(String key) {
        Object value = this.serverData.get(key);
        ObjectFieldOperation op = (ObjectFieldOperation)this.operations.get(key);
        if (null != op) {
            value = op.apply(value);
        }
        return value;
    }

    public boolean getBoolean(String key) {
        Boolean b = (Boolean)this.get(key);
        return b == null ? false : b;
    }

    public byte[] getBytes(String key) {
        return (byte[])this.get(key);
    }

    public Date getDate(String key) {
        Object res = this.get(key);
        if (res instanceof Date) {
            return (Date)res;
        }
        if (res instanceof Long) {
            return new Date((Long)res);
        }
        if (res instanceof String) {
            return StringUtil.dateFromString((String)res);
        }
        if (res instanceof JSONObject) {
            return new LCDate((JSONObject)res).getDate();
        }
        if (res instanceof Map) {
            JSONObject json = JSONObject.Builder.create((Map)res);
            return new LCDate(json).getDate();
        }
        return null;
    }

    public String getString(String key) {
        Object obj = this.get(key);
        if (obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    public int getInt(String key) {
        Number v = (Number)this.get(key);
        if (v != null) {
            return v.intValue();
        }
        return 0;
    }

    public long getLong(String key) {
        Number v = (Number)this.get(key);
        if (v != null) {
            return v.longValue();
        }
        return 0L;
    }

    public double getDouble(String key) {
        Number number = (Number)this.get(key);
        if (number != null) {
            return number.doubleValue();
        }
        return 0.0;
    }

    public Number getNumber(String key) {
        return (Number)this.get(key);
    }

    public List getList(String key) {
        return (List)this.get(key);
    }

    public JSONArray getJSONArray(String key) {
        Object list = this.get(key);
        if (list == null) {
            return null;
        }
        if (list instanceof JSONArray) {
            return (JSONArray)list;
        }
        if (list instanceof List) {
            return JSONArray.Builder.create((List)list);
        }
        if (list instanceof Object[]) {
            JSONArray array = JSONArray.Builder.create(null);
            for (Object obj : (Object[])list) {
                array.add(obj);
            }
            return array;
        }
        return null;
    }

    public JSONObject getJSONObject(String key) {
        Object object = this.get(key);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        String jsonString = JSON.toJSONString(object);
        JSONObject jsonObject = null;
        try {
            jsonObject = JSON.parseObject(jsonString);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Invalid json string", exception);
        }
        return jsonObject;
    }

    public LCGeoPoint getLCGeoPoint(String key) {
        return (LCGeoPoint)this.get(key);
    }

    public LCFile getLCFile(String key) {
        return (LCFile)this.get(key);
    }

    public <T extends LCObject> T getLCObject(String key) {
        try {
            return (T)((LCObject)this.get(key));
        }
        catch (Exception ex) {
            logger.w("failed to convert Object.", ex);
            return null;
        }
    }

    public <T extends LCObject> LCRelation<T> getRelation(String key) {
        this.validFieldName(key);
        Object object = this.get(key);
        if (object instanceof LCRelation) {
            ((LCRelation)object).setParent(this);
            ((LCRelation)object).setKey(key);
            return (LCRelation)object;
        }
        return new LCRelation(this, key);
    }

    void addRelation(LCObject object, String key) {
        this.validFieldName(key);
        BaseOperation op = OperationBuilder.gBuilder.create(OperationBuilder.OperationType.AddRelation, key, object);
        this.addNewOperation(op);
    }

    void removeRelation(LCObject object, String key) {
        this.validFieldName(key);
        BaseOperation op = OperationBuilder.gBuilder.create(OperationBuilder.OperationType.RemoveRelation, key, object);
        this.addNewOperation(op);
    }

    public ConcurrentMap<String, Object> getServerData() {
        return this.serverData;
    }

    protected void validFieldName(String key) {
        if (StringUtil.isEmpty(key)) {
            throw new IllegalArgumentException("Blank key");
        }
        if (key.startsWith("_")) {
            throw new IllegalArgumentException("key should not start with '_'");
        }
        if (RESERVED_ATTRS.contains(key)) {
            throw new IllegalArgumentException("key(" + key + ") is reserved by LeanCloud");
        }
    }

    public boolean isDataAvailable() {
        return !StringUtil.isEmpty(this.objectId) && !this.serverData.isEmpty();
    }

    public void add(String key, Object value) {
        this.validFieldName(key);
        BaseOperation op = OperationBuilder.gBuilder.create(OperationBuilder.OperationType.Add, key, value);
        this.addNewOperation(op);
    }

    public void addAll(String key, Collection<?> values) {
        this.validFieldName(key);
        BaseOperation op = OperationBuilder.gBuilder.create(OperationBuilder.OperationType.Add, key, values);
        this.addNewOperation(op);
    }

    public void addUnique(String key, Object value) {
        this.validFieldName(key);
        BaseOperation op = OperationBuilder.gBuilder.create(OperationBuilder.OperationType.AddUnique, key, value);
        this.addNewOperation(op);
    }

    public void addAllUnique(String key, Collection<?> values) {
        this.validFieldName(key);
        BaseOperation op = OperationBuilder.gBuilder.create(OperationBuilder.OperationType.AddUnique, key, values);
        this.addNewOperation(op);
    }

    public void put(String key, Object value) {
        this.validFieldName(key);
        if (null == value) {
            return;
        }
        this.internalPut(key, value);
    }

    protected void internalPut(String key, Object value) {
        BaseOperation op = OperationBuilder.gBuilder.create(OperationBuilder.OperationType.Set, key, value);
        this.addNewOperation(op);
    }

    public void remove(String key) {
        this.validFieldName(key);
        BaseOperation op = OperationBuilder.gBuilder.create(OperationBuilder.OperationType.Delete, key, null);
        this.addNewOperation(op);
    }

    public void removeAll(String key, Collection<?> values) {
        this.validFieldName(key);
        BaseOperation op = OperationBuilder.gBuilder.create(OperationBuilder.OperationType.Remove, key, values);
        this.addNewOperation(op);
    }

    public void increment(String key) {
        this.increment(key, 1);
    }

    public void increment(String key, Number value) {
        this.validFieldName(key);
        BaseOperation op = OperationBuilder.gBuilder.create(OperationBuilder.OperationType.Increment, key, value);
        this.addNewOperation(op);
    }

    public void decrement(String key) {
        this.decrement(key, 1);
    }

    public void decrement(String key, Number value) {
        this.validFieldName(key);
        BaseOperation op = OperationBuilder.gBuilder.create(OperationBuilder.OperationType.Decrement, key, value);
        this.addNewOperation(op);
    }

    public void bitAnd(String key, long value) {
        this.validFieldName(key);
        BaseOperation op = OperationBuilder.gBuilder.create(OperationBuilder.OperationType.BitAnd, key, value);
        this.addNewOperation(op);
    }

    public void bitOr(String key, long value) {
        this.validFieldName(key);
        BaseOperation op = OperationBuilder.gBuilder.create(OperationBuilder.OperationType.BitOr, key, value);
        this.addNewOperation(op);
    }

    public void bitXor(String key, long value) {
        this.validFieldName(key);
        BaseOperation op = OperationBuilder.gBuilder.create(OperationBuilder.OperationType.BitXor, key, value);
        this.addNewOperation(op);
    }

    public void abortOperations() {
        if (this.totallyOverwrite) {
            logger.w("Can't abort modify operations under TotalOverWrite mode.");
        }
        this.operations.clear();
    }

    protected void removeOperationForKey(String key) {
        this.operations.remove(key);
    }

    protected void addNewOperation(ObjectFieldOperation op) {
        if (null == op) {
            return;
        }
        if (this.totallyOverwrite) {
            if ("Delete".equalsIgnoreCase(op.getOperation())) {
                this.serverData.remove(op.getField());
            } else {
                Object oldValue = this.serverData.get(op.getField());
                Object newValue = op.apply(oldValue);
                if (null == newValue) {
                    this.serverData.remove(op.getField());
                } else {
                    this.serverData.put(op.getField(), newValue);
                }
            }
        } else {
            ObjectFieldOperation previous = null;
            if (this.operations.containsKey(op.getField())) {
                previous = (ObjectFieldOperation)this.operations.get(op.getField());
            }
            this.operations.put(op.getField(), op.merge(previous));
        }
    }

    private boolean needBatchMode() {
        for (ObjectFieldOperation op : this.operations.values()) {
            if (!(op instanceof CompoundOperation)) continue;
            return true;
        }
        return false;
    }

    protected JSONObject generateChangedParam() {
        LCACL serverACL;
        if (this.totallyOverwrite) {
            HashMap<String, Object> tmp = new HashMap<String, Object>();
            for (Map.Entry entry : this.serverData.entrySet()) {
                String key = (String)entry.getKey();
                Object val = entry.getValue();
                tmp.put(key, BaseOperation.encodeObject(val));
            }
            tmp.remove(KEY_CREATED_AT);
            tmp.remove(KEY_UPDATED_AT);
            tmp.remove(KEY_OBJECT_ID);
            if (this.ignoreHooks.size() > 0) {
                tmp.put(KEY_IGNORE_HOOKS, this.ignoreHooks);
            }
            return JSONObject.Builder.create(tmp);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        Set entries = this.operations.entrySet();
        for (Map.Entry entry : entries) {
            Map<String, Object> oneOp = ((ObjectFieldOperation)entry.getValue()).encode();
            params.putAll(oneOp);
        }
        if (null != this.acl && !this.acl.equals(serverACL = this.generateACLFromServerData())) {
            BaseOperation op = OperationBuilder.gBuilder.create(OperationBuilder.OperationType.Set, KEY_ACL, this.acl);
            params.putAll(op.encode());
        }
        if (this.ignoreHooks.size() > 0) {
            params.put(KEY_IGNORE_HOOKS, this.ignoreHooks);
        }
        if (!this.needBatchMode()) {
            return JSONObject.Builder.create(params);
        }
        ArrayList<Map<String, Object>> finalParams = new ArrayList<Map<String, Object>>();
        Map<String, Object> topParams = Utils.makeCompletedRequest(this.getObjectId(), this.getRequestRawEndpoint(), this.getRequestMethod(), params);
        if (null != topParams) {
            finalParams.add(topParams);
        }
        for (ObjectFieldOperation ops : this.operations.values()) {
            List<Map<String, Object>> restParams;
            if (!(ops instanceof CompoundOperation) || null == (restParams = ((CompoundOperation)ops).encodeRestOp(this)) || restParams.isEmpty()) continue;
            finalParams.addAll(restParams);
        }
        HashMap<String, Object> finalResult = new HashMap<String, Object>(1);
        finalResult.put("requests", finalParams);
        return JSONObject.Builder.create(finalResult);
    }

    protected List<LCObject> extractCascadingObjects(Object o) {
        ArrayList<LCObject> result = new ArrayList<LCObject>();
        if (o instanceof LCObject && StringUtil.isEmpty(((LCObject)o).getObjectId())) {
            result.add((LCObject)o);
        } else if (o instanceof Collection) {
            for (Object secondO : ((Collection)o).toArray()) {
                List<LCObject> tmp = this.extractCascadingObjects(secondO);
                if (null == tmp || tmp.isEmpty()) continue;
                result.addAll(tmp);
            }
        }
        return result;
    }

    protected Observable<List<LCObject>> generateCascadingSaveObjects() {
        ArrayList<LCObject> result = new ArrayList<LCObject>();
        for (ObjectFieldOperation ofo : this.operations.values()) {
            List<LCObject> operationValues = this.extractCascadingObjects(ofo.getValue());
            if (null == operationValues || operationValues.isEmpty()) continue;
            result.addAll(operationValues);
        }
        return Observable.just(result).subscribeOn(Schedulers.io());
    }

    protected List<LCFile> extractUnsavedFiles(Object o) {
        ArrayList<LCFile> result = new ArrayList<LCFile>();
        if (o instanceof LCFile && StringUtil.isEmpty(((LCFile)o).getObjectId())) {
            result.add((LCFile)o);
        } else if (o instanceof Collection) {
            for (Object secondTmp : ((Collection)o).toArray()) {
                List<LCFile> tmp = this.extractUnsavedFiles(secondTmp);
                if (null == tmp || tmp.isEmpty()) continue;
                result.addAll(tmp);
            }
        }
        return result;
    }

    protected List<LCFile> getUnsavedFiles() {
        ArrayList<LCFile> result = new ArrayList<LCFile>();
        for (ObjectFieldOperation ofo : this.operations.values()) {
            List<LCFile> unsavedFiles = this.extractUnsavedFiles(ofo.getValue());
            if (null == unsavedFiles || unsavedFiles.isEmpty()) continue;
            result.addAll(unsavedFiles);
        }
        return result;
    }

    protected void onSaveSuccess() {
        this.operations.clear();
    }

    protected void onSaveFailure() {
    }

    protected void onDataSynchronized() {
    }

    private Observable<? extends LCObject> saveSelfOperations(LCUser asAuthenticatedUser, LCSaveOption option) {
        String currentClass;
        boolean needFetch;
        boolean bl = needFetch = null != option ? option.fetchWhenSave : this.isFetchWhenSave();
        if (null != option && null != option.matchQuery && !StringUtil.isEmpty(currentClass = this.getClassName()) && !currentClass.equals(option.matchQuery.getClassName())) {
            return Observable.error((Throwable)new LCException(0, "AVObject class inconsistant with AVQuery in AVSaveOption"));
        }
        JSONObject paramData = this.generateChangedParam();
        logger.d("saveObject param: " + paramData.toJSONString());
        final String currentObjectId = this.getObjectId();
        if (this.needBatchMode()) {
            logger.w("Caution: batch mode will ignore fetchWhenSave flag and matchQuery.");
            if (StringUtil.isEmpty(currentObjectId)) {
                logger.d("request payload: " + paramData.toJSONString());
                return PaasClient.getStorageClient().batchSave(asAuthenticatedUser, paramData).map((Function)new Function<List<Map<String, Object>>, LCObject>(){

                    public LCObject apply(List<Map<String, Object>> object) throws Exception {
                        if (null != object && !object.isEmpty()) {
                            logger.d("batchSave result: " + object.toString());
                            Map<String, Object> lastResult = object.get(object.size() - 1);
                            if (null != lastResult) {
                                LCUtils.mergeConcurrentMap(LCObject.this.serverData, lastResult);
                                LCObject.this.onSaveSuccess();
                            }
                        }
                        return LCObject.this;
                    }
                });
            }
            return PaasClient.getStorageClient().batchUpdate(asAuthenticatedUser, paramData).map((Function)new Function<JSONObject, LCObject>(){

                public LCObject apply(JSONObject object) throws Exception {
                    if (null != object) {
                        logger.d("batchUpdate result: " + object.toJSONString());
                        Map lastResult = object.getObject(currentObjectId, Map.class);
                        if (null != lastResult) {
                            LCUtils.mergeConcurrentMap(LCObject.this.serverData, lastResult);
                            LCObject.this.onSaveSuccess();
                        }
                    }
                    return LCObject.this;
                }
            });
        }
        JSONObject whereCondition = null;
        if (null != option && null != option.matchQuery) {
            Map<String, Object> whereConditionMap = option.matchQuery.conditions.compileWhereOperationMap();
            whereCondition = JSONObject.Builder.create(whereConditionMap);
        }
        if (this.totallyOverwrite) {
            return PaasClient.getStorageClient().saveWholeObject(asAuthenticatedUser, this.getClass(), this.endpointClassName, currentObjectId, paramData, needFetch, whereCondition).map((Function)new Function<LCObject, LCObject>(){

                public LCObject apply(LCObject LCObject2) throws Exception {
                    LCObject.this.mergeRawData(LCObject2, needFetch);
                    LCObject.this.onSaveSuccess();
                    return LCObject.this;
                }
            });
        }
        if (StringUtil.isEmpty(currentObjectId)) {
            return PaasClient.getStorageClient().createObject(asAuthenticatedUser, this.className, paramData, needFetch, whereCondition).map((Function)new Function<LCObject, LCObject>(){

                public LCObject apply(LCObject LCObject2) throws Exception {
                    LCObject.this.mergeRawData(LCObject2, needFetch);
                    LCObject.this.onSaveSuccess();
                    return LCObject.this;
                }
            });
        }
        return PaasClient.getStorageClient().saveObject(asAuthenticatedUser, this.className, this.getObjectId(), paramData, needFetch, whereCondition).map((Function)new Function<LCObject, LCObject>(){

            public LCObject apply(LCObject LCObject2) throws Exception {
                LCObject.this.mergeRawData(LCObject2, needFetch);
                LCObject.this.onSaveSuccess();
                return LCObject.this;
            }
        });
    }

    public Observable<? extends LCObject> saveInBackground() {
        LCUser targetUser = null;
        return this.saveInBackground(targetUser);
    }

    public Observable<? extends LCObject> saveInBackground(LCUser asAuthenticatedUser) {
        LCSaveOption option = null;
        if (this.totallyOverwrite) {
            option = new LCSaveOption();
            option.setFetchWhenSave(true);
        }
        return this.saveInBackground(asAuthenticatedUser, option);
    }

    public Observable<? extends LCObject> saveInBackground(LCSaveOption option) {
        return this.saveInBackground(null, option);
    }

    public Observable<? extends LCObject> saveInBackground(final LCUser asAuthenticatedUser, final LCSaveOption option) {
        HashMap<LCObject, Boolean> markMap = new HashMap<LCObject, Boolean>();
        if (this.hasCircleReference(markMap)) {
            return Observable.error((Throwable)new LCException(100001, "Found a circular dependency when saving."));
        }
        Observable<List<LCObject>> needSaveFirstly = this.generateCascadingSaveObjects();
        return needSaveFirstly.flatMap((Function)new Function<List<LCObject>, Observable<? extends LCObject>>(){

            public Observable<? extends LCObject> apply(List<LCObject> objects) throws Exception {
                logger.d("First, try to execute save operations in thread: " + Thread.currentThread());
                for (LCObject o : objects) {
                    o.save(asAuthenticatedUser);
                }
                logger.d("Second, save object itself...");
                return LCObject.this.saveSelfOperations(asAuthenticatedUser, option);
            }
        });
    }

    public boolean hasCircleReference(Map<LCObject, Boolean> markMap) {
        if (null == markMap) {
            return false;
        }
        markMap.put(this, true);
        boolean rst = false;
        for (ObjectFieldOperation op : this.operations.values()) {
            rst = rst || op.checkCircleReference(markMap);
        }
        return rst;
    }

    public void save() {
        this.save(null);
    }

    public void save(LCUser asAuthenticatedUser) {
        this.saveInBackground(asAuthenticatedUser).blockingSubscribe();
    }

    public static void saveAll(Collection<? extends LCObject> objects) throws LCException {
        LCObject.saveAll(null, objects);
    }

    public static void saveAll(LCUser asAuthenticatedUser, Collection<? extends LCObject> objects) throws LCException {
        LCObject.saveAllInBackground(asAuthenticatedUser, objects).blockingSubscribe();
    }

    private static Observable<List<LCFile>> extractSaveAheadFiles(Collection<? extends LCObject> objects) {
        ArrayList<LCFile> needSaveAheadFiles = new ArrayList<LCFile>();
        for (LCObject lCObject : objects) {
            List<LCFile> cascadingSaveFiles = lCObject.getUnsavedFiles();
            if (null == cascadingSaveFiles || cascadingSaveFiles.isEmpty()) continue;
            needSaveAheadFiles.addAll(cascadingSaveFiles);
        }
        return Observable.just(needSaveAheadFiles).subscribeOn(Schedulers.io());
    }

    public static Observable<JSONArray> saveAllInBackground(Collection<? extends LCObject> objects) {
        return LCObject.saveAllInBackground(null, objects);
    }

    public static Observable<JSONArray> saveAllInBackground(final LCUser asAuthenticatedUser, final Collection<? extends LCObject> objects) {
        if (null == objects || objects.isEmpty()) {
            JSONArray emptyResult = JSONArray.Builder.create(null);
            return Observable.just((Object)emptyResult);
        }
        for (LCObject lCObject : objects) {
            HashMap<LCObject, Boolean> markMap;
            if (!lCObject.hasCircleReference(markMap = new HashMap<LCObject, Boolean>())) continue;
            return Observable.error((Throwable)new LCException(100001, "Found a circular dependency when saving."));
        }
        Observable<List<LCFile>> aHeadStage = LCObject.extractSaveAheadFiles(objects);
        return aHeadStage.flatMap((Function)new Function<List<LCFile>, ObservableSource<JSONArray>>(){

            public ObservableSource<JSONArray> apply(List<LCFile> avFiles) throws Exception {
                logger.d("begin to save objects with batch mode...");
                if (null != avFiles && !avFiles.isEmpty()) {
                    for (LCFile lCFile : avFiles) {
                        lCFile.save(asAuthenticatedUser);
                    }
                }
                JSONArray requests = JSONArray.Builder.create(null);
                for (LCObject o : objects) {
                    JSONObject requestBody = o.generateChangedParam();
                    JSONObject objectRequest = JSONObject.Builder.create(null);
                    objectRequest.put("method", o.getRequestMethod());
                    objectRequest.put("path", o.getRequestRawEndpoint());
                    objectRequest.put("body", requestBody);
                    requests.add(objectRequest);
                }
                JSONObject jSONObject = JSONObject.Builder.create(null);
                jSONObject.put("requests", requests);
                return PaasClient.getStorageClient().batchSave(asAuthenticatedUser, jSONObject).map((Function)new Function<List<Map<String, Object>>, JSONArray>(){

                    public JSONArray apply(List<Map<String, Object>> batchResults) throws Exception {
                        JSONArray result = JSONArray.Builder.create(null);
                        if (null != batchResults && objects.size() == batchResults.size()) {
                            logger.d("batchSave result: " + batchResults.toString());
                            Iterator it = objects.iterator();
                            for (int i = 0; i < batchResults.size() && it.hasNext(); ++i) {
                                JSONObject oneResult = JSONObject.Builder.create(batchResults.get(i));
                                LCObject originObject = (LCObject)it.next();
                                if (oneResult.containsKey("success")) {
                                    LCUtils.mergeConcurrentMap(originObject.serverData, oneResult.getJSONObject("success").getInnerMap());
                                    originObject.onSaveSuccess();
                                } else if (oneResult.containsKey("error")) {
                                    originObject.onSaveFailure();
                                }
                                result.add(oneResult);
                            }
                        }
                        return result;
                    }
                });
            }
        });
    }

    public void saveEventually() throws LCException {
        this.saveEventually(null);
    }

    public void saveEventually(LCUser asAuthenticatedUser) throws LCException {
        if (this.operations.isEmpty()) {
            return;
        }
        HashMap<LCObject, Boolean> markMap = new HashMap<LCObject, Boolean>();
        if (this.hasCircleReference(markMap)) {
            throw new LCException(100001, "Found a circular dependency when saving.");
        }
        NetworkingDetector detector = AppConfiguration.getGlobalNetworkingDetector();
        if (null != detector && detector.isConnected()) {
            this.saveInBackground(asAuthenticatedUser).subscribe((Observer)new Observer<LCObject>(){

                public void onSubscribe(Disposable disposable) {
                }

                public void onNext(LCObject LCObject2) {
                    logger.d("succeed to save directly");
                }

                public void onError(Throwable throwable) {
                    LCObject.this.add2ArchivedRequest(false);
                }

                public void onComplete() {
                }
            });
        } else {
            this.add2ArchivedRequest(false);
        }
    }

    private void add2ArchivedRequest(boolean isDelete) {
        ArchivedRequests requests = ArchivedRequests.getInstance();
        if (isDelete) {
            requests.deleteEventually(this);
        } else {
            requests.saveEventually(this);
        }
    }

    public void deleteEventually() {
        this.deleteEventually(null);
    }

    public void deleteEventually(LCUser asAuthenticatedUser) {
        String objectId = this.getObjectId();
        if (StringUtil.isEmpty(objectId)) {
            logger.w("objectId is empty, you couldn't delete a persistent object.");
            return;
        }
        NetworkingDetector detector = AppConfiguration.getGlobalNetworkingDetector();
        if (null != detector && detector.isConnected()) {
            this.deleteInBackground(asAuthenticatedUser).subscribe((Observer)new Observer<LCNull>(){

                public void onSubscribe(Disposable disposable) {
                }

                public void onNext(LCNull LCNull2) {
                    logger.d("succeed to delete directly.");
                }

                public void onError(Throwable throwable) {
                    LCObject.this.add2ArchivedRequest(true);
                }

                public void onComplete() {
                }
            });
        } else {
            this.add2ArchivedRequest(true);
        }
    }

    public Observable<LCNull> deleteInBackground() {
        return this.deleteInBackground(null);
    }

    public Observable<LCNull> deleteInBackground(LCUser asAuthenticatedUser) {
        HashMap<String, Object> ignoreParam = new HashMap<String, Object>();
        if (this.ignoreHooks.size() > 0) {
            ignoreParam.put(KEY_IGNORE_HOOKS, this.ignoreHooks);
        }
        if (this.totallyOverwrite) {
            return PaasClient.getStorageClient().deleteWholeObject(asAuthenticatedUser, this.endpointClassName, this.getObjectId(), ignoreParam);
        }
        return PaasClient.getStorageClient().deleteObject(asAuthenticatedUser, this.className, this.getObjectId(), ignoreParam);
    }

    public void delete() {
        this.delete(null);
    }

    public void delete(LCUser asAuthenticatedUser) {
        this.deleteInBackground(asAuthenticatedUser).blockingSubscribe();
    }

    public static void deleteAll(Collection<? extends LCObject> objects) throws LCException {
        LCObject.deleteAll(null, objects);
    }

    public static void deleteAll(LCUser asAuthenticatedUser, Collection<? extends LCObject> objects) throws LCException {
        LCObject.deleteAllInBackground(asAuthenticatedUser, objects).blockingSubscribe();
    }

    public static Observable<LCNull> deleteAllInBackground(Collection<? extends LCObject> objects) {
        return LCObject.deleteAllInBackground(null, objects);
    }

    public static Observable<LCNull> deleteAllInBackground(LCUser asAuthenticatedUser, Collection<? extends LCObject> objects) {
        if (null == objects || objects.isEmpty()) {
            return Observable.just((Object)LCNull.getINSTANCE());
        }
        String className = null;
        HashMap<String, Object> ignoreParams = new HashMap<String, Object>();
        StringBuilder sb = new StringBuilder();
        for (LCObject lCObject : objects) {
            if (StringUtil.isEmpty(lCObject.getObjectId()) || StringUtil.isEmpty(lCObject.getClassName())) {
                return Observable.error((Throwable)new IllegalArgumentException("Invalid AVObject, the class name or objectId is blank."));
            }
            if (className == null) {
                className = lCObject.getClassName();
                sb.append(lCObject.getObjectId());
                continue;
            }
            if (className.equals(lCObject.getClassName())) {
                sb.append(",").append(lCObject.getObjectId());
                continue;
            }
            return Observable.error((Throwable)new IllegalArgumentException("The objects class name must be the same."));
        }
        return PaasClient.getStorageClient().deleteObject(asAuthenticatedUser, className, sb.toString(), ignoreParams);
    }

    public void refresh() {
        this.refresh(null);
    }

    public void refresh(String includeKeys) {
        this.refreshInBackground(includeKeys).blockingSubscribe();
    }

    public void refresh(LCUser asAuthenticatedUser, String includeKeys) {
        this.refreshInBackground(asAuthenticatedUser, includeKeys).blockingSubscribe();
    }

    public Observable<LCObject> refreshInBackground() {
        return this.refreshInBackground(null, null);
    }

    public Observable<LCObject> refreshInBackground(LCUser asAuthenticatedUser) {
        return this.refreshInBackground(asAuthenticatedUser, null);
    }

    public Observable<LCObject> refreshInBackground(String includeKeys) {
        return this.refreshInBackground(null, includeKeys);
    }

    public Observable<LCObject> refreshInBackground(LCUser asAuthenticatedUser, final String includeKeys) {
        if (this.totallyOverwrite) {
            return PaasClient.getStorageClient().getWholeObject(asAuthenticatedUser, this.endpointClassName, this.getObjectId(), includeKeys).map((Function)new Function<LCObject, LCObject>(){

                public LCObject apply(LCObject LCObject2) throws Exception {
                    LCObject.this.serverData.clear();
                    LCObject.this.serverData.putAll(LCObject2.serverData);
                    LCObject.this.onDataSynchronized();
                    return LCObject.this;
                }
            });
        }
        return PaasClient.getStorageClient().fetchObject(asAuthenticatedUser, this.className, this.getObjectId(), includeKeys).map((Function)new Function<LCObject, LCObject>(){

            public LCObject apply(LCObject LCObject2) throws Exception {
                if (StringUtil.isEmpty(includeKeys)) {
                    if (LCObject.this.className.equals("_User") || LCObject.this instanceof LCUser) {
                        Object userSessionToken = LCObject.this.serverData.get("sessionToken");
                        LCObject.this.serverData.clear();
                        if (null != userSessionToken) {
                            LCObject.this.serverData.put("sessionToken", userSessionToken);
                        }
                    } else {
                        LCObject.this.serverData.clear();
                    }
                }
                LCObject.this.serverData.putAll(LCObject2.serverData);
                LCObject.this.onDataSynchronized();
                return LCObject.this;
            }
        });
    }

    public LCObject fetch() {
        return this.fetch(null);
    }

    public LCObject fetch(String includeKeys) {
        return this.fetch(null, includeKeys);
    }

    public LCObject fetch(LCUser asAuthenticatedUser, String includeKeys) {
        this.refresh(asAuthenticatedUser, includeKeys);
        return this;
    }

    public Observable<LCObject> fetchInBackground() {
        return this.refreshInBackground();
    }

    public Observable<LCObject> fetchInBackground(String includeKeys) {
        return this.fetchInBackground(null, includeKeys);
    }

    public Observable<LCObject> fetchInBackground(LCUser asAuthenticatedUser, String includeKeys) {
        return this.refreshInBackground(asAuthenticatedUser, includeKeys);
    }

    public Observable<LCObject> fetchIfNeededInBackground() {
        if (!StringUtil.isEmpty(this.getObjectId()) && this.serverData.size() > 1) {
            return Observable.just((Object)this);
        }
        return this.refreshInBackground();
    }

    public Observable<LCObject> fetchIfNeededInBackground(String includeKeys) {
        return this.fetchIfNeededInBackground(null, includeKeys);
    }

    public Observable<LCObject> fetchIfNeededInBackground(LCUser asAuthenticatedUser, String includeKeys) {
        if (!StringUtil.isEmpty(this.getObjectId()) && this.serverData.size() > 1) {
            return Observable.just((Object)this);
        }
        return this.refreshInBackground(asAuthenticatedUser, includeKeys);
    }

    public LCObject fetchIfNeeded() {
        this.fetchIfNeededInBackground().blockingSubscribe();
        return this;
    }

    protected void resetAll() {
        this.objectId = "";
        this.acl = null;
        this.serverData.clear();
        this.operations.clear();
    }

    protected void resetByRawData(LCObject LCObject2) {
        this.resetAll();
        if (null != LCObject2) {
            this.serverData.putAll(LCObject2.serverData);
            this.operations.putAll(LCObject2.operations);
        }
    }

    void mergeRawData(LCObject LCObject2, boolean fetchServerData) {
        if (null != LCObject2) {
            this.serverData.putAll(LCObject2.serverData);
        }
        if (!fetchServerData && AppConfiguration.isAutoMergeOperationDataWhenSave()) {
            for (Map.Entry entry : this.operations.entrySet()) {
                String attribute = (String)entry.getKey();
                Object value = this.internalGet(attribute);
                if (null == value) {
                    this.serverData.remove(attribute);
                    continue;
                }
                this.serverData.put(attribute, value);
            }
        }
    }

    public void resetServerData(Map<String, Object> data) {
        this.serverData.clear();
        LCUtils.mergeConcurrentMap(this.serverData, data);
        this.operations.clear();
    }

    public String getRequestRawEndpoint() {
        if (StringUtil.isEmpty(this.getObjectId())) {
            return "/1.1/classes/" + this.getClassName();
        }
        return "/1.1/classes/" + this.getClassName() + "/" + this.getObjectId();
    }

    public String getRequestMethod() {
        if (StringUtil.isEmpty(this.getObjectId())) {
            return "POST";
        }
        return "PUT";
    }

    public static <T extends LCObject> void registerSubclass(Class<T> clazz) {
        Transformer.registerClass(clazz);
    }

    public synchronized LCACL getACL() {
        if (null == this.acl) {
            this.acl = this.generateACLFromServerData();
        }
        return this.acl;
    }

    public synchronized void setACL(LCACL acl) {
        this.acl = acl;
    }

    protected LCACL generateACLFromServerData() {
        if (!this.serverData.containsKey(KEY_ACL)) {
            return new LCACL();
        }
        Object aclMap = this.serverData.get(KEY_ACL);
        if (aclMap instanceof HashMap) {
            return new LCACL((HashMap)aclMap);
        }
        return new LCACL();
    }

    public static <T extends LCObject> LCQuery<T> getQuery(Class<T> clazz) {
        return new LCQuery<T>(Transformer.getSubClassName(clazz), clazz);
    }

    public JSONObject toJSONObject() {
        return JSONObject.Builder.create(this.serverData);
    }

    public String toJSONString() {
        return JSON.toJSONString(this);
    }

    public static LCObject parseLCObject(String objectString) {
        if (StringUtil.isEmpty(objectString)) {
            return null;
        }
        objectString = objectString.replaceAll("^\\{\\s*\"@type\":\\s*\"[A-Za-z\\.]+\",", "{");
        objectString = objectString.replaceAll("\"@type\":\\s*\"com.avos.avoscloud.AVObject\",", "\"@type\":\"cn.leancloud.LCObject\",");
        objectString = objectString.replaceAll("\"@type\":\\s*\"com.avos.avoscloud.AVInstallation\",", "\"@type\":\"cn.leancloud.LCInstallation\",");
        objectString = objectString.replaceAll("\"@type\":\\s*\"com.avos.avoscloud.AVUser\",", "\"@type\":\"cn.leancloud.LCUser\",");
        objectString = objectString.replaceAll("\"@type\":\\s*\"com.avos.avoscloud.AVStatus\",", "\"@type\":\"cn.leancloud.LCStatus\",");
        objectString = objectString.replaceAll("\"@type\":\\s*\"com.avos.avoscloud.AVRole\",", "\"@type\":\"cn.leancloud.LCRole\",");
        objectString = objectString.replaceAll("\"@type\":\\s*\"com.avos.avoscloud.AVFile\",", "\"@type\":\"cn.leancloud.LCFile\",");
        objectString = objectString.replaceAll("\"@type\":\\s*\"com.avos.avoscloud.ops.[A-Za-z]+Op\",", "");
        objectString = StringUtil.replaceFastjsonDateForm(objectString);
        return JSON.parseObject(objectString, LCObject.class);
    }

    public static LCObject createWithoutData(String className, String objectId) {
        LCObject object = new LCObject(className);
        object.setObjectId(objectId);
        return object;
    }

    public static <T extends LCObject> T createWithoutData(Class<T> clazz, String objectId) throws LCException {
        try {
            LCObject obj = (LCObject)clazz.newInstance();
            obj.setClassName(Transformer.getSubClassName(clazz));
            obj.setObjectId(objectId);
            return (T)obj;
        }
        catch (Exception ex) {
            throw new LCException(ex);
        }
    }

    public void disableBeforeHook() {
        Collections.addAll(this.ignoreHooks, Hook.beforeSave, Hook.beforeUpdate, Hook.beforeDelete);
    }

    public void disableAfterHook() {
        Collections.addAll(this.ignoreHooks, Hook.afterSave, Hook.afterUpdate, Hook.afterDelete);
    }

    public void ignoreHook(Hook hook) {
        this.ignoreHooks.add(hook);
    }

    protected static <T extends LCObject> T cast(LCObject object, Class<T> clazz) throws Exception {
        if (clazz.getClass().isAssignableFrom(object.getClass())) {
            return (T)object;
        }
        LCObject newItem = (LCObject)clazz.newInstance();
        newItem.className = object.className;
        newItem.objectId = object.objectId;
        newItem.serverData.putAll(object.serverData);
        newItem.operations.putAll(object.operations);
        newItem.acl = object.acl;
        newItem.endpointClassName = object.endpointClassName;
        return (T)newItem;
    }

    public String toString() {
        return this.toJSONString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LCObject)) {
            return false;
        }
        LCObject LCObject2 = (LCObject)o;
        return this.isFetchWhenSave() == LCObject2.isFetchWhenSave() && Objects.equals(this.getClassName(), LCObject2.getClassName()) && Objects.equals(this.getServerData(), LCObject2.getServerData()) && Objects.equals(this.operations, LCObject2.operations) && Objects.equals(this.acl, LCObject2.acl);
    }

    public int hashCode() {
        return Objects.hash(this.getClassName(), this.getServerData(), this.operations, this.acl, this.isFetchWhenSave());
    }

    public static enum Hook {
        beforeSave,
        afterSave,
        beforeUpdate,
        afterUpdate,
        beforeDelete,
        afterDelete;

    }
}

