/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.upload;

import cn.leancloud.AVException;
import cn.leancloud.AVFile;
import cn.leancloud.AVLogger;
import cn.leancloud.callback.ProgressCallback;
import cn.leancloud.network.DNSDetoxicant;
import cn.leancloud.upload.Uploader;
import cn.leancloud.utils.LogUtil;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Dns;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public abstract class HttpClientUploader
implements Uploader {
    private static AVLogger logger = LogUtil.getLogger(HttpClientUploader.class);
    private OkHttpClient client = new OkHttpClient.Builder().connectTimeout(15L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).dns((Dns)new DNSDetoxicant()).build();
    ProgressCallback progressCallback;
    private volatile boolean cancelled = false;
    protected static final int DEFAULT_RETRY_TIMES = 6;
    protected AVFile avFile = null;

    protected synchronized OkHttpClient getOKHttpClient() {
        return this.client;
    }

    public HttpClientUploader(AVFile file, ProgressCallback progressCallback) {
        this.avFile = file;
        this.progressCallback = progressCallback;
        this.cancelled = false;
    }

    protected Response executeWithRetry(Request request, int retry) throws AVException {
        if (retry > 0 && !this.isCancelled()) {
            try {
                Response response = this.getOKHttpClient().newCall(request).execute();
                if (response.code() / 100 == 2) {
                    return response;
                }
                return this.executeWithRetry(request, retry - 1);
            }
            catch (IOException e) {
                return this.executeWithRetry(request, retry - 1);
            }
        }
        throw new AVException(-1, "Upload File failure");
    }

    @Override
    public void publishProgress(int progress) {
        if (this.progressCallback != null) {
            this.progressCallback.internalDone(progress, null);
        }
    }

    @Override
    public boolean cancel(boolean interrupt) {
        if (this.cancelled) {
            return false;
        }
        this.cancelled = true;
        if (interrupt) {
            this.interruptImmediately();
        }
        return true;
    }

    public void interruptImmediately() {
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }
}

