/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.ops;

import cn.leancloud.AVFile;
import cn.leancloud.AVObject;
import cn.leancloud.AVRelation;
import cn.leancloud.Transformer;
import cn.leancloud.codec.Base64;
import cn.leancloud.json.JSONObject;
import cn.leancloud.types.AVGeoPoint;
import cn.leancloud.utils.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Utils {
    private static final String typeTag = "__type";

    public static Map<String, Object> createPointerArrayOpMap(String key, String op, Collection<AVObject> objects) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("__op", op);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (AVObject obj : objects) {
            list.add(Utils.mapFromPointerObject(obj));
        }
        map.put("objects", list);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(key, map);
        return result;
    }

    public static Map<String, Object> mapFromPointerObject(AVObject object) {
        return Utils.mapFromAVObject(object, false);
    }

    public static Map<String, Object> mapFromGeoPoint(AVGeoPoint point) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(typeTag, "GeoPoint");
        result.put("latitude", point.getLatitude());
        result.put("longitude", point.getLongitude());
        return result;
    }

    public static AVGeoPoint geoPointFromMap(Map<String, Object> map) {
        double la = ((Number)map.get("latitude")).doubleValue();
        double lo = ((Number)map.get("longitude")).doubleValue();
        AVGeoPoint point = new AVGeoPoint(la, lo);
        return point;
    }

    public static AVObject parseObjectFromMap(Map<String, Object> map) {
        AVObject avObject = Transformer.objectFromClassName((String)map.get("className"));
        map.remove(typeTag);
        avObject.resetServerData(map);
        return avObject;
    }

    public static byte[] dataFromMap(Map<String, Object> map) {
        String value = (String)map.get("base64");
        return Base64.decode(value, 2);
    }

    public static Date dateFromMap(Map<String, Object> map) {
        String value = (String)map.get("iso");
        return StringUtil.dateFromString(value);
    }

    public static Map<String, Object> mapFromDate(Date date) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(typeTag, "Date");
        result.put("iso", StringUtil.stringFromDate(date));
        return result;
    }

    public static Map<String, Object> mapFromByteArray(byte[] data) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(typeTag, "Bytes");
        result.put("base64", Base64.encodeToString(data, 2));
        return result;
    }

    public static Map<String, Object> mapFromFile(AVFile file) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(typeTag, "_File");
        result.put("metaData", file.getMetaData());
        result.put("id", file.getName());
        return result;
    }

    public static Map<String, Object> mapFromAVObject(AVObject object, boolean topObject) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("className", object.internalClassName());
        if (!StringUtil.isEmpty(object.getObjectId())) {
            result.put("objectId", object.getObjectId());
        }
        if (!topObject) {
            result.put(typeTag, "Pointer");
        } else {
            result.put(typeTag, "Object");
            Map<String, Object> serverData = Utils.getParsedMap(object.getServerData(), false);
            if (serverData != null && !serverData.isEmpty()) {
                result.putAll(serverData);
            }
        }
        return result;
    }

    public static Map<String, Object> getParsedMap(Map<String, Object> map) {
        return Utils.getParsedMap(map, false);
    }

    public static Map<String, Object> getParsedMap(Map<String, Object> object, boolean topObject) {
        HashMap<String, Object> newMap = new HashMap<String, Object>(object.size());
        for (Map.Entry<String, Object> entry : object.entrySet()) {
            String key = entry.getKey();
            Object o = entry.getValue();
            newMap.put(key, Utils.getParsedObject(o, topObject));
        }
        return newMap;
    }

    public static List getParsedList(Collection list) {
        ArrayList<Object> newList = new ArrayList<Object>(list.size());
        for (Object o : list) {
            newList.add(Utils.getParsedObject(o));
        }
        return newList;
    }

    public static List getParsedList(Collection object, boolean topObject) {
        if (!topObject) {
            return Utils.getParsedList(object);
        }
        ArrayList<Object> newList = new ArrayList<Object>(object.size());
        for (Object o : object) {
            newList.add(Utils.getParsedObject(o, true));
        }
        return newList;
    }

    public static Object getParsedObject(Object object) {
        return Utils.getParsedObject(object, false);
    }

    public static Object getParsedObject(Object object, boolean topObject) {
        if (object == null) {
            return null;
        }
        if (object instanceof Map) {
            return Utils.getParsedMap((Map)object, topObject);
        }
        if (object instanceof Collection) {
            return Utils.getParsedList((Collection)object, topObject);
        }
        if (object instanceof AVObject) {
            if (!topObject) {
                return Utils.mapFromPointerObject((AVObject)object);
            }
            return Utils.mapFromAVObject((AVObject)object, true);
        }
        if (object instanceof AVGeoPoint) {
            return Utils.mapFromGeoPoint((AVGeoPoint)object);
        }
        if (object instanceof Date) {
            return Utils.mapFromDate((Date)object);
        }
        if (object instanceof byte[]) {
            return Utils.mapFromByteArray((byte[])object);
        }
        if (object instanceof AVFile) {
            return Utils.mapFromFile((AVFile)object);
        }
        return object;
    }

    public static Map<String, Object> createArrayOpMap(String key, String op, Collection<?> objects) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("__op", op);
        ArrayList<Object> array = new ArrayList<Object>();
        for (Object obj : objects) {
            array.add(Utils.getParsedObject(obj));
        }
        map.put("objects", array);
        HashMap<String, Object> ops = new HashMap<String, Object>();
        ops.put(key, map);
        return ops;
    }

    public static AVRelation objectFromRelationMap(Map<String, Object> map) {
        String className = (String)map.get("className");
        return new AVRelation(className);
    }

    public static AVFile fileFromMap(Map<String, Object> map) {
        AVFile file = new AVFile("", "");
        file.resetServerData(map);
        Object metadata = map.get("metaData");
        if (metadata != null && metadata instanceof Map) {
            file.getMetaData().putAll((Map)metadata);
        }
        return file;
    }

    public static List getObjectFrom(Collection list) {
        ArrayList<Object> newList = new ArrayList<Object>();
        for (Object obj : list) {
            newList.add(Utils.getObjectFrom(obj));
        }
        return newList;
    }

    public static Object getObjectFrom(Map<String, Object> map) {
        Object type = map.get(typeTag);
        if (null == type || !(type instanceof String)) {
            String classType;
            if (map.containsKey("className") && map.containsKey("serverData")) {
                String className = map.containsKey("className") ? (String)map.get("className") : (String)map.get("@type");
                AVObject avObject = Transformer.objectFromClassName(className);
                Map serverData = (Map)map.get("serverData");
                if (serverData.containsKey("className")) {
                    serverData.remove("className");
                }
                HashMap<String, Object> decodedValues = new HashMap<String, Object>();
                for (Map.Entry entry : serverData.entrySet()) {
                    String k = (String)entry.getKey();
                    Object v = entry.getValue();
                    if (v instanceof String || v instanceof Number || v instanceof Boolean || v instanceof Byte || v instanceof Character) {
                        decodedValues.put(k, v);
                        continue;
                    }
                    if (v instanceof Map || v instanceof JSONObject) {
                        decodedValues.put(k, Utils.getObjectFrom(v));
                        continue;
                    }
                    if (v instanceof Collection) {
                        decodedValues.put(k, Utils.getObjectFrom(v));
                        continue;
                    }
                    if (null == v) continue;
                    decodedValues.put(k, v);
                }
                avObject.resetServerData(decodedValues);
                return avObject;
            }
            if (map.containsKey("@type") && map.get("@type") instanceof String && null != (classType = (String)map.get("@type")) && classType.startsWith("cn.leancloud.")) {
                try {
                    AVObject avObject = (AVObject)Class.forName(classType).newInstance();
                    map.remove("@type");
                    HashMap<String, Object> decodedValues = new HashMap<String, Object>();
                    for (Map.Entry<String, Object> entry : map.entrySet()) {
                        String k = entry.getKey();
                        Object v = entry.getValue();
                        if (v instanceof String || v instanceof Number || v instanceof Boolean || v instanceof Byte || v instanceof Character) {
                            decodedValues.put(k, v);
                            continue;
                        }
                        if (v instanceof Map || v instanceof JSONObject) {
                            decodedValues.put(k, Utils.getObjectFrom(v));
                            continue;
                        }
                        if (v instanceof Collection) {
                            decodedValues.put(k, Utils.getObjectFrom(v));
                            continue;
                        }
                        if (null == v) continue;
                        decodedValues.put(k, v);
                    }
                    avObject.resetServerData(decodedValues);
                    return avObject;
                }
                catch (ClassNotFoundException ex) {
                    ex.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
            }
            HashMap<String, Object> newMap = new HashMap<String, Object>(map.size());
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                Object o = entry.getValue();
                newMap.put(key, Utils.getObjectFrom(o));
            }
            return newMap;
        }
        map.remove(typeTag);
        if (type.equals("Pointer") || type.equals("Object")) {
            AVObject avObject = Transformer.objectFromClassName((String)map.get("className"));
            map.remove("className");
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String k = entry.getKey();
                Object v = entry.getValue();
                if (v instanceof String || v instanceof Number || v instanceof Boolean || v instanceof Byte || v instanceof Character) {
                    avObject.getServerData().put(k, v);
                    continue;
                }
                if (v instanceof Map || v instanceof JSONObject) {
                    avObject.getServerData().put(k, Utils.getObjectFrom(v));
                    continue;
                }
                if (v instanceof Collection) {
                    avObject.getServerData().put(k, Utils.getObjectFrom(v));
                    continue;
                }
                if (null == v) continue;
                avObject.getServerData().put(k, v);
            }
            return avObject;
        }
        if (type.equals("GeoPoint")) {
            return Utils.geoPointFromMap(map);
        }
        if (type.equals("Bytes")) {
            return Utils.dataFromMap(map);
        }
        if (type.equals("Date")) {
            return Utils.dateFromMap(map);
        }
        if (type.equals("Relation")) {
            return Utils.objectFromRelationMap(map);
        }
        if (type.equals("File")) {
            return Utils.fileFromMap(map);
        }
        return map;
    }

    public static Object getObjectFrom(Object obj) {
        if (obj instanceof Collection) {
            return Utils.getObjectFrom((Collection)obj);
        }
        if (obj instanceof Map || obj instanceof JSONObject) {
            return Utils.getObjectFrom((Map)obj);
        }
        return obj;
    }

    public static Map<String, Object> makeCompletedRequest(String internalId, String path, String method, Map<String, Object> param) {
        if (null == param || StringUtil.isEmpty(path) || StringUtil.isEmpty(method)) {
            return null;
        }
        param.put("__internalId", internalId);
        HashMap<String, Object> topParams = new HashMap<String, Object>();
        topParams.put("body", param);
        topParams.put("path", path);
        topParams.put("method", method);
        return topParams;
    }
}

