/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.ops;

import cn.leancloud.AVACL;
import cn.leancloud.AVFile;
import cn.leancloud.AVLogger;
import cn.leancloud.AVObject;
import cn.leancloud.codec.Base64;
import cn.leancloud.json.JSONArray;
import cn.leancloud.json.JSONObject;
import cn.leancloud.ops.NullOperation;
import cn.leancloud.ops.ObjectFieldOperation;
import cn.leancloud.types.AVGeoPoint;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class BaseOperation
implements ObjectFieldOperation {
    static final AVLogger LOGGER = LogUtil.getLogger(BaseOperation.class);
    static final String KEY_OP = "__op";
    static final String KEY_OBJECTS = "objects";
    static final String KEY_AMOUNT = "amount";
    static final String KEY_VALUE = "value";
    public static final String KEY_INTERNAL_ID = "__internalId";
    public static final String KEY_BODY = "body";
    public static final String KEY_PATH = "path";
    public static final String KEY_HTTP_METHOD = "method";
    protected String op = null;
    protected String field = null;
    protected Object value = null;
    protected boolean isFinal = false;

    public BaseOperation() {
    }

    public BaseOperation(String op, String field, Object value, boolean isFinal) {
        this.op = op;
        this.field = field;
        this.value = value;
        this.isFinal = isFinal;
    }

    @Override
    public String getOperation() {
        return this.op;
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    @Override
    public boolean checkCircleReference(Map<AVObject, Boolean> markMap) {
        if (null == markMap) {
            return false;
        }
        return BaseOperation.checkValueCircleReference(markMap, this.value);
    }

    private static boolean checkValueCircleReference(Map<AVObject, Boolean> markMap, Object value) {
        if (null == value || null == markMap) {
            return false;
        }
        if (value instanceof AVObject) {
            AVObject v = (AVObject)value;
            if (markMap.containsKey(v) && markMap.get(v).booleanValue()) {
                return true;
            }
            boolean rst = v.hasCircleReference(markMap);
            markMap.put(v, rst);
            return rst;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            for (Object o : collection) {
                if (!BaseOperation.checkValueCircleReference(markMap, o)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public abstract Object apply(Object var1);

    @Override
    public abstract Map<String, Object> encode();

    protected ObjectFieldOperation mergeWithPrevious(ObjectFieldOperation previous) {
        return NullOperation.gInstance;
    }

    @Override
    public ObjectFieldOperation merge(ObjectFieldOperation other) {
        if (null == other || other instanceof NullOperation) {
            return this;
        }
        if (this.isFinal) {
            return this;
        }
        return this.mergeWithPrevious(other);
    }

    protected Object concatCollections(Object left, Object right) {
        if (null == left || null == right) {
            return null == left ? right : left;
        }
        List<Object> result = new ArrayList<Object>();
        if (left instanceof Collection) {
            result.addAll((Collection)left);
        } else {
            result.add(left);
        }
        if (right instanceof Collection) {
            result.addAll((Collection)right);
        } else {
            result.add(right);
        }
        try {
            if (null != result) {
                HashSet uniqueSet = new HashSet(result.size());
                for (Object e : result) {
                    uniqueSet.add(e);
                }
                result = Arrays.asList(uniqueSet.toArray());
            }
        }
        catch (Exception ex) {
            LOGGER.w("failed to concat collections.", ex);
        }
        return result;
    }

    protected void reportIllegalOperations(ObjectFieldOperation current, ObjectFieldOperation prev) {
        LOGGER.w("illegal operations. current=" + current.getClass().getSimpleName() + ", prev=" + prev.getClass().getSimpleName());
    }

    public static Object encodeObject(Object o) {
        return BaseOperation.encodeObject(o, false);
    }

    protected static Object encodeObject(Object o, boolean isTop) {
        if (null == o) {
            return null;
        }
        if (o instanceof Map) {
            return BaseOperation.encodeMap((Map)o, isTop);
        }
        if (o instanceof Collection) {
            return BaseOperation.encodeCollection((Collection)o, isTop);
        }
        if (o instanceof AVObject) {
            return BaseOperation.encodeAVObject((AVObject)o, isTop);
        }
        if (o instanceof AVGeoPoint) {
            return BaseOperation.encodeGeoPointer((AVGeoPoint)o);
        }
        if (o instanceof AVACL) {
            return ((AVACL)o).toJSONObject();
        }
        if (o instanceof AVFile) {
            return BaseOperation.encodeAVFile((AVFile)o);
        }
        if (o instanceof Date) {
            return BaseOperation.encodeDate((Date)o);
        }
        if (o instanceof byte[]) {
            return BaseOperation.encodeByteArray((byte[])o);
        }
        if (o instanceof JSONObject || o instanceof JSONArray) {
            return o;
        }
        return o;
    }

    protected static Object encodeMap(Map<String, Object> map, boolean isTop) {
        HashMap<String, Object> newMap = new HashMap<String, Object>(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object o = entry.getValue();
            newMap.put(key, BaseOperation.encodeObject(o, isTop));
        }
        return newMap;
    }

    protected static Object encodeCollection(Collection collection, boolean isTop) {
        ArrayList<Object> result = new ArrayList<Object>(collection.size());
        for (Object o : collection) {
            result.add(BaseOperation.encodeObject(o, isTop));
        }
        return result;
    }

    protected static Object encodeAVObject(AVObject o, boolean isTop) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("className", o.getClassName());
        if (!StringUtil.isEmpty(o.getObjectId())) {
            result.put("objectId", o.getObjectId());
        }
        if (isTop) {
            result.put("__type", "Object");
            Map serverData = (Map)BaseOperation.encodeMap(o.getServerData(), false);
            if (serverData != null && !serverData.isEmpty()) {
                result.putAll(serverData);
            }
        } else {
            result.put("__type", "Pointer");
        }
        return result;
    }

    protected static Object encodeGeoPointer(AVGeoPoint o) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("__type", "GeoPoint");
        result.put("latitude", o.getLatitude());
        result.put("longitude", o.getLongitude());
        return result;
    }

    protected static Object encodeAVFile(AVFile o) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("__type", "_File");
        result.put("metaData", o.getMetaData());
        result.put("id", o.getName());
        return result;
    }

    protected static Object encodeByteArray(byte[] o) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("__type", "Bytes");
        result.put("base64", Base64.encodeToString(o, 2));
        return result;
    }

    public static Map<String, Object> encodeDate(Date date) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("__type", "Date");
        result.put("iso", StringUtil.stringFromDate(date));
        return result;
    }
}

