/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.gson;

import cn.leancloud.AVFile;
import cn.leancloud.AVInstallation;
import cn.leancloud.AVObject;
import cn.leancloud.AVRole;
import cn.leancloud.AVStatus;
import cn.leancloud.AVUser;
import cn.leancloud.Transformer;
import cn.leancloud.gson.MapDeserializerDoubleAsIntFix;
import cn.leancloud.json.JSONObject;
import cn.leancloud.ops.Utils;
import cn.leancloud.utils.StringUtil;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.internal.LinkedTreeMap;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;

public class ObjectDeserializer
implements JsonDeserializer<AVObject> {
    public static final String KEY_VERSION = "_version";
    public static final String KEY_SERVERDATA = "serverData";
    private MapDeserializerDoubleAsIntFix mapDeserializer = new MapDeserializerDoubleAsIntFix();

    private AVObject generateObject(Map<String, Object> objectMap, String className) {
        Map serverJson = null;
        if (objectMap.containsKey(KEY_VERSION)) {
            className = (String)objectMap.get("className");
            serverJson = objectMap.containsKey(KEY_SERVERDATA) ? (Map)objectMap.get(KEY_SERVERDATA) : objectMap;
        } else if (objectMap.containsKey("className")) {
            className = (String)objectMap.get("className");
            objectMap.remove("className");
            if (objectMap.containsKey(KEY_SERVERDATA)) {
                LinkedTreeMap serverData = (LinkedTreeMap)objectMap.get(KEY_SERVERDATA);
                objectMap.remove(KEY_SERVERDATA);
                objectMap.putAll(serverData);
            }
            objectMap.remove("operationQueue");
            serverJson = objectMap;
        } else {
            serverJson = objectMap;
        }
        AVObject obj = className.endsWith(AVFile.class.getCanonicalName()) ? new AVFile() : (className.endsWith(AVUser.class.getCanonicalName()) ? new AVUser() : (className.endsWith(AVInstallation.class.getCanonicalName()) ? new AVInstallation() : (className.endsWith(AVStatus.class.getCanonicalName()) ? new AVStatus() : (className.endsWith(AVRole.class.getCanonicalName()) ? new AVRole() : (!StringUtil.isEmpty(className) && className.indexOf(".") < 0 ? Transformer.objectFromClassName(className) : new AVObject())))));
        serverJson.remove("@type");
        for (Map.Entry entry : serverJson.entrySet()) {
            String k = (String)entry.getKey();
            Object v = entry.getValue();
            if (v instanceof String || v instanceof Number || v instanceof Boolean || v instanceof Byte || v instanceof Character) {
                obj.getServerData().put(k, v);
                continue;
            }
            if (v instanceof Map || v instanceof JSONObject) {
                obj.getServerData().put(k, Utils.getObjectFrom(v));
                continue;
            }
            if (v instanceof Collection) {
                obj.getServerData().put(k, Utils.getObjectFrom(v));
                continue;
            }
            if (null == v) continue;
            obj.getServerData().put(k, v);
        }
        return obj;
    }

    public AVObject deserialize(JsonElement elem, Type type, JsonDeserializationContext ctx) throws JsonParseException {
        if (null == elem || !elem.isJsonObject()) {
            return null;
        }
        Object mapData = this.mapDeserializer.deserialize(elem, type, ctx);
        return this.generateObject((Map<String, Object>)mapData, ((Class)type).getCanonicalName());
    }
}

