/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.core;

import cn.leancloud.AVFile;
import cn.leancloud.AVFriendship;
import cn.leancloud.AVFriendshipRequest;
import cn.leancloud.AVLogger;
import cn.leancloud.AVObject;
import cn.leancloud.AVQuery;
import cn.leancloud.AVStatus;
import cn.leancloud.AVUser;
import cn.leancloud.Transformer;
import cn.leancloud.cache.QueryResultCache;
import cn.leancloud.core.AppConfiguration;
import cn.leancloud.gson.NumberDeserializerDoubleAsIntFix;
import cn.leancloud.json.JSON;
import cn.leancloud.json.JSONObject;
import cn.leancloud.ops.Utils;
import cn.leancloud.query.AVQueryResult;
import cn.leancloud.search.AVSearchResponse;
import cn.leancloud.service.APIService;
import cn.leancloud.sms.AVCaptchaDigest;
import cn.leancloud.sms.AVCaptchaOption;
import cn.leancloud.sms.AVCaptchaValidateResult;
import cn.leancloud.types.AVDate;
import cn.leancloud.types.AVNull;
import cn.leancloud.upload.FileUploadToken;
import cn.leancloud.utils.ErrorUtils;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Scheduler;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StorageClient {
    private static AVLogger LOGGER = LogUtil.getLogger(StorageClient.class);
    private APIService apiService = null;
    private boolean asynchronized = false;
    private AppConfiguration.SchedulerCreator defaultCreator = null;
    private QueryResultCache queryResultCache = QueryResultCache.getInstance();
    private AVUser currentUser = null;

    public StorageClient(APIService apiService, boolean asyncRequest, AppConfiguration.SchedulerCreator observerSchedulerCreator) {
        this.apiService = apiService;
        this.asynchronized = asyncRequest;
        this.defaultCreator = observerSchedulerCreator;
    }

    public void setCurrentUser(AVUser newUser) {
        this.currentUser = newUser;
    }

    public AVUser getCurrentUser() {
        return this.currentUser;
    }

    public Observable wrapObservable(Observable observable) {
        if (null == observable) {
            return null;
        }
        if (this.asynchronized) {
            observable = observable.subscribeOn(Schedulers.io());
        }
        if (null != this.defaultCreator) {
            observable = observable.observeOn(this.defaultCreator.create());
        }
        observable = observable.onErrorResumeNext((Function)new Function<Throwable, ObservableSource>(){

            public ObservableSource apply(Throwable throwable) throws Exception {
                return Observable.error((Throwable)ErrorUtils.propagateException(throwable));
            }
        });
        return observable;
    }

    private Observable wrapObservableInBackground(Observable observable) {
        if (null == observable) {
            return null;
        }
        Scheduler scheduler = Schedulers.io();
        if (this.asynchronized) {
            observable = observable.subscribeOn(scheduler);
        }
        if (null != this.defaultCreator) {
            observable = observable.observeOn(scheduler);
        }
        return observable;
    }

    public Observable<AVDate> getServerTime() {
        Observable date = this.wrapObservable(this.apiService.currentTimeMillis());
        return date;
    }

    public Observable<? extends AVObject> fetchObject(AVUser authenticatedUser, final String className, String objectId, String includeKeys) {
        Observable object = null;
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        object = StringUtil.isEmpty(includeKeys) ? this.wrapObservable(this.apiService.fetchObject(authenticatedSession, className, objectId)) : this.wrapObservable(this.apiService.fetchObject(authenticatedSession, className, objectId, includeKeys));
        if (null == object) {
            return object;
        }
        return object.map((Function)new Function<AVObject, AVObject>(){

            public AVObject apply(AVObject avObject) throws Exception {
                return Transformer.transform(avObject, className);
            }
        });
    }

    public boolean hasCachedResult(String className, Map<String, String> query, long maxAgeInMilliseconds) {
        return QueryResultCache.getInstance().hasCachedResult(className, query, maxAgeInMilliseconds);
    }

    private String getSessionToken(AVUser avUser) {
        if (null == avUser) {
            if (AppConfiguration.isIncognitoMode() || null == AVUser.currentUser()) {
                return "";
            }
            return AVUser.currentUser().getSessionToken();
        }
        return avUser.getSessionToken();
    }

    private Observable<AVQueryResult> queryRemoteServer(AVUser authenticatedUser, String className, Map<String, String> query) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        if ("_User".equalsIgnoreCase(className)) {
            return this.wrapObservable(this.apiService.queryUsers(authenticatedSession, query));
        }
        return this.wrapObservable(this.apiService.queryObjects(authenticatedSession, className, query));
    }

    public Observable<List<AVObject>> queryObjects(final AVUser authenticatedUser, final String className, final Map<String, String> query, AVQuery.CachePolicy cachePolicy, final long maxAgeInMilliseconds) {
        final String cacheKey = QueryResultCache.generateKeyForQueryCondition(className, query);
        Observable result = null;
        Observable<AVQueryResult> queryResult = null;
        switch (cachePolicy) {
            case CACHE_ONLY: {
                result = this.wrapObservable(QueryResultCache.getInstance().getCacheResult(className, query, maxAgeInMilliseconds, true));
                break;
            }
            case CACHE_ELSE_NETWORK: {
                result = this.wrapObservable(QueryResultCache.getInstance().getCacheResult(className, query, maxAgeInMilliseconds, false)).onErrorResumeNext((Function)new Function<Throwable, ObservableSource<? extends List<AVObject>>>(){

                    public ObservableSource<? extends List<AVObject>> apply(Throwable throwable) throws Exception {
                        LOGGER.d("failed to query local cache, cause: " + throwable.getMessage() + ", try to query networking");
                        return StorageClient.this.queryRemoteServer(authenticatedUser, className, query).map((Function)new Function<AVQueryResult, List<AVObject>>(){

                            public List<AVObject> apply(AVQueryResult o) throws Exception {
                                o.setClassName(className);
                                for (AVObject obj : o.getResults()) {
                                    obj.setClassName(className);
                                }
                                QueryResultCache.getInstance().cacheResult(cacheKey, o.toJSONString());
                                LOGGER.d("invoke within StorageClient.queryObjects(). resultSize:" + (null != o.getResults() ? o.getResults().size() : 0));
                                return o.getResults();
                            }
                        });
                    }
                });
                break;
            }
            case NETWORK_ELSE_CACHE: {
                queryResult = this.queryRemoteServer(authenticatedUser, className, query);
                if (null == queryResult) break;
                result = queryResult.map((Function)new Function<AVQueryResult, List<AVObject>>(){

                    public List<AVObject> apply(AVQueryResult o) throws Exception {
                        o.setClassName(className);
                        for (AVObject obj : o.getResults()) {
                            obj.setClassName(className);
                        }
                        QueryResultCache.getInstance().cacheResult(cacheKey, o.toJSONString());
                        LOGGER.d("invoke within StorageClient.queryObjects(). resultSize:" + (null != o.getResults() ? o.getResults().size() : 0));
                        return o.getResults();
                    }
                }).onErrorResumeNext((Function)new Function<Throwable, ObservableSource<? extends List<AVObject>>>(){

                    public ObservableSource<? extends List<AVObject>> apply(Throwable throwable) throws Exception {
                        LOGGER.d("failed to query networking, cause: " + throwable.getMessage() + ", try to query local cache.");
                        return QueryResultCache.getInstance().getCacheResult(className, query, maxAgeInMilliseconds, true);
                    }
                });
                break;
            }
            default: {
                queryResult = this.queryRemoteServer(authenticatedUser, className, query);
                if (null == queryResult) break;
                result = queryResult.map((Function)new Function<AVQueryResult, List<AVObject>>(){

                    public List<AVObject> apply(AVQueryResult o) throws Exception {
                        o.setClassName(className);
                        for (AVObject obj : o.getResults()) {
                            obj.setClassName(className);
                        }
                        QueryResultCache.getInstance().cacheResult(cacheKey, o.toJSONString());
                        LOGGER.d("invoke within StorageClient.queryObjects(). resultSize:" + (null != o.getResults() ? o.getResults().size() : 0));
                        return o.getResults();
                    }
                });
            }
        }
        return result;
    }

    public Observable<AVQueryResult> cloudQuery(AVUser authenticatedUser, Map<String, String> query) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservable(this.apiService.cloudQuery(authenticatedSession, query));
    }

    public Observable<Integer> queryCount(AVUser authenticatedUser, String className, Map<String, String> query) {
        Observable<AVQueryResult> queryResult = this.queryRemoteServer(authenticatedUser, className, query);
        if (null == queryResult) {
            return null;
        }
        return queryResult.map((Function)new Function<AVQueryResult, Integer>(){

            public Integer apply(AVQueryResult o) throws Exception {
                LOGGER.d("invoke within StorageClient.queryCount(). result:" + o + ", return:" + o.getCount());
                return o.getCount();
            }
        });
    }

    public Observable<AVNull> deleteObject(AVUser authenticatedUser, String className, String objectId, Map<String, Object> param) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservable(this.apiService.deleteObject(authenticatedSession, className, objectId, param));
    }

    public Observable<? extends AVObject> createObject(AVUser authenticatedUser, final String className, JSONObject data, boolean fetchFlag, JSONObject where) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        Observable object = this.wrapObservable(this.apiService.createObject(authenticatedSession, className, data, fetchFlag, where));
        if (null == object) {
            return null;
        }
        return object.map((Function)new Function<AVObject, AVObject>(){

            public AVObject apply(AVObject avObject) {
                LOGGER.d(avObject.toString());
                return Transformer.transform(avObject, className);
            }
        });
    }

    public Observable<? extends AVObject> saveObject(AVUser authenticatedUser, final String className, String objectId, JSONObject data, boolean fetchFlag, JSONObject where) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        Observable object = this.wrapObservable(this.apiService.updateObject(authenticatedSession, className, objectId, data, fetchFlag, where));
        if (null == object) {
            return null;
        }
        return object.map((Function)new Function<AVObject, AVObject>(){

            public AVObject apply(AVObject avObject) {
                LOGGER.d("saveObject finished. intermediaObj=" + avObject.toString() + ", convert to " + className);
                return Transformer.transform(avObject, className);
            }
        });
    }

    public <E extends AVObject> Observable<E> saveWholeObject(AVUser authenticatedUser, final Class<E> clazz, String endpointClass, String objectId, JSONObject object, boolean fetchFlag, JSONObject where) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        Observable result = null;
        result = StringUtil.isEmpty(objectId) ? this.wrapObservable(this.apiService.saveWholeObject(authenticatedSession, endpointClass, object, fetchFlag, where)) : this.wrapObservable(this.apiService.saveWholeObject(authenticatedSession, endpointClass, objectId, object, fetchFlag, where));
        if (null == result) {
            return null;
        }
        return result.map(new Function<AVObject, E>(){

            public E apply(AVObject avObject) throws Exception {
                return Transformer.transform(avObject, clazz);
            }
        });
    }

    public Observable<AVObject> getWholeObject(AVUser authenticatedUser, String endpointClass, String objectId, String includeKeys) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservable(this.apiService.getWholeObject(authenticatedSession, endpointClass, objectId, includeKeys));
    }

    public Observable<AVNull> deleteWholeObject(AVUser authenticatedUser, String endpointClass, String objectId, Map<String, Object> param) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservable(this.apiService.deleteWholeObject(authenticatedSession, endpointClass, objectId, param));
    }

    public Observable<AVFile> fetchFile(AVUser authenticatedUser, String objectId) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        Observable object = this.wrapObservable(this.apiService.fetchFile(authenticatedSession, objectId));
        if (null == object) {
            return null;
        }
        return object.map((Function)new Function<AVFile, AVFile>(){

            public AVFile apply(AVFile avFile) throws Exception {
                avFile.setClassName("_File");
                return avFile;
            }
        });
    }

    public Observable<FileUploadToken> newUploadToken(AVUser authenticatedUser, JSONObject fileData) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservableInBackground(this.apiService.createUploadToken(authenticatedSession, fileData));
    }

    public void fileCallback(AVUser authenticatedUser, JSONObject result) throws IOException {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        this.apiService.fileCallback(authenticatedSession, result).execute();
    }

    public Observable<List<Map<String, Object>>> batchSave(AVUser authenticatedUser, JSONObject parameter) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        Observable result = this.wrapObservable(this.apiService.batchCreate(authenticatedSession, parameter));
        return result;
    }

    public Observable<JSONObject> batchUpdate(AVUser authenticatedUser, JSONObject parameter) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        Observable result = this.wrapObservable(this.apiService.batchUpdate(authenticatedSession, parameter));
        return result;
    }

    public Observable<AVUser> signUp(JSONObject data) {
        return this.wrapObservable(this.apiService.signup(data));
    }

    public Observable<AVUser> signUpWithFlag(JSONObject data, boolean failOnNotExist) {
        return this.wrapObservable(this.apiService.signup(data, failOnNotExist));
    }

    public <T extends AVUser> Observable<T> signUpOrLoginByMobilephone(final JSONObject data, final Class<T> clazz) {
        return this.wrapObservable(this.apiService.signupByMobilePhone(data)).map(new Function<AVUser, T>(){

            public T apply(AVUser avUser) throws Exception {
                AVUser rst = (AVUser)Transformer.transform((AVObject)avUser, clazz);
                StorageClient.this.attachLoginInfo(data, rst);
                AVUser.changeCurrentUser(rst, true);
                return rst;
            }
        });
    }

    private <T extends AVUser> void attachLoginInfo(JSONObject data, T rst) {
        if (null == data || null == rst) {
            return;
        }
        if (data.containsKey("email")) {
            rst.setEmail(data.getString("email"));
        }
        if (data.containsKey("username")) {
            rst.setUsername(data.getString("username"));
        }
        if (data.containsKey("mobilePhoneNumber")) {
            rst.setMobilePhoneNumber(data.getString("mobilePhoneNumber"));
        }
    }

    public <T extends AVUser> Observable<T> logIn(final JSONObject data, final Class<T> clazz) {
        Observable object = this.wrapObservable(this.apiService.login(data));
        if (null == object) {
            return null;
        }
        return object.map(new Function<AVUser, T>(){

            public T apply(AVUser avUser) throws Exception {
                AVUser rst = (AVUser)Transformer.transform((AVObject)avUser, clazz);
                StorageClient.this.attachLoginInfo(data, rst);
                AVUser.changeCurrentUser(rst, true);
                return rst;
            }
        });
    }

    public Observable<AVFriendshipRequest> applyFriendshipRequest(AVUser authenticatedUser, JSONObject data) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        Observable result = this.wrapObservable(this.apiService.applyFriendship(authenticatedSession, data));
        if (null == result) {
            return null;
        }
        return result.map((Function)new Function<AVObject, AVFriendshipRequest>(){

            public AVFriendshipRequest apply(AVObject avObject) throws Exception {
                return Transformer.transform(avObject, AVFriendshipRequest.class);
            }
        });
    }

    public Observable<AVFriendshipRequest> acceptFriendshipRequest(AVUser authenticatedUser, AVFriendshipRequest request, JSONObject param) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        Observable result = this.wrapObservable(this.apiService.acceptFriendshipRequest(authenticatedSession, request.getObjectId(), param));
        if (null == result) {
            return null;
        }
        return result.map((Function)new Function<AVObject, AVFriendshipRequest>(){

            public AVFriendshipRequest apply(AVObject avObject) throws Exception {
                return Transformer.transform(avObject, AVFriendshipRequest.class);
            }
        });
    }

    public Observable<AVFriendshipRequest> declineFriendshipRequest(AVUser authenticatedUser, AVFriendshipRequest request) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        Observable result = this.wrapObservable(this.apiService.declineFriendshipRequest(authenticatedSession, request.getObjectId()));
        return result.map((Function)new Function<AVObject, AVFriendshipRequest>(){

            public AVFriendshipRequest apply(AVObject avObject) throws Exception {
                return Transformer.transform(avObject, AVFriendshipRequest.class);
            }
        });
    }

    public Observable<Boolean> checkAuthenticated(String sessionToken) {
        HashMap<String, String> param = new HashMap<String, String>(1);
        param.put("session_token", sessionToken);
        Observable apiResult = this.wrapObservable(this.apiService.checkAuthenticated(sessionToken, param));
        if (null == apiResult) {
            return Observable.just((Object)false);
        }
        return apiResult.map((Function)new Function<AVUser, Boolean>(){

            public Boolean apply(AVUser o) throws Exception {
                if (null != o) {
                    return true;
                }
                return false;
            }
        });
    }

    public <T extends AVUser> Observable<T> createUserBySession(String sessionToken, final Class<T> clazz) {
        HashMap<String, String> param = new HashMap<String, String>(1);
        param.put("session_token", sessionToken);
        return this.apiService.checkAuthenticated(sessionToken, param).map(new Function<AVUser, T>(){

            public T apply(AVUser avUser) throws Exception {
                if (null == avUser) {
                    LOGGER.e("The mapper function returned a null value.");
                    return null;
                }
                return (AVUser)Transformer.transform((AVObject)avUser, clazz);
            }
        });
    }

    public Observable<Boolean> refreshSessionToken(final AVUser user) {
        return this.wrapObservable(this.apiService.refreshSessionToken(user.getSessionToken(), user.getObjectId()).map((Function)new Function<AVUser, Boolean>(){

            public Boolean apply(AVUser avUser) throws Exception {
                if (null != avUser && !StringUtil.isEmpty(avUser.getSessionToken())) {
                    user.internalChangeSessionToken(avUser.getSessionToken());
                    return true;
                }
                return false;
            }
        }));
    }

    public Observable<AVNull> requestResetPassword(String email) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("email", email);
        return this.wrapObservable(this.apiService.requestResetPassword(map));
    }

    public Observable<AVNull> requestResetPasswordBySmsCode(String phoneNumber, String validateToken) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("mobilePhoneNumber", phoneNumber);
        if (!StringUtil.isEmpty(validateToken)) {
            map.put("validate_token", validateToken);
        }
        return this.wrapObservable(this.apiService.requestResetPasswordBySmsCode(map));
    }

    public Observable<AVNull> requestEmailVerify(String email) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("email", email);
        return this.wrapObservable(this.apiService.requestEmailVerify(map));
    }

    public Observable<AVNull> requestMobilePhoneVerify(String mobilePhone, String validateToken) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("mobilePhoneNumber", mobilePhone);
        if (!StringUtil.isEmpty(validateToken)) {
            map.put("validate_token", validateToken);
        }
        return this.wrapObservable(this.apiService.requestMobilePhoneVerify(map));
    }

    public Observable<AVNull> verifyMobilePhone(String verifyCode) {
        return this.wrapObservable(this.apiService.verifyMobilePhone(verifyCode));
    }

    public Observable<AVNull> requestLoginSmsCode(String phoneNumber, String validateToken) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("mobilePhoneNumber", phoneNumber);
        if (!StringUtil.isEmpty(validateToken)) {
            map.put("validate_token", validateToken);
        }
        return this.wrapObservable(this.apiService.requestLoginSmsCode(map));
    }

    public Observable<AVNull> resetPasswordBySmsCode(String smsCode, String newPass) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("password", newPass);
        return this.wrapObservable(this.apiService.resetPasswordBySmsCode(smsCode, map));
    }

    public Observable<AVNull> updatePassword(final AVUser user, String oldPass, String newPass) {
        if (null == user) {
            return Observable.error((Throwable)new IllegalArgumentException("user is null"));
        }
        if (StringUtil.isEmpty(oldPass) || StringUtil.isEmpty(newPass)) {
            return Observable.error((Throwable)new IllegalArgumentException("old password or new password is empty"));
        }
        JSONObject param = JSONObject.Builder.create(null);
        param.put("old_password", oldPass);
        param.put("new_password", newPass);
        return this.wrapObservable(this.apiService.updatePassword(user.getSessionToken(), user.getObjectId(), param).map((Function)new Function<AVUser, AVNull>(){

            public AVNull apply(AVUser var1) throws Exception {
                if (null != var1) {
                    user.internalChangeSessionToken(var1.getSessionToken());
                }
                return new AVNull();
            }
        }));
    }

    public Observable<JSONObject> followUser(AVUser authenticatedUser, String followee, String follower, Map<String, Object> attr) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservable(this.apiService.followUser(authenticatedSession, followee, follower, attr));
    }

    public Observable<JSONObject> unfollowUser(AVUser authenticatedUser, String followee, String follower) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservable(this.apiService.unfollowUser(authenticatedSession, followee, follower));
    }

    public Observable<AVFriendship> updateFriendship(AVUser authenticatedUser, String followeeUserid, String friendObjectId, Map<String, Object> attr) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservable(this.apiService.updateFriendship(authenticatedSession, followeeUserid, friendObjectId, attr));
    }

    public Observable<JSONObject> getFollowersAndFollowees(AVUser authenticatedUser, String userId) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservable(this.apiService.getFollowersAndFollowees(authenticatedSession, userId));
    }

    public Observable<AVStatus> postStatus(AVUser authenticatedUser, Map<String, Object> param) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservable(this.apiService.postStatus(authenticatedSession, param));
    }

    public Observable<AVStatus> fetchStatus(AVUser authenticatedUser, String objectId) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservable(this.apiService.fetchSingleStatus(authenticatedSession, objectId));
    }

    public Observable<List<AVStatus>> queryStatus(AVUser authenticatedUser, Map<String, String> param) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservable(this.apiService.fetchStatuses(authenticatedSession, param).map((Function)new Function<AVQueryResult, List<AVStatus>>(){

            public List<AVStatus> apply(AVQueryResult o) throws Exception {
                if (null == o) {
                    LOGGER.e("The mapper function returned a null value.");
                    return null;
                }
                ArrayList<AVStatus> results = new ArrayList<AVStatus>();
                for (AVObject obj : o.getResults()) {
                    results.add(new AVStatus(obj));
                }
                return results;
            }
        }));
    }

    public Observable<List<AVStatus>> queryInbox(AVUser authenticatedUser, Map<String, String> param) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservable(this.apiService.queryInbox(authenticatedSession, param).map((Function)new Function<AVQueryResult, List<AVStatus>>(){

            public List<AVStatus> apply(AVQueryResult o) throws Exception {
                if (null == o) {
                    LOGGER.e("The mapper function returned a null value.");
                    return null;
                }
                ArrayList<AVStatus> results = new ArrayList<AVStatus>();
                for (AVObject obj : o.getResults()) {
                    results.add(new AVStatus(obj));
                }
                return results;
            }
        }));
    }

    public Observable<JSONObject> getInboxCount(AVUser authenticatedUser, Map<String, String> param) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservable(this.apiService.getInboxCount(authenticatedSession, param));
    }

    public Observable<AVNull> deleteStatus(AVUser authenticatedUser, String statusId) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservable(this.apiService.deleteStatus(authenticatedSession, statusId));
    }

    public Observable<AVNull> deleteInboxStatus(AVUser authenticatedUser, Map<String, Object> param) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservable(this.apiService.deleteInboxStatus(authenticatedSession, param));
    }

    public <T> Observable<T> callRPC(AVUser authenticatedUser, String name, Object param) {
        return this.callRPC(authenticatedUser, name, param, false, null);
    }

    <T> Observable<T> callRPC(AVUser authenticatedUser, String name, Object param, final boolean enableCache, final String cacheKey) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        Observable cloudCall = this.wrapObservable(this.apiService.cloudRPC(authenticatedSession, name, param));
        if (null == cloudCall) {
            return null;
        }
        return cloudCall.map(new Function<Map<String, ?>, T>(){

            public T apply(Map<String, ?> resultMap) throws Exception {
                try {
                    Object resultValue = resultMap.get("result");
                    if (enableCache && !StringUtil.isEmpty(cacheKey)) {
                        LOGGER.d("cache rpc result:" + JSON.toJSONString(resultValue));
                        QueryResultCache.getInstance().cacheResult(cacheKey, JSON.toJSONString(resultValue));
                    }
                    if (resultValue instanceof Collection) {
                        return Utils.getObjectFrom((Collection)resultValue);
                    }
                    if (resultValue instanceof Map) {
                        return Utils.getObjectFrom((Map)resultValue);
                    }
                    return resultValue;
                }
                catch (Exception ex) {
                    LOGGER.d("RPCFunction error: " + ex.getMessage());
                    return null;
                }
            }
        });
    }

    public <T> Observable<T> callFunction(AVUser authenticatedUser, String name, Map<String, Object> params) {
        return this.callFunction(authenticatedUser, name, params, false, null);
    }

    <T> Observable<T> callFunction(AVUser authenticatedUser, String name, Map<String, Object> params, final boolean enableCache, final String cacheKey) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        Observable cloudCall = this.wrapObservable(this.apiService.cloudFunction(authenticatedSession, name, params));
        if (null == cloudCall) {
            return null;
        }
        return cloudCall.map(new Function<Map<String, ?>, T>(){

            public T apply(Map<String, ?> resultMap) throws Exception {
                try {
                    Object resultValue = resultMap.get("result");
                    if (enableCache && !StringUtil.isEmpty(cacheKey)) {
                        LOGGER.d("cache cloud function result:" + JSON.toJSONString(resultValue));
                        QueryResultCache.getInstance().cacheResult(cacheKey, JSON.toJSONString(resultMap));
                    }
                    if (resultValue instanceof Collection) {
                        return Utils.getObjectFrom((Collection)resultValue);
                    }
                    if (resultValue instanceof Map) {
                        return Utils.getObjectFrom((Map)resultValue);
                    }
                    return resultValue;
                }
                catch (Exception ex) {
                    LOGGER.d("CloudFunction error: " + ex.getMessage());
                    return null;
                }
            }
        });
    }

    <T> Observable<T> executeCachedQuery(String clazz, Map<String, Object> query, AVQuery.CachePolicy cachePolicy, long maxAgeInMilliseconds, final QueryExecutor cacheQueryExecutor, final QueryExecutor remoteQueryExecutor) {
        Observable result = null;
        switch (cachePolicy) {
            case CACHE_ONLY: {
                result = cacheQueryExecutor.executor();
                break;
            }
            case CACHE_ELSE_NETWORK: {
                result = cacheQueryExecutor.executor();
                result = result.onErrorResumeNext(new Function<Throwable, Observable<T>>(){

                    public Observable<T> apply(Throwable throwable) throws Exception {
                        LOGGER.d("failed to query local cache, cause: " + throwable.getMessage() + ", try to query networking");
                        return remoteQueryExecutor.executor();
                    }
                });
                break;
            }
            case NETWORK_ELSE_CACHE: {
                result = remoteQueryExecutor.executor();
                result = result.onErrorResumeNext(new Function<Throwable, Observable<T>>(){

                    public Observable<T> apply(Throwable throwable) throws Exception {
                        LOGGER.d("failed to query networking, cause: " + throwable.getMessage() + ", try to query local cache.");
                        return cacheQueryExecutor.executor();
                    }
                });
                break;
            }
            default: {
                result = remoteQueryExecutor.executor();
            }
        }
        return result;
    }

    public <T> Observable<T> callRPCWithCachePolicy(final AVUser asAuthenticatedUser, final String name, final Map<String, Object> param, final AVQuery.CachePolicy cachePolicy, final long maxCacheAge) {
        final String cacheKey = QueryResultCache.generateCachedKey(name, param);
        return this.executeCachedQuery(name, param, cachePolicy, maxCacheAge, new QueryExecutor(){

            @Override
            public <T> Observable<T> executor() {
                return QueryResultCache.getInstance().getCacheRawResult(name, cacheKey, maxCacheAge, true).map(new Function<String, T>(){

                    public T apply(String s) throws Exception {
                        if (StringUtil.isEmpty(s)) {
                            return null;
                        }
                        LOGGER.d("found cached rpc result: " + s);
                        Object parsedObject = JSON.parse(s);
                        if (parsedObject instanceof Collection) {
                            return Utils.getObjectFrom((Collection)parsedObject);
                        }
                        if (parsedObject instanceof Map) {
                            return Utils.getObjectFrom((Map)parsedObject);
                        }
                        return parsedObject;
                    }
                });
            }
        }, new QueryExecutor(){

            @Override
            public <T> Observable<T> executor() {
                return StorageClient.this.callRPC(asAuthenticatedUser, name, param, cachePolicy != AVQuery.CachePolicy.IGNORE_CACHE && cachePolicy != AVQuery.CachePolicy.NETWORK_ONLY, cacheKey);
            }
        });
    }

    public <T> Observable<T> callFunctionWithCachePolicy(final AVUser asAuthenticatedUser, final String name, final Map<String, Object> params, final AVQuery.CachePolicy cachePolicy, final long maxCacheAge) {
        final String cacheKey = QueryResultCache.generateCachedKey(name, params);
        return this.executeCachedQuery(name, params, cachePolicy, maxCacheAge, new QueryExecutor(){

            @Override
            public <T> Observable<T> executor() {
                return QueryResultCache.getInstance().getCacheRawResult(name, cacheKey, maxCacheAge, true).map(new Function<String, T>(){

                    public T apply(String s) throws Exception {
                        if (StringUtil.isEmpty(s)) {
                            return null;
                        }
                        LOGGER.d("found cached function result: " + s);
                        Object parsedObject = null;
                        try {
                            JSONObject tmpObject = JSON.parseObject(s);
                            parsedObject = null != tmpObject && tmpObject.containsKey("result") ? tmpObject.get("result") : tmpObject;
                        }
                        catch (Exception exception) {
                            parsedObject = JSON.parse(s);
                        }
                        if (parsedObject instanceof Collection) {
                            return Utils.getObjectFrom((Collection)parsedObject);
                        }
                        if (parsedObject instanceof Map) {
                            return Utils.getObjectFrom((Map)parsedObject);
                        }
                        if (parsedObject instanceof Number) {
                            return NumberDeserializerDoubleAsIntFix.parsePrecisionNumber((Number)parsedObject);
                        }
                        return parsedObject;
                    }
                });
            }
        }, new QueryExecutor(){

            @Override
            public <T> Observable<T> executor() {
                return StorageClient.this.callFunction(asAuthenticatedUser, name, params, cachePolicy != AVQuery.CachePolicy.IGNORE_CACHE && cachePolicy != AVQuery.CachePolicy.NETWORK_ONLY, cacheKey);
            }
        });
    }

    public Observable<AVCaptchaDigest> requestCaptcha(AVCaptchaOption option) {
        return this.wrapObservable(this.apiService.requestCaptcha(option.getRequestParam()));
    }

    public Observable<AVCaptchaValidateResult> verifyCaptcha(String code, String token) {
        if (StringUtil.isEmpty(code) || StringUtil.isEmpty(token)) {
            return Observable.error((Throwable)new IllegalArgumentException("code or token is empty"));
        }
        HashMap<String, String> param = new HashMap<String, String>(2);
        param.put("captcha_code", code);
        param.put("captcha_token", token);
        return this.wrapObservable(this.apiService.verifyCaptcha(param));
    }

    public Observable<AVNull> requestSMSCode(String mobilePhone, Map<String, Object> param) {
        param.put("mobilePhoneNumber", mobilePhone);
        return this.wrapObservable(this.apiService.requestSMSCode(param));
    }

    public Observable<AVNull> requestSMSCodeForUpdatingPhoneNumber(AVUser asUser, String mobilePhone, Map<String, Object> param) {
        param.put("mobilePhoneNumber", mobilePhone);
        String sessionToken = this.getSessionToken(asUser);
        return this.wrapObservable(this.apiService.requestSMSCodeForUpdatingPhoneNumber(sessionToken, param));
    }

    public Observable<AVNull> verifySMSCode(String code, String mobilePhone) {
        if (StringUtil.isEmpty(code) || StringUtil.isEmpty(mobilePhone)) {
            return Observable.error((Throwable)new IllegalArgumentException("code or mobilePhone is empty"));
        }
        HashMap<String, Object> param = new HashMap<String, Object>(1);
        param.put("mobilePhoneNumber", mobilePhone);
        return this.wrapObservable(this.apiService.verifySMSCode(code, param));
    }

    public Observable<AVNull> verifySMSCodeForUpdatingPhoneNumber(AVUser asUser, String code, String mobilePhone) {
        if (StringUtil.isEmpty(code) || StringUtil.isEmpty(mobilePhone)) {
            return Observable.error((Throwable)new IllegalArgumentException("code or mobilePhone is empty"));
        }
        String sessionToken = this.getSessionToken(asUser);
        HashMap<String, Object> param = new HashMap<String, Object>(1);
        param.put("mobilePhoneNumber", mobilePhone);
        param.put("code", code);
        return this.wrapObservable(this.apiService.verifySMSCodeForUpdatingPhoneNumber(sessionToken, param));
    }

    public Observable<AVSearchResponse> search(AVUser authenticatedUser, Map<String, String> params) {
        String authenticatedSession = this.getSessionToken(authenticatedUser);
        return this.wrapObservable(this.apiService.search(authenticatedSession, params));
    }

    static interface QueryExecutor {
        public <T> Observable<T> executor();
    }
}

