/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.core;

import cn.leancloud.AVFile;
import cn.leancloud.AVFriendship;
import cn.leancloud.AVFriendshipRequest;
import cn.leancloud.AVInstallation;
import cn.leancloud.AVLogger;
import cn.leancloud.AVObject;
import cn.leancloud.AVStatus;
import cn.leancloud.AVUser;
import cn.leancloud.core.AVOSService;
import cn.leancloud.core.AppConfiguration;
import cn.leancloud.core.AppRouter;
import cn.leancloud.core.GeneralRequestSignature;
import cn.leancloud.core.PaasClient;
import cn.leancloud.types.AVDate;
import cn.leancloud.utils.StringUtil;
import io.reactivex.Observable;

public class AVOSCloud {
    private static REGION defaultRegion = REGION.NorthChina;
    private static String applicationId = "";
    private static String applicationKey = "";
    private static String hookKey = "";
    private static volatile AVLogger.Level logLevel = AVLogger.Level.INFO;
    static boolean printAllHeaders = false;
    private static boolean enableCircularReferenceDetect = false;

    public static void setRegion(REGION region) {
        defaultRegion = region;
    }

    public static REGION getRegion() {
        return defaultRegion;
    }

    public static void enablePrintAllHeaders4Debug(boolean flag) {
        printAllHeaders = flag;
        if (flag) {
            System.out.println("======= WARNING: you are going to dump all details for a REST request, it is very risky for security!!! please ONLY USE IN absolutely trusted environment!!!");
            System.out.println("( \u2022\u0300\u1d17\u2022\u0301 )\u0648( \u2022\u0300\u1d17\u2022\u0301 )\u0648( \u2022\u0300\u1d17\u2022\u0301 )\u0648( \u2022\u0300\u1d17\u2022\u0301 )\u0648( \u2022\u0300\u1d17\u2022\u0301 )\u0648( \u2022\u0300\u1d17\u2022\u0301 )\u0648( \u2022\u0300\u1d17\u2022\u0301 )\u0648( \u2022\u0300\u1d17\u2022\u0301 )\u0648( \u2022\u0300\u1d17\u2022\u0301 )\u0648( \u2022\u0300\u1d17\u2022\u0301 )\u0648");
        }
    }

    public static void setLogLevel(AVLogger.Level level) {
        logLevel = level;
    }

    public static AVLogger.Level getLogLevel() {
        return logLevel;
    }

    public static boolean isDebugEnable() {
        return logLevel.intLevel() >= AVLogger.Level.DEBUG.intLevel();
    }

    public static void setCircularReferenceDetectEnable(boolean enable) {
        enableCircularReferenceDetect = enable;
    }

    public static boolean isEnableCircularReferenceDetect() {
        return enableCircularReferenceDetect;
    }

    public static void initialize(String appId, String appKey) {
        AVObject.registerSubclass(AVStatus.class);
        AVObject.registerSubclass(AVUser.class);
        AVObject.registerSubclass(AVFile.class);
        AVObject.registerSubclass(AVInstallation.class);
        AVObject.registerSubclass(AVFriendshipRequest.class);
        AVObject.registerSubclass(AVFriendship.class);
        applicationId = appId;
        applicationKey = appKey;
        PaasClient.initializeGlobalClient();
    }

    public static void initialize(String appId, String appKey, String serverUrl) {
        AVOSCloud.setServerURLs(serverUrl);
        AVOSCloud.initialize(appId, appKey);
    }

    public static Observable<AVDate> getServerDateInBackground() {
        return PaasClient.getStorageClient().getServerTime();
    }

    public static void setMasterKey(String masterKey) {
        GeneralRequestSignature.setMasterKey(masterKey);
    }

    public static void setServer(AVOSService service, String host) {
        if (StringUtil.isEmpty(host)) {
            return;
        }
        if (!host.toLowerCase().startsWith("http")) {
            host = "https://" + host;
        }
        AppRouter appRouter = AppRouter.getInstance();
        appRouter.freezeEndpoint(service, host);
    }

    protected static void setServerURLs(String host) {
        AVOSCloud.setServer(AVOSService.API, host);
        AVOSCloud.setServer(AVOSService.RTM, host);
        AVOSCloud.setServer(AVOSService.ENGINE, host);
        AVOSCloud.setServer(AVOSService.PUSH, host);
        AVOSCloud.setServer(AVOSService.STATS, host);
    }

    @Deprecated
    public static void setLastModifyEnabled(boolean val) {
        AppConfiguration.setLastModifyEnabled(val);
    }

    @Deprecated
    public static boolean isLastModifyEnabled() {
        return AppConfiguration.isLastModifyEnabled();
    }

    @Deprecated
    public static void setNetworkTimeout(int seconds) {
        AppConfiguration.setNetworkTimeout(seconds);
    }

    @Deprecated
    public static int getNetworkTimeout() {
        return AppConfiguration.getNetworkTimeout();
    }

    public static void setAutoMergeOperationDataWhenSave(boolean flag) {
        AppConfiguration.setAutoMergeOperationDataWhenSave(flag);
    }

    static void setAlwaysFetchWhenSave(boolean flag) {
    }

    public static String getApplicationId() {
        return applicationId;
    }

    public static String getSimplifiedAppId() {
        if (StringUtil.isEmpty(applicationId)) {
            return "";
        }
        return applicationId.substring(0, 8);
    }

    public static String getApplicationKey() {
        return applicationKey;
    }

    public static String getHookKey() {
        return hookKey;
    }

    public static void setHookKey(String key) {
        hookKey = key;
    }

    public static enum REGION {
        EastChina,
        NorthChina,
        NorthAmerica;

    }
}

