/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.AVFile;
import cn.leancloud.AVFriendship;
import cn.leancloud.AVFriendshipRequest;
import cn.leancloud.AVInstallation;
import cn.leancloud.AVLogger;
import cn.leancloud.AVObject;
import cn.leancloud.AVRole;
import cn.leancloud.AVStatus;
import cn.leancloud.AVUser;
import cn.leancloud.annotation.AVClassName;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class Transformer {
    private static AVLogger logger = LogUtil.getLogger(Transformer.class);
    private static Pattern classnamePattern = Pattern.compile("^[a-zA-Z_][a-zA-Z_0-9]*$");
    private static final Map<String, Class<? extends AVObject>> subClassesMAP = new HashMap<String, Class<? extends AVObject>>();
    private static final Map<Class<? extends AVObject>, String> subClassesReverseMAP = new HashMap<Class<? extends AVObject>, String>();

    static Class<? extends AVObject> getSubClass(String className) {
        return subClassesMAP.get(className);
    }

    public static String getSubClassName(Class clazz) {
        if (AVUser.class.isAssignableFrom(clazz)) {
            return "_User";
        }
        if (AVRole.class.isAssignableFrom(clazz)) {
            return "_Role";
        }
        if (AVStatus.class.isAssignableFrom(clazz)) {
            return "_Status";
        }
        if (AVFile.class.isAssignableFrom(clazz)) {
            return "_File";
        }
        if (AVFriendship.class.isAssignableFrom(clazz)) {
            return "_Followee";
        }
        if (AVFriendshipRequest.class.isAssignableFrom(clazz)) {
            return "_FriendshipRequest";
        }
        return subClassesReverseMAP.get(clazz);
    }

    public static <T extends AVObject> void registerClass(Class<T> clazz) {
        AVClassName avClassName = clazz.getAnnotation(AVClassName.class);
        if (avClassName == null) {
            throw new IllegalArgumentException("The class is not annotated by @AVClassName");
        }
        String className = avClassName.value();
        Transformer.checkClassName(className);
        subClassesMAP.put(className, clazz);
        subClassesReverseMAP.put(clazz, className);
    }

    public static <T extends AVObject> T transform(AVObject rawObj, String className) {
        if (null == rawObj) {
            return null;
        }
        AVObject result = Transformer.objectFromClassName(className);
        result.resetByRawData(rawObj);
        return (T)result;
    }

    public static <T extends AVObject> T transform(AVObject rawObj, Class<T> clazz) {
        if (null == rawObj) {
            return null;
        }
        AVObject result = null;
        if (subClassesReverseMAP.containsKey(clazz)) {
            try {
                result = (AVObject)clazz.newInstance();
            }
            catch (Exception ex) {
                logger.w("newInstance failed. cause: " + ex.getMessage());
                result = new AVObject(clazz.getSimpleName());
            }
        } else {
            result = AVUser.class.isAssignableFrom(clazz) ? new AVUser() : (AVRole.class.isAssignableFrom(clazz) ? new AVRole() : (AVStatus.class.isAssignableFrom(clazz) ? new AVStatus() : (AVFile.class.isAssignableFrom(clazz) ? new AVFile() : (AVFriendshipRequest.class.isAssignableFrom(clazz) ? new AVFriendshipRequest() : (AVFriendship.class.isAssignableFrom(clazz) ? new AVFriendship() : new AVObject(clazz.getSimpleName()))))));
        }
        result.resetByRawData(rawObj);
        return (T)result;
    }

    public static void checkClassName(String className) {
        if (StringUtil.isEmpty(className)) {
            throw new IllegalArgumentException("Blank class name");
        }
        if (!classnamePattern.matcher(className).matches()) {
            throw new IllegalArgumentException("Invalid class name");
        }
    }

    public static AVObject objectFromClassName(String className) {
        AVObject result = null;
        if ("_User".equals(className)) {
            result = new AVUser();
        } else if ("_Status".equals(className)) {
            result = new AVStatus();
        } else if ("_Role".equals(className)) {
            result = new AVRole();
        } else if ("_File".equals(className)) {
            result = new AVFile();
        } else if ("_Installation".equals(className)) {
            result = new AVInstallation();
        } else if ("_FriendshipRequest".equals(className)) {
            result = new AVFriendshipRequest();
        } else if ("_Followee".equals(className)) {
            result = new AVFriendship();
        } else if (subClassesMAP.containsKey(className)) {
            try {
                result = subClassesMAP.get(className).newInstance();
            }
            catch (Exception ex) {
                logger.w("failed to create subClass: " + className, ex);
                result = new AVObject(className);
            }
        } else {
            result = new AVObject(className);
        }
        return result;
    }

    private Transformer() {
    }
}

