/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.AVException;
import cn.leancloud.AVFriendship;
import cn.leancloud.AVFriendshipRequest;
import cn.leancloud.AVObject;
import cn.leancloud.AVQuery;
import cn.leancloud.AVRole;
import cn.leancloud.AVSaveOption;
import cn.leancloud.Transformer;
import cn.leancloud.annotation.AVClassName;
import cn.leancloud.cache.PersistenceUtil;
import cn.leancloud.callback.AVCallback;
import cn.leancloud.callback.FollowersAndFolloweesCallback;
import cn.leancloud.core.AppConfiguration;
import cn.leancloud.core.PaasClient;
import cn.leancloud.json.JSON;
import cn.leancloud.json.JSONObject;
import cn.leancloud.ops.Utils;
import cn.leancloud.sms.AVSMS;
import cn.leancloud.sms.AVSMSOption;
import cn.leancloud.types.AVNull;
import cn.leancloud.utils.AVUtils;
import cn.leancloud.utils.ErrorUtils;
import cn.leancloud.utils.StringUtil;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Function;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@AVClassName(value="_User")
public class AVUser
extends AVObject {
    public static final String ATTR_USERNAME = "username";
    private static final String ATTR_PASSWORD = "password";
    public static final String ATTR_EMAIL = "email";
    public static final String ATTR_MOBILEPHONE = "mobilePhoneNumber";
    private static final String ATTR_SMSCODE = "smsCode";
    private static final String ATTR_MOBILEPHONE_VERIFIED = "mobilePhoneVerified";
    public static final String ATTR_SESSION_TOKEN = "sessionToken";
    private static final String PARAM_ATTR_FRIENDSHIP = "friendship";
    private static final String AUTHDATA_TAG = "authData";
    private static final String AUTHDATA_PLATFORM_ANONYMOUS = "anonymous";
    private static final String AUTHDATA_ATTR_UNIONID = "unionid";
    private static final String AUTHDATA_ATTR_UNIONID_PLATFORM = "platform";
    private static final String AUTHDATA_ATTR_MAIN_ACCOUNT = "main_account";
    private static final String ILLEGALARGUMENT_MSG_FORMAT = "illegal parameter. %s must not null/empty.";
    public static final String CLASS_NAME = "_User";
    public static final String FOLLOWER_TAG = "follower";
    public static final String FOLLOWEE_TAG = "followee";
    private static Class<? extends AVUser> subClazz = null;
    private static transient boolean enableAutomatic = false;

    public AVUser() {
        super(CLASS_NAME);
    }

    public static AVUser currentUser() {
        return AVUser.getCurrentUser();
    }

    public String getEmail() {
        return (String)this.get(ATTR_EMAIL);
    }

    public void setEmail(String email) {
        this.put(ATTR_EMAIL, email);
    }

    public String getUsername() {
        return (String)this.get(ATTR_USERNAME);
    }

    public void setUsername(String name) {
        this.put(ATTR_USERNAME, name);
    }

    public String getPassword() {
        return (String)this.get(ATTR_PASSWORD);
    }

    public void setPassword(String password) {
        this.put(ATTR_PASSWORD, password);
    }

    public String getMobilePhoneNumber() {
        return (String)this.get(ATTR_MOBILEPHONE);
    }

    public void setMobilePhoneNumber(String mobile) {
        this.put(ATTR_MOBILEPHONE, mobile);
    }

    public boolean isMobilePhoneVerified() {
        return this.getBoolean(ATTR_MOBILEPHONE_VERIFIED);
    }

    public String getSessionToken() {
        return (String)this.get(ATTR_SESSION_TOKEN);
    }

    public void internalChangeSessionToken(String token) {
        this.getServerData().put(ATTR_SESSION_TOKEN, token);
    }

    public boolean isAuthenticated() {
        String sessionToken = this.getSessionToken();
        return !StringUtil.isEmpty(sessionToken);
    }

    private void updateCurrentUserCache() {
        String sessionToken = this.getSessionToken();
        AVUser currentUser = AVUser.currentUser();
        if (null != currentUser && !StringUtil.isEmpty(currentUser.getObjectId()) && currentUser.getObjectId().equals(this.getObjectId()) && !StringUtil.isEmpty(sessionToken)) {
            AVUser.changeCurrentUser(this, true);
        }
    }

    @Override
    protected void onSaveSuccess() {
        super.onSaveSuccess();
        this.updateCurrentUserCache();
    }

    @Override
    protected void onSaveFailure() {
        super.onSaveFailure();
    }

    @Override
    protected void onDataSynchronized() {
        super.onDataSynchronized();
        this.updateCurrentUserCache();
    }

    public boolean isAnonymous() {
        JSONObject existedAuthData = this.getJSONObject(AUTHDATA_TAG);
        return existedAuthData != null && existedAuthData.size() == 1 && existedAuthData.containsKey(AUTHDATA_PLATFORM_ANONYMOUS);
    }

    public void signUp() {
        this.signUpInBackground().blockingSubscribe();
    }

    public Observable<AVUser> signUpInBackground() {
        JSONObject paramData = this.generateChangedParam();
        logger.d("signup param: " + paramData.toJSONString());
        return PaasClient.getStorageClient().signUp(paramData).map((Function)new Function<AVUser, AVUser>(){

            public AVUser apply(AVUser avUser) throws Exception {
                AVUser.this.mergeRawData(avUser, true);
                AVUser.this.onSaveSuccess();
                return AVUser.this;
            }
        });
    }

    public static AVUser signUpOrLoginByMobilePhone(String mobilePhoneNumber, String smsCode) {
        return AVUser.signUpOrLoginByMobilePhone(mobilePhoneNumber, smsCode, AVUser.internalUserClazz());
    }

    public static <T extends AVUser> T signUpOrLoginByMobilePhone(String mobilePhoneNumber, String smsCode, Class<T> clazz) {
        return (T)((AVUser)AVUser.signUpOrLoginByMobilePhoneInBackground(mobilePhoneNumber, smsCode, clazz).blockingSingle());
    }

    public static Observable<? extends AVUser> signUpOrLoginByMobilePhoneInBackground(String mobilePhoneNumber, String smsCode) {
        return AVUser.signUpOrLoginByMobilePhoneInBackground(mobilePhoneNumber, smsCode, AVUser.internalUserClazz());
    }

    public static <T extends AVUser> Observable<T> signUpOrLoginByMobilePhoneInBackground(String mobilePhoneNumber, String smsCode, Class<T> clazz) {
        if (StringUtil.isEmpty(mobilePhoneNumber)) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, ATTR_MOBILEPHONE)));
        }
        if (StringUtil.isEmpty(smsCode)) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, ATTR_SMSCODE)));
        }
        if (null == clazz) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, "clazz")));
        }
        Map<String, Object> params = AVUser.createUserMap(null, null, null, mobilePhoneNumber, smsCode);
        JSONObject data = JSONObject.Builder.create(params);
        return PaasClient.getStorageClient().signUpOrLoginByMobilephone(data, clazz);
    }

    public static Observable<? extends AVUser> logIn(String username, String password) {
        return AVUser.logIn(username, password, AVUser.internalUserClazz());
    }

    public static Observable<? extends AVUser> logInAnonymously() {
        String anonymousId = UUID.randomUUID().toString().toLowerCase();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("id", anonymousId);
        return AVUser.loginWithAuthData(param, AUTHDATA_PLATFORM_ANONYMOUS);
    }

    public static <T extends AVUser> Observable<T> logIn(String username, String password, Class<T> clazz) {
        Map<String, Object> params = AVUser.createUserMap(username, password, null, null, null);
        JSONObject data = JSONObject.Builder.create(params);
        return PaasClient.getStorageClient().logIn(data, clazz);
    }

    public static Observable<? extends AVUser> loginByMobilePhoneNumber(String mobile, String password) {
        return AVUser.loginByMobilePhoneNumber(mobile, password, AVUser.internalUserClazz());
    }

    public static Observable<? extends AVUser> loginByEmail(String email, String password) {
        HashMap<String, Object> params = AVUser.createUserMapAFAP(null, password, email, null, null);
        return PaasClient.getStorageClient().logIn(JSONObject.Builder.create(params), AVUser.internalUserClazz());
    }

    public static <T extends AVUser> Observable<T> loginByMobilePhoneNumber(String mobile, String password, Class<T> clazz) {
        Map<String, Object> params = AVUser.createUserMap(null, password, null, mobile, null);
        JSONObject data = JSONObject.Builder.create(params);
        return PaasClient.getStorageClient().logIn(data, clazz);
    }

    public static Observable<? extends AVUser> loginBySMSCode(String mobile, String smsCode) {
        return AVUser.loginBySMSCode(mobile, smsCode, AVUser.internalUserClazz());
    }

    public static <T extends AVUser> Observable<T> loginBySMSCode(String mobile, String smsCode, Class<T> clazz) {
        Map<String, Object> params = AVUser.createUserMap(null, null, null, mobile, smsCode);
        JSONObject data = JSONObject.Builder.create(params);
        return PaasClient.getStorageClient().logIn(data, clazz);
    }

    private static Map<String, Object> createUserMap(String username, String password, String email, String phoneNumber, String smsCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtil.isEmpty(username) && StringUtil.isEmpty(phoneNumber)) {
            throw new IllegalArgumentException("Blank username and blank mobile phone number");
        }
        if (!StringUtil.isEmpty(username)) {
            map.put(ATTR_USERNAME, username);
        }
        if (!StringUtil.isEmpty(password)) {
            map.put(ATTR_PASSWORD, password);
        }
        if (!StringUtil.isEmpty(email)) {
            map.put(ATTR_EMAIL, email);
        }
        if (!StringUtil.isEmpty(phoneNumber)) {
            map.put(ATTR_MOBILEPHONE, phoneNumber);
        }
        if (!StringUtil.isEmpty(smsCode)) {
            map.put(ATTR_SMSCODE, smsCode);
        }
        return map;
    }

    private static HashMap<String, Object> createUserMapAFAP(String username, String password, String email, String phoneNumber, String smsCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!StringUtil.isEmpty(username)) {
            map.put(ATTR_USERNAME, username);
        }
        if (!StringUtil.isEmpty(password)) {
            map.put(ATTR_PASSWORD, password);
        }
        if (!StringUtil.isEmpty(email)) {
            map.put(ATTR_EMAIL, email);
        }
        if (!StringUtil.isEmpty(phoneNumber)) {
            map.put(ATTR_MOBILEPHONE, phoneNumber);
        }
        if (!StringUtil.isEmpty(smsCode)) {
            map.put(ATTR_SMSCODE, smsCode);
        }
        return map;
    }

    public static Observable<? extends AVUser> loginWithAuthData(Map<String, Object> authData, String platform) {
        return AVUser.loginWithAuthData(AVUser.internalUserClazz(), authData, platform);
    }

    public static Observable<? extends AVUser> loginWithAuthData(Map<String, Object> authData, String platform, String unionId, String unionIdPlatform, boolean asMainAccount) {
        return AVUser.loginWithAuthData(AVUser.internalUserClazz(), authData, platform, unionId, unionIdPlatform, asMainAccount);
    }

    public static <T extends AVUser> Observable<T> loginWithAuthData(final Class<T> clazz, Map<String, Object> authData, String platform) {
        if (null == clazz) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, "clazz")));
        }
        if (null == authData || authData.isEmpty()) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, AUTHDATA_TAG)));
        }
        if (StringUtil.isEmpty(platform)) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, AUTHDATA_ATTR_UNIONID_PLATFORM)));
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        HashMap<String, Map<String, Object>> authMap = new HashMap<String, Map<String, Object>>();
        authMap.put(platform, authData);
        data.put(AUTHDATA_TAG, authMap);
        JSONObject param = JSONObject.Builder.create(data);
        return PaasClient.getStorageClient().signUp(param).map(new Function<AVUser, T>(){

            public T apply(AVUser avUser) throws Exception {
                AVUser result = (AVUser)Transformer.transform((AVObject)avUser, clazz);
                AVUser.changeCurrentUser(result, true);
                return result;
            }
        });
    }

    public static <T extends AVUser> Observable<T> loginWithAuthData(Class<T> clazz, Map<String, Object> authData, String platform, String unionId, String unionIdPlatform, boolean asMainAccount) {
        if (StringUtil.isEmpty(unionId)) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, "unionId")));
        }
        if (StringUtil.isEmpty(unionIdPlatform)) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, "unionIdPlatform")));
        }
        if (null == authData || authData.isEmpty()) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, AUTHDATA_TAG)));
        }
        authData.put(AUTHDATA_ATTR_UNIONID, unionId);
        authData.put(AUTHDATA_ATTR_UNIONID_PLATFORM, unionIdPlatform);
        if (asMainAccount) {
            authData.put(AUTHDATA_ATTR_MAIN_ACCOUNT, asMainAccount);
        }
        return AVUser.loginWithAuthData(clazz, authData, platform);
    }

    public Observable<AVUser> loginWithAuthData(Map<String, Object> authData, String platform, boolean failOnNotExist) {
        if (null == authData || authData.isEmpty()) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, AUTHDATA_TAG)));
        }
        if (StringUtil.isEmpty(platform)) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, AUTHDATA_ATTR_UNIONID_PLATFORM)));
        }
        HashMap<String, Object> data = AVUser.createUserMapAFAP(this.getUsername(), null, this.getEmail(), this.getMobilePhoneNumber(), null);
        HashMap<String, Map<String, Object>> authMap = new HashMap<String, Map<String, Object>>();
        authMap.put(platform, authData);
        data.put(AUTHDATA_TAG, authMap);
        JSONObject param = JSONObject.Builder.create(data);
        return PaasClient.getStorageClient().signUpWithFlag(param, failOnNotExist).map((Function)new Function<AVUser, AVUser>(){

            public AVUser apply(AVUser avUser) throws Exception {
                AVUser.this.resetByRawData(avUser);
                AVUser.changeCurrentUser(AVUser.this, true);
                return AVUser.this;
            }
        });
    }

    public Observable<AVUser> loginWithAuthData(Map<String, Object> authData, String platform, String unionId, String unionIdPlatform, boolean asMainAccount, boolean failOnNotExist) {
        if (null == authData || authData.isEmpty()) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, AUTHDATA_TAG)));
        }
        if (StringUtil.isEmpty(unionId)) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, "unionId")));
        }
        if (StringUtil.isEmpty(unionIdPlatform)) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, "unionIdPlatform")));
        }
        authData.put(AUTHDATA_ATTR_UNIONID, unionId);
        authData.put(AUTHDATA_ATTR_UNIONID_PLATFORM, unionIdPlatform);
        if (asMainAccount) {
            authData.put(AUTHDATA_ATTR_MAIN_ACCOUNT, asMainAccount);
        }
        return this.loginWithAuthData(authData, platform, failOnNotExist);
    }

    public Observable<AVUser> associateWithAuthData(Map<String, Object> authData, String platform) {
        if (null == authData || authData.isEmpty()) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, AUTHDATA_TAG)));
        }
        if (StringUtil.isEmpty(platform)) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, AUTHDATA_ATTR_UNIONID_PLATFORM)));
        }
        HashMap<String, Map<String, Object>> authDataAttr = new HashMap<String, Map<String, Object>>();
        authDataAttr.put(platform, authData);
        Object existedAuthData = this.get(AUTHDATA_TAG);
        if (existedAuthData instanceof Map) {
            authDataAttr.putAll((Map)existedAuthData);
        }
        this.put(AUTHDATA_TAG, authDataAttr);
        return this.saveInBackground(new AVSaveOption().setFetchWhenSave(true));
    }

    public Observable<AVUser> associateWithAuthData(Map<String, Object> authData, String platform, String unionId, String unionIdPlatform, boolean asMainAccount) {
        if (null == authData || authData.isEmpty()) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, AUTHDATA_TAG)));
        }
        if (StringUtil.isEmpty(unionId)) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, "unionId")));
        }
        if (StringUtil.isEmpty(unionIdPlatform)) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, "unionIdPlatform")));
        }
        authData.put(AUTHDATA_ATTR_UNIONID, unionId);
        authData.put(AUTHDATA_ATTR_UNIONID_PLATFORM, unionIdPlatform);
        if (asMainAccount) {
            authData.put(AUTHDATA_ATTR_MAIN_ACCOUNT, true);
        }
        return this.associateWithAuthData(authData, platform);
    }

    public Observable<AVUser> dissociateWithAuthData(final String platform) {
        if (StringUtil.isEmpty(platform)) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, AUTHDATA_ATTR_UNIONID_PLATFORM)));
        }
        String objectId = this.getObjectId();
        if (StringUtil.isEmpty(objectId) || !this.isAuthenticated()) {
            return Observable.error((Throwable)new AVException(206, "the user object missing a valid session"));
        }
        this.remove("authData." + platform);
        return this.saveInBackground().map((Function)new Function<AVObject, AVUser>(){

            public AVUser apply(@NonNull AVObject var1) throws Exception {
                Map authData = (Map)AVUser.this.get(AVUser.AUTHDATA_TAG);
                if (authData != null) {
                    authData.remove(platform);
                }
                return AVUser.this;
            }
        });
    }

    public Observable<Boolean> checkAuthenticatedInBackground() {
        String sessionToken = this.getSessionToken();
        if (StringUtil.isEmpty(sessionToken)) {
            logger.d("sessionToken is not existed.");
            return Observable.just((Object)false);
        }
        return PaasClient.getStorageClient().checkAuthenticated(sessionToken);
    }

    public Observable<Boolean> refreshSessionTokenInBackground() {
        return PaasClient.getStorageClient().refreshSessionToken(this);
    }

    public static AVUser becomeWithSessionToken(String sessionToken) {
        return AVUser.becomeWithSessionToken(sessionToken, false);
    }

    public static AVUser becomeWithSessionToken(String sessionToken, boolean saveToCurrentUser) {
        AVUser usr = (AVUser)AVUser.becomeWithSessionTokenInBackground(sessionToken, saveToCurrentUser).blockingFirst();
        return usr;
    }

    public static Observable<? extends AVUser> becomeWithSessionTokenInBackground(String sessionToken) {
        return AVUser.becomeWithSessionTokenInBackground(sessionToken, false);
    }

    public static Observable<? extends AVUser> becomeWithSessionTokenInBackground(String sessionToken, boolean saveToCurrentUser) {
        return AVUser.becomeWithSessionTokenInBackground(sessionToken, saveToCurrentUser, AVUser.internalUserClazz());
    }

    public static <T extends AVUser> T becomeWithSessionToken(String sessionToken, Class<T> clazz) {
        return AVUser.becomeWithSessionToken(sessionToken, false, clazz);
    }

    public static <T extends AVUser> T becomeWithSessionToken(String sessionToken, boolean saveToCurrentUser, Class<T> clazz) {
        AVUser result = (AVUser)AVUser.becomeWithSessionTokenInBackground(sessionToken, saveToCurrentUser, clazz).blockingFirst();
        return (T)result;
    }

    public static <T extends AVUser> Observable<T> becomeWithSessionTokenInBackground(String sessionToken, Class<T> clazz) {
        return AVUser.becomeWithSessionTokenInBackground(sessionToken, false, clazz);
    }

    public static <T extends AVUser> Observable<T> becomeWithSessionTokenInBackground(String sessionToken, final boolean saveToCurrentUser, Class<T> clazz) {
        return PaasClient.getStorageClient().createUserBySession(sessionToken, clazz).map(new Function<T, T>(){

            public T apply(T result) throws Exception {
                if (saveToCurrentUser) {
                    AVUser.changeCurrentUser(result, true);
                }
                return result;
            }
        });
    }

    public static void logOut() {
        AVUser.changeCurrentUser(null, true);
    }

    public static <T extends AVUser> AVQuery<T> getUserQuery(Class<T> clazz) {
        return new AVQuery<T>(CLASS_NAME, clazz);
    }

    public static AVQuery<AVUser> getQuery() {
        return AVUser.getQuery(AVUser.class);
    }

    public Observable<List<AVRole>> getRolesInBackground() {
        AVQuery roleQuery = new AVQuery("_Role");
        roleQuery.whereEqualTo("users", this);
        return roleQuery.findInBackground();
    }

    public static void enableAutomaticUser() {
        enableAutomatic = true;
    }

    public static boolean isEnableAutomatic() {
        return enableAutomatic;
    }

    public static void disableAutomaticUser() {
        enableAutomatic = false;
    }

    private static File currentUserArchivePath() {
        return new File(AppConfiguration.getDocumentDir() + "/currentUser");
    }

    private static boolean userArchiveExist() {
        return AVUser.currentUserArchivePath().exists();
    }

    public static synchronized void changeCurrentUser(AVUser newUser, boolean save) {
        if (AppConfiguration.isIncognitoMode()) {
            return;
        }
        if (null != newUser) {
            newUser.removeOperationForKey(ATTR_PASSWORD);
        }
        File currentUserArchivePath = AVUser.currentUserArchivePath();
        if (null != newUser && save) {
            String jsonString = newUser.toJSONString();
            logger.d(jsonString);
            PersistenceUtil.sharedInstance().saveContentToFile(jsonString, currentUserArchivePath);
        } else if (save) {
            PersistenceUtil.sharedInstance().removeLock(currentUserArchivePath.getAbsolutePath());
            boolean deleteRst = currentUserArchivePath.delete();
            if (!deleteRst) {
                logger.w("failed to delete currentUser cache file.");
            }
        }
        PaasClient.getStorageClient().setCurrentUser(newUser);
    }

    public static AVUser getCurrentUser() {
        return AVUser.getCurrentUser(AVUser.internalUserClazz());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static <T extends AVUser> T getCurrentUser(Class<T> userClass) {
        if (AppConfiguration.isIncognitoMode()) {
            return null;
        }
        AVUser user = PaasClient.getStorageClient().getCurrentUser();
        if (null != user && userClass.isAssignableFrom(user.getClass())) {
            return (T)user;
        }
        if (AVUser.userArchiveExist()) {
            File currentUserArchivePath = AVUser.currentUserArchivePath();
            Class<AVUser> clazz = AVUser.class;
            // MONITORENTER : cn.leancloud.AVUser.class
            String jsonString = PersistenceUtil.sharedInstance().readContentFromFile(currentUserArchivePath);
            if (!StringUtil.isEmpty(jsonString)) {
                if (jsonString.indexOf("@type") >= 0 || jsonString.indexOf("_version") >= 0) {
                    try {
                        user = (AVUser)AVObject.parseAVObject(jsonString);
                        PaasClient.getStorageClient().setCurrentUser(user);
                    }
                    catch (Exception ex) {
                        logger.w("failed to deserialize AVUser instance.", ex);
                    }
                } else {
                    try {
                        AVUser newUser = (AVUser)userClass.newInstance();
                        Map rawData = JSON.parseObject(jsonString, Map.class);
                        if (rawData.containsKey("serverData") || rawData.get("serverData") instanceof Map) {
                            newUser.resetServerData((Map)rawData.get("serverData"));
                        } else {
                            newUser.resetServerData(rawData);
                        }
                        AVUser.changeCurrentUser(newUser, true);
                        user = newUser;
                    }
                    catch (Exception ex) {
                        logger.w(ex);
                    }
                }
            }
            // MONITOREXIT : clazz
        }
        if (!enableAutomatic) return (T)((AVUser)Transformer.transform((AVObject)user, userClass));
        if (null != user) return (T)((AVUser)Transformer.transform((AVObject)user, userClass));
        try {
            user = (AVUser)userClass.newInstance();
            AVUser.changeCurrentUser(user, true);
            return (T)((AVUser)Transformer.transform((AVObject)user, userClass));
        }
        catch (Exception ex) {
            logger.w(ex);
        }
        return (T)((AVUser)Transformer.transform((AVObject)user, userClass));
    }

    public static Observable<AVNull> requestPasswordResetInBackground(String email) {
        return PaasClient.getStorageClient().requestResetPassword(email);
    }

    public static Observable<AVNull> requestPasswordResetBySmsCodeInBackground(String phoneNumber) {
        return AVUser.requestPasswordResetBySmsCodeInBackground(phoneNumber, null);
    }

    public static Observable<AVNull> requestPasswordResetBySmsCodeInBackground(String phoneNumber, String validateToken) {
        return PaasClient.getStorageClient().requestResetPasswordBySmsCode(phoneNumber, validateToken);
    }

    public static Observable<AVNull> resetPasswordBySmsCodeInBackground(String smsCode, String newPassword) {
        return PaasClient.getStorageClient().resetPasswordBySmsCode(smsCode, newPassword);
    }

    public Observable<AVNull> updatePasswordInBackground(String oldPass, String newPass) {
        return PaasClient.getStorageClient().updatePassword(this, oldPass, newPass);
    }

    public static Observable<AVNull> requestEmailVerifyInBackground(String email) {
        return PaasClient.getStorageClient().requestEmailVerify(email);
    }

    public static Observable<AVNull> requestMobilePhoneVerifyInBackground(String mobilePhone) {
        if (StringUtil.isEmpty(mobilePhone) || !AVSMS.checkMobilePhoneNumber(mobilePhone)) {
            return Observable.error((Throwable)new IllegalArgumentException("mobile phone number is empty or invalid"));
        }
        return AVUser.requestMobilePhoneVerifyInBackground(mobilePhone, null);
    }

    public static Observable<AVNull> requestMobilePhoneVerifyInBackground(String mobilePhone, String validateToken) {
        if (StringUtil.isEmpty(mobilePhone) || !AVSMS.checkMobilePhoneNumber(mobilePhone)) {
            return Observable.error((Throwable)new IllegalArgumentException("mobile phone number is empty or invalid"));
        }
        return PaasClient.getStorageClient().requestMobilePhoneVerify(mobilePhone, validateToken);
    }

    public static Observable<AVNull> requestLoginSmsCodeInBackground(String mobilePhone) {
        if (StringUtil.isEmpty(mobilePhone) || !AVSMS.checkMobilePhoneNumber(mobilePhone)) {
            return Observable.error((Throwable)new IllegalArgumentException("mobile phone number is empty or invalid"));
        }
        return AVUser.requestLoginSmsCodeInBackground(mobilePhone, null);
    }

    public static Observable<AVNull> requestLoginSmsCodeInBackground(String mobilePhone, String validateToken) {
        if (StringUtil.isEmpty(mobilePhone) || !AVSMS.checkMobilePhoneNumber(mobilePhone)) {
            return Observable.error((Throwable)new IllegalArgumentException("mobile phone number is empty or invalid"));
        }
        return PaasClient.getStorageClient().requestLoginSmsCode(mobilePhone, validateToken);
    }

    public static Observable<AVNull> verifyMobilePhoneInBackground(String verifyCode) {
        return PaasClient.getStorageClient().verifyMobilePhone(verifyCode);
    }

    public static Observable<AVNull> requestSMSCodeForUpdatingPhoneNumberInBackground(String mobilePhone, AVSMSOption option) {
        return AVUser.requestSMSCodeForUpdatingPhoneNumberInBackground(null, mobilePhone, option);
    }

    public static Observable<AVNull> requestSMSCodeForUpdatingPhoneNumberInBackground(AVUser asAuthenticatedUser, String mobilePhone, AVSMSOption option) {
        if (StringUtil.isEmpty(mobilePhone) || !AVSMS.checkMobilePhoneNumber(mobilePhone)) {
            return Observable.error((Throwable)new IllegalArgumentException("mobile phone number is empty or invalid"));
        }
        HashMap<String, Object> param = null == option ? new HashMap() : option.getOptionMap();
        return PaasClient.getStorageClient().requestSMSCodeForUpdatingPhoneNumber(asAuthenticatedUser, mobilePhone, param);
    }

    public static Observable<AVNull> verifySMSCodeForUpdatingPhoneNumberInBackground(String code, String mobilePhone) {
        return AVUser.verifySMSCodeForUpdatingPhoneNumberInBackground(null, code, mobilePhone);
    }

    public static Observable<AVNull> verifySMSCodeForUpdatingPhoneNumberInBackground(AVUser asAuthenticatedUser, String code, String mobilePhone) {
        if (StringUtil.isEmpty(code) || StringUtil.isEmpty(mobilePhone)) {
            return Observable.error((Throwable)new IllegalArgumentException("code or mobilePhone is empty"));
        }
        return PaasClient.getStorageClient().verifySMSCodeForUpdatingPhoneNumber(asAuthenticatedUser, code, mobilePhone);
    }

    private boolean checkUserAuthentication(AVCallback callback) {
        if (!this.isAuthenticated() || StringUtil.isEmpty(this.getObjectId())) {
            if (callback != null) {
                callback.internalDone(ErrorUtils.propagateException(206, "No valid session token, make sure signUp or login has been called."));
            }
            return false;
        }
        return true;
    }

    public Observable<JSONObject> followInBackground(String userObjectId) {
        return this.followInBackground(null, userObjectId);
    }

    public Observable<JSONObject> followInBackground(AVUser asAuthenticatedUser, String userObjectId) {
        return this.followInBackground(asAuthenticatedUser, userObjectId, new HashMap<String, Object>());
    }

    public Observable<JSONObject> followInBackground(String userObjectId, Map<String, Object> attributes) {
        return this.followInBackground(null, userObjectId, attributes);
    }

    public Observable<JSONObject> followInBackground(AVUser asAuthenticatedUser, String userObjectId, Map<String, Object> attributes) {
        if (!this.checkUserAuthentication(null)) {
            return Observable.error((Throwable)ErrorUtils.propagateException(206, "No valid session token, make sure signUp or login has been called."));
        }
        return PaasClient.getStorageClient().followUser(asAuthenticatedUser, this.getObjectId(), userObjectId, attributes);
    }

    public Observable<JSONObject> unfollowInBackground(String userObjectId) {
        return this.unfollowInBackground(null, userObjectId);
    }

    public Observable<JSONObject> unfollowInBackground(AVUser asAuthenticatedUser, String userObjectId) {
        if (!this.checkUserAuthentication(null)) {
            return Observable.error((Throwable)ErrorUtils.propagateException(206, "No valid session token, make sure signUp or login has been called."));
        }
        return PaasClient.getStorageClient().unfollowUser(asAuthenticatedUser, this.getObjectId(), userObjectId);
    }

    public AVQuery<AVObject> followerQuery() {
        return AVUser.followerQuery(this.getObjectId(), AVObject.class);
    }

    public AVQuery<AVObject> followeeQuery() {
        return AVUser.followeeQuery(this.getObjectId(), AVObject.class);
    }

    public static <T extends AVObject> AVQuery<T> followerQuery(String userObjectId, Class<T> clazz) {
        if (StringUtil.isEmpty(userObjectId)) {
            throw new IllegalArgumentException("Blank user objectId");
        }
        AVQuery<T> query = new AVQuery<T>("_Follower", clazz);
        query.whereEqualTo("user", AVUser.createWithoutData(CLASS_NAME, userObjectId));
        query.include(FOLLOWER_TAG);
        return query;
    }

    public static <T extends AVObject> AVQuery<T> followeeQuery(String userObjectId, Class<T> clazz) {
        if (StringUtil.isEmpty(userObjectId)) {
            throw new IllegalArgumentException("Blank user objectId");
        }
        AVQuery<T> query = new AVQuery<T>("_Followee", clazz);
        query.whereEqualTo("user", AVUser.createWithoutData(CLASS_NAME, userObjectId));
        query.include(FOLLOWEE_TAG);
        return query;
    }

    public AVQuery<AVFriendship> friendshipQuery(boolean isFollowerDirection) {
        String userObjectId = this.getObjectId();
        if (StringUtil.isEmpty(userObjectId)) {
            logger.d("user object id is empty.");
            return null;
        }
        AVQuery<AVFriendship> query = new AVQuery<AVFriendship>("_Followee");
        if (isFollowerDirection) {
            query.whereEqualTo(FOLLOWEE_TAG, AVUser.createWithoutData(CLASS_NAME, userObjectId));
            query.include("user");
        } else {
            query.whereEqualTo("user", AVUser.createWithoutData(CLASS_NAME, userObjectId));
            query.include(FOLLOWEE_TAG);
        }
        return query;
    }

    public Observable<AVFriendshipRequest> applyFriendshipInBackground(AVUser friend, Map<String, Object> attributes) {
        return this.applyFriendshipInBackground(null, friend, attributes);
    }

    public Observable<AVFriendshipRequest> applyFriendshipInBackground(AVUser asAuthenticatedUser, AVUser friend, Map<String, Object> attributes) {
        if (!this.checkUserAuthentication(null)) {
            logger.d("current user isn't authenticated.");
            return Observable.error((Throwable)ErrorUtils.propagateException(206, "No valid session token, make sure signUp or login has been called."));
        }
        if (null == friend || StringUtil.isEmpty(friend.getObjectId())) {
            return Observable.error((Throwable)ErrorUtils.propagateException(9304, "friend user is invalid."));
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("user", Utils.getParsedObject(this));
        param.put("friend", Utils.getParsedObject(friend));
        if (null != attributes && attributes.size() > 0) {
            param.put(PARAM_ATTR_FRIENDSHIP, attributes);
        }
        JSONObject jsonObject = JSONObject.Builder.create(param);
        return PaasClient.getStorageClient().applyFriendshipRequest(asAuthenticatedUser, jsonObject);
    }

    public Observable<AVFriendship> updateFriendship(AVFriendship friendship) {
        return this.updateFriendship(null, friendship);
    }

    public Observable<AVFriendship> updateFriendship(AVUser asAuthenticatedUser, AVFriendship friendship) {
        if (!this.checkUserAuthentication(null)) {
            logger.d("current user isn't authenticated.");
            return Observable.error((Throwable)ErrorUtils.propagateException(206, "No valid session token, make sure signUp or login has been called."));
        }
        if (null == friendship || StringUtil.isEmpty(friendship.getObjectId())) {
            return Observable.error((Throwable)ErrorUtils.propagateException(9304, "friendship request(objectId) is invalid."));
        }
        if (null == friendship.getFollowee() || StringUtil.isEmpty(friendship.getFollowee().getObjectId())) {
            return Observable.error((Throwable)ErrorUtils.propagateException(9304, "friendship request(followee) is invalid."));
        }
        JSONObject changedParam = friendship.generateChangedParam();
        if (null == changedParam || changedParam.size() < 1) {
            logger.d("nothing is changed within friendship.");
            return Observable.just((Object)friendship);
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(PARAM_ATTR_FRIENDSHIP, changedParam);
        return PaasClient.getStorageClient().updateFriendship(asAuthenticatedUser, this.getObjectId(), friendship.getFollowee().getObjectId(), param);
    }

    public Observable<AVFriendshipRequest> acceptFriendshipRequest(AVFriendshipRequest request, Map<String, Object> attributes) {
        return this.acceptFriendshipRequest(null, request, attributes);
    }

    public Observable<AVFriendshipRequest> acceptFriendshipRequest(AVUser asAuthenticatedUser, AVFriendshipRequest request, Map<String, Object> attributes) {
        if (!this.checkUserAuthentication(null)) {
            logger.d("current user isn't authenticated.");
            return Observable.error((Throwable)ErrorUtils.propagateException(206, "No valid session token, make sure signUp or login has been called."));
        }
        if (null == request || StringUtil.isEmpty(request.getObjectId())) {
            return Observable.error((Throwable)ErrorUtils.propagateException(9304, "friendship request(objectId) is invalid."));
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (null != attributes && attributes.size() > 0) {
            param.put(PARAM_ATTR_FRIENDSHIP, attributes);
        }
        JSONObject jsonObject = JSONObject.Builder.create(param);
        return PaasClient.getStorageClient().acceptFriendshipRequest(asAuthenticatedUser, request, jsonObject);
    }

    public Observable<AVFriendshipRequest> declineFriendshipRequest(AVFriendshipRequest request) {
        return this.declineFriendshipRequest(null, request);
    }

    public Observable<AVFriendshipRequest> declineFriendshipRequest(AVUser asAuthenticatedUser, AVFriendshipRequest request) {
        if (!this.checkUserAuthentication(null)) {
            logger.d("current user isn't authenticated.");
            return Observable.error((Throwable)ErrorUtils.propagateException(206, "No valid session token, make sure signUp or login has been called."));
        }
        if (null == request || StringUtil.isEmpty(request.getObjectId())) {
            return Observable.error((Throwable)ErrorUtils.propagateException(9304, "friendship request(objectId) is invalid."));
        }
        return PaasClient.getStorageClient().declineFriendshipRequest(asAuthenticatedUser, request);
    }

    public AVQuery<AVFriendshipRequest> friendshipRequestQuery(int status, boolean includeTargetUser, boolean requestToMe) {
        if (!this.checkUserAuthentication(null)) {
            logger.d("current user isn't authenticated.");
            return null;
        }
        ArrayList<String> statusCondition = new ArrayList<String>(1);
        if ((status & 1) == 1) {
            statusCondition.add(AVFriendshipRequest.RequestStatus.Pending.name().toLowerCase());
        }
        if ((status & 2) == 2) {
            statusCondition.add(AVFriendshipRequest.RequestStatus.Accepted.name().toLowerCase());
        }
        if ((status & 4) == 4) {
            statusCondition.add(AVFriendshipRequest.RequestStatus.Declined.name().toLowerCase());
        }
        if (statusCondition.size() < 1) {
            logger.d("status parameter is invalid.");
            return null;
        }
        AVQuery<AVFriendshipRequest> result = new AVQuery<AVFriendshipRequest>("_FriendshipRequest");
        result.whereContainedIn("status", statusCondition);
        if (requestToMe) {
            result.whereEqualTo("friend", this);
            if (includeTargetUser) {
                result.include("user");
            }
        } else {
            result.whereEqualTo("user", this);
            if (includeTargetUser) {
                result.include("friend");
            }
        }
        result.addDescendingOrder("updatedAt");
        return result;
    }

    private void processResultList(List<JSONObject> results, List<AVUser> list, String tag) {
        for (JSONObject item : results) {
            if (null == item) continue;
            AVUser user = (AVUser)Utils.parseObjectFromMap((Map)item.get(tag));
            list.add(user);
        }
    }

    private Map<String, List<AVUser>> parseFollowerAndFollowee(JSONObject jsonObject) {
        HashMap<String, List<AVUser>> map = new HashMap<String, List<AVUser>>();
        if (null != jsonObject) {
            List<JSONObject> followees;
            List<JSONObject> followers = AVUtils.getObjectListFromMapList((List)jsonObject.get("followers"));
            if (null != followers && followers.size() > 0) {
                LinkedList<AVUser> followerUsers = new LinkedList<AVUser>();
                this.processResultList(followers, followerUsers, FOLLOWER_TAG);
                map.put(FOLLOWER_TAG, followerUsers);
            }
            if (null != (followees = AVUtils.getObjectListFromMapList((List)jsonObject.get("followees"))) && followees.size() > 0) {
                LinkedList<AVUser> followeeUsers = new LinkedList<AVUser>();
                this.processResultList(followees, followeeUsers, FOLLOWEE_TAG);
                map.put(FOLLOWEE_TAG, followeeUsers);
            }
        }
        return map;
    }

    public void getFollowersAndFolloweesInBackground(FollowersAndFolloweesCallback callback) {
        this.getFollowersAndFolloweesInBackground(null, callback);
    }

    public void getFollowersAndFolloweesInBackground(AVUser asAuthenticatedUser, final FollowersAndFolloweesCallback callback) {
        if (null == callback) {
            return;
        }
        if (!this.checkUserAuthentication(callback)) {
            return;
        }
        PaasClient.getStorageClient().getFollowersAndFollowees(asAuthenticatedUser, this.getObjectId()).subscribe((Observer)new Observer<JSONObject>(){

            public void onSubscribe(Disposable disposable) {
            }

            public void onNext(JSONObject jsonObject) {
                if (null == jsonObject) {
                    callback.done(null, null);
                } else {
                    Map result = AVUser.this.parseFollowerAndFollowee(jsonObject);
                    callback.done(result, null);
                }
            }

            public void onError(Throwable throwable) {
                callback.done(null, new AVException(throwable));
            }

            public void onComplete() {
            }
        });
    }

    public static void alwaysUseSubUserClass(Class<? extends AVUser> clazz) {
        AVUser.registerSubclass(clazz);
        subClazz = clazz;
    }

    private static Class internalUserClazz() {
        return subClazz == null ? AVUser.class : subClazz;
    }

    public static <T extends AVUser> T cast(AVUser user, Class<T> clazz) {
        try {
            AVUser newUser = (AVUser)AVObject.cast(user, clazz);
            return (T)newUser;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static enum SNS_PLATFORM {
        FACEBOOK("facebook"),
        TWITTER("twitter"),
        QQ("qq"),
        WEIBO("weibo"),
        WECHAT("weixin");

        private String name;

        private SNS_PLATFORM(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

