/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.AVObject;
import cn.leancloud.AVUser;
import cn.leancloud.Transformer;
import cn.leancloud.core.PaasClient;
import cn.leancloud.query.AVCloudQueryResult;
import cn.leancloud.query.AVQueryResult;
import cn.leancloud.utils.AVUtils;
import cn.leancloud.utils.StringUtil;
import io.reactivex.Observable;
import io.reactivex.functions.Function;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

class AVCloudQuery {
    private AVCloudQuery() {
    }

    public static Observable<AVCloudQueryResult> executeInBackground(String cql) {
        return AVCloudQuery.executeInBackground(null, cql);
    }

    public static Observable<AVCloudQueryResult> executeInBackground(AVUser asAuthenticatedUser, String cql) {
        return AVCloudQuery.executeInBackground(asAuthenticatedUser, cql, AVObject.class);
    }

    public static Observable<AVCloudQueryResult> executeInBackground(String cql, Object ... params) {
        return AVCloudQuery.executeInBackground(null, cql, params);
    }

    public static Observable<AVCloudQueryResult> executeInBackground(AVUser asAuthenticatedUser, String cql, Object ... params) {
        return AVCloudQuery.executeInBackground(asAuthenticatedUser, cql, AVObject.class, params);
    }

    public static Observable<AVCloudQueryResult> executeInBackground(String cql, Class<? extends AVObject> clazz) {
        return AVCloudQuery.executeInBackground(null, cql, clazz);
    }

    public static Observable<AVCloudQueryResult> executeInBackground(AVUser asAuthenticatedUser, String cql, Class<? extends AVObject> clazz) {
        return AVCloudQuery.executeInBackground(asAuthenticatedUser, cql, clazz, null);
    }

    public static <T extends AVObject> Observable<AVCloudQueryResult> executeInBackground(String cql, Class<T> clazz, Object ... params) {
        return AVCloudQuery.executeInBackground(null, cql, clazz, params);
    }

    public static <T extends AVObject> Observable<AVCloudQueryResult> executeInBackground(AVUser asAuthenticatedUser, String cql, Class<T> clazz, Object ... params) {
        if (StringUtil.isEmpty(cql)) {
            throw new IllegalArgumentException("cql is empty");
        }
        if (null == clazz) {
            throw new IllegalArgumentException("target class is null");
        }
        LinkedList<Object> pValue = new LinkedList<Object>();
        if (null != params) {
            for (Object o : params) {
                pValue.add(o);
            }
        }
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("cql", cql);
        if (!pValue.isEmpty()) {
            p.put("pvalues", AVUtils.jsonStringFromObjectWithNull(pValue));
        }
        return PaasClient.getStorageClient().cloudQuery(asAuthenticatedUser, p).map((Function)new Function<AVQueryResult, AVCloudQueryResult>(){

            public AVCloudQueryResult apply(AVQueryResult avQueryResult) throws Exception {
                AVCloudQueryResult finalResult = new AVCloudQueryResult();
                ArrayList rawObjs = new ArrayList(avQueryResult.getCount());
                for (AVObject o : avQueryResult.getResults()) {
                    rawObjs.add(Transformer.transform(o, avQueryResult.getClassName()));
                }
                finalResult.setResults(rawObjs);
                finalResult.setCount(avQueryResult.getCount());
                return finalResult;
            }
        });
    }
}

