/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.service;

import cn.leancloud.AVFile;
import cn.leancloud.AVFriendship;
import cn.leancloud.AVObject;
import cn.leancloud.AVRole;
import cn.leancloud.AVStatus;
import cn.leancloud.AVUser;
import cn.leancloud.json.JSONObject;
import cn.leancloud.query.AVQueryResult;
import cn.leancloud.search.AVSearchResponse;
import cn.leancloud.sms.AVCaptchaDigest;
import cn.leancloud.sms.AVCaptchaValidateResult;
import cn.leancloud.types.AVDate;
import cn.leancloud.types.AVNull;
import cn.leancloud.upload.FileUploadToken;
import io.reactivex.Observable;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;

public interface APIService {
    public static final String HEADER_KEY_LC_SESSIONTOKEN = "X-LC-Session";

    @GET(value="/1.1/classes/{className}")
    public Observable<List<? extends AVObject>> findObjects(@Header(value="X-LC-Session") String var1, @Path(value="className") String var2);

    @GET(value="/1.1/classes/{className}")
    public Observable<AVQueryResult> queryObjects(@Header(value="X-LC-Session") String var1, @Path(value="className") String var2, @QueryMap Map<String, String> var3);

    @GET(value="/1.1/cloudQuery")
    public Observable<AVQueryResult> cloudQuery(@Header(value="X-LC-Session") String var1, @QueryMap Map<String, String> var2);

    @GET(value="/1.1/classes/{className}/{objectId}")
    public Observable<AVObject> fetchObject(@Header(value="X-LC-Session") String var1, @Path(value="className") String var2, @Path(value="objectId") String var3);

    @GET(value="/1.1/classes/{className}/{objectId}")
    public Observable<AVObject> fetchObject(@Header(value="X-LC-Session") String var1, @Path(value="className") String var2, @Path(value="objectId") String var3, @Query(value="include") String var4);

    @POST(value="/1.1/classes/{className}")
    public Observable<AVObject> createObject(@Header(value="X-LC-Session") String var1, @Path(value="className") String var2, @Body JSONObject var3, @Query(value="fetchWhenSave") boolean var4, @Query(value="where") JSONObject var5);

    @PUT(value="/1.1/classes/{className}/{objectId}")
    public Observable<AVObject> updateObject(@Header(value="X-LC-Session") String var1, @Path(value="className") String var2, @Path(value="objectId") String var3, @Body JSONObject var4, @Query(value="fetchWhenSave") boolean var5, @Query(value="where") JSONObject var6);

    @HTTP(method="DELETE", path="/1.1/classes/{className}/{objectId}", hasBody=true)
    public Observable<AVNull> deleteObject(@Header(value="X-LC-Session") String var1, @Path(value="className") String var2, @Path(value="objectId") String var3, @Body Map<String, Object> var4);

    @POST(value="/1.1/batch")
    public Observable<List<Map<String, Object>>> batchCreate(@Header(value="X-LC-Session") String var1, @Body JSONObject var2);

    @POST(value="/1.1/{endpointClass}")
    public Observable<AVObject> saveWholeObject(@Header(value="X-LC-Session") String var1, @Path(value="endpointClass") String var2, @Body JSONObject var3, @Query(value="fetchWhenSave") boolean var4, @Query(value="where") JSONObject var5);

    @PUT(value="/1.1/{endpointClass}/{objectId}")
    public Observable<AVObject> saveWholeObject(@Header(value="X-LC-Session") String var1, @Path(value="endpointClass") String var2, @Path(value="objectId") String var3, @Body JSONObject var4, @Query(value="fetchWhenSave") boolean var5, @Query(value="where") JSONObject var6);

    @GET(value="/1.1/{endpointClass}/{objectId}")
    public Observable<AVObject> getWholeObject(@Header(value="X-LC-Session") String var1, @Path(value="endpointClass") String var2, @Path(value="objectId") String var3, @Query(value="include") String var4);

    @HTTP(method="DELETE", path="/1.1/{endpointClass}/{objectId}", hasBody=true)
    public Observable<AVNull> deleteWholeObject(@Header(value="X-LC-Session") String var1, @Path(value="endpointClass") String var2, @Path(value="objectId") String var3, @Body Map<String, Object> var4);

    @POST(value="/1.1/batch/save")
    public Observable<JSONObject> batchUpdate(@Header(value="X-LC-Session") String var1, @Body JSONObject var2);

    @POST(value="/1.1/functions/{name}")
    public Observable<Map<String, Object>> cloudFunction(@Header(value="X-LC-Session") String var1, @Path(value="name") String var2, @Body Map<String, Object> var3);

    @POST(value="/1.1/call/{name}")
    public Observable<Map<String, Object>> cloudRPC(@Header(value="X-LC-Session") String var1, @Path(value="name") String var2, @Body Object var3);

    @POST(value="/1.1/fileTokens")
    public Observable<FileUploadToken> createUploadToken(@Header(value="X-LC-Session") String var1, @Body JSONObject var2);

    @POST(value="/1.1/fileCallback")
    public Call<AVNull> fileCallback(@Header(value="X-LC-Session") String var1, @Body JSONObject var2);

    @GET(value="/1.1/files/{objectId}")
    public Observable<AVFile> fetchFile(@Header(value="X-LC-Session") String var1, @Path(value="objectId") String var2);

    @GET(value="/1.1/date")
    public Observable<AVDate> currentTimeMillis();

    @POST(value="/1.1/roles")
    public Observable<AVRole> createRole(@Body JSONObject var1);

    @POST(value="/1.1/users")
    public Observable<AVUser> signup(@Body JSONObject var1);

    @POST(value="/1.1/users")
    public Observable<AVUser> signup(@Body JSONObject var1, @Query(value="failOnNotExist") boolean var2);

    @GET(value="/1.1/users")
    public Observable<AVQueryResult> queryUsers(@Header(value="X-LC-Session") String var1, @QueryMap Map<String, String> var2);

    @POST(value="/1.1/users/friendshipRequests")
    public Observable<AVObject> applyFriendship(@Header(value="X-LC-Session") String var1, @Body JSONObject var2);

    @PUT(value="/1.1/users/friendshipRequests/{requestId}/accept")
    public Observable<AVObject> acceptFriendshipRequest(@Header(value="X-LC-Session") String var1, @Path(value="requestId") String var2, @Body JSONObject var3);

    @PUT(value="/1.1/users/friendshipRequests/{requestId}/decline")
    public Observable<AVObject> declineFriendshipRequest(@Header(value="X-LC-Session") String var1, @Path(value="requestId") String var2);

    @POST(value="/1.1/usersByMobilePhone")
    public Observable<AVUser> signupByMobilePhone(@Body JSONObject var1);

    @POST(value="/1.1/login")
    public Observable<AVUser> login(@Body JSONObject var1);

    @PUT(value="/1.1/users/{objectId}/updatePassword")
    public Observable<AVUser> updatePassword(@Header(value="X-LC-Session") String var1, @Path(value="objectId") String var2, @Body JSONObject var3);

    @GET(value="/1.1/users/me")
    public Observable<AVUser> checkAuthenticated(@Header(value="X-LC-Session") String var1, @QueryMap Map<String, String> var2);

    @PUT(value="/1.1/users/{objectId}/refreshSessionToken")
    public Observable<AVUser> refreshSessionToken(@Header(value="X-LC-Session") String var1, @Path(value="objectId") String var2);

    @POST(value="/1.1/requestPasswordReset")
    public Observable<AVNull> requestResetPassword(@Body Map<String, String> var1);

    @POST(value="/1.1/requestPasswordResetBySmsCode")
    public Observable<AVNull> requestResetPasswordBySmsCode(@Body Map<String, String> var1);

    @PUT(value="/1.1/resetPasswordBySmsCode/{smsCode}")
    public Observable<AVNull> resetPasswordBySmsCode(@Path(value="smsCode") String var1, @Body Map<String, String> var2);

    @POST(value="/1.1/requestEmailVerify")
    public Observable<AVNull> requestEmailVerify(@Body Map<String, String> var1);

    @POST(value="/1.1/requestMobilePhoneVerify")
    public Observable<AVNull> requestMobilePhoneVerify(@Body Map<String, String> var1);

    @POST(value="/1.1/verifyMobilePhone/{verifyCode}")
    public Observable<AVNull> verifyMobilePhone(@Path(value="verifyCode") String var1);

    @POST(value="/1.1/requestLoginSmsCode")
    public Observable<AVNull> requestLoginSmsCode(@Body Map<String, String> var1);

    @POST(value="/1.1/users/{followee}/friendship/{follower}")
    public Observable<JSONObject> followUser(@Header(value="X-LC-Session") String var1, @Path(value="followee") String var2, @Path(value="follower") String var3, @Body Map<String, Object> var4);

    @PUT(value="/1.1/users/{followee}/friendship/{friendId}")
    public Observable<AVFriendship> updateFriendship(@Header(value="X-LC-Session") String var1, @Path(value="followee") String var2, @Path(value="friendId") String var3, @Body Map<String, Object> var4);

    @DELETE(value="/1.1/users/{followee}/friendship/{follower}")
    public Observable<JSONObject> unfollowUser(@Header(value="X-LC-Session") String var1, @Path(value="followee") String var2, @Path(value="follower") String var3);

    @GET(value="/1.1/users/{userId}/followers")
    public Observable<JSONObject> getFollowers(@Header(value="X-LC-Session") String var1, @Path(value="userId") String var2);

    @GET(value="/1.1/users/{userId}/followees")
    public Observable<JSONObject> getFollowees(@Header(value="X-LC-Session") String var1, @Path(value="userId") String var2);

    @GET(value="/1.1/users/{userId}/followersAndFollowees")
    public Observable<JSONObject> getFollowersAndFollowees(@Header(value="X-LC-Session") String var1, @Path(value="userId") String var2);

    @POST(value="/1.1/statuses")
    public Observable<AVStatus> postStatus(@Header(value="X-LC-Session") String var1, @Body Map<String, Object> var2);

    @GET(value="/1.1/statuses/{statusId}")
    public Observable<AVStatus> fetchSingleStatus(@Header(value="X-LC-Session") String var1, @Path(value="statusId") String var2);

    @GET(value="/1.1/statuses")
    public Observable<AVQueryResult> fetchStatuses(@Header(value="X-LC-Session") String var1, @QueryMap Map<String, String> var2);

    @DELETE(value="/1.1/statuses/{statusId}")
    public Observable<AVNull> deleteStatus(@Header(value="X-LC-Session") String var1, @Path(value="statusId") String var2);

    @DELETE(value="/1.1/subscribe/statuses/inbox")
    public Observable<AVNull> deleteInboxStatus(@Header(value="X-LC-Session") String var1, @QueryMap Map<String, Object> var2);

    @GET(value="/1.1/subscribe/statuses")
    public Observable<AVQueryResult> queryInbox(@Header(value="X-LC-Session") String var1, @QueryMap Map<String, String> var2);

    @GET(value="/1.1/subscribe/statuses/count")
    public Observable<JSONObject> getInboxCount(@Header(value="X-LC-Session") String var1, @QueryMap Map<String, String> var2);

    @POST(value="/1.1/subscribe/statuses/resetUnreadCount")
    public Observable<AVNull> resetInboxUnreadCount(@Header(value="X-LC-Session") String var1);

    @GET(value="/1.1/requestCaptcha")
    public Observable<AVCaptchaDigest> requestCaptcha(@QueryMap Map<String, String> var1);

    @POST(value="/1.1/verifyCaptcha")
    public Observable<AVCaptchaValidateResult> verifyCaptcha(@Body Map<String, String> var1);

    @POST(value="/1.1/requestSmsCode")
    public Observable<AVNull> requestSMSCode(@Body Map<String, Object> var1);

    @POST(value="/1.1/verifySmsCode/{code}")
    public Observable<AVNull> verifySMSCode(@Path(value="code") String var1, @Body Map<String, Object> var2);

    @POST(value="/1.1/requestChangePhoneNumber")
    public Observable<AVNull> requestSMSCodeForUpdatingPhoneNumber(@Header(value="X-LC-Session") String var1, @Body Map<String, Object> var2);

    @POST(value="/1.1/changePhoneNumber")
    public Observable<AVNull> verifySMSCodeForUpdatingPhoneNumber(@Header(value="X-LC-Session") String var1, @Body Map<String, Object> var2);

    @GET(value="/1.1/search/select")
    public Observable<AVSearchResponse> search(@Header(value="X-LC-Session") String var1, @QueryMap Map<String, String> var2);
}

