/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.search;

import cn.leancloud.AVLogger;
import cn.leancloud.AVObject;
import cn.leancloud.AVUser;
import cn.leancloud.Transformer;
import cn.leancloud.core.PaasClient;
import cn.leancloud.search.AVSearchResponse;
import cn.leancloud.search.AVSearchSortBuilder;
import cn.leancloud.utils.AVUtils;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import io.reactivex.Observable;
import io.reactivex.functions.Function;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AVSearchQuery<T extends AVObject> {
    private static final AVLogger LOGGER = LogUtil.getLogger(AVSearchQuery.class);
    public static final String AVSEARCH_HIGHTLIGHT = "highlight_avoscloud_";
    public static final String AVSEARCH_APP_URL = "app_url_avoscloud_";
    public static final String AVSEARCH_DEEP_LINK = "deep_link_avoscloud_";
    public static final String DATA_EXTRA_SEARCH_KEY = "com.avos.avoscloud.search.key";
    private String sid;
    private int limit = 100;
    private int skip = 0;
    private String hightlights;
    private static final String URL = "search/select";
    private List<String> fields;
    private String queryString;
    private String titleAttribute;
    private String className;
    private int hits;
    private String order;
    private AVSearchSortBuilder sortBuilder;
    private List<String> include;
    Class<T> clazz;

    public AVSearchSortBuilder getSortBuilder() {
        return this.sortBuilder;
    }

    public void setSortBuilder(AVSearchSortBuilder sortBuilder) {
        this.sortBuilder = sortBuilder;
    }

    public AVSearchQuery() {
        this(null);
    }

    public AVSearchQuery(String queryString) {
        this(queryString, null);
    }

    public AVSearchQuery(String queryString, Class<T> clazz) {
        this.queryString = queryString;
        this.clazz = clazz;
        this.include = new LinkedList<String>();
        this.className = clazz == null ? Transformer.getSubClassName(AVObject.class) : Transformer.getSubClassName(clazz);
    }

    public String getClassName() {
        return this.className;
    }

    public AVSearchQuery order(String order) {
        this.order = order;
        return this;
    }

    public AVSearchQuery orderByAscending(String key) {
        this.order = StringUtil.isEmpty(this.order) ? String.format("%s", key) : String.format("%s,%s", this.order, key);
        return this;
    }

    public AVSearchQuery orderByDescending(String key) {
        this.order = StringUtil.isEmpty(this.order) ? String.format("-%s", key) : String.format("%s,-%s", this.order, key);
        return this;
    }

    public AVSearchQuery addAscendingOrder(String key) {
        if (StringUtil.isEmpty(this.order)) {
            return this.orderByAscending(key);
        }
        this.order = String.format("%s,%s", this.order, key);
        return this;
    }

    public AVSearchQuery addDescendingOrder(String key) {
        if (StringUtil.isEmpty(this.order)) {
            return this.orderByDescending(key);
        }
        this.order = String.format("%s,-%s", this.order, key);
        return this;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getSkip() {
        return this.skip;
    }

    public void setSkip(int skip) {
        this.skip = skip;
    }

    public void setHightLights(String hightlights) {
        this.hightlights = hightlights;
    }

    public String getHightLights() {
        return this.hightlights;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    public List<String> getFields() {
        return this.fields;
    }

    @Deprecated
    public void setLastId(String lastId) {
        this.sid = lastId;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    @Deprecated
    public String getLastId() {
        return this.sid;
    }

    public String getSid() {
        return this.sid;
    }

    public void setTitleAttribute(String titleAttribute) {
        this.titleAttribute = titleAttribute;
    }

    public String getTitleAttribute() {
        return this.titleAttribute;
    }

    public void setQueryString(String query) {
        if (!(this.queryString == null && query == null || this.queryString != null && this.queryString.equals(query))) {
            this.sid = null;
        }
        this.queryString = query;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public int getHits() {
        return this.hits;
    }

    public void include(String key) {
        this.include.add(key);
    }

    private Map<String, String> getParameters(String query) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", query);
        if (!StringUtil.isEmpty(this.sid)) {
            params.put("sid", this.sid);
        }
        if (!StringUtil.isEmpty(this.hightlights)) {
            params.put("highlights", this.hightlights);
        } else {
            params.put("highlights", "*");
        }
        if (this.fields != null && this.fields.size() > 0) {
            params.put("fields", StringUtil.join(",", this.fields));
        }
        if (this.limit > 0) {
            params.put("limit", String.valueOf(this.limit));
        }
        if (this.skip > 0) {
            params.put("skip", String.valueOf(this.skip));
        }
        if (!StringUtil.isEmpty(this.order)) {
            params.put("order", this.order);
        }
        if (this.sortBuilder != null) {
            params.put("sort", AVUtils.jsonStringFromObjectWithNull(this.sortBuilder.getSortFields()));
        }
        if (!this.include.isEmpty()) {
            String value = StringUtil.join(",", this.include);
            params.put("include", value);
        }
        if (!StringUtil.isEmpty(this.className)) {
            params.put("clazz", this.className);
        }
        return params;
    }

    public Observable<List<T>> findInBackground() {
        return this.findInBackground(null);
    }

    public Observable<List<T>> findInBackground(AVUser asAuthenticatedUser) {
        return this.getSearchResult(asAuthenticatedUser, this.getParameters(this.queryString));
    }

    protected Observable<List<T>> getSearchResult(AVUser asAuthenticatedUser, Map<String, String> params) {
        return PaasClient.getStorageClient().search(asAuthenticatedUser, params).map(new Function<AVSearchResponse, List<T>>(){

            public List<T> apply(AVSearchResponse result) throws Exception {
                return AVSearchQuery.this.processContent(result);
            }
        });
    }

    private List<T> processContent(AVSearchResponse resp) throws Exception {
        if (null == resp) {
            return Collections.emptyList();
        }
        this.sid = resp.sid;
        this.hits = resp.hits;
        LinkedList<AVObject> result = new LinkedList<AVObject>();
        for (Map item : resp.results) {
            if (item == null || item.isEmpty()) continue;
            AVObject object = this.clazz == null ? new AVObject(StringUtil.isEmpty(this.className) ? (String)item.get("className") : this.className) : (AVObject)this.clazz.newInstance();
            if (item.containsKey("_highlight")) {
                item.put(AVSEARCH_HIGHTLIGHT, item.get("_highlight"));
                item.remove("_highlight");
            }
            if (item.containsKey("_app_url")) {
                item.put(AVSEARCH_APP_URL, item.get("_app_url"));
                item.remove("_app_url");
            }
            if (item.containsKey("_deeplink")) {
                item.put(AVSEARCH_DEEP_LINK, item.get("_deeplink"));
                item.remove("_deeplink");
            }
            object.resetServerData(item);
            result.add(object);
        }
        return result;
    }
}

