/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.gson;

import cn.leancloud.gson.GsonObject;
import cn.leancloud.gson.GsonWrapper;
import cn.leancloud.json.JSONArray;
import cn.leancloud.json.JSONObject;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class GsonArray
extends JSONArray {
    private JsonArray gsonArray;

    public GsonArray(JsonArray array) {
        this.gsonArray = array;
    }

    public GsonArray(List<Object> list) {
        this.gsonArray = new JsonArray(list.size());
        for (Object obj : list) {
            this.gsonArray.add(GsonWrapper.toJsonElement(obj));
        }
    }

    public GsonArray() {
        this.gsonArray = new JsonArray();
    }

    public JsonArray getRawObject() {
        return this.gsonArray;
    }

    @Override
    public int size() {
        return this.gsonArray.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() <= 0;
    }

    @Override
    public boolean contains(Object o) {
        JsonElement elem = GsonWrapper.toJsonElement(o);
        return this.gsonArray.contains(elem);
    }

    @Override
    public Iterator<Object> iterator() {
        return new InnerIterator(this.gsonArray.iterator());
    }

    @Override
    public Object[] toArray() {
        ArrayList<Object> list = new ArrayList<Object>(this.size());
        Iterator<Object> it = this.iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        ArrayList<Object> list = new ArrayList<Object>(this.size());
        Iterator<Object> it = this.iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list.toArray(a);
    }

    @Override
    public boolean add(Object obj) {
        this.gsonArray.add(GsonWrapper.toJsonElement(obj));
        return true;
    }

    @Override
    public JSONArray fluentAdd(Object e) {
        this.add(e);
        return this;
    }

    @Override
    public boolean remove(Object o) {
        return this.gsonArray.remove(GsonWrapper.toJsonElement(o));
    }

    @Override
    public JSONArray fluentRemove(Object o) {
        this.remove(o);
        return this;
    }

    @Override
    public boolean containsAll(Collection<? extends Object> c) {
        for (Object object : c) {
            if (this.gsonArray.contains(GsonWrapper.toJsonElement(object))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Object> c) {
        for (Object object : c) {
            this.gsonArray.add(GsonWrapper.toJsonElement(object));
        }
        return true;
    }

    @Override
    public JSONArray fluentAddAll(Collection<? extends Object> c) {
        this.addAll(c);
        return this;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Object> c) {
        throw new UnsupportedOperationException("addAll with specified index.");
    }

    @Override
    public JSONArray fluentAddAll(int index, Collection<? extends Object> c) {
        this.addAll(index, c);
        return this;
    }

    @Override
    public boolean removeAll(Collection<? extends Object> c) {
        for (Object object : c) {
            this.gsonArray.remove(GsonWrapper.toJsonElement(object));
        }
        return true;
    }

    @Override
    public JSONArray fluentRemoveAll(Collection<?> c) {
        this.removeAll((Collection<? extends Object>)c);
        return this;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return false;
    }

    @Override
    public JSONArray fluentRetainAll(Collection<?> c) {
        this.retainAll(c);
        return this;
    }

    @Override
    public void clear() {
        for (int total = this.size(); total >= 1; --total) {
            this.gsonArray.remove(total - 1);
        }
    }

    @Override
    public JSONArray fluentClear() {
        this.clear();
        return this;
    }

    @Override
    public Object set(int index, Object element) {
        this.gsonArray.set(index, GsonWrapper.toJsonElement(element));
        return element;
    }

    @Override
    public JSONArray fluentSet(int index, Object element) {
        this.set(index, element);
        return this;
    }

    @Override
    public void add(int index, Object element) {
        JsonElement elem = this.gsonArray.get(index);
        if (elem.isJsonArray()) {
            ((JsonArray)elem).add(GsonWrapper.toJsonElement(element));
        }
    }

    @Override
    public JSONArray fluentAdd(int index, Object element) {
        this.add(index, element);
        return this;
    }

    @Override
    public Object remove(int index) {
        return this.gsonArray.remove(index);
    }

    @Override
    public JSONArray fluentRemove(int index) {
        this.remove(index);
        return this;
    }

    @Override
    public int indexOf(Object o) {
        JsonElement elem = GsonWrapper.toJsonElement(o);
        for (int i = 0; i < this.size(); ++i) {
            if (!elem.equals(this.gsonArray.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        JsonElement elem = GsonWrapper.toJsonElement(o);
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!elem.equals(this.gsonArray.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<Object> listIterator() {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public List<Object> subList(int fromIndex, int toIndex) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = fromIndex; i >= 0 && i < this.size() && i < toIndex; ++i) {
            result.add(GsonWrapper.toJavaObject(this.gsonArray.get(i)));
        }
        return result;
    }

    @Override
    public Object get(int index) {
        return GsonWrapper.toJavaObject(this.getElement(index));
    }

    @Override
    public JSONObject getJSONObject(int index) {
        JsonElement result = this.getElement(index);
        if (null == result || !result.isJsonObject()) {
            return null;
        }
        return new GsonObject(result.getAsJsonObject());
    }

    @Override
    public JSONArray getJSONArray(int index) {
        JsonElement result = this.getElement(index);
        if (null == result || !result.isJsonArray()) {
            return null;
        }
        return new GsonArray(result.getAsJsonArray());
    }

    @Override
    public <T> T getObject(int index, Class<T> clazz) {
        JsonElement result = this.getElement(index);
        if (null == result) {
            return null;
        }
        return GsonWrapper.toJavaObject(result, clazz);
    }

    @Override
    public <T> T getObject(int index, Type type) {
        return this.getObject(index, type);
    }

    private JsonElement getElement(int index) {
        if (index >= this.size()) {
            return null;
        }
        return this.gsonArray.get(index);
    }

    @Override
    public Boolean getBoolean(int index) {
        JsonElement elem = this.getElement(index);
        if (null == elem) {
            return false;
        }
        return elem.getAsBoolean();
    }

    @Override
    public boolean getBooleanValue(int index) {
        return this.getBoolean(index);
    }

    @Override
    public Byte getByte(int index) {
        JsonElement elem = this.getElement(index);
        if (null == elem) {
            return (byte)0;
        }
        return elem.getAsByte();
    }

    @Override
    public byte getByteValue(int index) {
        return this.getByte(index);
    }

    @Override
    public Short getShort(int index) {
        JsonElement elem = this.getElement(index);
        if (null == elem) {
            return (short)0;
        }
        return elem.getAsShort();
    }

    @Override
    public short getShortValue(int index) {
        return this.getShort(index);
    }

    @Override
    public Integer getInteger(int index) {
        JsonElement elem = this.getElement(index);
        if (null == elem) {
            return 0;
        }
        return elem.getAsInt();
    }

    @Override
    public int getIntValue(int index) {
        return this.getInteger(index);
    }

    @Override
    public Long getLong(int index) {
        JsonElement elem = this.getElement(index);
        if (null == elem) {
            return 0L;
        }
        return elem.getAsLong();
    }

    @Override
    public long getLongValue(int index) {
        return this.getLong(index);
    }

    @Override
    public Float getFloat(int index) {
        JsonElement elem = this.getElement(index);
        if (null == elem) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf(elem.getAsFloat());
    }

    @Override
    public float getFloatValue(int index) {
        return this.getFloat(index).floatValue();
    }

    @Override
    public Double getDouble(int index) {
        JsonElement elem = this.getElement(index);
        if (null == elem) {
            return 0.0;
        }
        return elem.getAsDouble();
    }

    @Override
    public double getDoubleValue(int index) {
        return this.getDouble(index);
    }

    @Override
    public BigDecimal getBigDecimal(int index) {
        JsonElement elem = this.getElement(index);
        if (null == elem) {
            return null;
        }
        return elem.getAsBigDecimal();
    }

    @Override
    public BigInteger getBigInteger(int index) {
        JsonElement elem = this.getElement(index);
        if (null == elem) {
            return null;
        }
        return elem.getAsBigInteger();
    }

    @Override
    public String getString(int index) {
        JsonElement elem = this.getElement(index);
        if (null == elem) {
            return null;
        }
        return elem.getAsString();
    }

    @Override
    public java.util.Date getDate(int index) {
        Object val = this.get(index);
        return GsonWrapper.castToDate(val);
    }

    @Override
    public Date getSqlDate(int index) {
        throw new UnsupportedOperationException("getSqlDate is not supported.");
    }

    @Override
    public Timestamp getTimestamp(int index) {
        throw new UnsupportedOperationException("getTimestamp is not supported.");
    }

    @Override
    public <T> List<T> toJavaList(Class<T> clazz) {
        ArrayList<T> result = new ArrayList<T>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            result.add(this.getObject(i, clazz));
        }
        return result;
    }

    public Object clone() {
        return new GsonArray(this.gsonArray.deepCopy());
    }

    @Override
    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GsonArray)) {
            return false;
        }
        return this.gsonArray.equals((Object)((GsonArray)obj).gsonArray);
    }

    @Override
    public int hashCode() {
        return this.gsonArray.hashCode();
    }

    @Override
    public String toJSONString() {
        return this.gsonArray.toString();
    }

    static class InnerIterator
    implements Iterator<Object> {
        private Iterator<JsonElement> gsonIterator = null;

        public InnerIterator(Iterator<JsonElement> jsonIterator) {
            this.gsonIterator = jsonIterator;
        }

        @Override
        public boolean hasNext() {
            return this.gsonIterator.hasNext();
        }

        @Override
        public Object next() {
            JsonElement elem = this.gsonIterator.next();
            if (null == elem) {
                return null;
            }
            return GsonWrapper.toJavaObject(elem);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

