/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.AVACL;
import cn.leancloud.AVObject;
import cn.leancloud.AVQuery;
import cn.leancloud.AVStatusQuery;
import cn.leancloud.AVUser;
import cn.leancloud.annotation.AVClassName;
import cn.leancloud.core.PaasClient;
import cn.leancloud.json.JSON;
import cn.leancloud.json.JSONObject;
import cn.leancloud.ops.Utils;
import cn.leancloud.types.AVNull;
import cn.leancloud.utils.ErrorUtils;
import cn.leancloud.utils.StringUtil;
import io.reactivex.Observable;
import io.reactivex.functions.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@AVClassName(value="_Status")
public class AVStatus
extends AVObject {
    public static final String CLASS_NAME = "_Status";
    public static final String ATTR_MESSAGE_ID = "messageId";
    public static final String ATTR_INBOX_TYPE = "inboxType";
    public static final String ATTR_SOURCE = "source";
    public static final String ATTR_OWNER = "owner";
    public static final String ATTR_IMAGE = "image";
    public static final String ATTR_MESSAGE = "message";
    public static int INVALID_MESSAGE_ID = 0;

    public static AVStatus createStatus(String imageUrl, String message) {
        AVStatus status = new AVStatus();
        status.setImageUrl(imageUrl);
        status.setMessage(message);
        return status;
    }

    public static AVStatus createStatusWithData(Map<String, Object> data) {
        AVStatus status = new AVStatus();
        status.resetServerData(data);
        return status;
    }

    public AVStatus() {
        super(CLASS_NAME);
        this.totallyOverwrite = true;
        this.endpointClassName = "statuses";
    }

    public AVStatus(AVObject o) {
        super(o);
    }

    public void setImageUrl(String imageUrl) {
        this.put(ATTR_IMAGE, imageUrl);
    }

    public String getImageUrl() {
        return this.getString(ATTR_IMAGE);
    }

    public void setMessage(String msg) {
        this.put(ATTR_MESSAGE, msg);
    }

    public String getMessage() {
        return this.getString(ATTR_MESSAGE);
    }

    public long getMessageId() {
        return this.getLong(ATTR_MESSAGE_ID);
    }

    protected void setMessageId(long messageId) {
        this.put(ATTR_MESSAGE_ID, messageId);
    }

    public String getInboxType() {
        return this.getString(ATTR_INBOX_TYPE);
    }

    public AVUser getSource() {
        return (AVUser)this.getAVObject(ATTR_SOURCE);
    }

    public void setSource(AVObject source) {
        this.put(ATTR_SOURCE, Utils.mapFromAVObject(source, false));
    }

    public void setInboxType(String type) {
        if (!StringUtil.isEmpty(type)) {
            this.put(ATTR_INBOX_TYPE, type);
        }
    }

    @Override
    public void put(String key, Object value) {
        this.serverData.put(key, value);
    }

    @Override
    public Object get(String key) {
        return this.serverData.get(key);
    }

    @Override
    public void remove(String key) {
        this.serverData.remove(key);
    }

    @Override
    public Observable<AVNull> deleteInBackground() {
        return AVStatus.deleteInBackground(this);
    }

    public static Observable<AVNull> deleteInBackground(AVStatus status) {
        return AVStatus.deleteInBackground(null, status);
    }

    public static Observable<AVNull> deleteInBackground(AVUser asAuthenticatedUser, AVStatus status) {
        if (!AVStatus.checkCurrentUserAuthenticated()) {
            return Observable.error((Throwable)ErrorUtils.sessionMissingException());
        }
        String currentUserObjectId = AVUser.currentUser().getObjectId();
        AVObject source = null;
        Object sourceObject = status.get(ATTR_SOURCE);
        if (sourceObject instanceof AVObject) {
            source = (AVObject)sourceObject;
        } else if (sourceObject instanceof JSONObject) {
            JSONObject sourceJson = (JSONObject)sourceObject;
            source = AVObject.createWithoutData(sourceJson.getString("className"), sourceJson.getString("objectId"));
        } else if (sourceObject instanceof HashMap) {
            HashMap sourceMap = (HashMap)sourceObject;
            source = AVObject.createWithoutData((String)sourceMap.get("className"), (String)sourceMap.get("objectId"));
        }
        String statusObjectId = status.getObjectId();
        long messageId = status.getMessageId();
        if (null != source && currentUserObjectId.equals(source.getString("objectId"))) {
            if (StringUtil.isEmpty(statusObjectId)) {
                return Observable.error((Throwable)ErrorUtils.invalidObjectIdException());
            }
            return PaasClient.getStorageClient().deleteStatus(asAuthenticatedUser, statusObjectId);
        }
        if ((long)INVALID_MESSAGE_ID == messageId) {
            return Observable.error((Throwable)ErrorUtils.invalidObjectIdException());
        }
        String ownerString = JSON.toJSONString(Utils.mapFromAVObject(AVUser.currentUser(), false));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(ATTR_MESSAGE_ID, String.valueOf(messageId));
        params.put(ATTR_INBOX_TYPE, status.getInboxType());
        params.put(ATTR_OWNER, ownerString);
        return PaasClient.getStorageClient().deleteInboxStatus(asAuthenticatedUser, params);
    }

    public static Observable<AVStatus> getStatusWithIdInBackground(String statusId) {
        return AVStatus.getStatusWithIdInBackground(null, statusId);
    }

    public static Observable<AVStatus> getStatusWithIdInBackground(AVUser asAuthenticatedUser, String statusId) {
        return PaasClient.getStorageClient().fetchStatus(asAuthenticatedUser, statusId);
    }

    public Observable<AVStatus> sendToUsersInBackground(AVQuery query) {
        return this.sendToUsersInBackground(INBOX_TYPE.TIMELINE.toString(), query);
    }

    public Observable<AVStatus> sendToUsersInBackground(String inboxType, AVQuery query) {
        return this.sendInBackground(inboxType, query);
    }

    public Observable<AVStatus> sendToFollowersInBackground() {
        return this.sendToFollowersInBackground(INBOX_TYPE.TIMELINE.toString());
    }

    private AVQuery generateFollowerQuery(String userObjectId) {
        AVUser user = new AVUser();
        user.setObjectId(userObjectId);
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("follower");
        AVQuery query = new AVQuery("_Follower");
        query.whereEqualTo("user", Utils.mapFromAVObject(user, false));
        query.selectKeys(keys);
        return query;
    }

    public Observable<AVStatus> sendToFollowersInBackground(String inboxType) {
        if (!AVStatus.checkCurrentUserAuthenticated()) {
            return Observable.error((Throwable)ErrorUtils.sessionMissingException());
        }
        AVQuery followerQuery = this.generateFollowerQuery(AVUser.currentUser().getObjectId());
        return this.sendInBackground(inboxType, followerQuery);
    }

    public Observable<AVStatus> sendPrivatelyInBackground(String receiverObjectId) {
        AVQuery<AVUser> userQuery = AVUser.getQuery();
        userQuery.whereEqualTo("objectId", receiverObjectId);
        return this.sendInBackground(INBOX_TYPE.PRIVATE.toString(), userQuery);
    }

    private Observable<AVStatus> sendInBackground(String inboxType, AVQuery query) {
        return this.sendInBackground(null, inboxType, query);
    }

    private Observable<AVStatus> sendInBackground(AVUser asAuthenticatedUser, String inboxType, AVQuery query) {
        if (!AVStatus.checkCurrentUserAuthenticated()) {
            return Observable.error((Throwable)ErrorUtils.sessionMissingException());
        }
        this.setSource(AVUser.currentUser());
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("data", this.serverData);
        param.put(ATTR_INBOX_TYPE, inboxType);
        Map<String, Object> queryCondition = query.assembleJsonParam();
        param.put("query", queryCondition);
        return PaasClient.getStorageClient().postStatus(asAuthenticatedUser, param).map((Function)new Function<AVStatus, AVStatus>(){

            public AVStatus apply(AVStatus avStatus) throws Exception {
                AVStatus.this.mergeRawData(avStatus, true);
                return avStatus;
            }
        });
    }

    public static AVStatusQuery statusQuery(AVUser source) {
        AVStatusQuery query = new AVStatusQuery(AVStatusQuery.SourceType.OWNED);
        query.setSource(source);
        query.setDirection(AVStatusQuery.PaginationDirection.NEW_TO_OLD);
        query.setInboxType(INBOX_TYPE.TIMELINE.toString());
        return query;
    }

    public static AVStatusQuery inboxQuery(AVUser owner, String inboxType) {
        AVStatusQuery query = new AVStatusQuery(AVStatusQuery.SourceType.INBOX);
        query.setOwner(owner);
        query.setDirection(AVStatusQuery.PaginationDirection.NEW_TO_OLD);
        query.setInboxType(inboxType);
        return query;
    }

    public AVObject toObject() {
        return AVObject.createWithoutData(CLASS_NAME, this.objectId);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (StringUtil.isEmpty(this.objectId)) {
            return false;
        }
        AVStatus other = (AVStatus)obj;
        return this.objectId.equals(other.objectId);
    }

    private static boolean checkCurrentUserAuthenticated() {
        AVUser currentUser = AVUser.getCurrentUser();
        return null != currentUser && currentUser.isAuthenticated();
    }

    @Override
    @Deprecated
    public void add(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public AVACL getACL() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void setACL(AVACL acl) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void addAll(String key, Collection<?> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void addAllUnique(String key, Collection<?> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void addUnique(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public AVObject fetch() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public AVObject fetch(String includedKeys) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void refresh() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void refresh(String includedKeys) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public AVObject fetchIfNeeded() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public Observable<AVObject> fetchIfNeededInBackground() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public Observable<AVObject> fetchInBackground() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public Observable<AVObject> refreshInBackground() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public Observable<AVObject> fetchInBackground(String includeKeys) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void save() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public Observable<? extends AVObject> saveInBackground() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void saveEventually() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean isFetchWhenSave() {
        return false;
    }

    @Override
    @Deprecated
    public void setFetchWhenSave(boolean fetchWhenSave) {
        throw new UnsupportedOperationException();
    }

    public static enum INBOX_TYPE {
        TIMELINE("default"),
        PRIVATE("private");

        private String type;

        private INBOX_TYPE(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

