/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.AVObject;
import cn.leancloud.AVSaveOption;
import cn.leancloud.AVUser;
import cn.leancloud.annotation.AVClassName;
import cn.leancloud.utils.ErrorUtils;
import io.reactivex.Observable;
import java.util.Map;

@AVClassName(value="_FriendshipRequest")
public class AVFriendshipRequest
extends AVObject {
    public static final String CLASS_NAME = "_FriendshipRequest";
    public static final String ATTR_FRIEND = "friend";
    public static final String ATTR_USER = "user";
    public static final String ATTR_STATUS = "status";
    public static final int STATUS_PENDING = 1;
    public static final int STATUS_ACCEPTED = 2;
    public static final int STATUS_DECLINED = 4;
    public static final int STATUS_ANY = 7;

    public AVFriendshipRequest() {
        super(CLASS_NAME);
    }

    public AVFriendshipRequest(AVFriendshipRequest other) {
        super(other);
    }

    public void setFriend(AVUser user) {
        this.put(ATTR_FRIEND, user);
    }

    public AVUser getFriend() {
        return (AVUser)this.getAVObject(ATTR_FRIEND);
    }

    public AVUser getSourceUser() {
        return (AVUser)this.getAVObject(ATTR_USER);
    }

    public void setSourceUser(AVUser user) {
        this.put(ATTR_USER, user);
    }

    public Observable<? extends AVObject> accept(Map<String, Object> attributes) {
        AVUser currentUser = AVUser.currentUser();
        if (null == currentUser) {
            logger.d("current user is null.");
            return Observable.error((Throwable)ErrorUtils.propagateException(206, "No valid session token, make sure signUp or login has been called."));
        }
        return currentUser.acceptFriendshipRequest(this, attributes);
    }

    public Observable<? extends AVObject> decline() {
        AVUser currentUser = AVUser.currentUser();
        if (null == currentUser) {
            logger.d("current user is null.");
            return Observable.error((Throwable)ErrorUtils.propagateException(206, "No valid session token, make sure signUp or login has been called."));
        }
        return currentUser.declineFriendshipRequest(this);
    }

    @Override
    public Observable<? extends AVObject> saveInBackground(AVSaveOption option) {
        return Observable.error((Throwable)ErrorUtils.propagateException(119, "save operation isn't allowed in AVFriendshipRequest class."));
    }

    static enum RequestStatus {
        Pending,
        Accepted,
        Declined;

    }
}

