/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.service;

import cn.leancloud.AVFile;
import cn.leancloud.AVObject;
import cn.leancloud.AVRole;
import cn.leancloud.AVStatus;
import cn.leancloud.AVUser;
import cn.leancloud.query.AVQueryResult;
import cn.leancloud.search.AVSearchResponse;
import cn.leancloud.sms.AVCaptchaDigest;
import cn.leancloud.sms.AVCaptchaValidateResult;
import cn.leancloud.types.AVDate;
import cn.leancloud.types.AVNull;
import cn.leancloud.upload.FileUploadToken;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import io.reactivex.Observable;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;

public interface APIService {
    @GET(value="/1.1/classes/{className}")
    public Observable<List<? extends AVObject>> findObjects(@Path(value="className") String var1);

    @GET(value="/1.1/classes/{className}")
    public Observable<AVQueryResult> queryObjects(@Path(value="className") String var1, @QueryMap Map<String, String> var2);

    @GET(value="/1.1/cloudQuery")
    public Observable<AVQueryResult> cloudQuery(@QueryMap Map<String, String> var1);

    @GET(value="/1.1/classes/{className}/{objectId}")
    public Observable<AVObject> fetchObject(@Path(value="className") String var1, @Path(value="objectId") String var2);

    @GET(value="/1.1/classes/{className}/{objectId}")
    public Observable<AVObject> fetchObject(@Path(value="className") String var1, @Path(value="objectId") String var2, @Query(value="include") String var3);

    @POST(value="/1.1/classes/{className}")
    public Observable<AVObject> createObject(@Path(value="className") String var1, @Body JSONObject var2, @Query(value="fetchWhenSave") boolean var3, @Query(value="where") JSONObject var4);

    @PUT(value="/1.1/classes/{className}/{objectId}")
    public Observable<AVObject> updateObject(@Path(value="className") String var1, @Path(value="objectId") String var2, @Body JSONObject var3, @Query(value="fetchWhenSave") boolean var4, @Query(value="where") JSONObject var5);

    @HTTP(method="DELETE", path="/1.1/classes/{className}/{objectId}", hasBody=true)
    public Observable<AVNull> deleteObject(@Path(value="className") String var1, @Path(value="objectId") String var2, @Body Map<String, Object> var3);

    @POST(value="/1.1/batch")
    public Observable<JSONArray> batchCreate(@Body JSONObject var1);

    @POST(value="/1.1/{endpointClass}")
    public Observable<AVObject> saveWholeObject(@Path(value="endpointClass") String var1, @Body JSONObject var2, @Query(value="fetchWhenSave") boolean var3, @Query(value="where") JSONObject var4);

    @PUT(value="/1.1/{endpointClass}/{objectId}")
    public Observable<AVObject> saveWholeObject(@Path(value="endpointClass") String var1, @Path(value="objectId") String var2, @Body JSONObject var3, @Query(value="fetchWhenSave") boolean var4, @Query(value="where") JSONObject var5);

    @GET(value="/1.1/{endpointClass}/{objectId}")
    public Observable<AVObject> getWholeObject(@Path(value="endpointClass") String var1, @Path(value="objectId") String var2, @Query(value="include") String var3);

    @HTTP(method="DELETE", path="/1.1/{endpointClass}/{objectId}", hasBody=true)
    public Observable<AVNull> deleteWholeObject(@Path(value="endpointClass") String var1, @Path(value="objectId") String var2, @Body Map<String, Object> var3);

    @POST(value="/1.1/batch/save")
    public Observable<JSONObject> batchUpdate(@Body JSONObject var1);

    @POST(value="/1.1/functions/{name}")
    public Observable<Map<String, Object>> cloudFunction(@Path(value="name") String var1, @Body Map<String, Object> var2);

    @POST(value="/1.1/call/{name}")
    public Observable<Map<String, Object>> cloudRPC(@Path(value="name") String var1, @Body Object var2);

    @POST(value="/1.1/fileTokens")
    public Observable<FileUploadToken> createUploadToken(@Body JSONObject var1);

    @POST(value="/1.1/fileCallback")
    public Call<AVNull> fileCallback(@Body JSONObject var1);

    @GET(value="/1.1/files/{objectId}")
    public Observable<AVFile> fetchFile(@Path(value="objectId") String var1);

    @GET(value="/1.1/date")
    public Observable<AVDate> currentTimeMillis();

    @POST(value="/1.1/roles")
    public Observable<AVRole> createRole(@Body JSONObject var1);

    @POST(value="/1.1/users")
    public Observable<AVUser> signup(@Body JSONObject var1);

    @POST(value="/1.1/users")
    public Observable<AVUser> signup(@Body JSONObject var1, @Query(value="failOnNotExist") boolean var2);

    @GET(value="/1.1/users")
    public Observable<AVQueryResult> queryUsers(@QueryMap Map<String, String> var1);

    @POST(value="/1.1/usersByMobilePhone")
    public Observable<AVUser> signupByMobilePhone(@Body JSONObject var1);

    @POST(value="/1.1/login")
    public Observable<AVUser> login(@Body JSONObject var1);

    @PUT(value="/1.1/users/{objectId}/updatePassword")
    public Observable<AVUser> updatePassword(@Path(value="objectId") String var1, @Body JSONObject var2);

    @PUT(value="/1.1/resetPasswordBySmsCode/{smsCode}")
    public Observable<AVNull> resetPasswordBySmsCode(@Path(value="smsCode") String var1, @Body Map<String, String> var2);

    @GET(value="/1.1/users/me")
    public Observable<AVUser> checkAuthenticated(@QueryMap Map<String, String> var1);

    @PUT(value="/1.1/users/{objectId}/refreshSessionToken")
    public Observable<AVUser> refreshSessionToken(@Path(value="objectId") String var1);

    @POST(value="/1.1/requestPasswordReset")
    public Observable<AVNull> requestResetPassword(@Body Map<String, String> var1);

    @POST(value="/1.1/requestPasswordResetBySmsCode")
    public Observable<AVNull> requestResetPasswordBySmsCode(@Body Map<String, String> var1);

    @POST(value="/1.1/requestEmailVerify")
    public Observable<AVNull> requestEmailVerify(@Body Map<String, String> var1);

    @POST(value="/1.1/requestMobilePhoneVerify")
    public Observable<AVNull> requestMobilePhoneVerify(@Body Map<String, String> var1);

    @POST(value="/1.1/requestLoginSmsCode")
    public Observable<AVNull> requestLoginSmsCode(@Body Map<String, String> var1);

    @POST(value="/1.1/verifyMobilePhone/{verifyCode}")
    public Observable<AVNull> verifyMobilePhone(@Path(value="verifyCode") String var1);

    @POST(value="/1.1/users/{followee}/friendship/{follower}")
    public Observable<JSONObject> followUser(@Path(value="followee") String var1, @Path(value="follower") String var2, @Body Map<String, Object> var3);

    @DELETE(value="/1.1/users/{followee}/friendship/{follower}")
    public Observable<JSONObject> unfollowUser(@Path(value="followee") String var1, @Path(value="follower") String var2);

    @GET(value="/1.1/users/{userId}/followers")
    public Observable<JSONObject> getFollowers(@Path(value="userId") String var1);

    @GET(value="/1.1/users/{userId}/followees")
    public Observable<JSONObject> getFollowees(@Path(value="userId") String var1);

    @GET(value="/1.1/users/{userId}/followersAndFollowees")
    public Observable<JSONObject> getFollowersAndFollowees(@Path(value="userId") String var1);

    @POST(value="/1.1/statuses")
    public Observable<AVStatus> postStatus(@Body Map<String, Object> var1);

    @GET(value="/1.1/statuses/{statusId}")
    public Observable<AVStatus> fetchSingleStatus(@Path(value="statusId") String var1);

    @GET(value="/1.1/statuses")
    public Observable<AVQueryResult> fetchStatuses(@QueryMap Map<String, String> var1);

    @DELETE(value="/1.1/statuses/{statusId}")
    public Observable<AVNull> deleteStatus(@Path(value="statusId") String var1);

    @DELETE(value="/1.1/subscribe/statuses/inbox")
    public Observable<AVNull> deleteInboxStatus(@QueryMap Map<String, Object> var1);

    @GET(value="/1.1/subscribe/statuses")
    public Observable<AVQueryResult> queryInbox(@QueryMap Map<String, String> var1);

    @GET(value="/1.1/subscribe/statuses/count")
    public Observable<JSONObject> getInboxCount(@QueryMap Map<String, String> var1);

    @POST(value="/1.1/subscribe/statuses/resetUnreadCount")
    public Observable<AVNull> resetInboxUnreadCount();

    @GET(value="/1.1/requestCaptcha")
    public Observable<AVCaptchaDigest> requestCaptcha(@QueryMap Map<String, String> var1);

    @POST(value="/1.1/verifyCaptcha")
    public Observable<AVCaptchaValidateResult> verifyCaptcha(@Body Map<String, String> var1);

    @POST(value="/1.1/requestSmsCode")
    public Observable<AVNull> requestSMSCode(@Body Map<String, Object> var1);

    @POST(value="/1.1/verifySmsCode/{code}")
    public Observable<AVNull> verifySMSCode(@Path(value="code") String var1, @Body Map<String, Object> var2);

    @GET(value="/1.1/search/select")
    public Observable<AVSearchResponse> search(@QueryMap Map<String, String> var1);
}

