/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.AVFile;
import cn.leancloud.AVInstallation;
import cn.leancloud.AVLogger;
import cn.leancloud.AVObject;
import cn.leancloud.AVRole;
import cn.leancloud.AVStatus;
import cn.leancloud.AVUser;
import cn.leancloud.ObjectValueFilter;
import cn.leancloud.Transformer;
import cn.leancloud.core.AVOSCloud;
import cn.leancloud.ops.Utils;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ObjectTypeAdapter
implements ObjectSerializer,
ObjectDeserializer {
    private static AVLogger LOGGER = LogUtil.getLogger(ObjectTypeAdapter.class);
    public static final String KEY_VERSION = "_version";
    private static final String DEFAULT_VERSION = "5";
    public static final String KEY_SERVERDATA = "serverData";

    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        this.write(serializer, object, fieldName, fieldType);
    }

    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        AVObject avObject = (AVObject)object;
        SerializeWriter writer = serializer.getWriter();
        writer.write(123);
        writer.write(32);
        writer.writeFieldName(KEY_VERSION, false);
        writer.writeString(DEFAULT_VERSION);
        writer.write(44);
        writer.writeFieldName("className", false);
        writer.writeString(avObject.getClassName());
        writer.write(44);
        writer.writeFieldName(KEY_SERVERDATA, false);
        if (AVOSCloud.isEnableCircularReferenceDetect()) {
            writer.write(JSON.toJSONString(avObject.serverData, (SerializeFilter)ObjectValueFilter.instance, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName}));
        } else {
            writer.write(JSON.toJSONString(avObject.serverData, (SerializeFilter)ObjectValueFilter.instance, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName, SerializerFeature.DisableCircularReferenceDetect}));
        }
        writer.write(125);
    }

    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        if (!AVObject.class.isAssignableFrom((Class)type)) {
            return (T)parser.parseObject();
        }
        String className = "";
        Map serverJson = null;
        Map objectMap = (Map)parser.parseObject(Map.class);
        if (objectMap.containsKey(KEY_VERSION)) {
            className = (String)objectMap.get("className");
            serverJson = objectMap.containsKey(KEY_SERVERDATA) ? (Map)objectMap.get(KEY_SERVERDATA) : objectMap;
        } else if (objectMap.containsKey("className")) {
            className = (String)objectMap.get("className");
            objectMap.remove("className");
            if (objectMap.containsKey(KEY_SERVERDATA)) {
                ConcurrentHashMap serverData = (ConcurrentHashMap)objectMap.get(KEY_SERVERDATA);
                objectMap.remove(KEY_SERVERDATA);
                objectMap.putAll(serverData);
            }
            objectMap.remove("operationQueue");
            serverJson = objectMap;
        } else {
            serverJson = objectMap;
        }
        AVObject obj = type.toString().endsWith(AVFile.class.getCanonicalName()) ? new AVFile() : (type.toString().endsWith(AVUser.class.getCanonicalName()) ? new AVUser() : (type.toString().endsWith(AVInstallation.class.getCanonicalName()) ? new AVInstallation() : (type.toString().endsWith(AVStatus.class.getCanonicalName()) ? new AVStatus() : (type.toString().endsWith(AVRole.class.getCanonicalName()) ? new AVRole() : (!StringUtil.isEmpty(className) ? Transformer.objectFromClassName(className) : new AVObject())))));
        for (Map.Entry entry : serverJson.entrySet()) {
            String k = (String)entry.getKey();
            Object v = entry.getValue();
            if (v instanceof String || v instanceof Number || v instanceof Boolean || v instanceof Byte || v instanceof Character) {
                obj.serverData.put(k, v);
                continue;
            }
            if (v instanceof Map || v instanceof JSONObject) {
                obj.serverData.put(k, Utils.getObjectFrom(v));
                continue;
            }
            if (v instanceof Collection) {
                obj.serverData.put(k, Utils.getObjectFrom(v));
                continue;
            }
            if (null == v) continue;
            obj.serverData.put(k, v);
        }
        return (T)obj;
    }

    public int getFastMatchToken() {
        return 14;
    }
}

