/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.core;

import cn.leancloud.AVACL;
import cn.leancloud.cache.InMemorySetting;
import cn.leancloud.cache.LastModifyCache;
import cn.leancloud.cache.SystemSetting;
import cn.leancloud.logging.InternalLoggerAdapter;
import cn.leancloud.logging.SimpleLoggerAdapter;
import cn.leancloud.network.NetworkingDetector;
import cn.leancloud.network.SimpleNetworkingDetector;
import cn.leancloud.utils.FileUtil;
import io.reactivex.Scheduler;
import java.io.File;

public class AppConfiguration {
    public static final int DEFAULT_NETWORK_TIMEOUT = 30;
    private static AVACL defaultACL;
    private static int networkTimeout;
    private static InternalLoggerAdapter logAdapter;
    private static boolean asynchronized;
    private static SchedulerCreator defaultScheduler;
    private static NetworkingDetector globalNetworkingDetector;
    private static String applicationPackageName;
    private static String importantFileDir;
    private static String documentDir;
    private static String fileCacheDir;
    private static String commandCacheDir;
    private static String analyticsCacheDir;
    private static String queryResultCacheDir;
    private static SystemSetting defaultSetting;
    private static boolean enableLocalCache;
    private static final String SDK_VERSION = "6.5.11";
    private static final String DEFAULT_USER_AGENT = "LeanCloud-Java-SDK/6.5.11";
    private static boolean autoMergeOperationDataWhenSave;

    public static void setNetworkTimeout(int seconds) {
        networkTimeout = seconds;
    }

    public static int getNetworkTimeout() {
        return networkTimeout;
    }

    public static void setLastModifyEnabled(boolean val) {
        LastModifyCache.getInstance().setLastModifyEnabled(val);
    }

    public static boolean isLastModifyEnabled() {
        return LastModifyCache.getInstance().isLastModifyEnabled();
    }

    public static AVACL getDefaultACL() {
        return defaultACL;
    }

    public static void setDefaultACL(AVACL acl) {
        defaultACL = acl;
    }

    public static void setLogAdapter(InternalLoggerAdapter adapter) {
        logAdapter = adapter;
    }

    public static InternalLoggerAdapter getLogAdapter() {
        return logAdapter;
    }

    public static String getUserAgent() {
        return DEFAULT_USER_AGENT;
    }

    public static void config(boolean asyncRequest, SchedulerCreator observerSchedulerCreator) {
        asynchronized = asyncRequest;
        defaultScheduler = observerSchedulerCreator;
    }

    public static boolean isEnableLocalCache() {
        return enableLocalCache;
    }

    public static void setEnableLocalCache(boolean enableLocalCache) {
        AppConfiguration.enableLocalCache = enableLocalCache;
    }

    public static boolean isAutoMergeOperationDataWhenSave() {
        return autoMergeOperationDataWhenSave;
    }

    public static void setAutoMergeOperationDataWhenSave(boolean flag) {
        autoMergeOperationDataWhenSave = flag;
    }

    public static boolean isAsynchronized() {
        return asynchronized;
    }

    public static SchedulerCreator getDefaultScheduler() {
        return defaultScheduler;
    }

    public static void makeSureCacheDirWorkable() {
        AppConfiguration.makeSureDirExist(importantFileDir);
        AppConfiguration.makeSureDirExist(documentDir);
        AppConfiguration.makeSureDirExist(fileCacheDir);
        AppConfiguration.makeSureDirExist(queryResultCacheDir);
        AppConfiguration.makeSureDirExist(commandCacheDir);
        AppConfiguration.makeSureDirExist(analyticsCacheDir);
    }

    private static void makeSureDirExist(String dirPath) {
        File dirFile = new File(dirPath);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
    }

    public static void configCacheSettings(String imFileDir, String docDir, String fileDir, String queryResultDir, String commandDir, String analyticsDir, SystemSetting setting) {
        importantFileDir = imFileDir;
        if (!importantFileDir.endsWith("/")) {
            importantFileDir = importantFileDir + "/";
        }
        if (!(documentDir = docDir).endsWith("/")) {
            documentDir = documentDir + "/";
        }
        if (!(fileCacheDir = fileDir).endsWith("/")) {
            fileCacheDir = fileCacheDir + "/";
        }
        if (!(queryResultCacheDir = queryResultDir).endsWith("/")) {
            queryResultCacheDir = queryResultCacheDir + "/";
        }
        if (!(commandCacheDir = commandDir).endsWith("/")) {
            commandCacheDir = commandCacheDir + "/";
        }
        if (!(analyticsCacheDir = analyticsDir).endsWith("/")) {
            analyticsCacheDir = analyticsCacheDir + "/";
        }
        AppConfiguration.makeSureCacheDirWorkable();
        defaultSetting = setting;
    }

    public static String getAnalyticsCacheDir() {
        if (!enableLocalCache) {
            return null;
        }
        AppConfiguration.makeSureDirExist(analyticsCacheDir);
        return analyticsCacheDir;
    }

    public static String getCommandCacheDir() {
        if (!enableLocalCache) {
            return null;
        }
        AppConfiguration.makeSureDirExist(commandCacheDir);
        return commandCacheDir;
    }

    public static String getImportantFileDir() {
        if (!enableLocalCache) {
            return null;
        }
        AppConfiguration.makeSureDirExist(importantFileDir);
        return importantFileDir;
    }

    public static String getDocumentDir() {
        if (!enableLocalCache) {
            return null;
        }
        AppConfiguration.makeSureDirExist(documentDir);
        return documentDir;
    }

    public static String getFileCacheDir() {
        if (!enableLocalCache) {
            return null;
        }
        AppConfiguration.makeSureDirExist(fileCacheDir);
        return fileCacheDir;
    }

    public static String getQueryResultCacheDir() {
        if (!enableLocalCache) {
            return null;
        }
        AppConfiguration.makeSureDirExist(queryResultCacheDir);
        return queryResultCacheDir;
    }

    public static String getApplicationPackageName() {
        return applicationPackageName;
    }

    public static void setApplicationPackageName(String applicationPackageName) {
        AppConfiguration.applicationPackageName = applicationPackageName;
    }

    public static SystemSetting getDefaultSetting() {
        return defaultSetting;
    }

    public static NetworkingDetector getGlobalNetworkingDetector() {
        return globalNetworkingDetector;
    }

    public static void setGlobalNetworkingDetector(NetworkingDetector globalNetworkingDetector) {
        AppConfiguration.globalNetworkingDetector = globalNetworkingDetector;
    }

    public static void setMimeTypeDetector(FileUtil.MimeTypeDetector detector) {
        if (null != detector) {
            FileUtil.config(detector);
        }
    }

    static {
        networkTimeout = 30;
        logAdapter = new SimpleLoggerAdapter();
        asynchronized = false;
        defaultScheduler = null;
        globalNetworkingDetector = new SimpleNetworkingDetector();
        applicationPackageName = "";
        importantFileDir = "./persistFiles/";
        documentDir = "./data/";
        fileCacheDir = "./file/";
        commandCacheDir = "./command/";
        analyticsCacheDir = "./stats/";
        queryResultCacheDir = "./PaasKeyValueCache";
        defaultSetting = new InMemorySetting();
        enableLocalCache = true;
        autoMergeOperationDataWhenSave = true;
    }

    public static interface SchedulerCreator {
        public Scheduler create();
    }
}

