/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.upload;

import cn.leancloud.AVException;
import cn.leancloud.AVFile;
import cn.leancloud.callback.ProgressCallback;
import cn.leancloud.upload.FileUploader;
import cn.leancloud.upload.HttpClientUploader;
import cn.leancloud.utils.FileUtil;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

class S3Uploader
extends HttpClientUploader {
    private static String DEFAULT_HEADER_CACHE_CONTROL = "Cache-Control";
    private static String DEFAULT_HEADER_CACHE_CONTROL_VALUE = "public, max-age=31536000";
    private volatile Call call;
    private String uploadUrl;
    private int retryTimes = 6;
    private static final int DEFAULT_MIN_WRITE_TIMEOUT = 30;
    private static final int DEFAULT_MAX_WRITE_TIMEOUT = 240;
    private static final int DEFAULT_MIN_UPLOAD_RATE = 51200;
    private static int writeTimeout = 0;

    S3Uploader(AVFile avFile, String uploadUrl, ProgressCallback progressCallback) {
        super(avFile, progressCallback);
        this.uploadUrl = uploadUrl;
    }

    @Override
    public AVException execute() {
        try {
            byte[] bytes = this.avFile.getData();
            return this.executeWithRetry(bytes);
        }
        catch (Exception e) {
            return new AVException(e.getCause());
        }
    }

    private AVException executeWithRetry(byte[] data) {
        block7: {
            if (null != data && data.length > 0) {
                OkHttpClient.Builder okhttpBuilder = this.getOKHttpClient().newBuilder();
                int timeout = writeTimeout > 0 ? writeTimeout : this.getWriteTimeoutByLength(data.length);
                okhttpBuilder.writeTimeout((long)timeout, TimeUnit.SECONDS);
                OkHttpClient httpClient = okhttpBuilder.build();
                Response response = null;
                Object serverResponse = null;
                try {
                    String mimeType = FileUtil.getFileMimeType(this.avFile);
                    Request.Builder builder = new Request.Builder();
                    builder.url(this.uploadUrl);
                    RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)mimeType), (byte[])data);
                    builder.put(requestBody);
                    builder.addHeader("Content-Type", mimeType);
                    if (!FileUploader.UPLOAD_HEADERS.containsKey(DEFAULT_HEADER_CACHE_CONTROL)) {
                        builder.addHeader(DEFAULT_HEADER_CACHE_CONTROL, DEFAULT_HEADER_CACHE_CONTROL_VALUE);
                    }
                    for (Map.Entry<String, String> entry : FileUploader.UPLOAD_HEADERS.entrySet()) {
                        builder.addHeader(entry.getKey(), entry.getValue());
                    }
                    this.call = httpClient.newCall(builder.build());
                    response = this.call.execute();
                    if (2 == response.code() / 100) break block7;
                    if (this.retryTimes > 0) {
                        --this.retryTimes;
                        this.executeWithRetry(data);
                        break block7;
                    }
                    return new AVException(-1, "upload file failure:" + response.code());
                }
                catch (IOException exception) {
                    if (this.retryTimes > 0) {
                        --this.retryTimes;
                        return this.executeWithRetry(data);
                    }
                    return new AVException(exception.getCause());
                }
            }
        }
        return null;
    }

    private int getWriteTimeoutByLength(int dataLength) {
        int writeSecond = dataLength / 51200;
        if (writeSecond < 30) {
            writeSecond = 30;
        } else if (writeSecond > 240) {
            writeSecond = 240;
        }
        return writeSecond;
    }

    public static void setWriteTimeout(int seconds) throws AVException {
        if (seconds <= 0) {
            throw new AVException(new IllegalArgumentException("Timeout too small"));
        }
        if (seconds > 3600) {
            throw new AVException(new IllegalArgumentException("Timeout too large"));
        }
        writeTimeout = seconds;
    }
}

