/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.ops;

import cn.leancloud.ops.BaseOperation;
import cn.leancloud.ops.BitAndOperation;
import cn.leancloud.ops.BitOrOperation;
import cn.leancloud.ops.BitXorOperation;
import cn.leancloud.ops.CompoundOperation;
import cn.leancloud.ops.DecrementOperation;
import cn.leancloud.ops.DeleteOperation;
import cn.leancloud.ops.IncrementOperation;
import cn.leancloud.ops.NullOperation;
import cn.leancloud.ops.ObjectFieldOperation;
import cn.leancloud.ops.SetOperation;
import java.util.HashMap;
import java.util.Map;

public abstract class NumericOperation
extends BaseOperation {
    public NumericOperation(String op, String field, Object value) {
        super(op, field, value, false);
        if (!(this.getValue() instanceof Number)) {
            throw new IllegalArgumentException("Value is not number!");
        }
    }

    @Override
    public Object apply(Object obj) {
        Number init;
        if (null == obj) {
            init = 0;
        } else if (obj instanceof Number) {
            init = (Number)obj;
        } else {
            LOGGER.w("cannot apply AddOperation on non number attribute. targetValueType=" + obj.getClass().getSimpleName());
            return obj;
        }
        Number result = 0;
        if (this instanceof DecrementOperation) {
            result = NumericOperation.subNumbers(init, (Number)this.value);
        } else if (this instanceof IncrementOperation) {
            result = NumericOperation.addNumbers(init, (Number)this.value);
        } else if (this instanceof BitXorOperation) {
            result = NumericOperation.calculateLongs(init, (Number)this.value, 'X');
        } else if (this instanceof BitAndOperation) {
            result = NumericOperation.calculateLongs(init, (Number)this.value, 'A');
        } else if (this instanceof BitOrOperation) {
            result = NumericOperation.calculateLongs(init, (Number)this.value, 'O');
        }
        return result;
    }

    @Override
    public Map<String, Object> encode() {
        HashMap<String, Object> opMap = new HashMap<String, Object>();
        opMap.put("__op", this.getOperation());
        if (this instanceof IncrementOperation || this instanceof DecrementOperation) {
            opMap.put("amount", this.getValue());
        } else {
            opMap.put("value", this.getValue());
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(this.getField(), opMap);
        return result;
    }

    @Override
    protected ObjectFieldOperation mergeWithPrevious(ObjectFieldOperation other) {
        if (other instanceof SetOperation || other instanceof DeleteOperation) {
            return other;
        }
        if (other instanceof NumericOperation) {
            return new CompoundOperation(this.field, other, this);
        }
        if (other instanceof CompoundOperation) {
            return ((CompoundOperation)other).mergeWithPrevious(this);
        }
        this.reportIllegalOperations(this, other);
        return NullOperation.gInstance;
    }

    protected static Long calculateLongs(Number a, Number b, char op) {
        Long first = a.longValue();
        Long second = b.longValue();
        Long result = 0L;
        switch (op) {
            case 'A': {
                result = first & second;
                break;
            }
            case 'O': {
                result = first | second;
                break;
            }
            case 'X': {
                result = first ^ second;
                break;
            }
        }
        return result;
    }

    protected static Number addNumbers(Number a, Number b) {
        if (a instanceof Double || b instanceof Double) {
            return a.doubleValue() + b.doubleValue();
        }
        if (a instanceof Float || b instanceof Float) {
            return Float.valueOf(a.floatValue() + b.floatValue());
        }
        if (a instanceof Long || b instanceof Long) {
            return a.longValue() + b.longValue();
        }
        return a.intValue() + b.intValue();
    }

    protected static Number subNumbers(Number a, Number b) {
        if (a instanceof Double || b instanceof Double) {
            return a.doubleValue() - b.doubleValue();
        }
        if (a instanceof Float || b instanceof Float) {
            return Float.valueOf(a.floatValue() - b.floatValue());
        }
        if (a instanceof Long || b instanceof Long) {
            return a.longValue() - b.longValue();
        }
        return a.intValue() - b.intValue();
    }
}

